/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PComponent;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.utils.StringUtils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class TradeRecord
extends MxObject {
    private StringProperty recordId = new SimpleStringProperty("");
    private StringProperty recordDate = new SimpleStringProperty("");
    private StringProperty recordTime = new SimpleStringProperty("");
    private String extAccntId = "";
    private String extSecAccntId = "";
    private ObjectProperty<MxNode> tradeType = new SimpleObjectProperty();
    private Instrument instrument;
    private StringProperty comments = new SimpleStringProperty("");
    private StringProperty beginSecQty = new SimpleStringProperty("");
    private StringProperty secOccurQty = new SimpleStringProperty("");
    private StringProperty secBalance = new SimpleStringProperty("");
    private StringProperty beginAmt = new SimpleStringProperty("");
    private StringProperty occurAmt = new SimpleStringProperty("");
    private StringProperty balance = new SimpleStringProperty("");
    private StringProperty avail = new SimpleStringProperty("");
    private StringProperty advisable = new SimpleStringProperty("");
    private DoubleProperty price = new SimpleDoubleProperty(0.0);
    private LongProperty qty = new SimpleLongProperty(0L);
    private DoubleProperty amount = new SimpleDoubleProperty(0.0);
    private StringProperty execId = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty inverstorSecId = new SimpleStringProperty("");
    private String secId = "";
    private String secName = "";
    private String appId;
    private boolean showAmt = true;
    private String exTradeType = "";
    private static final int PT_SOD = 1;
    private static final int PT_INTRADAY = 2;
    private static final int PT_FROZEN = 3;
    private static final int PT_DIVIDE = 6;
    private static final int PT_intEREST = 7;
    private static final int PT_AVAILABLE = 9;
    private static final int PT_TRADE = 10;
    private static final int PT_IMPAWNIN = 11;
    private static final int PT_IMPAWNOUT_FROZEN = 12;
    private static final int PT_IMPAWNOUT_AVAIL = 13;
    private static final int PT_WITHDRAW_QUOTA = 14;
    private static final int PT_TRANSACTION_FEE = 15;
    private static int AT_SEC = 1;
    private static int AT_CASH = 2;
    private static int AT_EXEC_ID = 3;
    private static int AL_EXT = 1;
    private static int AL_SUB = 2;

    public void update(Object obj) {
        if (obj instanceof PComponent.TradeRecord) {
            this.update((PComponent.TradeRecord)PComponent.TradeRecord.class.cast(obj));
        } else if (obj instanceof TradeRecord) {
            this.update((TradeRecord)((Object)TradeRecord.class.cast(obj)));
        }
    }

    private void update(PComponent.TradeRecord tr) {
        this.setRecordId(Long.toString(tr.getTransId()));
        if (tr.getDateTime().length() > 7) {
            this.setRecordDate(tr.getDateTime().substring(0, 8));
        }
        if (tr.getDateTime().length() > 8) {
            this.setRecordTime(tr.getDateTime().substring(9));
        }
        this.setComments(tr.getComments());
        if (1 == tr.getTradeTypeValue() || 8 == tr.getTradeTypeValue() || 9 == tr.getTradeTypeValue() || 10 == tr.getTradeTypeValue()) {
            if (49 == tr.getSideValue()) {
                this.getTradeType().setRaw(Integer.toString(tr.getSideValue() + tr.getTradeTypeValue()));
            } else if (50 == tr.getSideValue()) {
                this.getTradeType().setRaw(Integer.toString(tr.getSideValue() * 2 + tr.getTradeTypeValue()));
            } else {
                this.getTradeType().setRaw(Integer.toString(tr.getTradeTypeValue()));
            }
        } else {
            this.getTradeType().setRaw(Integer.toString(tr.getTradeTypeValue()));
        }
        this.setExTradeType(this.getTradeType().getValue());
        for (PComponent.PosQty po : tr.getItemsList()) {
            double deltaAmt = (double)Math.round(po.getDeltaAmt() * 1000.0) / 1000.0;
            double balance = (double)Math.round(po.getBalance() * 1000.0) / 1000.0;
            int accType = po.getAccntTypeValue();
            int accLevel = po.getAccntLevelValue();
            int posType = po.getPosTypeValue();
            if (AT_SEC == accType) {
                PComponent.Instrument inst = po.getInstrument();
                this.getInstrument().update((Object)inst);
                this.setSecId(inst.getSecurityId());
                this.setSecName(inst.getSymbol());
                this.setAppId(inst.getApplId());
                if (AL_EXT == accLevel) {
                    this.setExtSecAccntId(po.getAccnt());
                }
                if (2 != posType) continue;
                this.setSecOccurQty(StringUtils.toPriceStr((double)StringUtils.parseInt((String)StringUtils.toPriceStr((double)deltaAmt, (int)0)), (int)0));
                this.setSecBalance(StringUtils.toPriceStr((double)balance, (int)0));
                if (11 == tr.getTradeTypeValue() || 12 == tr.getTradeTypeValue()) {
                    this.setBeginSecQty(StringUtils.toPriceStr((double)balance, (int)0));
                    continue;
                }
                this.setBeginSecQty(StringUtils.toPriceStr((double)(balance - deltaAmt), (int)0));
                continue;
            }
            if (AT_CASH == accType) {
                if (AL_EXT != accLevel) continue;
                this.setExtAccntId(po.getAccnt());
                switch (posType) {
                    case 2: {
                        this.setOccurAmt(StringUtils.toPriceStr((double)(deltaAmt + StringUtils.parseDouble((String)this.getOccurAmt()))));
                        this.setBalance(StringUtils.toPriceStr((double)(balance + StringUtils.parseDouble((String)this.getBalance()))));
                        this.setAvail(StringUtils.toPriceStr((double)balance));
                        break;
                    }
                    case 9: {
                        this.setOccurAmt(StringUtils.toPriceStr((double)(deltaAmt + StringUtils.parseDouble((String)this.getOccurAmt()))));
                        this.setBalance(StringUtils.toPriceStr((double)(balance + StringUtils.parseDouble((String)this.getBalance()))));
                        this.setAvail(StringUtils.toPriceStr((double)balance));
                        break;
                    }
                    case 3: {
                        this.setOccurAmt(StringUtils.toPriceStr((double)(deltaAmt + StringUtils.parseDouble((String)this.getOccurAmt()))));
                        this.setBalance(StringUtils.toPriceStr((double)(balance + StringUtils.parseDouble((String)this.getBalance()))));
                        break;
                    }
                    case 14: {
                        this.setAdvisable(StringUtils.toPriceStr((double)balance));
                        break;
                    }
                }
                continue;
            }
            if (AT_EXEC_ID != accType) continue;
            this.setPrice(po.getDeltaAmt());
            this.setQty((long)po.getBalance());
            this.setExecId(po.getAccnt());
        }
        String market = this.getInstrument().getMarket().getRaw();
        String secType = this.getInstrument().getSecType();
        if ("REPO".equals(secType) && "XSHG".equals(market)) {
            this.setAmount(1000L * this.getQty());
        } else if ("REPO".equals(secType) && "XSHE".equals(market)) {
            this.setAmount(100L * this.getQty());
        } else {
            this.setAmount(this.getPrice() * (double)this.getQty());
        }
        if (11 == tr.getTradeTypeValue() || 12 == tr.getTradeTypeValue()) {
            this.setBeginAmt(StringUtils.toPriceStr((double)StringUtils.parseDouble((String)this.getBalance())));
        } else {
            this.setBeginAmt(StringUtils.toPriceStr((double)(StringUtils.parseDouble((String)this.getBalance()) - StringUtils.parseDouble((String)this.getOccurAmt()))));
        }
        if (StringUtils.parseDouble((String)this.getBeginSecQty()) == 0.0 && StringUtils.parseDouble((String)this.getSecOccurQty()) == 0.0 && StringUtils.parseDouble((String)this.getSecBalance()) == 0.0) {
            this.setBeginSecQty("");
            this.setSecOccurQty("");
            this.setSecBalance("");
        }
        if (StringUtils.parseDouble((String)this.getBeginAmt()) == 0.0 && StringUtils.parseDouble((String)this.getOccurAmt()) == 0.0 && StringUtils.parseDouble((String)this.getBalance()) == 0.0 && StringUtils.parseDouble((String)this.getAvail()) == 0.0 && StringUtils.parseDouble((String)this.getAdvisable()) == 0.0) {
            this.setBeginAmt("");
            this.setOccurAmt("");
            this.setBalance("");
            this.setAvail("");
            this.setAdvisable("");
            this.setShowAmt(false);
        }
    }

    private void update(TradeRecord tr) {
        this.setInstrument(tr.getInstrument());
        this.setRecordId(tr.getRecordId());
        this.setRecordDate(tr.getRecordDate());
        this.setRecordTime(tr.getRecordTime());
        this.setExtAccntId(tr.getExtAccntId());
        this.setExtSecAccntId(tr.getExtSecAccntId());
        this.setTradeType(tr.getTradeType());
        this.setComments(tr.getComments());
        this.setBeginSecQty(tr.getBeginSecQty());
        this.setSecOccurQty(tr.getSecOccurQty());
        this.setSecBalance(tr.getSecBalance());
        this.setBeginAmt(tr.getBeginAmt());
        this.setOccurAmt(tr.getOccurAmt());
        this.setBalance(tr.getBalance());
        this.setAvail(tr.getAvail());
        this.setAdvisable(tr.getAdvisable());
        this.setPrice(tr.getPrice());
        this.setQty(tr.getQty());
        this.setAmount(tr.getAmount());
        this.setExecId(tr.getExecId());
        this.setInvestorId(tr.getInvestorId());
        this.setInverstorSecId(tr.getInverstorSecId());
        this.setSecId(tr.getSecId());
        this.setSecName(tr.getSecName());
        this.setAppId(tr.getAppId());
        this.setExTradeType(tr.getExTradeType());
    }

    public final StringProperty recordIdProperty() {
        return this.recordId;
    }

    public final String getRecordId() {
        return (String)this.recordIdProperty().get();
    }

    public final void setRecordId(String recordId) {
        this.recordIdProperty().set((Object)recordId);
    }

    public final StringProperty recordDateProperty() {
        return this.recordDate;
    }

    public final String getRecordDate() {
        return (String)this.recordDateProperty().get();
    }

    public final void setRecordDate(String recordDate) {
        this.recordDateProperty().set((Object)recordDate);
    }

    public final StringProperty recordTimeProperty() {
        return this.recordTime;
    }

    public final String getRecordTime() {
        return (String)this.recordTimeProperty().get();
    }

    public final void setRecordTime(String recordTime) {
        this.recordTimeProperty().set((Object)recordTime);
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public final ObjectProperty<MxNode> tradeTypeProperty() {
        return this.tradeType;
    }

    public final MxNode getTradeType() {
        return (MxNode)this.tradeTypeProperty().get();
    }

    public final void setTradeType(MxNode tradeType) {
        this.tradeTypeProperty().set((Object)tradeType);
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final LongProperty qtyProperty() {
        return this.qty;
    }

    public final long getQty() {
        return this.qtyProperty().get();
    }

    public final void setQty(long qty) {
        this.qtyProperty().set(qty);
    }

    public final DoubleProperty amountProperty() {
        return this.amount;
    }

    public final double getAmount() {
        return this.amountProperty().get();
    }

    public final void setAmount(double amount) {
        this.amountProperty().set(amount);
    }

    public final StringProperty execIdProperty() {
        return this.execId;
    }

    public final String getExecId() {
        return (String)this.execIdProperty().get();
    }

    public final void setExecId(String execId) {
        this.execIdProperty().set((Object)execId);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty inverstorSecIdProperty() {
        return this.inverstorSecId;
    }

    public final String getInverstorSecId() {
        return (String)this.inverstorSecIdProperty().get();
    }

    public final void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecIdProperty().set((Object)inverstorSecId);
    }

    public final StringProperty commentsProperty() {
        return this.comments;
    }

    public final String getComments() {
        return (String)this.commentsProperty().get();
    }

    public final void setComments(String comments) {
        this.commentsProperty().set((Object)comments);
    }

    public String getSecId() {
        return this.secId;
    }

    public void setSecId(String secId) {
        this.secId = secId;
    }

    public String getSecName() {
        return this.secName;
    }

    public void setSecName(String secName) {
        this.secName = secName;
    }

    public final StringProperty beginSecQtyProperty() {
        return this.beginSecQty;
    }

    public final String getBeginSecQty() {
        return (String)this.beginSecQtyProperty().get();
    }

    public final void setBeginSecQty(String beginSecQty) {
        this.beginSecQtyProperty().set((Object)beginSecQty);
    }

    public final StringProperty secOccurQtyProperty() {
        return this.secOccurQty;
    }

    public final String getSecOccurQty() {
        return (String)this.secOccurQtyProperty().get();
    }

    public final void setSecOccurQty(String secOccurQty) {
        this.secOccurQtyProperty().set((Object)secOccurQty);
    }

    public final StringProperty secBalanceProperty() {
        return this.secBalance;
    }

    public final String getSecBalance() {
        return (String)this.secBalanceProperty().get();
    }

    public final void setSecBalance(String secBalance) {
        this.secBalanceProperty().set((Object)secBalance);
    }

    public final StringProperty beginAmtProperty() {
        return this.beginAmt;
    }

    public final String getBeginAmt() {
        return (String)this.beginAmtProperty().get();
    }

    public final void setBeginAmt(String beginAmt) {
        this.beginAmtProperty().set((Object)beginAmt);
    }

    public final StringProperty occurAmtProperty() {
        return this.occurAmt;
    }

    public final String getOccurAmt() {
        return (String)this.occurAmtProperty().get();
    }

    public final void setOccurAmt(String occurAmt) {
        this.occurAmtProperty().set((Object)occurAmt);
    }

    public final StringProperty balanceProperty() {
        return this.balance;
    }

    public final String getBalance() {
        return (String)this.balanceProperty().get();
    }

    public final void setBalance(String balance) {
        this.balanceProperty().set((Object)balance);
    }

    public final StringProperty availProperty() {
        return this.avail;
    }

    public final String getAvail() {
        return (String)this.availProperty().get();
    }

    public final void setAvail(String avail) {
        this.availProperty().set((Object)avail);
    }

    public final StringProperty advisableProperty() {
        return this.advisable;
    }

    public final String getAdvisable() {
        return (String)this.advisableProperty().get();
    }

    public final void setAdvisable(String advisable) {
        this.advisableProperty().set((Object)advisable);
    }

    public boolean isShowAmt() {
        return this.showAmt;
    }

    public void setShowAmt(boolean showAmt) {
        this.showAmt = showAmt;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getExTradeType() {
        return this.exTradeType;
    }

    public void setExTradeType(String exTradeType) {
        this.exTradeType = exTradeType;
    }
}

