/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class SubResult
extends MxObject {
    private StringProperty date = new SimpleStringProperty("");
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private ObjectProperty<MxNode> market = new SimpleObjectProperty();
    private DoubleProperty price = new SimpleDoubleProperty();
    private StringProperty start = new SimpleStringProperty();
    private IntegerProperty quantity = new SimpleIntegerProperty();
    private IntegerProperty count = new SimpleIntegerProperty();
    private DoubleProperty amount = new SimpleDoubleProperty();
    private StringProperty fundAcct = new SimpleStringProperty("");
    private StringProperty secAcct = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty inverstorSecId = new SimpleStringProperty("");
    private StringProperty portfolioId = new SimpleStringProperty("");
    private StringProperty portfolioName = new SimpleStringProperty("");
    @Inject
    private MObjFactory of;

    @PostConstruct
    private void init() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.setMarket(node);
    }

    public void update(Object obj) {
        if (obj instanceof PCashService.ApplyNumber) {
            PCashService.ApplyNumber num = (PCashService.ApplyNumber)PCashService.ApplyNumber.class.cast(obj);
            this.update(num);
        }
    }

    private void update(PCashService.ApplyNumber num) {
        this.setDate(num.getApplyDay());
        this.setCode(num.getSecurityId());
        this.setName(num.getSecurityName());
        this.getMarket().setRaw(num.getMarket());
        this.setPrice(Double.valueOf(String.format("%.3f", num.getPrice())));
        this.setQuantity(num.getNumberSize());
        if (this.getMarket().getRaw().equals("XSHG")) {
            this.setCount(num.getNumberSize() * 1000);
        }
        if (this.getMarket().getRaw().equals("XSHE")) {
            this.setCount(num.getNumberSize() * 500);
        }
        this.setAmount(num.getHitMoney());
        this.setSecAcct(num.getExtSecAccntId());
        this.setStart(num.getStartNumber());
    }

    public final StringProperty dateProperty() {
        return this.date;
    }

    public final String getDate() {
        return (String)this.dateProperty().get();
    }

    public final void setDate(String date) {
        this.dateProperty().set((Object)date);
    }

    public final StringProperty codeProperty() {
        return this.code;
    }

    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final IntegerProperty quantityProperty() {
        return this.quantity;
    }

    public final int getQuantity() {
        return this.quantityProperty().get();
    }

    public final void setQuantity(int quantity) {
        this.quantityProperty().set(quantity);
    }

    public final DoubleProperty amountProperty() {
        return this.amount;
    }

    public final double getAmount() {
        return this.amountProperty().get();
    }

    public final void setAmount(double amount) {
        this.amountProperty().set(amount);
    }

    public final StringProperty fundAcctProperty() {
        return this.fundAcct;
    }

    public final String getFundAcct() {
        return (String)this.fundAcctProperty().get();
    }

    public final void setFundAcct(String fundAcct) {
        this.fundAcctProperty().set((Object)fundAcct);
    }

    public final StringProperty secAcctProperty() {
        return this.secAcct;
    }

    public final String getSecAcct() {
        return (String)this.secAcctProperty().get();
    }

    public final void setSecAcct(String secAcct) {
        this.secAcctProperty().set((Object)secAcct);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final IntegerProperty countProperty() {
        return this.count;
    }

    public final int getCount() {
        return this.countProperty().get();
    }

    public final void setCount(int count) {
        this.countProperty().set(count);
    }

    public final StringProperty startProperty() {
        return this.start;
    }

    public final String getStart() {
        return (String)this.startProperty().get();
    }

    public final void setStart(String start) {
        this.startProperty().set((Object)start);
    }

    public final ObjectProperty<MxNode> marketProperty() {
        return this.market;
    }

    public final MxNode getMarket() {
        return (MxNode)this.marketProperty().get();
    }

    public final void setMarket(MxNode market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty inverstorSecIdProperty() {
        return this.inverstorSecId;
    }

    public final String getInverstorSecId() {
        return (String)this.inverstorSecIdProperty().get();
    }

    public final void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecIdProperty().set((Object)inverstorSecId);
    }

    public final StringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public final String getPortfolioId() {
        return (String)this.portfolioIdProperty().get();
    }

    public final void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set((Object)portfolioId);
    }

    public final StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public final String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public final void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }
}

