/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.javafx.obj.MxObject;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class SecuritySummary
extends MxObject {
    private Instrument instrument;
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty portfolio = new SimpleStringProperty("");
    private DoubleProperty dividendVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty dividendAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty buyVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty buyAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty sellVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty sellAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty profit = new SimpleDoubleProperty(0.0);
    private String secId;
    private String secName;
    private String market;

    public void update(Object obj) {
        if (obj instanceof PCashService.ExtAccntSecuritySummary) {
            this.update((PCashService.ExtAccntSecuritySummary)PCashService.ExtAccntSecuritySummary.class.cast(obj));
        } else if (obj instanceof PCashService.SubAccntSecuritySummary) {
            this.update((PCashService.SubAccntSecuritySummary)PCashService.SubAccntSecuritySummary.class.cast(obj));
        } else if (obj instanceof SecuritySummary) {
            this.update((SecuritySummary)((Object)SecuritySummary.class.cast(obj)));
        }
    }

    private void update(PCashService.ExtAccntSecuritySummary ca) {
        PCashService.Instrument inst = ca.getInstrument();
        this.getInstrument().update((Object)inst);
        this.setSecId(this.getInstrument().getSecId());
        this.setMarket(this.getInstrument().getMarket().getValue());
        this.setInvestorId(ca.getInvestorId());
        this.setDividendVolume((long)ca.getDividendVolume());
        this.setDividendAmt((double)Math.round(ca.getDividendAmt() * 100.0) / 100.0);
        this.setBuyVolume((long)ca.getBuyInVolume());
        this.setBuyAmt((double)Math.round(ca.getBuyInAmt() * 100.0) / 100.0);
        this.setSellVolume((long)ca.getSellOutVolume());
        this.setSellAmt((double)Math.round(ca.getSellOutAmt() * 100.0) / 100.0);
        this.setProfit((double)Math.round(ca.getProfit() * 100.0) / 100.0);
    }

    private void update(PCashService.SubAccntSecuritySummary ca) {
        PCashService.Instrument inst = ca.getInstrument();
        this.getInstrument().update((Object)inst);
        this.setSecId(this.getInstrument().getSecId());
        this.setMarket(this.getInstrument().getMarket().getValue());
        this.setPortfolio(ca.getPortfolioId());
        this.setDividendVolume((long)ca.getDividendVolume());
        this.setDividendAmt((double)Math.round(ca.getDividendAmt() * 100.0) / 100.0);
        this.setBuyVolume((long)ca.getBuyInVolume());
        this.setBuyAmt((double)Math.round(ca.getBuyInAmt() * 100.0) / 100.0);
        this.setSellVolume((long)ca.getSellOutVolume());
        this.setSellAmt((double)Math.round(ca.getSellOutAmt() * 100.0) / 100.0);
        this.setProfit((double)Math.round(ca.getProfit() * 100.0) / 100.0);
    }

    private void update(SecuritySummary ca) {
        this.setInstrument(ca.getInstrument());
        this.setSecId(ca.getSecId());
        this.setSecName(ca.getSecName());
        this.setMarket(ca.getMarket());
        this.setInvestorId(ca.getInvestorId());
        this.setPortfolio(ca.getPortfolio());
        this.setDividendVolume(ca.getDividendVolume());
        this.setDividendAmt(ca.getDividendAmt());
        this.setBuyVolume(ca.getBuyVolume());
        this.setBuyAmt(ca.getBuyAmt());
        this.setSellVolume(ca.getSellVolume());
        this.setSellAmt(ca.getSellAmt());
        this.setProfit(ca.getProfit());
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty portfolioProperty() {
        return this.portfolio;
    }

    public final String getPortfolio() {
        return (String)this.portfolioProperty().get();
    }

    public final void setPortfolio(String portfolio) {
        this.portfolioProperty().set((Object)portfolio);
    }

    public final DoubleProperty dividendVolumeProperty() {
        return this.dividendVolume;
    }

    public final double getDividendVolume() {
        return this.dividendVolumeProperty().get();
    }

    public final void setDividendVolume(double dividendVolume) {
        this.dividendVolumeProperty().set(dividendVolume);
    }

    public final DoubleProperty dividendAmtProperty() {
        return this.dividendAmt;
    }

    public final double getDividendAmt() {
        return this.dividendAmtProperty().get();
    }

    public final void setDividendAmt(double dividendAmt) {
        this.dividendAmtProperty().set(dividendAmt);
    }

    public final DoubleProperty buyVolumeProperty() {
        return this.buyVolume;
    }

    public final double getBuyVolume() {
        return this.buyVolumeProperty().get();
    }

    public final void setBuyVolume(double buyVolume) {
        this.buyVolumeProperty().set(buyVolume);
    }

    public final DoubleProperty buyAmtProperty() {
        return this.buyAmt;
    }

    public final double getBuyAmt() {
        return this.buyAmtProperty().get();
    }

    public final void setBuyAmt(double buyAmt) {
        this.buyAmtProperty().set(buyAmt);
    }

    public final DoubleProperty sellVolumeProperty() {
        return this.sellVolume;
    }

    public final double getSellVolume() {
        return this.sellVolumeProperty().get();
    }

    public final void setSellVolume(double sellVolume) {
        this.sellVolumeProperty().set(sellVolume);
    }

    public final DoubleProperty sellAmtProperty() {
        return this.sellAmt;
    }

    public final double getSellAmt() {
        return this.sellAmtProperty().get();
    }

    public final void setSellAmt(double sellAmt) {
        this.sellAmtProperty().set(sellAmt);
    }

    public final DoubleProperty profitProperty() {
        return this.profit;
    }

    public final double getProfit() {
        return this.profitProperty().get();
    }

    public final void setProfit(double profit) {
        this.profitProperty().set(profit);
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public String getSecId() {
        return this.secId;
    }

    public void setSecId(String secId) {
        this.secId = secId;
    }

    public String getSecName() {
        return this.secName;
    }

    public void setSecName(String secName) {
        this.secName = secName;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }
}

