/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.proto.trade.PCashService;
import java.math.BigDecimal;

public class SecTransRecord {
    private String fundAccId;
    private String secAccId;
    private String masterPortId;
    private String slavePortId;
    private String code;
    private String name;
    private int count;
    private Double price;
    private String operDate;
    private String operTime;
    private String userId;
    private String partyId;
    private String market;

    public void update(Object obj) {
        if (obj instanceof PCashService.PosTransRecord) {
            this.update((PCashService.PosTransRecord)PCashService.PosTransRecord.class.cast(obj));
        }
    }

    private void update(PCashService.PosTransRecord record) {
        this.setFundAccId(record.getExtAccntId().replaceAll("[_A-Z]*", ""));
        String srcProtf = record.getSrcPortfolioId();
        String dstProtf = record.getDstPortfolioId();
        this.setMasterPortId(srcProtf.isEmpty() ? this.getFundAccId() : srcProtf);
        this.setSlavePortId(dstProtf.isEmpty() ? this.getFundAccId() : dstProtf);
        this.setUserId(record.getUserId());
        this.setPartyId(record.getUserPartyId());
        this.setOperDate(record.getOperDate());
        this.setOperTime(record.getOperTime());
        PCashService.TransPositionElem elem = record.getElem();
        this.setSecAccId(elem.getSecAccntId().replaceAll("[_A-Z]*", ""));
        this.setMarket(elem.getMic());
        this.setCode(elem.getSecurityId());
        this.setName(elem.getSymbol());
        this.setCount((int)elem.getQuantity());
        this.setPrice(BigDecimal.valueOf(elem.getCostPrice()).setScale(2, 4).doubleValue());
    }

    public String getFundAccId() {
        return this.fundAccId;
    }

    public void setFundAccId(String fundAccId) {
        this.fundAccId = fundAccId;
    }

    public String getSecAccId() {
        return this.secAccId;
    }

    public void setSecAccId(String secAccId) {
        this.secAccId = secAccId;
    }

    public String getMasterPortId() {
        return this.masterPortId;
    }

    public void setMasterPortId(String masterPortId) {
        this.masterPortId = masterPortId;
    }

    public String getSlavePortId() {
        return this.slavePortId;
    }

    public void setSlavePortId(String slavePortId) {
        this.slavePortId = slavePortId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getOperDate() {
        return this.operDate;
    }

    public void setOperDate(String operDate) {
        this.operDate = operDate;
    }

    public String getOperTime() {
        return this.operTime;
    }

    public void setOperTime(String operTime) {
        this.operTime = operTime;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }
}

