/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PQuote;
import cms.tmx.entity.factory.CfetsLegFactory;
import cms.tmx.entity.factory.CfetsRoutingGrpFactory;
import cms.tmx.entity.factory.DeliveryTypeOptionFactory;
import cms.tmx.entity.factory.InstrumentFactory;
import cms.tmx.entity.trade.CfetsLeg;
import cms.tmx.entity.trade.CfetsRoutingGrp;
import cms.tmx.entity.trade.DeliveryTypeOption;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.entity.trade.LegStipulation;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class Quote
extends MxSelObj {
    private StringProperty quoteId = new SimpleStringProperty("");
    private ObjectProperty<Instrument> instrument = new SimpleObjectProperty();
    private ObjectProperty<CfetsRoutingGrp> cfetsRoutingGrp = new SimpleObjectProperty();
    private ObjectProperty<MxNode> anonymousIndicator = new SimpleObjectProperty();
    private ObjectProperty<MxNode> quoteType = new SimpleObjectProperty();
    private ObjectProperty<MxNode> contingencyIndicatior = new SimpleObjectProperty();
    private StringProperty quoteTime = new SimpleStringProperty("");
    private IntegerProperty maxFloor = new SimpleIntegerProperty(0);
    private IntegerProperty minTickSize = new SimpleIntegerProperty(0);
    private StringProperty validUntilTime = new SimpleStringProperty("");
    private ObjectProperty<MxNode> quoteStatus = new SimpleObjectProperty();
    private ObservableList<DeliveryTypeOption> deliveryTypeOptionList = FxUtils.newList();
    private ObservableList<CfetsLeg> cfetsLegList = FxUtils.newList();
    private ObjectProperty<CfetsLeg> buyLeg = new SimpleObjectProperty();
    private ObjectProperty<CfetsLeg> sellLeg = new SimpleObjectProperty();
    private StringProperty transactTime = new SimpleStringProperty("");
    private StringProperty clOrdId = new SimpleStringProperty("");
    private StringProperty cfetsUserID = new SimpleStringProperty("");
    private ObjectProperty<MxNode> errorCode = new SimpleObjectProperty();
    private StringProperty errorText = new SimpleStringProperty("");
    private StringProperty accntID = new SimpleStringProperty();
    private StringProperty secAccntID = new SimpleStringProperty();
    private DoubleProperty buyYtmLst = new SimpleDoubleProperty(0.0);
    private DoubleProperty buySkLst = new SimpleDoubleProperty(0.0);
    private DoubleProperty sellYtmLst = new SimpleDoubleProperty(0.0);
    private DoubleProperty sellSkLst = new SimpleDoubleProperty(0.0);
    private StringProperty restTime = new SimpleStringProperty("");
    private ObjectProperty<DeliveryTypeOption> buyDto = new SimpleObjectProperty();
    private ObjectProperty<DeliveryTypeOption> sellDto = new SimpleObjectProperty();
    private StringProperty partySubID = new SimpleStringProperty("");
    private StringProperty fundAccountNameStr = new SimpleStringProperty("");
    private StringProperty secAccountNameStr = new SimpleStringProperty("");
    @Inject
    private MObjFactory of;
    @Inject
    private InstrumentFactory insf;
    @Inject
    private CfetsRoutingGrpFactory crgf;
    @Inject
    private DeliveryTypeOptionFactory dtof;
    @Inject
    private CfetsLegFactory clf;
    private String buy = "49";
    private String sell = "50";
    private static MxNode anonymousIndicatorNode;
    private static MxNode quoteTypeNode;
    private static MxNode contingencyIndicatiorNode;
    private static MxNode quoteStatusNode;
    private static MxNode errorCodeNode;

    @PostConstruct
    public void init() {
        if (anonymousIndicatorNode == null) {
            anonymousIndicatorNode = MxNodeFactory.create((String)"anonymous_indicator", (String)"");
        }
        this.setAnonymousIndicator(anonymousIndicatorNode.clone());
        if (quoteTypeNode == null) {
            quoteTypeNode = MxNodeFactory.create((String)"quote_type", (String)"");
        }
        this.setQuoteType(quoteTypeNode.clone());
        if (contingencyIndicatiorNode == null) {
            contingencyIndicatiorNode = MxNodeFactory.create((String)"contingency_indicatior", (String)"");
        }
        this.setContingencyIndicatior(contingencyIndicatiorNode.clone());
        if (quoteStatusNode == null) {
            quoteStatusNode = MxNodeFactory.create((String)"quote_status", (String)"");
        }
        this.setQuoteStatus(quoteStatusNode.clone());
        if (errorCodeNode == null) {
            errorCodeNode = MxNodeFactory.create((String)"cfets_error_code", (String)"");
        }
        this.setErrorCode(errorCodeNode.clone());
    }

    public void update(Object obj) {
        if (obj instanceof PQuote.Quote) {
            PQuote.Quote en = (PQuote.Quote)PQuote.Quote.class.cast(obj);
            this.update(en);
        } else if (obj instanceof Quote) {
            Quote en = (Quote)((Object)Quote.class.cast(obj));
            this.update(en);
        }
    }

    private void update(PQuote.Quote en) {
        PComponent.Instrument inst = en.getInstrument();
        if (this.getInstrument() == null) {
            this.setInstrument(this.insf.create());
        }
        this.getInstrument().update((Object)inst);
        this.setQuoteId(en.getQuoteId());
        PComponent.CfetsRoutingGrp cfetsRoutingGrp = en.getRoutingGrp();
        if (this.getCfetsRoutingGrp() == null) {
            this.setCfetsRoutingGrp(this.crgf.create());
        }
        this.getCfetsRoutingGrp().update((Object)cfetsRoutingGrp);
        this.getAnonymousIndicator().setRaw(en.getAnonymousIndicator());
        this.getQuoteType().setRaw(Integer.toString(en.getQuoteType().getNumber()));
        this.getContingencyIndicatior().setRaw(en.getContingencyIndicatior());
        this.setQuoteTime(en.getQuoteTime());
        this.setMaxFloor(en.getMaxFloor() / 10000);
        this.setMinTickSize(en.getMinTickSize() / 10000);
        this.setValidUntilTime(en.getValidUntilTime());
        this.getQuoteStatus().setRaw(Integer.toString(en.getQuoteStatus().getNumber()));
        this.setPartySubID(en.getCfetsUserId());
        this.setTransactTime(en.getTransactTime());
        this.setClOrdId(en.getClOrdId());
        this.setCfetsUserID(en.getCfetsUserId());
        this.getErrorCode().setRaw(en.getErrorCode());
        if ("".equals(this.getErrorCode().getValue()) || this.getErrorCode().getValue() == null) {
            this.setErrorText(en.getErrorCode());
        } else {
            this.setErrorText(this.getErrorCode().getValue());
        }
        for (PComponent.DeliveryTypeOption deliveryTypeOption : en.getDeliveryTypeOptionList()) {
            DeliveryTypeOption dto = this.dtof.create();
            dto.update((Object)deliveryTypeOption);
            if (this.buy.equals(Integer.toString(deliveryTypeOption.getDeliveryOptionDirection().getNumber()))) {
                this.buyDto.set((Object)dto);
            } else if (this.sell.equals(Integer.toString(deliveryTypeOption.getDeliveryOptionDirection().getNumber()))) {
                this.sellDto.set((Object)dto);
            }
            this.deliveryTypeOptionList.add((Object)dto);
        }
        for (PComponent.CfetsLeg cfetsLeg : en.getLegList()) {
            CfetsLeg cl = this.clf.create();
            cl.update((Object)cfetsLeg);
            if (this.buy.equals(Integer.toString(cfetsLeg.getLegSide().getNumber()))) {
                this.buyLeg.set((Object)cl);
                for (LegStipulation legStipulation : cl.getLegStipulationList()) {
                    if ("\u5230\u671f\u6536\u76ca\u7387".equals(legStipulation.getLegStipulationType().getValue())) {
                        this.buyYtmLst.setValue((Number)legStipulation.getLegStipulationValue());
                        continue;
                    }
                    if (!"\u884c\u6743\u6536\u76ca\u7387".equals(legStipulation.getLegStipulationType().getValue())) continue;
                    this.buySkLst.setValue((Number)legStipulation.getLegStipulationValue());
                }
                continue;
            }
            if (!this.sell.equals(Integer.toString(cfetsLeg.getLegSide().getNumber()))) continue;
            this.sellLeg.set((Object)cl);
            for (LegStipulation legStipulation : cl.getLegStipulationList()) {
                if ("\u5230\u671f\u6536\u76ca\u7387".equals(legStipulation.getLegStipulationType().getValue())) {
                    this.sellYtmLst.setValue((Number)legStipulation.getLegStipulationValue());
                    continue;
                }
                if (!"\u884c\u6743\u6536\u76ca\u7387".equals(legStipulation.getLegStipulationType().getValue())) continue;
                this.sellSkLst.setValue((Number)legStipulation.getLegStipulationValue());
            }
        }
    }

    private void update(Quote en) {
        this.setInstrument(en.getInstrument());
        this.setQuoteId(en.getQuoteId());
        this.setCfetsRoutingGrp(en.getCfetsRoutingGrp());
        this.setAnonymousIndicator(en.getAnonymousIndicator());
        this.setQuoteType(en.getQuoteType());
        this.setContingencyIndicatior(en.getContingencyIndicatior());
        this.setQuoteTime(en.getQuoteTime());
        this.setMaxFloor(en.getMaxFloor());
        this.setMinTickSize(en.getMinTickSize());
        this.setValidUntilTime(en.getValidUntilTime());
        this.setQuoteStatus(en.getQuoteStatus());
        this.setPartySubID(en.getPartySubID());
        this.setDeliveryTypeOptionList(en.getDeliveryTypeOptionList());
        this.setCfetsLegList(en.getCfetsLegList());
        this.setTransactTime(en.getTransactTime());
        this.setClOrdId(en.getClOrdId());
        this.setCfetsUserID(en.getCfetsUserID());
        this.setBuyLeg(en.getBuyLeg());
        this.setBuySkLst(en.getBuySkLst());
        this.setBuyYtmLst(en.getBuyYtmLst());
        this.setBuyDto(en.getBuyDto());
        this.setSellLeg(en.getSellLeg());
        this.setSellSkLst(en.getSellSkLst());
        this.setSellYtmLst(en.getSellYtmLst());
        this.setSellDto(en.getSellDto());
    }

    public final StringProperty quoteIdProperty() {
        return this.quoteId;
    }

    public final String getQuoteId() {
        return (String)this.quoteIdProperty().get();
    }

    public final void setQuoteId(String quoteId) {
        this.quoteIdProperty().set((Object)quoteId);
    }

    public final ObjectProperty<Instrument> instrumentProperty() {
        return this.instrument;
    }

    public final Instrument getInstrument() {
        return (Instrument)((Object)this.instrumentProperty().get());
    }

    public final void setInstrument(Instrument instrument) {
        this.instrumentProperty().set((Object)instrument);
    }

    public final ObjectProperty<CfetsRoutingGrp> cfetsRoutingGrpProperty() {
        return this.cfetsRoutingGrp;
    }

    public final CfetsRoutingGrp getCfetsRoutingGrp() {
        return (CfetsRoutingGrp)((Object)this.cfetsRoutingGrpProperty().get());
    }

    public final void setCfetsRoutingGrp(CfetsRoutingGrp cfetsRoutingGrp) {
        this.cfetsRoutingGrpProperty().set((Object)cfetsRoutingGrp);
    }

    public final ObjectProperty<MxNode> anonymousIndicatorProperty() {
        return this.anonymousIndicator;
    }

    public final MxNode getAnonymousIndicator() {
        return (MxNode)this.anonymousIndicatorProperty().get();
    }

    public final void setAnonymousIndicator(MxNode anonymousIndicator) {
        this.anonymousIndicatorProperty().set((Object)anonymousIndicator);
    }

    public final ObjectProperty<MxNode> quoteTypeProperty() {
        return this.quoteType;
    }

    public final MxNode getQuoteType() {
        return (MxNode)this.quoteTypeProperty().get();
    }

    public final void setQuoteType(MxNode quoteType) {
        this.quoteTypeProperty().set((Object)quoteType);
    }

    public final ObjectProperty<MxNode> contingencyIndicatiorProperty() {
        return this.contingencyIndicatior;
    }

    public final MxNode getContingencyIndicatior() {
        return (MxNode)this.contingencyIndicatiorProperty().get();
    }

    public final void setContingencyIndicatior(MxNode contingencyIndicatior) {
        this.contingencyIndicatiorProperty().set((Object)contingencyIndicatior);
    }

    public final StringProperty quoteTimeProperty() {
        return this.quoteTime;
    }

    public final String getQuoteTime() {
        return (String)this.quoteTimeProperty().get();
    }

    public final void setQuoteTime(String quoteTime) {
        this.quoteTimeProperty().set((Object)quoteTime);
    }

    public final IntegerProperty maxFloorProperty() {
        return this.maxFloor;
    }

    public final int getMaxFloor() {
        return this.maxFloorProperty().get();
    }

    public final void setMaxFloor(int maxFloor) {
        this.maxFloorProperty().set(maxFloor);
    }

    public final IntegerProperty minTickSizeProperty() {
        return this.minTickSize;
    }

    public final int getMinTickSize() {
        return this.minTickSizeProperty().get();
    }

    public final void setMinTickSize(int minTickSize) {
        this.minTickSizeProperty().set(minTickSize);
    }

    public final StringProperty validUntilTimeProperty() {
        return this.validUntilTime;
    }

    public final String getValidUntilTime() {
        return (String)this.validUntilTimeProperty().get();
    }

    public final void setValidUntilTime(String validUntilTime) {
        this.validUntilTimeProperty().set((Object)validUntilTime);
    }

    public final ObjectProperty<MxNode> quoteStatusProperty() {
        return this.quoteStatus;
    }

    public final MxNode getQuoteStatus() {
        return (MxNode)this.quoteStatusProperty().get();
    }

    public final void setQuoteStatus(MxNode quoteStatus) {
        this.quoteStatusProperty().set((Object)quoteStatus);
    }

    public ObservableList<DeliveryTypeOption> getDeliveryTypeOptionList() {
        return this.deliveryTypeOptionList;
    }

    public void setDeliveryTypeOptionList(ObservableList<DeliveryTypeOption> deliveryTypeOptionList) {
        this.deliveryTypeOptionList = deliveryTypeOptionList;
    }

    public ObservableList<CfetsLeg> getCfetsLegList() {
        return this.cfetsLegList;
    }

    public void setCfetsLegList(ObservableList<CfetsLeg> cfetsLegList) {
        this.cfetsLegList = cfetsLegList;
    }

    public final ObjectProperty<CfetsLeg> buyLegProperty() {
        return this.buyLeg;
    }

    public final CfetsLeg getBuyLeg() {
        return (CfetsLeg)((Object)this.buyLegProperty().get());
    }

    public final void setBuyLeg(CfetsLeg buyLeg) {
        this.buyLegProperty().set((Object)buyLeg);
    }

    public final ObjectProperty<CfetsLeg> sellLegProperty() {
        return this.sellLeg;
    }

    public final CfetsLeg getSellLeg() {
        return (CfetsLeg)((Object)this.sellLegProperty().get());
    }

    public final void setSellLeg(CfetsLeg sellLeg) {
        this.sellLegProperty().set((Object)sellLeg);
    }

    public final DoubleProperty buyYtmLstProperty() {
        return this.buyYtmLst;
    }

    public final double getBuyYtmLst() {
        return this.buyYtmLstProperty().get();
    }

    public final void setBuyYtmLst(double buyYtmLst) {
        this.buyYtmLstProperty().set(buyYtmLst);
    }

    public final DoubleProperty buySkLstProperty() {
        return this.buySkLst;
    }

    public final double getBuySkLst() {
        return this.buySkLstProperty().get();
    }

    public final void setBuySkLst(double buySkLst) {
        this.buySkLstProperty().set(buySkLst);
    }

    public final DoubleProperty sellYtmLstProperty() {
        return this.sellYtmLst;
    }

    public final double getSellYtmLst() {
        return this.sellYtmLstProperty().get();
    }

    public final void setSellYtmLst(double sellYtmLst) {
        this.sellYtmLstProperty().set(sellYtmLst);
    }

    public final DoubleProperty sellSkLstProperty() {
        return this.sellSkLst;
    }

    public final double getSellSkLst() {
        return this.sellSkLstProperty().get();
    }

    public final void setSellSkLst(double sellSkLst) {
        this.sellSkLstProperty().set(sellSkLst);
    }

    public final ObjectProperty<DeliveryTypeOption> buyDtoProperty() {
        return this.buyDto;
    }

    public final DeliveryTypeOption getBuyDto() {
        return (DeliveryTypeOption)((Object)this.buyDtoProperty().get());
    }

    public final void setBuyDto(DeliveryTypeOption buyDto) {
        this.buyDtoProperty().set((Object)buyDto);
    }

    public final ObjectProperty<DeliveryTypeOption> sellDtoProperty() {
        return this.sellDto;
    }

    public final DeliveryTypeOption getSellDto() {
        return (DeliveryTypeOption)((Object)this.sellDtoProperty().get());
    }

    public final void setSellDto(DeliveryTypeOption sellDto) {
        this.sellDtoProperty().set((Object)sellDto);
    }

    public final StringProperty partySubIDProperty() {
        return this.partySubID;
    }

    public final String getPartySubID() {
        return (String)this.partySubIDProperty().get();
    }

    public final void setPartySubID(String partySubID) {
        this.partySubIDProperty().set((Object)partySubID);
    }

    public final StringProperty accntIDProperty() {
        return this.accntID;
    }

    public final String getAccntID() {
        return (String)this.accntIDProperty().get();
    }

    public final void setAccntID(String accntID) {
        this.accntIDProperty().set((Object)accntID);
    }

    public final StringProperty secAccntIDProperty() {
        return this.secAccntID;
    }

    public final String getSecAccntID() {
        return (String)this.secAccntIDProperty().get();
    }

    public final void setSecAccntID(String secAccntID) {
        this.secAccntIDProperty().set((Object)secAccntID);
    }

    public final StringProperty restTimeProperty() {
        return this.restTime;
    }

    public final String getRestTime() {
        return (String)this.restTimeProperty().get();
    }

    public final void setRestTime(String restTime) {
        this.restTimeProperty().set((Object)restTime);
    }

    public final StringProperty fundAccountNameStrProperty() {
        return this.fundAccountNameStr;
    }

    public final String getFundAccountNameStr() {
        return (String)this.fundAccountNameStrProperty().get();
    }

    public final void setFundAccountNameStr(String fundAccountNameStr) {
        this.fundAccountNameStrProperty().set((Object)fundAccountNameStr);
    }

    public final StringProperty secAccountNameStrProperty() {
        return this.secAccountNameStr;
    }

    public final String getSecAccountNameStr() {
        return (String)this.secAccountNameStrProperty().get();
    }

    public final void setSecAccountNameStr(String secAccountNameStr) {
        this.secAccountNameStrProperty().set((Object)secAccountNameStr);
    }

    public final StringProperty transactTimeProperty() {
        return this.transactTime;
    }

    public final String getTransactTime() {
        return (String)this.transactTimeProperty().get();
    }

    public final void setTransactTime(String transactTime) {
        this.transactTimeProperty().set((Object)transactTime);
    }

    public final StringProperty clOrdIdProperty() {
        return this.clOrdId;
    }

    public final String getClOrdId() {
        return (String)this.clOrdIdProperty().get();
    }

    public final void setClOrdId(String clOrdId) {
        this.clOrdIdProperty().set((Object)clOrdId);
    }

    public final StringProperty cfetsUserIDProperty() {
        return this.cfetsUserID;
    }

    public final String getCfetsUserID() {
        return (String)this.cfetsUserIDProperty().get();
    }

    public final void setCfetsUserID(String cfetsUserID) {
        this.cfetsUserIDProperty().set((Object)cfetsUserID);
    }

    public final ObjectProperty<MxNode> errorCodeProperty() {
        return this.errorCode;
    }

    public final MxNode getErrorCode() {
        return (MxNode)this.errorCodeProperty().get();
    }

    public final void setErrorCode(MxNode errorCode) {
        this.errorCodeProperty().set((Object)errorCode);
    }

    public final StringProperty errorTextProperty() {
        return this.errorText;
    }

    public final String getErrorText() {
        return (String)this.errorTextProperty().get();
    }

    public final void setErrorText(String errorText) {
        this.errorTextProperty().set((Object)errorText);
    }
}

