/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.api.trade.info.IPositionQueryInfo;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxDirtySelObj;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class Position
extends MxDirtySelObj
implements IPositionQueryInfo {
    private StringProperty secId = new SimpleStringProperty("");
    private StringProperty extAccId = new SimpleStringProperty("");
    private StringProperty extAccntName = new SimpleStringProperty("");
    private String brokerId = "";
    private StringProperty extSecAccId = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty investorName = new SimpleStringProperty("");
    private StringProperty inverstorSecId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> market = new SimpleObjectProperty();
    private String marketGrp = "";
    private StringProperty secName = new SimpleStringProperty("");
    private String secType = "";
    private StringProperty unit = new SimpleStringProperty("");
    private StringProperty tradingDay = new SimpleStringProperty("");
    private double newPrice;
    private StringProperty repoUnit = new SimpleStringProperty("");
    private StringProperty counterName = new SimpleStringProperty("");
    private String exMarket;
    private String portfolioId = "";
    private String portfolioName = "";
    private int posiId;
    private StringProperty accntGrpName = new SimpleStringProperty("");
    private StringProperty industry = new SimpleStringProperty("");

    public String toString() {
        return String.format("%s.%s.%s.%s", this.extAccId.get(), this.extSecAccId.get(), ((MxNode)this.market.get()).getRaw(), this.secId.get());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.extAccId.get() == null ? 0 : ((String)this.extAccId.get()).hashCode());
        result = 31 * result + (this.extSecAccId.get() == null ? 0 : ((String)this.extSecAccId.get()).hashCode());
        result = 31 * result + (this.market.get() == null ? 0 : ((MxNode)this.market.get()).getRaw().hashCode());
        result = 31 * result + (this.secId.get() == null ? 0 : ((String)this.secId.get()).hashCode());
        result = 31 * result + (this.secType == null ? 0 : this.secType.hashCode());
        result = 31 * result + (this.tradingDay.get() == null ? 0 : ((String)this.tradingDay.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)((Object)obj);
        if (this.extAccId.get() == null ? other.extAccId.get() != null : !((String)this.extAccId.get()).equals(other.extAccId.get())) {
            return false;
        }
        if (this.extSecAccId.get() == null ? other.extSecAccId.get() != null : !((String)this.extSecAccId.get()).equals(other.extSecAccId.get())) {
            return false;
        }
        if (this.market.get() == null ? other.market.get() != null : !((MxNode)this.market.get()).getRaw().equals(((MxNode)other.market.get()).getRaw())) {
            return false;
        }
        if (this.secId.get() == null ? other.secId.get() != null : !((String)this.secId.get()).equals(other.secId.get())) {
            return false;
        }
        if (this.secType == null ? other.secType != null : !this.secType.equals(other.secType)) {
            return false;
        }
        return !(this.tradingDay.get() == null ? other.tradingDay.get() != null : !((String)this.tradingDay.get()).equals(other.tradingDay.get()));
    }

    public void update(Object obj) {
        if (obj instanceof PPositionService.ExtPosition) {
            PPositionService.ExtPosition position = (PPositionService.ExtPosition)PPositionService.ExtPosition.class.cast(obj);
            this.update(position);
        } else if (obj instanceof PPositionService.SubPosition) {
            PPositionService.SubPosition position = (PPositionService.SubPosition)PPositionService.SubPosition.class.cast(obj);
            this.update(position);
        } else if (obj instanceof Position) {
            Position position = (Position)((Object)Position.class.cast(obj));
            this.update(position);
        }
    }

    private void update(PPositionService.ExtPosition po) {
        this.setSecId(po.getSecurityId());
        this.setExtAccId(po.getExtAccntId());
        this.setExtSecAccId(po.getExtSecAccntId());
        this.setMarketGrp(po.getMarketGrp());
        this.setSecName(po.getSecurityName());
        this.setSecType(po.getSecurityType());
        ((MxNode)this.market.get()).setRaw(po.getMarket());
        this.setTradingDay(po.getTradingDay());
        this.setExMarket(this.getMarket().getValue());
        if (po.getMarket().equals("XSHG")) {
            this.setRepoUnit("\u624b");
        } else if (po.getMarket().equals("XSHE")) {
            this.setRepoUnit("\u5f20");
        }
        this.setAccntGrpName(po.getAccntGroupId());
    }

    private void update(PPositionService.SubPosition po) {
        this.setSecId(po.getInstrument());
        this.setExtAccId(po.getExtAccntId());
        this.setExtSecAccId(po.getExtSecAccntId());
        this.setMarketGrp(po.getMarketGrp());
        this.setSecName(po.getSecurityName());
        this.setSecType(po.getSecurityType());
        ((MxNode)this.market.get()).setRaw(po.getMarket());
        this.setExMarket(this.getMarket().getValue());
        if (po.getMarket().equals("XSHG")) {
            this.setRepoUnit("\u624b");
        } else if (po.getMarket().equals("XSHE")) {
            this.setRepoUnit("\u5f20");
        }
    }

    private void update(Position po) {
        this.setSecId(po.getSecId());
        this.setExtAccId(po.getExtAccId());
        this.setExtAccntName(po.getExtAccntName());
        this.setExtSecAccId(po.getExtSecAccId());
        this.setBrokerId(po.getBrokerId());
        this.setInvestorId(po.getInvestorId());
        this.setInvestorName(po.getInvestorName());
        this.setInverstorSecId(po.getInverstorSecId());
        this.setMarketGrp(po.getMarketGrp());
        this.setSecName(po.getSecName());
        this.setSecType(po.getSecType());
        if (po.getMarket() != null) {
            ((MxNode)this.market.get()).setRaw(po.getMarket().getRaw());
            if (po.getMarket().equals((Object)"XSHG")) {
                this.setRepoUnit("\u624b");
            } else if (po.getMarket().equals((Object)"XSHE")) {
                this.setRepoUnit("\u5f20");
            }
        }
        this.setUnit(po.getUnit());
        this.setTradingDay(po.getTradingDay());
        this.setExMarket(po.getExMarket());
        this.setAccntGrpName(po.getAccntGrpName());
        this.setCounterName(po.getCounterName());
        this.setIndustry(po.getIndustry());
    }

    public StringProperty secIdProperty() {
        return this.secId;
    }

    public String getSecId() {
        return (String)this.secIdProperty().get();
    }

    public void setSecId(String secId) {
        this.secIdProperty().set((Object)secId);
    }

    public ObjectProperty<MxNode> marketProperty() {
        return this.market;
    }

    public MxNode getMarket() {
        return (MxNode)this.marketProperty().get();
    }

    public void setMarket(MxNode market) {
        this.marketProperty().set((Object)market);
    }

    public String getMarketGrp() {
        return this.marketGrp;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGrp = marketGrp;
    }

    public StringProperty secNameProperty() {
        return this.secName;
    }

    public String getSecName() {
        return (String)this.secNameProperty().get();
    }

    public void setSecName(String secName) {
        this.secNameProperty().set((Object)secName);
    }

    public StringProperty extAccIdProperty() {
        return this.extAccId;
    }

    public String getExtAccId() {
        return (String)this.extAccIdProperty().get();
    }

    public void setExtAccId(String extAccId) {
        this.extAccIdProperty().set((Object)extAccId);
    }

    public StringProperty extSecAccIdProperty() {
        return this.extSecAccId;
    }

    public String getExtSecAccId() {
        return (String)this.extSecAccIdProperty().get();
    }

    public void setExtSecAccId(String extSecAccId) {
        this.extSecAccIdProperty().set((Object)extSecAccId);
    }

    public String getMktGroupInfo() {
        return this.getMarketGrp();
    }

    public String getExtAccntIdInfo() {
        return this.getExtAccId();
    }

    public String getExtSecAccIdInfo() {
        return this.getExtSecAccId();
    }

    public String getSecIdInfo() {
        return this.getSecId();
    }

    public String getMktInfo() {
        return this.getMarket().getRaw();
    }

    public String getPstDirInfo() {
        return null;
    }

    public String getHedgeFlagInfo() {
        return null;
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final String getUnit() {
        return (String)this.unitProperty().get();
    }

    public final void setUnit(String unit) {
        this.unitProperty().set((Object)unit);
    }

    public StringProperty tradingDayProperty() {
        return this.tradingDay;
    }

    public String getTradingDay() {
        return (String)this.tradingDayProperty().get();
    }

    public void setTradingDay(String tradingDay) {
        this.tradingDayProperty().set((Object)tradingDay);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty inverstorSecIdProperty() {
        return this.inverstorSecId;
    }

    public final String getInverstorSecId() {
        return (String)this.inverstorSecIdProperty().get();
    }

    public final void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecIdProperty().set((Object)inverstorSecId);
    }

    public double getNewPrice() {
        return this.newPrice;
    }

    public void setNewPrice(double newPrice) {
        this.newPrice = newPrice;
    }

    public String getExMarket() {
        return this.exMarket;
    }

    public void setExMarket(String exMarket) {
        this.exMarket = exMarket;
    }

    public final StringProperty repoUnitProperty() {
        return this.repoUnit;
    }

    public final String getRepoUnit() {
        return (String)this.repoUnitProperty().get();
    }

    public final void setRepoUnit(String repoUnit) {
        this.repoUnitProperty().set((Object)repoUnit);
    }

    public int getPosiId() {
        return this.posiId;
    }

    public void setPosiId(int posiId) {
        this.posiId = posiId;
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public String getPortfolioName() {
        return this.portfolioName;
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioName = portfolioName;
    }

    public final StringProperty extAccntNameProperty() {
        return this.extAccntName;
    }

    public final String getExtAccntName() {
        return (String)this.extAccntNameProperty().get();
    }

    public final void setExtAccntName(String extAccntName) {
        this.extAccntNameProperty().set((Object)extAccntName);
    }

    public final StringProperty accntGrpNameProperty() {
        return this.accntGrpName;
    }

    public final String getAccntGrpName() {
        return (String)this.accntGrpNameProperty().get();
    }

    public final void setAccntGrpName(String accntGrpName) {
        this.accntGrpNameProperty().set((Object)accntGrpName);
    }

    public final StringProperty investorNameProperty() {
        return this.investorName;
    }

    public final String getInvestorName() {
        return (String)this.investorNameProperty().get();
    }

    public final void setInvestorName(String investorName) {
        this.investorNameProperty().set((Object)investorName);
    }

    public StringProperty counterNameProperty() {
        return this.counterName;
    }

    public String getCounterName() {
        return (String)this.counterNameProperty().get();
    }

    public void setCounterName(String counterName) {
        this.counterNameProperty().set((Object)counterName);
    }

    public final StringProperty industryProperty() {
        return this.industry;
    }

    public final String getIndustry() {
        return (String)this.industryProperty().get();
    }

    public final void setIndustry(String industry) {
        this.industryProperty().set((Object)industry);
    }
}

