/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PCcsRefdata;
import cms.tmx.datatype.message.PRefData;
import cms.tmx.entity.data.RefItem;
import com.google.protobuf.Any;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PledgeInfo
extends RefItem {
    private static final Logger logger = LogManager.getLogger(PledgeInfo.class);
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty type = new SimpleStringProperty("");
    private StringProperty subType = new SimpleStringProperty("");
    private StringProperty secCode = new SimpleStringProperty("");
    private StringProperty secName = new SimpleStringProperty("");
    private DoubleProperty multiplier = new SimpleDoubleProperty(0.0);
    private StringProperty stdCode = new SimpleStringProperty("");
    private StringProperty impTime = new SimpleStringProperty("");
    private DoubleProperty parValue = new SimpleDoubleProperty();

    @Override
    public void update(Object obj) {
        super.update(obj);
        if (obj instanceof PRefData.SecListItem) {
            PRefData.SecListItem refData = (PRefData.SecListItem)PRefData.SecListItem.class.cast(obj);
            Any any = refData.getObject();
            if (any.is(PCcsRefdata.PledgeStyleRepoBond.class)) {
                try {
                    PCcsRefdata.PledgeStyleRepoBond bond = (PCcsRefdata.PledgeStyleRepoBond)any.unpack(PCcsRefdata.PledgeStyleRepoBond.class);
                    this.updateBond(bond);
                    this.changed();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        } else if (obj instanceof cms.tmx.http.security.dto.PledgeInfo) {
            this.update((cms.tmx.http.security.dto.PledgeInfo)cms.tmx.http.security.dto.PledgeInfo.class.cast(obj));
        }
    }

    private void updateBond(PCcsRefdata.PledgeStyleRepoBond bond) {
        this.setParValue(bond.getFaceValue());
        this.setCode(bond.getSecurityId());
        this.setName(bond.getSecurityName());
        this.setMarket(bond.getMarket());
        this.setType(bond.getSecurityType());
        this.setSubType(bond.getSecuritySubType());
        this.setSecCode(bond.getProductSecId());
        this.setSecName(bond.getProductSecName());
        this.setMultiplier(bond.getContractMultiplier());
        this.setStdCode(bond.getStdSecCode());
        this.setImpTime(bond.getImpTime());
    }

    private void update(cms.tmx.http.security.dto.PledgeInfo info) {
        this.setCode(info.getInstrument().getSecurityId());
        this.setName(info.getInstrument().getSymbol());
        this.setMarket(info.getInstrument().getMarket());
        this.setType(info.getInstrument().getSecurityType());
        this.setType("PLEDGE");
        this.setSubType(info.getInstrument().getSecuritySubType());
        if (info.getUnderlying() != null) {
            this.setSecCode(info.getUnderlying().getSecurityId());
            this.setSecName(info.getUnderlying().getSymbol());
        }
        if (info.getParams() != null) {
            this.setParValue(info.getParams().getFaceValue());
            this.setImpTime(info.getParams().getImpTime());
            this.setMultiplier(info.getParams().getContractMultiplier());
            this.setStdCode(info.getParams().getRegularShare());
        }
    }

    @Override
    public final StringProperty codeProperty() {
        return this.code;
    }

    @Override
    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    @Override
    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    @Override
    public final StringProperty nameProperty() {
        return this.name;
    }

    @Override
    public final String getName() {
        return (String)this.nameProperty().get();
    }

    @Override
    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    @Override
    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    @Override
    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty typeProperty() {
        return this.type;
    }

    @Override
    public final String getType() {
        return (String)this.typeProperty().get();
    }

    @Override
    public final void setType(String type) {
        this.typeProperty().set((Object)type);
    }

    public final StringProperty subTypeProperty() {
        return this.subType;
    }

    public final String getSubType() {
        return (String)this.subTypeProperty().get();
    }

    public final void setSubType(String subType) {
        this.subTypeProperty().set((Object)subType);
    }

    public final StringProperty secCodeProperty() {
        return this.secCode;
    }

    public final String getSecCode() {
        return (String)this.secCodeProperty().get();
    }

    public final void setSecCode(String secCode) {
        this.secCodeProperty().set((Object)secCode);
    }

    public final StringProperty secNameProperty() {
        return this.secName;
    }

    public final String getSecName() {
        return (String)this.secNameProperty().get();
    }

    public final void setSecName(String secName) {
        this.secNameProperty().set((Object)secName);
    }

    public final DoubleProperty multiplierProperty() {
        return this.multiplier;
    }

    public final double getMultiplier() {
        return this.multiplierProperty().get();
    }

    public final void setMultiplier(double multiplier) {
        this.multiplierProperty().set(multiplier);
    }

    public final StringProperty stdCodeProperty() {
        return this.stdCode;
    }

    public final String getStdCode() {
        return (String)this.stdCodeProperty().get();
    }

    public final void setStdCode(String stdCode) {
        this.stdCodeProperty().set((Object)stdCode);
    }

    public final StringProperty impTimeProperty() {
        return this.impTime;
    }

    public final String getImpTime() {
        return (String)this.impTimeProperty().get();
    }

    public final void setImpTime(String impTime) {
        this.impTimeProperty().set((Object)impTime);
    }

    @Override
    public String toString() {
        return (String)this.code.get();
    }

    public DoubleProperty parValueProperty() {
        return this.parValue;
    }

    public double getParValue() {
        return this.parValueProperty().get();
    }

    public void setParValue(double parValue) {
        this.parValueProperty().set(parValue);
    }
}

