/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.SimpleBooleanProperty;

public class Order
extends MxSelObj {
    private static final List<String> CAN_CANCEL_STATUS = Arrays.asList("48", "49", "90", "54");
    private static final List<String> CAN_SELECT = Arrays.asList("90", "65");
    protected String orderId = "";
    private String clOrdId = "";
    protected String sysOrderId = "";
    private Instrument instrument;
    private String extAccntId = "";
    private String extSecAccntId = "";
    private String brokerId = "";
    private String investorId = "";
    private String inverstorSecId = "";
    private String subSecAccntId = "";
    private MxNode side;
    private int ordType;
    private int orderQty = 0;
    private String unit = "";
    private double price = 0.0;
    private String execId = "";
    private String execTime = "";
    private String execDateTime = "";
    private MxNode ordStatus;
    private int errCode;
    private String errInfo = "";
    private int wthErrCode;
    private String wthErrInfo = "";
    private double lastQty;
    private double lastPx;
    private int cumQty = 0;
    private double leavesQty;
    private double avgPx = 0.0;
    private double totalValue;
    private double orderAmt = 0.0;
    private double frozenMargin = 0.0;
    private double frozenCommission;
    private double margentaken;
    protected String ordDate = "";
    private String ordTime = "";
    private String counterOrdTime = "";
    private String ordDateTime = "";
    private double donePercent = 0.0;
    private boolean canCancel = false;
    private SimpleBooleanProperty canSelect = new SimpleBooleanProperty(false);
    private String secAccntId = "";
    private boolean canCancelReplace = true;
    private String underlying = "";
    private String applId = "";
    private String userId = "";
    private String userName = "";
    private String baseId = "";
    private int execModeType;
    private int execModeId;
    protected String source;
    private int tif;
    private int maxLevels;
    private String attachment = "";
    private double newPrice;
    private String resourceId = "";
    private String reference = "";
    private String riskDetail = "";
    private String wthUserName = "";
    private String wthTime = "";
    private String secId = "";
    private String secName = "";
    private String market = "";
    private String exSide = "";
    private String exOrdStatus = "";
    private double realFee = 0.0;
    private double commision = 0.0;
    private double chgOwnerFee = 0.0;
    private double stampTax = 0.0;
    private double handleFee = 0.0;
    private double secAdminFee = 0.0;
    private double otherFee = 0.0;
    private String portfolioId = "";
    private String portfolioName = "";
    private String ordTypeDesc = "";
    private String extOrderId = "";
    private double nowPrice = 0.0;
    private double rate;
    private String basketName = "";
    private long execExpectQty = 0L;
    private double execExpectAmt = 0.0;
    private String inverstorStatus = "";

    public void update(Object obj) {
        if (obj instanceof POrderService.SingleOrder) {
            POrderService.SingleOrder en = (POrderService.SingleOrder)POrderService.SingleOrder.class.cast(obj);
            this.update(en);
        } else if (obj instanceof Order) {
            Order en = (Order)((Object)Order.class.cast(obj));
            this.update(en);
        } else if (obj instanceof ExecutionReport) {
            this.update((ExecutionReport)ExecutionReport.class.cast(obj));
        }
    }

    private void update(ExecutionReport report) {
        PMessage.ExecutionReport pReport = report.getReport();
        this.getInstrument().update((Object)pReport.getInstrument());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.ordDate == null ? 0 : this.ordDate.hashCode());
        result = 31 * result + (this.sysOrderId == null ? 0 : this.sysOrderId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)((Object)obj);
        if (this.ordDate == null ? other.ordDate != null : !this.ordDate.equals(other.ordDate)) {
            return false;
        }
        return !(this.sysOrderId == null ? other.sysOrderId != null : !this.sysOrderId.equals(other.sysOrderId));
    }

    private void update(Order en) {
        this.setInstrument(en.getInstrument());
        this.setOrderId(en.getOrderId());
        this.setClOrdId(en.getClOrdId());
        this.setSysOrderId(en.getSysOrderId());
        this.setExtSecAccntId(en.getExtSecAccntId());
        this.setBrokerId(en.getBrokerId());
        this.setInverstorSecId(en.getInverstorSecId());
        this.setSide(en.getSide());
        this.setOrdType(en.getOrdType());
        this.setOrderQty(en.getOrderQty());
        this.setPrice(en.getPrice());
        this.setOrdStatus(en.getOrdStatus());
        this.setCumQty(en.getCumQty());
        this.setAvgPx(en.getAvgPx());
        this.setSecAccntId(en.getSecAccntId());
        this.setFrozenMargin(en.getFrozenMargin());
        this.setOrdDate(en.getOrdDate());
        this.setOrdTime(en.getOrdTime());
        this.setCounterOrdTime(en.getCounterOrdTime());
        this.setDonePercent(en.getDonePercent());
        this.setOrderAmt(en.getOrderAmt());
        this.setApplId(en.getApplId());
        this.setUserId(en.getUserId());
        this.setUserName(en.getUserName());
        this.setBaseId(en.getBaseId());
        this.setExecModeType(en.getExecModeType());
        this.setSource(en.getSource());
        this.setUnit(en.getUnit());
        this.setResourceId(en.getResourceId());
        this.setReference(en.getReference());
        this.setRiskDetail(en.getRiskDetail());
        this.setWthUserName(en.getWthUserName());
        this.setWthTime(en.getWthTime());
        this.setCanCancelReplace(en.isCanCancelReplace());
        this.setCanCancel(en.isCanCancel());
        this.setExtOrderId(en.getExtOrderId());
        this.setSecId(en.getSecId());
        this.setSecName(en.getSecName());
        this.setMarket(en.getMarket());
        this.setExSide(en.getExSide());
        this.setExOrdStatus(en.getExOrdStatus());
        this.setRealFee(en.getRealFee());
        this.setCommision(en.getCommision());
        this.setChgOwnerFee(en.getChgOwnerFee());
        this.setStampTax(en.getStampTax());
        this.setHandleFee(en.getHandleFee());
        this.setSecAdminFee(en.getSecAdminFee());
        this.setOtherFee(en.getOtherFee());
        this.setTif(en.getTif());
        this.setMaxLevels(en.getMaxLevels());
        this.setAttachment(en.getAttachment());
        this.setOrdTypeDesc(en.getOrdTypeDesc());
        this.setNowPrice(en.getNowPrice());
        this.setRate(en.getRate());
    }

    private void update(POrderService.SingleOrder en) {
        PComponent.Instrument inst = en.getInstrument();
        this.setTotalValue(en.getTradeAmount());
        this.getInstrument().update((Object)inst);
        this.setOrderId(en.getOrderId());
        this.setClOrdId(en.getClOrdId());
        this.setSysOrderId(en.getSysOrderId());
        this.setExtSecAccntId(en.getExtSecAccntId());
        this.getSide().setRaw(Integer.toString(en.getSideValue()));
        this.setOrdType(en.getOrdTypeValue());
        this.setOrderQty((int)en.getOrderQty());
        this.setPrice((double)Math.round(en.getPrice() * 1000.0) / 1000.0);
        this.getOrdStatus().setRaw(Integer.toString(en.getOrdStatusValue()));
        if (CAN_CANCEL_STATUS.contains(this.ordStatus.getRaw())) {
            this.setCanCancel(true);
        }
        if (CAN_SELECT.contains(this.ordStatus.getRaw())) {
            this.setCanSelect(true);
        }
        this.setCumQty((int)en.getCumQty());
        this.setAvgPx((double)Math.round(en.getAvgPx() * 10000.0) / 10000.0);
        this.setFrozenMargin((double)Math.round(en.getFrozenMargin() * 100.0) / 100.0);
        this.setOrdDate(en.getOrdDate());
        this.setOrdTime(en.getOrdTime());
        this.setCounterOrdTime(en.getCounterOrdTime());
        String ordDateTime = en.getOrdDatetime();
        if (en.getOrdTime().contains(".")) {
            ordDateTime = String.valueOf(ordDateTime) + en.getOrdTime().substring(en.getOrdTime().indexOf("."));
        }
        this.setOrdDateTime(ordDateTime);
        double per = 0.0;
        if (this.getCumQty() > 0 && this.getOrderQty() > 0) {
            per = (double)this.getCumQty() * 100.0 / (double)this.getOrderQty();
        }
        this.setDonePercent(per);
        this.setOrderAmt((double)Math.round(en.getOrderAmount() * 1000.0) / 1000.0);
        this.setApplId(en.getInstrument().getApplId());
        this.setUserId(en.getUserId());
        if (en.getExecMode().getEmName().contains("_")) {
            String str = en.getExecMode().getEmName();
            this.setBaseId(str.substring(0, str.indexOf("_")));
        } else {
            this.setBaseId(en.getExecMode().getEmName());
        }
        this.setExecModeType(en.getExecMode().getEmTypeValue());
        this.setExecModeId(en.getExecMode().getEmId());
        this.setSource(en.getExecMode().getEmName());
        this.setResourceId(en.getResourceId());
        this.setReference(en.getReference());
        this.setRiskDetail(en.getRiskDetail());
        this.setWthTime(en.getWthTime());
        this.setSecId(this.getInstrument().getSecId());
        this.setSecName(this.getInstrument().getSymbol());
        this.setMarket(this.getInstrument().getMarket().getValue());
        this.setExSide(this.getSide().getValue());
        this.setExOrdStatus(this.getOrdStatus().getValue());
        this.setRealFee(en.getRealFee());
        this.setCommision(en.getCommision());
        this.setChgOwnerFee(en.getChgOwnerFee());
        this.setStampTax(en.getStampTax());
        this.setHandleFee(en.getHandleFee());
        this.setSecAdminFee(en.getSecAdminFee());
        this.setOtherFee(en.getOtherFee());
        this.setTif(en.getTif());
        this.setMaxLevels(en.getMaxPriceLevels());
        this.setAttachment(en.getAttachment());
        this.setOrdTypeDesc(this.translateOrdType(en));
        this.setRate((double)Math.round(en.getExchangeRate() * 10000.0) / 10000.0);
    }

    private String translateOrdType(POrderService.SingleOrder en) {
        block35: {
            StringBuilder sb;
            block37: {
                block36: {
                    if (50 == en.getOrdTypeValue()) {
                        StringBuilder sb2 = new StringBuilder("\u9650\u4ef7");
                        if ("SHSC".equals(en.getInstrument().getMarket()) || "SZSC".equals(en.getInstrument().getMarket())) {
                            switch (en.getMaxPriceLevels()) {
                                case 2: {
                                    sb2.append("-\u9650\u4ef7\u76d8(\u96f6\u80a1)");
                                    break;
                                }
                                case 1: {
                                    sb2.append("-\u7ade\u4ef7\u9650\u4ef7\u76d8");
                                    break;
                                }
                                case 0: {
                                    sb2.append("-\u589e\u5f3a\u9650\u4ef7\u76d8");
                                    break;
                                }
                            }
                        }
                        return sb2.toString();
                    }
                    if (99 == en.getOrdTypeValue()) {
                        return "\u76d8\u540e\u56fa\u5b9a\u4ef7";
                    }
                    if (49 != en.getOrdTypeValue()) break block35;
                    sb = new StringBuilder("\u5e02\u4ef7-");
                    if (!"XSHE".equals(en.getInstrument().getMarket())) break block36;
                    switch (en.getTif()) {
                        case 48: {
                            if (en.getMaxPriceLevels() == 1) {
                                sb.append("\u5bf9\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            if (en.getMaxPriceLevels() == 0) {
                                sb.append("\u672c\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            break block37;
                        }
                        case 51: {
                            if (en.getMaxPriceLevels() == 0) {
                                sb.append("\u5373\u65f6\u6210\u4ea4\u5269\u4f59\u64a4\u9500");
                                break;
                            }
                            if (en.getMaxPriceLevels() == 5) {
                                sb.append("\u4e94\u6863\u5373\u6210\u5269\u64a4");
                                break;
                            }
                            break block37;
                        }
                        case 52: {
                            sb.append("\u5168\u989d\u6210\u4ea4\u6216\u64a4\u9500");
                            break;
                        }
                    }
                    break block37;
                }
                if ("XSHG".equals(en.getInstrument().getMarket())) {
                    if (48 == en.getTif()) {
                        if (en.getInstrument().getSecurityId().startsWith("688")) {
                            switch (en.getMaxPriceLevels()) {
                                case 5: {
                                    sb.append("\u4e94\u6863\u5373\u6210\u8f6c\u9650\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                    break;
                                }
                                case 0: {
                                    sb.append("\u672c\u65b9\u6700\u4f18\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                    break;
                                }
                                case 1: {
                                    sb.append("\u5bf9\u624b\u65b9\u6700\u4f18\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                    break;
                                }
                            }
                            sb.append((double)Math.round(en.getPrice() * 100.0) / 100.0);
                        } else {
                            switch (en.getMaxPriceLevels()) {
                                case 5: {
                                    sb.append("\u4e94\u6863\u5373\u6210\u8f6c\u9650\u4ef7");
                                    break;
                                }
                                case 0: {
                                    sb.append("\u672c\u65b9\u6700\u4f18\u4ef7");
                                    break;
                                }
                                case 1: {
                                    sb.append("\u5bf9\u624b\u65b9\u6700\u4f18\u4ef7");
                                    break;
                                }
                            }
                        }
                    } else if (51 == en.getTif() && 5 == en.getMaxPriceLevels()) {
                        if (en.getInstrument().getSecurityId().startsWith("688")) {
                            sb.append("\u4e94\u6863\u5373\u6210\u5269\u64a4-\u4fdd\u62a4\u4ef7\u683c-");
                            sb.append((double)Math.round(en.getPrice() * 100.0) / 100.0);
                        } else {
                            sb.append("\u4e94\u6863\u5373\u6210\u5269\u64a4");
                        }
                    }
                }
            }
            return sb.toString();
        }
        return "";
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getClOrdId() {
        return this.clOrdId;
    }

    public void setClOrdId(String clOrdId) {
        this.clOrdId = clOrdId;
    }

    public String getSysOrderId() {
        return this.sysOrderId;
    }

    public void setSysOrderId(String sysOrderId) {
        this.sysOrderId = sysOrderId;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }

    public String getInverstorSecId() {
        return this.inverstorSecId;
    }

    public void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecId = inverstorSecId;
    }

    public String getSubSecAccntId() {
        return this.subSecAccntId;
    }

    public void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntId = subSecAccntId;
    }

    public int getOrdType() {
        return this.ordType;
    }

    public void setOrdType(int ordType) {
        this.ordType = ordType;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getExecId() {
        return this.execId;
    }

    public void setExecId(String execId) {
        this.execId = execId;
    }

    public String getExecTime() {
        return this.execTime;
    }

    public void setExecTime(String execTime) {
        this.execTime = execTime;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public String getErrInfo() {
        return this.errInfo;
    }

    public void setErrInfo(String errInfo) {
        this.errInfo = errInfo;
    }

    public int getWthErrCode() {
        return this.wthErrCode;
    }

    public void setWthErrCode(int wthErrCode) {
        this.wthErrCode = wthErrCode;
    }

    public String getWthErrInfo() {
        return this.wthErrInfo;
    }

    public void setWthErrInfo(String wthErrInfo) {
        this.wthErrInfo = wthErrInfo;
    }

    public double getLastQty() {
        return this.lastQty;
    }

    public void setLastQty(double lastQty) {
        this.lastQty = lastQty;
    }

    public double getLastPx() {
        return this.lastPx;
    }

    public void setLastPx(double lastPx) {
        this.lastPx = lastPx;
    }

    public double getLeavesQty() {
        return this.leavesQty;
    }

    public void setLeavesQty(double leavesQty) {
        this.leavesQty = leavesQty;
    }

    public double getAvgPx() {
        return this.avgPx;
    }

    public void setAvgPx(double avgPx) {
        this.avgPx = avgPx;
    }

    public double getTotalValue() {
        return this.totalValue;
    }

    public void setTotalValue(double totalValue) {
        this.totalValue = totalValue;
    }

    public double getOrderAmt() {
        return this.orderAmt;
    }

    public void setOrderAmt(double orderAmt) {
        this.orderAmt = orderAmt;
    }

    public double getFrozenMargin() {
        return this.frozenMargin;
    }

    public void setFrozenMargin(double frozenMargin) {
        this.frozenMargin = frozenMargin;
    }

    public double getFrozenCommission() {
        return this.frozenCommission;
    }

    public void setFrozenCommission(double frozenCommission) {
        this.frozenCommission = frozenCommission;
    }

    public double getMargentaken() {
        return this.margentaken;
    }

    public void setMargentaken(double margentaken) {
        this.margentaken = margentaken;
    }

    public String getOrdDate() {
        return this.ordDate;
    }

    public void setOrdDate(String ordDate) {
        this.ordDate = ordDate;
    }

    public String getOrdTime() {
        return this.ordTime;
    }

    public void setOrdTime(String ordTime) {
        this.ordTime = ordTime;
    }

    public double getDonePercent() {
        return this.donePercent;
    }

    public void setDonePercent(double donePercent) {
        this.donePercent = donePercent;
    }

    public boolean isCanCancel() {
        return this.canCancel;
    }

    public void setCanCancel(boolean canCancel) {
        this.canCancel = canCancel;
    }

    public boolean isCanCancelReplace() {
        return this.canCancelReplace;
    }

    public void setCanCancelReplace(boolean canCancelReplace) {
        this.canCancelReplace = canCancelReplace;
    }

    public String getUnderlying() {
        return this.underlying;
    }

    public void setUnderlying(String underlying) {
        this.underlying = underlying;
    }

    public String getApplId() {
        return this.applId;
    }

    public void setApplId(String applId) {
        this.applId = applId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getBaseId() {
        return this.baseId;
    }

    public void setBaseId(String baseId) {
        this.baseId = baseId;
    }

    public int getExecModeType() {
        return this.execModeType;
    }

    public void setExecModeType(int execModeType) {
        this.execModeType = execModeType;
    }

    public int getExecModeId() {
        return this.execModeId;
    }

    public void setExecModeId(int execModeId) {
        this.execModeId = execModeId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public int getTif() {
        return this.tif;
    }

    public void setTif(int tif) {
        this.tif = tif;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public void setMaxLevels(int maxLevels) {
        this.maxLevels = maxLevels;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public double getNewPrice() {
        return this.newPrice;
    }

    public void setNewPrice(double newPrice) {
        this.newPrice = newPrice;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getRiskDetail() {
        return this.riskDetail;
    }

    public void setRiskDetail(String riskDetail) {
        this.riskDetail = riskDetail;
    }

    public String getWthUserName() {
        return this.wthUserName;
    }

    public void setWthUserName(String wthUserName) {
        this.wthUserName = wthUserName;
    }

    public String getWthTime() {
        return this.wthTime;
    }

    public void setWthTime(String wthTime) {
        this.wthTime = wthTime;
    }

    public String getSecId() {
        return this.secId;
    }

    public void setSecId(String secId) {
        this.secId = secId;
    }

    public String getSecName() {
        return this.secName;
    }

    public void setSecName(String secName) {
        this.secName = secName;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getExSide() {
        return this.exSide;
    }

    public void setExSide(String exSide) {
        this.exSide = exSide;
    }

    public String getExOrdStatus() {
        return this.exOrdStatus;
    }

    public void setExOrdStatus(String exOrdStatus) {
        this.exOrdStatus = exOrdStatus;
    }

    public double getRealFee() {
        return this.realFee;
    }

    public void setRealFee(double realFee) {
        this.realFee = realFee;
    }

    public double getCommision() {
        return this.commision;
    }

    public void setCommision(double commision) {
        this.commision = commision;
    }

    public double getChgOwnerFee() {
        return this.chgOwnerFee;
    }

    public void setChgOwnerFee(double chgOwnerFee) {
        this.chgOwnerFee = chgOwnerFee;
    }

    public double getStampTax() {
        return this.stampTax;
    }

    public void setStampTax(double stampTax) {
        this.stampTax = stampTax;
    }

    public double getHandleFee() {
        return this.handleFee;
    }

    public void setHandleFee(double handleFee) {
        this.handleFee = handleFee;
    }

    public double getSecAdminFee() {
        return this.secAdminFee;
    }

    public void setSecAdminFee(double secAdminFee) {
        this.secAdminFee = secAdminFee;
    }

    public double getOtherFee() {
        return this.otherFee;
    }

    public void setOtherFee(double otherFee) {
        this.otherFee = otherFee;
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public String getPortfolioName() {
        return this.portfolioName;
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioName = portfolioName;
    }

    public String getOrdTypeDesc() {
        return this.ordTypeDesc;
    }

    public void setOrdTypeDesc(String ordTypeDesc) {
        this.ordTypeDesc = ordTypeDesc;
    }

    public void setCumQty(int cumQty) {
        this.cumQty = cumQty;
    }

    public void setOrderQty(int orderQty) {
        this.orderQty = orderQty;
    }

    public int getOrderQty() {
        return this.orderQty;
    }

    public int getCumQty() {
        return this.cumQty;
    }

    public MxNode getSide() {
        return this.side;
    }

    public void setSide(MxNode side) {
        this.side = side;
    }

    public MxNode getOrdStatus() {
        return this.ordStatus;
    }

    public void setOrdStatus(MxNode ordStatus) {
        this.ordStatus = ordStatus;
    }

    public String getExtOrderId() {
        return this.orderId;
    }

    public void setExtOrderId(String extOrderId) {
        this.extOrderId = extOrderId;
    }

    public String getSecAccntId() {
        return this.inverstorSecId;
    }

    public void setSecAccntId(String secAccntId) {
        this.secAccntId = secAccntId;
    }

    public double getNowPrice() {
        return this.nowPrice;
    }

    public void setNowPrice(double nowPrice) {
        this.nowPrice = nowPrice;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public String getBasketName() {
        return this.basketName;
    }

    public void setBasketName(String basketName) {
        this.basketName = basketName;
    }

    public long getExecExpectQty() {
        return this.execExpectQty;
    }

    public void setExecExpectQty(long execExpectQty) {
        this.execExpectQty = execExpectQty;
    }

    public double getExecExpectAmt() {
        return this.execExpectAmt;
    }

    public void setExecExpectAmt(double execExpectAmt) {
        this.execExpectAmt = execExpectAmt;
    }

    public String getInverstorStatus() {
        return this.inverstorStatus;
    }

    public void setInverstorStatus(String inverstorStatus) {
        this.inverstorStatus = inverstorStatus;
    }

    public final SimpleBooleanProperty canSelectProperty() {
        return this.canSelect;
    }

    public final boolean isCanSelect() {
        return this.canSelectProperty().get();
    }

    public final void setCanSelect(boolean canSelect) {
        this.canSelectProperty().set(canSelect);
    }

    public String transferErrInfo() {
        StringBuilder errorInfo = new StringBuilder(this.getErrInfo());
        if ("52".equals(this.getOrdStatus().getRaw()) || "70".equals(this.getOrdStatus().getRaw())) {
            if (StringUtils.isEmpty((String)errorInfo.toString())) {
                errorInfo.append("\u5df2\u64a4\u5355 ");
            }
            errorInfo.append(this.getWthTime()).append(" ").append(this.getWthUserName()).append("\uff1b");
        }
        return errorInfo.toString();
    }

    public String getExecDateTime() {
        return this.execDateTime;
    }

    public void setExecDateTime(String execDateTime) {
        this.execDateTime = execDateTime;
    }

    public String getOrdDateTime() {
        return this.ordDateTime;
    }

    public void setOrdDateTime(String ordDateTime) {
        this.ordDateTime = ordDateTime;
    }

    public String getCounterOrdTime() {
        return this.counterOrdTime;
    }

    public void setCounterOrdTime(String counterOrdTime) {
        this.counterOrdTime = counterOrdTime;
    }
}

