/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.strategy.dto.SummarizedOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObSummarizedOrder
extends MxObject {
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty securityName = new SimpleStringProperty("");
    private StringProperty securityGroup = new SimpleStringProperty("");
    private ObjectProperty<SecSubType> secSubType = new SimpleObjectProperty();
    private String secType;
    private ObjectProperty<MxNode> market = new SimpleObjectProperty();
    private ObjectProperty<MxNode> side = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty unit = new SimpleStringProperty("");
    private DoubleProperty percent = new SimpleDoubleProperty(0.0);
    private DoubleProperty nowPrice = new SimpleDoubleProperty(0.0);
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty orderDate = new SimpleStringProperty("");
    private DoubleProperty avgPx = new SimpleDoubleProperty(0.0);
    private DoubleProperty orderQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty orderAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty cumQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty leavesQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty frozenQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty frozenAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty tradeAmount = new SimpleDoubleProperty(0.0);
    private double settlCurrAmt = 0.0;
    private DoubleProperty cxlQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty realFee = new SimpleDoubleProperty(0.0);
    private DoubleProperty commission = new SimpleDoubleProperty(0.0);
    private DoubleProperty chgOwnerFee = new SimpleDoubleProperty(0.0);
    private DoubleProperty stampTax = new SimpleDoubleProperty(0.0);
    private DoubleProperty handleFee = new SimpleDoubleProperty(0.0);
    private DoubleProperty secAdminFee = new SimpleDoubleProperty(0.0);
    private DoubleProperty otherFee = new SimpleDoubleProperty(0.0);
    private DoubleProperty incurredAmt = new SimpleDoubleProperty(0.0);
    private StringProperty portfolioId = new SimpleStringProperty("");
    private StringProperty portfolioName = new SimpleStringProperty("");
    private StringProperty sumDate = new SimpleStringProperty("");
    private StringProperty portGrpName = new SimpleStringProperty("");
    private String interval;
    String extCashAccntId;
    private String exMarket;
    private String exSide;

    public ObSummarizedOrder() {
        this.setSide(new MxNode().load("side", ""));
        this.setMarket(new MxNode().load("market_code", ""));
    }

    public void update(Object obj) {
        if (obj instanceof SummarizedOrder) {
            SummarizedOrder exe = (SummarizedOrder)obj;
            this.update(exe);
        } else if (obj instanceof ObSummarizedOrder) {
            ObSummarizedOrder exe = (ObSummarizedOrder)((Object)obj);
            this.update(exe);
        }
    }

    private void update(SummarizedOrder d) {
        this.setSecurityId(d.getInstrument().getSecurityId());
        this.setSecurityName(d.getInstrument().getSymbol());
        this.setSecurityGroup(d.getInstrument().getSecurityGroup());
        this.setSecType(d.getInstrument().getSecurityType());
        this.getMarket().setRaw(d.getMarket());
        this.getSide().setRaw(d.getSide().getValue());
        this.setInvestorId(d.getInvestorId());
        this.setOrderDate(d.getOrderDate());
        this.setAvgPx((double)Math.round(d.getAvgPx() * 1000.0) / 1000.0);
        this.setPortfolioId(d.getPortfolioId());
        this.setPortfolioName(d.getPortfolioName());
        this.setSumDate(d.getOrderDate());
        this.setOrderQty(d.getOrderQty());
        this.setOrderAmount(d.getOrderAmount());
        this.setCumQty(d.getCumQty());
        this.setLeavesQty(d.getLeavesQty());
        this.setFrozenQty(d.getFrozenQty());
        this.setFrozenAmount(d.getFrozenAmount());
        this.setTradeAmount((double)Math.round(d.getTradeAmount() * 100.0) / 100.0);
        this.setSettlCurrAmt(d.getSettlCurrAmt());
        this.setCxlQty(d.getCxlQty());
        this.setRealFee(d.getRealFee());
        this.setCommission(d.getCommission());
        this.setChgOwnerFee(d.getChgOwnerFee());
        this.setStampTax(d.getStampTax());
        this.setHandleFee(d.getHandleFee());
        this.setSecAdminFee(d.getSecAdminFee());
        this.setOtherFee(d.getOtherFee());
        this.setExtCashAccntId(d.getExtCashAccntId());
        this.setExMarket(this.getMarket().getValue());
        this.setExSide(this.getSide().getValue());
        this.setPortGrpName(d.getAssetGroupName());
        this.setSecSubType(SecSubType.get((String)d.getSecSubType()));
    }

    public void update(ObSummarizedOrder d) {
        this.setSecurityId(d.getSecurityId());
        this.setSecurityName(d.getSecurityName());
        this.setMarket(d.getMarket());
        this.setSecurityGroup(d.getSecurityGroup());
        this.setSide(d.getSide());
        this.setUnit(d.getUnit());
        this.setInvestorId(d.getInvestorId());
        this.setOrderDate(d.getOrderDate());
        this.setAvgPx(d.getAvgPx());
        this.setPortfolioId(d.getPortfolioId());
        this.setPortfolioName(d.getPortfolioName());
        this.setSumDate(d.getSumDate());
        this.setPercent(d.getPercent());
        this.setNowPrice(d.getNowPrice());
        this.setInterval(d.getInterval());
        this.setOrderQty(d.getOrderQty());
        this.setOrderAmount(d.getOrderAmount());
        this.setCumQty(d.getCumQty());
        this.setLeavesQty(d.getLeavesQty());
        this.setFrozenQty(d.getFrozenQty());
        this.setFrozenAmount(d.getFrozenAmount());
        this.setTradeAmount(d.getTradeAmount());
        this.setSettlCurrAmt(d.getSettlCurrAmt());
        this.setCxlQty(d.getCxlQty());
        this.setRealFee(d.getRealFee());
        this.setCommission(d.getCommission());
        this.setChgOwnerFee(d.getChgOwnerFee());
        this.setStampTax(d.getStampTax());
        this.setHandleFee(d.getHandleFee());
        this.setSecAdminFee(d.getSecAdminFee());
        this.setOtherFee(d.getOtherFee());
        this.setExtCashAccntId(d.getExtCashAccntId());
        this.setExMarket(this.getExMarket());
        this.setExSide(this.getExSide());
        this.setIncurredAmt(d.getIncurredAmt());
        this.setPortGrpName(d.getPortGrpName());
        this.setSecSubType(d.getSecSubType());
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public final StringProperty securityGroupProperty() {
        return this.securityGroup;
    }

    public final String getSecurityGroup() {
        return (String)this.securityGroupProperty().get();
    }

    public final void setSecurityGroup(String securityGroup) {
        this.securityGroupProperty().set((Object)securityGroup);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final String getUnit() {
        return (String)this.unitProperty().get();
    }

    public final void setUnit(String unit) {
        this.unitProperty().set((Object)unit);
    }

    public final DoubleProperty percentProperty() {
        return this.percent;
    }

    public final double getPercent() {
        return this.percentProperty().get();
    }

    public final void setPercent(double percent) {
        this.percentProperty().set(percent);
    }

    public final DoubleProperty nowPriceProperty() {
        return this.nowPrice;
    }

    public final double getNowPrice() {
        return this.nowPriceProperty().get();
    }

    public final void setNowPrice(double nowPrice) {
        this.nowPriceProperty().set(nowPrice);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty orderDateProperty() {
        return this.orderDate;
    }

    public final String getOrderDate() {
        return (String)this.orderDateProperty().get();
    }

    public final void setOrderDate(String orderDate) {
        this.orderDateProperty().set((Object)orderDate);
    }

    public final DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    public final double getAvgPx() {
        return this.avgPxProperty().get();
    }

    public final void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public final DoubleProperty orderQtyProperty() {
        return this.orderQty;
    }

    public final double getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public final void setOrderQty(double orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public final DoubleProperty orderAmountProperty() {
        return this.orderAmount;
    }

    public final double getOrderAmount() {
        return this.orderAmountProperty().get();
    }

    public final void setOrderAmount(double orderAmount) {
        this.orderAmountProperty().set(orderAmount);
    }

    public final DoubleProperty cumQtyProperty() {
        return this.cumQty;
    }

    public final double getCumQty() {
        return this.cumQtyProperty().get();
    }

    public final void setCumQty(double cumQty) {
        this.cumQtyProperty().set(cumQty);
    }

    public final DoubleProperty leavesQtyProperty() {
        return this.leavesQty;
    }

    public final double getLeavesQty() {
        return this.leavesQtyProperty().get();
    }

    public final void setLeavesQty(double leavesQty) {
        this.leavesQtyProperty().set(leavesQty);
    }

    public final DoubleProperty frozenQtyProperty() {
        return this.frozenQty;
    }

    public final double getFrozenQty() {
        return this.frozenQtyProperty().get();
    }

    public final void setFrozenQty(double frozenQty) {
        this.frozenQtyProperty().set(frozenQty);
    }

    public final DoubleProperty frozenAmountProperty() {
        return this.frozenAmount;
    }

    public final double getFrozenAmount() {
        return this.frozenAmountProperty().get();
    }

    public final void setFrozenAmount(double frozenAmount) {
        this.frozenAmountProperty().set(frozenAmount);
    }

    public final DoubleProperty tradeAmountProperty() {
        return this.tradeAmount;
    }

    public final double getTradeAmount() {
        return this.tradeAmountProperty().get();
    }

    public final void setTradeAmount(double tradeAmount) {
        this.tradeAmountProperty().set(tradeAmount);
    }

    public final DoubleProperty cxlQtyProperty() {
        return this.cxlQty;
    }

    public final double getCxlQty() {
        return this.cxlQtyProperty().get();
    }

    public final void setCxlQty(double cxlQty) {
        this.cxlQtyProperty().set(cxlQty);
    }

    public final DoubleProperty realFeeProperty() {
        return this.realFee;
    }

    public final double getRealFee() {
        return this.realFeeProperty().get();
    }

    public final void setRealFee(double realFee) {
        this.realFeeProperty().set(realFee);
    }

    public final DoubleProperty commissionProperty() {
        return this.commission;
    }

    public final double getCommission() {
        return this.commissionProperty().get();
    }

    public final void setCommission(double commission) {
        this.commissionProperty().set(commission);
    }

    public final DoubleProperty chgOwnerFeeProperty() {
        return this.chgOwnerFee;
    }

    public final double getChgOwnerFee() {
        return this.chgOwnerFeeProperty().get();
    }

    public final void setChgOwnerFee(double chgOwnerFee) {
        this.chgOwnerFeeProperty().set(chgOwnerFee);
    }

    public final DoubleProperty stampTaxProperty() {
        return this.stampTax;
    }

    public final double getStampTax() {
        return this.stampTaxProperty().get();
    }

    public final void setStampTax(double stampTax) {
        this.stampTaxProperty().set(stampTax);
    }

    public final DoubleProperty handleFeeProperty() {
        return this.handleFee;
    }

    public final double getHandleFee() {
        return this.handleFeeProperty().get();
    }

    public final void setHandleFee(double handleFee) {
        this.handleFeeProperty().set(handleFee);
    }

    public final DoubleProperty secAdminFeeProperty() {
        return this.secAdminFee;
    }

    public final double getSecAdminFee() {
        return this.secAdminFeeProperty().get();
    }

    public final void setSecAdminFee(double secAdminFee) {
        this.secAdminFeeProperty().set(secAdminFee);
    }

    public final DoubleProperty otherFeeProperty() {
        return this.otherFee;
    }

    public final double getOtherFee() {
        return this.otherFeeProperty().get();
    }

    public final void setOtherFee(double otherFee) {
        this.otherFeeProperty().set(otherFee);
    }

    public final DoubleProperty incurredAmtProperty() {
        return this.incurredAmt;
    }

    public final double getIncurredAmt() {
        return this.incurredAmtProperty().get();
    }

    public final void setIncurredAmt(double incurredAmt) {
        this.incurredAmtProperty().set(incurredAmt);
    }

    public final StringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public final String getPortfolioId() {
        return (String)this.portfolioIdProperty().get();
    }

    public final void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set((Object)portfolioId);
    }

    public final StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public final String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public final void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public final StringProperty sumDateProperty() {
        return this.sumDate;
    }

    public final String getSumDate() {
        return (String)this.sumDateProperty().get();
    }

    public final void setSumDate(String sumDate) {
        this.sumDateProperty().set((Object)sumDate);
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public String getExtCashAccntId() {
        return this.extCashAccntId;
    }

    public void setExtCashAccntId(String extCashAccntId) {
        this.extCashAccntId = extCashAccntId;
    }

    public final ObjectProperty<MxNode> marketProperty() {
        return this.market;
    }

    public final MxNode getMarket() {
        return (MxNode)this.marketProperty().get();
    }

    public final void setMarket(MxNode market) {
        this.marketProperty().set((Object)market);
    }

    public String getExMarket() {
        return this.exMarket;
    }

    public void setExMarket(String exMarket) {
        this.exMarket = exMarket;
    }

    public String getExSide() {
        return this.exSide;
    }

    public void setExSide(String exSide) {
        this.exSide = exSide;
    }

    public double getSettlCurrAmt() {
        return this.settlCurrAmt;
    }

    public void setSettlCurrAmt(double settlCurrAmt) {
        this.settlCurrAmt = settlCurrAmt;
    }

    public final StringProperty portGrpNameProperty() {
        return this.portGrpName;
    }

    public final String getPortGrpName() {
        return (String)this.portGrpNameProperty().get();
    }

    public final void setPortGrpName(String portGrpName) {
        this.portGrpNameProperty().set((Object)portGrpName);
    }

    public final ObjectProperty<SecSubType> secSubTypeProperty() {
        return this.secSubType;
    }

    public final SecSubType getSecSubType() {
        return (SecSubType)this.secSubTypeProperty().get();
    }

    public final void setSecSubType(SecSubType secSubType) {
        this.secSubTypeProperty().set((Object)secSubType);
    }
}

