/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.Party;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObSingleOrderXswapBond
extends MxSelObj {
    private StringProperty ordCategory = new SimpleStringProperty("");
    private ObjectProperty<MxNode> ordType = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty source = new SimpleStringProperty("");
    private StringProperty sourceId = new SimpleStringProperty("");
    private IntegerProperty contextId = new SimpleIntegerProperty();
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty secName = new SimpleStringProperty("");
    private ObjectProperty<MxNode> side = new SimpleObjectProperty((Object)new MxNode());
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty leavesQty = new SimpleDoubleProperty();
    private DoubleProperty orderQty = new SimpleDoubleProperty();
    private DoubleProperty cumQty = new SimpleDoubleProperty();
    private ObjectProperty<MxNode> ordStatus = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty orderId = new SimpleStringProperty("");
    private StringProperty ordDate = new SimpleStringProperty("");
    private StringProperty ordTime = new SimpleStringProperty("");
    private StringProperty effTime = new SimpleStringProperty("");
    private StringProperty traderId = new SimpleStringProperty("");
    private StringProperty userName = new SimpleStringProperty("");
    private Party selfParty;
    private StringProperty ocFlag = new SimpleStringProperty("");
    private StringProperty errInfo = new SimpleStringProperty("");
    private StringProperty extOrderId = new SimpleStringProperty("");

    public ObSingleOrderXswapBond() {
        this.setSide(new MxNode().load("side", ""));
        this.setOrdStatus(new MxNode().load("ord_status", ""));
        this.setOrdType(new MxNode().load("price_type", ""));
    }

    public void update(Object obj) {
        if (obj instanceof SingleOrder) {
            SingleOrder order = (SingleOrder)obj;
            this.update(order);
        } else if (obj instanceof Order) {
            Order order = (Order)obj;
            this.update(order);
        } else if (obj instanceof ObSingleOrderXswapBond) {
            ObSingleOrderXswapBond order = (ObSingleOrderXswapBond)((Object)obj);
            this.update(order);
        }
    }

    public void update(SingleOrder order) {
        this.setSecurityId(order.getInstrument().getSecurityId());
        this.setSecName(order.getInstrument().getSymbol());
        this.getSide().setRaw(order.getSide().getValue());
        this.setPrice(order.getPrice());
        this.setLeavesQty(order.getLeavesQty());
        this.setOrderQty(order.getOrderQty());
        this.getOrdStatus().setRaw(order.getOrdStatus().getValue());
        this.getOrdType().setRaw(order.getOrdType().getValue());
        this.setOrderId(order.getOrderId());
        this.setOrdDate(order.getOrdDate());
        this.setOrdTime(order.getOrdTime());
        this.setErrInfo(order.getErrInfo());
        this.setOcFlag(this.transferOc(order.getPositionEffect()));
        this.setTraderId(order.getSelfParty().getTraderId());
        this.setUserName(order.getUserName());
        this.setCumQty(order.getCumQty());
        this.setExtOrderId(order.getExtOrderId());
        this.setSource(order.getSource());
        this.setSourceId(order.getSourceId());
        this.setOrdCategory(order.getOrdCategory());
    }

    public void update(Order order) {
        if (order.getInstrument() != null) {
            this.setSecurityId(order.getInstrument().getSecurityId());
            this.setSecName(order.getInstrument().getSymbol());
        }
        this.getSide().setRaw(order.getSide().getValue());
        this.setPrice(order.getPrice());
        this.setLeavesQty(order.getLeavesQty());
        this.setOrderQty(order.getOrderQty());
        this.getOrdStatus().setRaw(order.getOrdStatus().getValue());
        this.getOrdType().setRaw(order.getOrdType().getValue());
        this.setOrderId(order.getOrderId());
        this.setOrdDate(order.getOrdDate());
        this.setOrdTime(order.getOrdTime());
        this.setErrInfo(order.getErrInfo());
        this.setOcFlag(this.transferOc(order.getPositionEffect()));
        this.setTraderId(order.getSelfparty().getTraderId());
        this.setUserName(order.getUserName());
        this.setCumQty(order.getCumQty());
        this.setExtOrderId(order.getExtOrderId());
        this.setSource(order.getSource());
        this.setSourceId(order.getSourceId());
        this.setOrdCategory(order.getOrdCategory());
        this.setSource(order.getSource());
        this.setSourceId(order.getSourceId());
        this.setOrdCategory(order.getOrdCategory());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.orderId == null ? 0 : ((String)this.orderId.get()).hashCode());
        result = 31 * result + (this.ordTime == null ? 0 : ((String)this.ordTime.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObSingleOrderXswapBond other = (ObSingleOrderXswapBond)((Object)obj);
        if (this.orderId == null ? other.orderId != null : !((String)this.orderId.get()).equals(other.orderId.get())) {
            return false;
        }
        return !(this.ordTime == null ? other.ordTime != null : !((String)this.ordTime.get()).equals(other.ordTime.get()));
    }

    private String transferOc(String positionEffect) {
        if ("PE_CLOSE".equals(positionEffect)) {
            return "\u5e73\u4ed3";
        }
        if ("PE_OPEN".equals(positionEffect)) {
            return "\u5f00\u4ed3";
        }
        if ("PE_FIFO".equals(positionEffect)) {
            return "\u81ea\u52a8";
        }
        return null;
    }

    public void update(ObSingleOrderXswapBond order) {
        this.setSecurityId(order.getSecurityId());
        this.setSecName(order.getSecName());
        this.setSide(order.getSide());
        this.setPrice(order.getPrice());
        this.setLeavesQty(order.getLeavesQty());
        this.setOrderQty(order.getOrderQty());
        this.setOrdStatus(order.getOrdStatus());
        this.setOrderId(order.getOrderId());
        this.setOrdDate(order.getOrdDate());
        this.setOrdTime(order.getOrdTime());
        this.setErrInfo(order.getErrInfo());
        this.setTraderId(order.getTraderId());
        this.setUserName(order.getUserName());
        this.setCumQty(order.getCumQty());
        this.setExtOrderId(order.getExtOrderId());
        this.getOrdType().setRaw(order.getOrdType().getRaw());
        this.setSource(order.getSource());
        this.setSourceId(order.getSourceId());
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final DoubleProperty leavesQtyProperty() {
        return this.leavesQty;
    }

    public final double getLeavesQty() {
        return this.leavesQtyProperty().get();
    }

    public final void setLeavesQty(double leavesQty) {
        this.leavesQtyProperty().set(leavesQty);
    }

    public final DoubleProperty orderQtyProperty() {
        return this.orderQty;
    }

    public final double getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public final void setOrderQty(double orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public final ObjectProperty<MxNode> ordStatusProperty() {
        return this.ordStatus;
    }

    public final MxNode getOrdStatus() {
        return (MxNode)this.ordStatusProperty().get();
    }

    public final void setOrdStatus(MxNode status) {
        this.ordStatusProperty().set((Object)status);
    }

    public final StringProperty orderIdProperty() {
        return this.orderId;
    }

    public final String getOrderId() {
        return (String)this.orderIdProperty().get();
    }

    public final void setOrderId(String orderId) {
        this.orderIdProperty().set((Object)orderId);
    }

    public final IntegerProperty contextIdProperty() {
        return this.contextId;
    }

    public final int getContextId() {
        return this.contextIdProperty().get();
    }

    public final void setContextId(int contextId) {
        this.contextIdProperty().set(contextId);
    }

    public final StringProperty ordTimeProperty() {
        return this.ordTime;
    }

    public final String getOrdTime() {
        return (String)this.ordTimeProperty().get();
    }

    public final void setOrdTime(String ordTime) {
        this.ordTimeProperty().set((Object)ordTime);
    }

    public final StringProperty effTimeProperty() {
        return this.effTime;
    }

    public final String getEffTime() {
        return (String)this.effTimeProperty().get();
    }

    public final void setEffTime(String effTime) {
        this.effTimeProperty().set((Object)effTime);
    }

    public final StringProperty traderIdProperty() {
        return this.traderId;
    }

    public final String getTraderId() {
        return (String)this.traderIdProperty().get();
    }

    public final void setTraderId(String traderId) {
        this.traderIdProperty().set((Object)traderId);
    }

    public final StringProperty ocFlagProperty() {
        return this.ocFlag;
    }

    public final String getOcFlag() {
        return (String)this.ocFlagProperty().get();
    }

    public final void setOcFlag(String ocFlag) {
        this.ocFlagProperty().set((Object)ocFlag);
    }

    public final DoubleProperty cumQtyProperty() {
        return this.cumQty;
    }

    public final double getCumQty() {
        return this.cumQtyProperty().get();
    }

    public final void setCumQty(double cumQty) {
        this.cumQtyProperty().set(cumQty);
    }

    public final StringProperty extOrderIdProperty() {
        return this.extOrderId;
    }

    public final String getExtOrderId() {
        return (String)this.extOrderIdProperty().get();
    }

    public final void setExtOrderId(String extOrderId) {
        this.extOrderIdProperty().set((Object)extOrderId);
    }

    public final ObjectProperty<MxNode> ordTypeProperty() {
        return this.ordType;
    }

    public final MxNode getOrdType() {
        return (MxNode)this.ordTypeProperty().get();
    }

    public final void setOrdType(MxNode ordType) {
        this.ordTypeProperty().set((Object)ordType);
    }

    public final StringProperty sourceProperty() {
        return this.source;
    }

    public final String getSource() {
        return (String)this.sourceProperty().get();
    }

    public final void setSource(String source) {
        this.sourceProperty().set((Object)source);
    }

    public final StringProperty sourceIdProperty() {
        return this.sourceId;
    }

    public final String getSourceId() {
        return (String)this.sourceIdProperty().get();
    }

    public final void setSourceId(String sourceId) {
        this.sourceIdProperty().set((Object)sourceId);
    }

    public final StringProperty secNameProperty() {
        return this.secName;
    }

    public final String getSecName() {
        return (String)this.secNameProperty().get();
    }

    public final void setSecName(String secName) {
        this.secNameProperty().set((Object)secName);
    }

    public final StringProperty ordDateProperty() {
        return this.ordDate;
    }

    public final String getOrdDate() {
        return (String)this.ordDateProperty().get();
    }

    public final void setOrdDate(String ordDate) {
        this.ordDateProperty().set((Object)ordDate);
    }

    public final StringProperty userNameProperty() {
        return this.userName;
    }

    public final String getUserName() {
        return (String)this.userNameProperty().get();
    }

    public final void setUserName(String userName) {
        this.userNameProperty().set((Object)userName);
    }

    public final StringProperty errInfoProperty() {
        return this.errInfo;
    }

    public final String getErrInfo() {
        return (String)this.errInfoProperty().get();
    }

    public final void setErrInfo(String errInfo) {
        this.errInfoProperty().set((Object)errInfo);
    }

    public final StringProperty ordCategoryProperty() {
        return this.ordCategory;
    }

    public final String getOrdCategory() {
        return (String)this.ordCategoryProperty().get();
    }

    public final void setOrdCategory(String ordCategory) {
        this.ordCategoryProperty().set((Object)ordCategory);
    }
}

