/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.utils.StringUtils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObSingleOrderXBond
extends MxSelObj {
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty securityName = new SimpleStringProperty("");
    private ObjectProperty<MxNode> side = new SimpleObjectProperty((Object)new MxNode());
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty leavesQty = new SimpleDoubleProperty();
    private DoubleProperty orderQty = new SimpleDoubleProperty();
    private DoubleProperty cumQty = new SimpleDoubleProperty();
    private ObjectProperty<MxNode> ordStatus = new SimpleObjectProperty((Object)new MxNode());
    private ObjectProperty<MxNode> matchType = new SimpleObjectProperty((Object)new MxNode());
    private ObjectProperty<MxNode> settlType = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty ordCategory = new SimpleStringProperty("");
    private DoubleProperty yield = new SimpleDoubleProperty();
    private StringProperty orderId = new SimpleStringProperty("");
    private StringProperty extOrderId = new SimpleStringProperty("");
    private StringProperty traderId = new SimpleStringProperty("");
    private StringProperty errInfo = new SimpleStringProperty("");
    private StringProperty wthErrInfo = new SimpleStringProperty("");
    private StringProperty ordDate = new SimpleStringProperty("");
    private StringProperty ordTime = new SimpleStringProperty("");
    private StringProperty cxlTime = new SimpleStringProperty("");
    private StringProperty userId = new SimpleStringProperty("");
    private StringProperty userName = new SimpleStringProperty("");
    private StringProperty source = new SimpleStringProperty("");
    private StringProperty sourceId = new SimpleStringProperty("");
    private DoubleProperty avgPx = new SimpleDoubleProperty();
    private DoubleProperty avgYield = new SimpleDoubleProperty();
    private StringProperty termToMaturity = new SimpleStringProperty("");

    public ObSingleOrderXBond() {
        this.setSide(new MxNode().load("xbond_side", ""));
        this.setOrdStatus(new MxNode().load("ord_status", ""));
        this.setMatchType(new MxNode().load("match_type", ""));
        this.setSettlType(new MxNode().load("settl_type", ""));
    }

    public void update(Object obj) {
        if (obj instanceof SingleOrder) {
            this.update((SingleOrder)SingleOrder.class.cast(obj));
        } else if (obj instanceof Order) {
            this.update((Order)Order.class.cast(obj));
        } else if (obj instanceof ObSingleOrderXBond) {
            this.update((ObSingleOrderXBond)((Object)ObSingleOrderXBond.class.cast(obj)));
        }
    }

    public void update(SingleOrder order) {
        this.setSecurityId(order.getInstrument().getSecurityId());
        this.setSecurityName(order.getInstrument().getSymbol());
        this.getSide().setRaw(order.getSide().getValue());
        this.setPrice((double)Math.round(order.getPrice() * 10000.0) / 10000.0);
        this.setYield((double)Math.round(order.getYield() * 10000.0) / 10000.0);
        this.setAvgPx((double)Math.round(order.getAvgPx() * 10000.0) / 10000.0);
        this.setAvgYield((double)Math.round(order.getAvgYield() * 10000.0) / 10000.0);
        this.setLeavesQty(order.getLeavesQty());
        this.setOrderQty(order.getOrderQty());
        this.getOrdStatus().setRaw(order.getOrdStatus().getValue());
        if (order.isInactive() && (this.getOrdStatus().getRaw().equals("48") || this.getOrdStatus().getRaw().equals("49"))) {
            this.getOrdStatus().setRaw("73");
        }
        if (order.getMatchType() != null) {
            this.getMatchType().setRaw(order.getMatchType().getValue());
        }
        this.setOrderId(order.getOrderId());
        this.setExtOrderId(order.getExtOrderId());
        this.setOrdDate(order.getOrdDate());
        this.setOrdTime(order.getOrdTime());
        this.setUserId(order.getUserId());
        this.setUserName(order.getUserName());
        if (order.getSettlType() != null) {
            this.getSettlType().setRaw(String.valueOf(order.getSettlType().ordinal()));
        }
        this.setTermToMaturity(order.getTermToMaturity());
        this.setTraderId(order.getTraderId());
        this.setErrInfo(this.transferErrInfo(order));
        this.setWthErrInfo(order.getWthErrInfo());
        this.setSource(order.getSource());
        this.setSourceId(order.getSourceId());
        this.setOrdCategory(order.getOrdCategory());
    }

    public void update(Order order) {
        this.setSecurityId(order.getInstrument().getSecurityId());
        this.setSecurityName(order.getInstrument().getSymbol());
        this.getSide().setRaw(order.getSide().getValue());
        this.setPrice((double)Math.round(order.getPrice() * 10000.0) / 10000.0);
        this.setYield((double)Math.round(order.getYield() * 10000.0) / 10000.0);
        this.setAvgPx((double)Math.round(order.getAvgPx() * 10000.0) / 10000.0);
        this.setOrderQty(order.getOrderQty());
        this.setCumQty(order.getCumQty());
        this.setLeavesQty(order.getLeavesQty());
        this.getOrdStatus().setRaw(order.getOrdStatus().getValue());
        if (order.isInactive() && (this.getOrdStatus().getRaw().equals("48") || this.getOrdStatus().getRaw().equals("49"))) {
            this.getOrdStatus().setRaw("73");
        }
        if (order.getMatchType() != null) {
            this.getMatchType().setRaw(order.getMatchType().getValue());
        }
        this.setOrderId(order.getOrderId());
        this.setExtOrderId(order.getExtOrderId());
        this.setOrdDate(order.getOrdDate());
        this.setOrdTime(order.getOrdTime());
        this.setCxlTime(order.getCxlTime());
        this.setUserId(order.getUserId());
        this.setUserName(order.getUserName());
        if (order.getSettlType() != null) {
            this.getSettlType().setRaw(String.valueOf(order.getSettlType().ordinal()));
        }
        this.setTermToMaturity(order.getTermToMaturity());
        this.setTraderId(order.getSelfparty().getTraderId());
        this.setErrInfo(order.getErrInfo());
        this.setWthErrInfo(order.getWthErrInfo());
        this.setSource(order.getSource());
        this.setSourceId(order.getSourceId());
        this.setOrdCategory(order.getOrdCategory());
    }

    private String transferErrInfo(SingleOrder en) {
        String errorInfo = "";
        if (!StringUtils.isEmpty((String)en.getErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u4e0b\u5355\u9519\u8bef\uff08" + en.getErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)en.getWthErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u64a4\u5355\u9519\u8bef\uff08" + en.getWthErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)en.getRiskDetail())) {
            errorInfo = String.valueOf(errorInfo) + "\u98ce\u63a7\u8be6\u60c5\uff08" + en.getRiskDetail() + "\uff09";
        }
        return errorInfo;
    }

    public void update(ObSingleOrderXBond order) {
        this.setSecurityId(order.getSecurityId());
        this.setSecurityName(order.getSecurityName());
        this.setSide(order.getSide());
        this.setPrice(order.getPrice());
        this.setLeavesQty(order.getLeavesQty());
        this.setOrderQty(order.getOrderQty());
        this.setOrdStatus(order.getOrdStatus());
        this.setMatchType(order.getMatchType());
        this.setSource(order.getSource());
        this.setSourceId(order.getSourceId());
        this.setOrdCategory(order.getOrdCategory());
        this.setOrderId(order.getOrderId());
        this.setExtOrderId(order.getExtOrderId());
        this.setOrdDate(order.getOrdDate());
        this.setOrdTime(order.getOrdTime());
        this.setUserId(order.getUserId());
        this.setSettlType(order.getSettlType());
        this.setTermToMaturity(order.getTermToMaturity());
        this.setTraderId(order.getTraderId());
        this.setErrInfo(order.getErrInfo());
        this.setWthErrInfo(order.getWthErrInfo());
        this.setUserName(order.getUserName());
        this.setSource(order.getSource());
        this.setSourceId(order.getSourceId());
        this.setYield(order.getYield());
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final DoubleProperty leavesQtyProperty() {
        return this.leavesQty;
    }

    public final double getLeavesQty() {
        return this.leavesQtyProperty().get();
    }

    public final void setLeavesQty(double leavesQty) {
        this.leavesQtyProperty().set(leavesQty);
    }

    public final DoubleProperty orderQtyProperty() {
        return this.orderQty;
    }

    public final double getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public final void setOrderQty(double orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public final StringProperty orderIdProperty() {
        return this.orderId;
    }

    public final String getOrderId() {
        return (String)this.orderIdProperty().get();
    }

    public final void setOrderId(String orderId) {
        this.orderIdProperty().set((Object)orderId);
    }

    public final ObjectProperty<MxNode> matchTypeProperty() {
        return this.matchType;
    }

    public final MxNode getMatchType() {
        return (MxNode)this.matchTypeProperty().get();
    }

    public final void setMatchType(MxNode matchType) {
        this.matchTypeProperty().set((Object)matchType);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public final ObjectProperty<MxNode> settlTypeProperty() {
        return this.settlType;
    }

    public final MxNode getSettlType() {
        return (MxNode)this.settlTypeProperty().get();
    }

    public final void setSettlType(MxNode settlType) {
        this.settlTypeProperty().set((Object)settlType);
    }

    public final StringProperty termToMaturityProperty() {
        return this.termToMaturity;
    }

    public final String getTermToMaturity() {
        return (String)this.termToMaturityProperty().get();
    }

    public final void setTermToMaturity(String termToMaturity) {
        this.termToMaturityProperty().set((Object)termToMaturity);
    }

    public final StringProperty traderIdProperty() {
        return this.traderId;
    }

    public final String getTraderId() {
        return (String)this.traderIdProperty().get();
    }

    public final void setTraderId(String traderId) {
        this.traderIdProperty().set((Object)traderId);
    }

    public final StringProperty errInfoProperty() {
        return this.errInfo;
    }

    public final String getErrInfo() {
        return (String)this.errInfoProperty().get();
    }

    public final void setErrInfo(String errInfo) {
        this.errInfoProperty().set((Object)errInfo);
    }

    public final StringProperty ordTimeProperty() {
        return this.ordTime;
    }

    public final String getOrdTime() {
        return (String)this.ordTimeProperty().get();
    }

    public final void setOrdTime(String ordTime) {
        this.ordTimeProperty().set((Object)ordTime);
    }

    public final StringProperty wthErrInfoProperty() {
        return this.wthErrInfo;
    }

    public final String getWthErrInfo() {
        return (String)this.wthErrInfoProperty().get();
    }

    public final void setWthErrInfo(String wthErrInfo) {
        this.wthErrInfoProperty().set((Object)wthErrInfo);
    }

    public final StringProperty extOrderIdProperty() {
        return this.extOrderId;
    }

    public final String getExtOrderId() {
        return (String)this.extOrderIdProperty().get();
    }

    public final void setExtOrderId(String extOrderId) {
        this.extOrderIdProperty().set((Object)extOrderId);
    }

    public final ObjectProperty<MxNode> ordStatusProperty() {
        return this.ordStatus;
    }

    public final MxNode getOrdStatus() {
        return (MxNode)this.ordStatusProperty().get();
    }

    public final void setOrdStatus(MxNode ordStatus) {
        this.ordStatusProperty().set((Object)ordStatus);
    }

    public final StringProperty userIdProperty() {
        return this.userId;
    }

    public final String getUserId() {
        return (String)this.userIdProperty().get();
    }

    public final void setUserId(String userId) {
        this.userIdProperty().set((Object)userId);
    }

    public final StringProperty userNameProperty() {
        return this.userName;
    }

    public final String getUserName() {
        return (String)this.userNameProperty().get();
    }

    public final void setUserName(String userName) {
        this.userNameProperty().set((Object)userName);
    }

    public final StringProperty sourceProperty() {
        return this.source;
    }

    public final String getSource() {
        return (String)this.sourceProperty().get();
    }

    public final void setSource(String source) {
        this.sourceProperty().set((Object)source);
    }

    public final DoubleProperty yieldProperty() {
        return this.yield;
    }

    public final double getYield() {
        return this.yieldProperty().get();
    }

    public final void setYield(double yield) {
        this.yieldProperty().set(yield);
    }

    public final DoubleProperty avgYieldProperty() {
        return this.avgYield;
    }

    public final double getAvgYield() {
        return this.avgYieldProperty().get();
    }

    public final void setAvgYield(double avgYield) {
        this.avgYieldProperty().set(avgYield);
    }

    public final StringProperty sourceIdProperty() {
        return this.sourceId;
    }

    public final String getSourceId() {
        return (String)this.sourceIdProperty().get();
    }

    public final void setSourceId(String sourceId) {
        this.sourceIdProperty().set((Object)sourceId);
    }

    public final StringProperty ordDateProperty() {
        return this.ordDate;
    }

    public final String getOrdDate() {
        return (String)this.ordDateProperty().get();
    }

    public final void setOrdDate(String ordDate) {
        this.ordDateProperty().set((Object)ordDate);
    }

    public final DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    public final double getAvgPx() {
        return this.avgPxProperty().get();
    }

    public final void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public final DoubleProperty cumQtyProperty() {
        return this.cumQty;
    }

    public final double getCumQty() {
        return this.cumQtyProperty().get();
    }

    public final void setCumQty(double cumQty) {
        this.cumQtyProperty().set(cumQty);
    }

    public final StringProperty cxlTimeProperty() {
        return this.cxlTime;
    }

    public final String getCxlTime() {
        return (String)this.cxlTimeProperty().get();
    }

    public final void setCxlTime(String cxlTime) {
        this.cxlTimeProperty().set((Object)cxlTime);
    }

    public final StringProperty ordCategoryProperty() {
        return this.ordCategory;
    }

    public final String getOrdCategory() {
        return (String)this.ordCategoryProperty().get();
    }

    public final void setOrdCategory(String ordCategory) {
        this.ordCategoryProperty().set((Object)ordCategory);
    }
}

