/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.http.api.strategy.dto.Attachment;
import cms.tmx.http.api.strategy.dto.OrdStatus;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObSingleOrderNeeq
extends MxSelObj {
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty securityName = new SimpleStringProperty("");
    private StringProperty securityGroup = new SimpleStringProperty("");
    private StringProperty securitySubType = new SimpleStringProperty("");
    private String secType = "";
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty marketString = new SimpleStringProperty("");
    private ObjectProperty<MxNode> side = new SimpleObjectProperty((Object)new MxNode());
    private ObjectProperty<MxNode> positionEffect = new SimpleObjectProperty((Object)new MxNode());
    private DoubleProperty price = new SimpleDoubleProperty();
    private ObjectProperty<MxNode> ordType = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty ordTypeDesc = new SimpleStringProperty("");
    private DoubleProperty orderQty = new SimpleDoubleProperty();
    private StringProperty unit = new SimpleStringProperty("");
    private DoubleProperty orderAmount = new SimpleDoubleProperty();
    private DoubleProperty frozenMargin = new SimpleDoubleProperty();
    private DoubleProperty cumQty = new SimpleDoubleProperty();
    private DoubleProperty donePercent = new SimpleDoubleProperty();
    private DoubleProperty wthQty = new SimpleDoubleProperty();
    private DoubleProperty avgPx = new SimpleDoubleProperty();
    private DoubleProperty totalValue = new SimpleDoubleProperty();
    private StringProperty ordTime = new SimpleStringProperty("");
    private StringProperty wthTime = new SimpleStringProperty("");
    private StringProperty cxlTime = new SimpleStringProperty("");
    private StringProperty ordStatus = new SimpleStringProperty("");
    private StringProperty status = new SimpleStringProperty("");
    private BooleanProperty canCancel = new SimpleBooleanProperty(false);
    private StringProperty orderId = new SimpleStringProperty("");
    private Attachment attachment;
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty investorName = new SimpleStringProperty("");
    private StringProperty investorSecId = new SimpleStringProperty("");
    private StringProperty ordDate = new SimpleStringProperty("");
    private StringProperty traderId = new SimpleStringProperty("");
    private StringProperty traderName = new SimpleStringProperty("");
    private StringProperty errInfo = new SimpleStringProperty("");
    private StringProperty neeqErrInfo = new SimpleStringProperty("");
    private StringProperty extOrderId = new SimpleStringProperty("");
    private StringProperty wthErrInfo = new SimpleStringProperty("");
    private StringProperty matchType = new SimpleStringProperty("");
    private StringProperty userId = new SimpleStringProperty("");
    private StringProperty userName = new SimpleStringProperty("");
    private DoubleProperty leavesQty = new SimpleDoubleProperty();
    private StringProperty source = new SimpleStringProperty("");
    private StringProperty reference = new SimpleStringProperty("");
    private StringProperty portfolioId = new SimpleStringProperty("");
    private StringProperty portfolioName = new SimpleStringProperty("");
    private StringProperty extCashAccntId = new SimpleStringProperty("");
    private StringProperty extSecAccntId = new SimpleStringProperty("");
    private StringProperty tifName = new SimpleStringProperty("");
    private StringProperty accntId = new SimpleStringProperty("");
    private DoubleProperty avalQty = new SimpleDoubleProperty();
    private static final String COMMON_ISSUE = "COMMON_ISSUE";
    private StringProperty issueId = new SimpleStringProperty("");
    private StringProperty issueName = new SimpleStringProperty("");
    private static final List<String> CAN_CANCEL_STATUS = Arrays.asList("48", "49", "90", "54");

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.ordDate.get() == null ? 0 : ((String)this.ordDate.get()).hashCode());
        result = 31 * result + (this.orderId.get() == null ? 0 : ((String)this.orderId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObSingleOrderNeeq other = (ObSingleOrderNeeq)((Object)obj);
        if (this.ordDate.get() == null ? other.ordDate.get() != null : !((String)this.ordDate.get()).equals(other.ordDate.get())) {
            return false;
        }
        return !(this.orderId.get() == null ? other.orderId.get() != null : !((String)this.orderId.get()).equals(other.orderId.get()));
    }

    public ObSingleOrderNeeq() {
        this.setSide(new MxNode().load("side", ""));
        this.setPositionEffect(new MxNode().load("oc_flag", ""));
        this.setOrdType(new MxNode().load("order_type", ""));
    }

    public void update(Object obj) {
        if (obj instanceof SingleOrder) {
            SingleOrder order = (SingleOrder)obj;
            this.update(order);
        } else if (obj instanceof ObSingleOrderNeeq) {
            ObSingleOrderNeeq order = (ObSingleOrderNeeq)((Object)obj);
            this.update(order);
        } else if (obj instanceof Order) {
            Order order = (Order)obj;
            this.update(order);
        }
    }

    public void update(Order order) {
        this.setWthQty(order.getCxlQty());
        this.setCancelTime(order.getWthTime());
        this.getSide().setRaw(order.getSide().getValue());
        this.getPositionEffect().setRaw(order.getPositionEffect());
        this.setPrice((double)Math.round(order.getPrice() * 10000.0) / 10000.0);
        this.setOrderQty(order.getOrderQty());
        this.setOrderAmount(order.getOrderAmount());
        this.setFrozenMargin(order.getFrozenMargin());
        this.setCumQty(order.getCumQty());
        double per = 0.0;
        if (this.getCumQty() > 0.0 && this.getOrderQty() > 0.0) {
            per = this.getCumQty() * 100.0 / this.getOrderQty();
        }
        this.setCxlTime(order.getCxlTime());
        this.setDonePercent(per);
        this.setAvgPx(order.getAvgPx());
        this.setCumAmount(order.getTotalValue());
        this.setOrdTime(order.getOrdTime());
        if (order.getOrdStatus() != null) {
            String ordStatus = order.getOrdStatus().getDes();
            if ("XHKG".equals(order.getInstrument().getMarket()) && OrdStatus.ORD_STATUS_DONE_FOR_DAY.equals((Object)order.getOrdStatus())) {
                ordStatus = this.getCumQty() > 0.0 ? "\u90e8\u6210\u90e8\u8fc7\u671f" : "\u5df2\u8fc7\u671f";
            }
            this.setStatus(ordStatus);
            this.setOrdStatus(ordStatus);
            if (CAN_CANCEL_STATUS.contains(order.getOrdStatus().getValue())) {
                this.setCanCancel(true);
            } else {
                this.setCanCancel(false);
            }
        }
        this.setReference(order.getReference());
        this.setOrderId(order.getOrderId());
        this.setOrdDate(order.getOrdDate());
        this.setTraderId(order.getTraderId());
        this.setTraderName(order.getTraderId());
        this.setErrInfo(this.transferErrInfo(order));
        this.setNeeqErrInfo(order.getNeeqErrInfo());
        this.setWthErrInfo(order.getWthErrInfo());
        this.setExtOrderId(order.getExtOrderId());
        this.setInvestorSecId(order.getInvestorSecId());
        this.setInvestorId(order.getInvestorId());
        this.setLeavesQty(order.getLeavesQty());
        this.setUserId(order.getUserId());
        this.setUserName(order.getUserName());
        this.setPortfolioId(order.getPortfolioId());
        this.setPortfolioName(order.getPortfolioName());
        this.setUnit(order.getUnit());
        if (order.getOrdType() != null) {
            this.getOrdType().setRaw(order.getOrdType().getValue());
            this.setOrdTypeDesc(order.getOrdTypeDesc());
        }
        if ("49".equals(order.getOrdType().getValue()) && "SGEX".equals(order.getInstrument().getMarket())) {
            this.setOrdTypeDesc(String.valueOf(order.getOrdTypeDesc()) + "-" + this.setSgeTifString(order.getTif()));
        }
        if (order.getMatchType() != null) {
            this.setMatchType(order.getMatchType().getDes());
        }
        if (order.getInstrument() != null) {
            if (COMMON_ISSUE.equals(order.getInstrument().getMarketIndicator())) {
                this.setIssueId(order.getInstrument().getSecurityId());
                this.setIssueName(order.getInstrument().getSymbol());
                this.setSecurityGroup(order.getInstrument().getSecurityGroup());
                this.setSecuritySubType(order.getInstrument().getSecuritySubType());
                if (order.getUnderlying() != null) {
                    this.setSecurityId(order.getUnderlying().getSecurityId());
                    this.setSecurityName(order.getUnderlying().getSymbol());
                }
            } else {
                this.setMarket(MarketUtils.getMarketNameById((String)order.getInstrument().getMarket()));
                this.setUnit(order.getUnit());
                this.setSecuritySubType(order.getInstrument().getSecuritySubType());
                this.setSecurityId(order.getInstrument().getSecurityId());
                this.setSecurityName(order.getInstrument().getSymbol());
                this.setSecurityGroup(order.getInstrument().getSecurityGroup());
                this.setSecType(order.getInstrument().getSecurityType());
            }
        }
        if (order.getExtAccntId() != null) {
            this.setExtCashAccntId(order.getExtAccntId().getCashAccntId());
            this.setExtSecAccntId(order.getExtAccntId().getSecAccntId());
        }
        this.setMarketString(order.getMarket());
        this.setSelected(order.isSelected());
        this.setTifName(order.getTifName());
        this.setAccntId(order.getExtAccntId().getAccntId());
        if (order.getExecMode() != null) {
            String source = order.getExecMode().getEmName();
            if ("XHKG".equals(order.getInstrument().getMarket())) {
                StringBuffer type = new StringBuffer(this.getOrdType().getRaw());
                type.append("#").append(source);
                MxNode node = MxNodeFactory.create((String)"hk_algo_name", (String)type.toString());
                if (node != null) {
                    source = node.getValue();
                }
                if (order.getAttachment() != null && !order.getAttachment().isEmpty()) {
                    this.setAttachment((Attachment)new Gson().fromJson(order.getAttachment(), Attachment.class));
                }
            }
            this.setSource(source);
        } else {
            this.setSource("");
        }
        this.setAvalQty(order.getOrderQty() - order.getCumQty() - order.getCxlQty());
    }

    public void update(SingleOrder order) {
        this.setWthQty(order.getWthQty());
        this.setCancelTime(order.getWthTime());
        this.setMarket(order.getMarket());
        this.getSide().setRaw(order.getSide().getValue());
        this.getPositionEffect().setRaw(order.getPositionEffect());
        this.setPrice((double)Math.round(order.getPrice() * 10000.0) / 10000.0);
        this.setOrderQty((double)Math.round(order.getOrderQty() * 1000.0) / 1000.0);
        this.setOrderAmount(order.getOrderAmount());
        this.setFrozenMargin(order.getFrozenMargin());
        this.setCumQty((double)Math.round(order.getCumQty() * 1000.0) / 1000.0);
        double per = 0.0;
        if (this.getCumQty() > 0.0 && this.getOrderQty() > 0.0) {
            per = this.getCumQty() * 100.0 / this.getOrderQty();
        }
        this.setDonePercent(per);
        this.setAvgPx(order.getAvgPx());
        this.setCumAmount(order.getTotalValue());
        this.setOrdTime(order.getOrdTime());
        if (order.getOrdStatus() != null) {
            String ordStatus = order.getOrdStatus().getDes();
            if ("XHKG".equals(order.getInstrument().getMarket()) && OrdStatus.ORD_STATUS_DONE_FOR_DAY.equals((Object)order.getOrdStatus())) {
                ordStatus = this.getCumQty() > 0.0 ? "\u90e8\u6210\u90e8\u8fc7\u671f" : "\u5df2\u8fc7\u671f";
            }
            this.setStatus(ordStatus);
            this.setOrdStatus(ordStatus);
            if (CAN_CANCEL_STATUS.contains(order.getOrdStatus().getValue())) {
                this.setCanCancel(true);
            } else {
                this.setCanCancel(false);
            }
        }
        this.setReference(order.getReference());
        this.setOrderId(order.getOrderId());
        this.setOrdDate(order.getOrdDate());
        this.setTraderId(order.getTraderId());
        this.setTraderName(order.getTraderId());
        this.setErrInfo(this.transferErrInfo(order));
        this.setNeeqErrInfo(order.getNeeqErrInfo());
        this.setWthErrInfo(order.getWthErrInfo());
        this.setExtOrderId(order.getExtOrderId());
        this.setInvestorSecId(order.getInvestorSecId());
        this.setInvestorId(order.getInvestorId());
        this.setUnit("\u80a1");
        this.setLeavesQty(order.getLeavesQty());
        this.setUserId(order.getUserId());
        this.setUserName(order.getUserName());
        this.setPortfolioId(order.getPortfolioId());
        if (order.getOrdType() != null) {
            this.getOrdType().setRaw(order.getOrdType().getValue());
            this.setOrdTypeDesc(order.getOrdTypeDesc());
        }
        if (order.getMatchType() != null) {
            this.setMatchType(order.getMatchType().getDes());
        }
        if (order.getInstrument() != null) {
            if (COMMON_ISSUE.equals(order.getInstrument().getMarketIndicator())) {
                this.setIssueId(order.getInstrument().getSecurityId());
                this.setIssueName(order.getInstrument().getSymbol());
                this.setSecurityGroup(order.getInstrument().getSecurityGroup());
                this.setSecuritySubType(order.getInstrument().getSecuritySubType());
                if (order.getUnderlying() != null) {
                    this.setSecurityId(order.getUnderlying().getSecurityId());
                    this.setSecurityName(order.getUnderlying().getSymbol());
                }
            } else {
                this.setSecuritySubType(order.getInstrument().getSecuritySubType());
                this.setSecurityId(order.getInstrument().getSecurityId());
                this.setSecurityName(order.getInstrument().getSymbol());
                this.setSecurityGroup(order.getInstrument().getSecurityGroup());
                this.setSecType(order.getInstrument().getSecurityType());
            }
        }
        this.setCxlTime(order.getWthTime());
        this.setMarketString(order.getMarket());
        this.setSelected(order.isSelected());
        this.setTifName(this.setTifString(order.getTif()));
        if ("49".equals(order.getOrdType().getValue()) && "SGEX".equals(order.getInstrument().getMarket())) {
            this.setOrdTypeDesc(String.valueOf(order.getOrdTypeDesc()) + "-" + this.setSgeTifString(order.getTif()));
        }
        this.setInvestorName(order.getInvestorName());
        this.setSource(order.getSource());
    }

    private String transferErrInfo(SingleOrder en) {
        String errorInfo = "";
        if (!StringUtils.isEmpty((String)en.getErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u4e0b\u5355\u9519\u8bef\uff08" + en.getErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)en.getWthErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u64a4\u5355\u9519\u8bef\uff08" + en.getWthErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)en.getRiskDetail())) {
            errorInfo = String.valueOf(errorInfo) + "\u98ce\u63a7\u8be6\u60c5\uff08" + en.getRiskDetail() + "\uff09";
        }
        return errorInfo;
    }

    private String transferErrInfo(Order en) {
        String errorInfo = "";
        if (!StringUtils.isEmpty((String)en.getErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u4e0b\u5355\u9519\u8bef\uff08" + en.getErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)en.getCxlErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u64a4\u5355\u9519\u8bef\uff08" + en.getCxlErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)en.getRiskDetail())) {
            errorInfo = String.valueOf(errorInfo) + "\u98ce\u63a7\u8be6\u60c5\uff08" + en.getRiskDetail() + "\uff09";
        }
        return errorInfo;
    }

    public void update(ObSingleOrderNeeq order) {
        this.setSecurityId(order.getSecurityId());
        this.setSecurityName(order.getSecurityName());
        this.setSecuritySubType(order.getSecuritySubType());
        this.setSecType(order.getSecType());
        this.setMarket(order.getMarket());
        this.setSecurityGroup(order.getSecurityGroup());
        this.setSide(order.getSide());
        this.setPositionEffect(order.getPositionEffect());
        this.setPrice(order.getPrice());
        this.setOrdType(order.getOrdType());
        this.setOrderQty(order.getOrderQty());
        this.setUnit(order.getUnit());
        this.setOrderAmount(order.getOrderAmount());
        this.setFrozenMargin(order.getFrozenMargin());
        this.setCumQty(order.getCumQty());
        this.setDonePercent(order.getDonePercent());
        this.setWthQty(order.getWthQty());
        this.setAvgPx(order.getAvgPx());
        this.setReference(order.getReference());
        this.setCumAmount(order.getCumAmount());
        this.setOrdTime(order.getOrdTime());
        this.setCancelTime(order.getCancelTime());
        this.setOrdStatus(order.getOrdStatus());
        this.setStatus(order.getStatus());
        this.setOrderId(order.getOrderId());
        this.setInvestorId(order.getInvestorId());
        this.setInvestorSecId(order.getInvestorSecId());
        this.setOrdDate(order.getOrdDate());
        this.setTraderId(order.getTraderId());
        this.setTraderName(order.getTraderName());
        this.setErrInfo(order.getErrInfo());
        this.setExtOrderId(order.getExtOrderId());
        this.setCancelTime(order.getCancelTime());
        this.setIssueId(order.getIssueId());
        this.setIssueName(order.getIssueName());
        this.setPortfolioId(order.getPortfolioId());
        this.setPortfolioName(order.getPortfolioName());
        this.setCxlTime(order.getCxlTime());
        this.setMarketString(order.getMarketString());
        this.setExtCashAccntId(order.getExtCashAccntId());
        this.setExtSecAccntId(order.getExtSecAccntId());
        this.setSource(order.getSource());
        this.setAttachment(order.getAttachment());
        this.setLeavesQty(order.getLeavesQty());
        this.setUserId(order.getUserId());
        this.setErrInfo(order.getErrInfo());
        this.setNeeqErrInfo(order.getNeeqErrInfo());
        this.setWthErrInfo(order.getWthErrInfo());
        this.setUserName(order.getUserName());
        this.setSource(order.getSource());
        this.setTifName(order.getTifName());
        this.setAvalQty(order.getAvalQty());
        this.setInvestorName(order.getInvestorName());
    }

    public String setTifString(int tif) {
        if (tif == 48) {
            return "\u5f53\u65e5\u6709\u6548";
        }
        if (tif == 51) {
            return "\u7acb\u5373\u6210\u4ea4\u5269\u4f59\u64a4\u5355";
        }
        if (tif == 52) {
            return "\u5168\u90e8\u6210\u4ea4\u5426\u5219\u64a4\u5355";
        }
        return String.valueOf(tif);
    }

    public String setSgeTifString(int tif) {
        if (tif == 48) {
            return "\u5e02\u4ef7\u8f6c\u9650\u4ef7";
        }
        if (tif == 51) {
            return "\u7acb\u5373\u6210\u4ea4\u5269\u4f59\u64a4\u5355";
        }
        if (tif == 52) {
            return "\u5168\u90e8\u6210\u4ea4\u5426\u5219\u64a4\u5355";
        }
        return String.valueOf(tif);
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final ObjectProperty<MxNode> ordTypeProperty() {
        return this.ordType;
    }

    public final MxNode getOrdType() {
        return (MxNode)this.ordTypeProperty().get();
    }

    public final void setOrdType(MxNode ordType) {
        this.ordTypeProperty().set((Object)ordType);
    }

    public final DoubleProperty orderQtyProperty() {
        return this.orderQty;
    }

    public final double getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public final void setOrderQty(double orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final String getUnit() {
        return (String)this.unitProperty().get();
    }

    public final void setUnit(String unit) {
        this.unitProperty().set((Object)unit);
    }

    public final DoubleProperty orderAmountProperty() {
        return this.orderAmount;
    }

    public final double getOrderAmount() {
        return this.orderAmountProperty().get();
    }

    public final void setOrderAmount(double orderAmount) {
        this.orderAmountProperty().set(orderAmount);
    }

    public final DoubleProperty frozenMarginProperty() {
        return this.frozenMargin;
    }

    public final double getFrozenMargin() {
        return this.frozenMarginProperty().get();
    }

    public final void setFrozenMargin(double frozenMargin) {
        this.frozenMarginProperty().set(frozenMargin);
    }

    public final DoubleProperty cumQtyProperty() {
        return this.cumQty;
    }

    public final double getCumQty() {
        return this.cumQtyProperty().get();
    }

    public final void setCumQty(double cumQty) {
        this.cumQtyProperty().set(cumQty);
    }

    public final DoubleProperty donePercentProperty() {
        return this.donePercent;
    }

    public final double getDonePercent() {
        return this.donePercentProperty().get();
    }

    public final void setDonePercent(double donePercent) {
        this.donePercentProperty().set(donePercent);
    }

    public final DoubleProperty cumAmountProperty() {
        return this.totalValue;
    }

    public final double getCumAmount() {
        return this.cumAmountProperty().get();
    }

    public final void setCumAmount(double cumAmount) {
        this.cumAmountProperty().set(cumAmount);
    }

    public final StringProperty ordTimeProperty() {
        return this.ordTime;
    }

    public final String getOrdTime() {
        return (String)this.ordTimeProperty().get();
    }

    public final void setOrdTime(String ordTime) {
        this.ordTimeProperty().set((Object)ordTime);
    }

    public final StringProperty cancelTimeProperty() {
        return this.wthTime;
    }

    public final String getCancelTime() {
        return (String)this.cancelTimeProperty().get();
    }

    public final void setCancelTime(String cancelTime) {
        this.cancelTimeProperty().set((Object)cancelTime);
    }

    public final StringProperty orderIdProperty() {
        return this.orderId;
    }

    public final String getOrderId() {
        return (String)this.orderIdProperty().get();
    }

    public final void setOrderId(String orderId) {
        this.orderIdProperty().set((Object)orderId);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty ordDateProperty() {
        return this.ordDate;
    }

    public final String getOrdDate() {
        return (String)this.ordDateProperty().get();
    }

    public final void setOrdDate(String ordDate) {
        this.ordDateProperty().set((Object)ordDate);
    }

    public final StringProperty traderIdProperty() {
        return this.traderId;
    }

    public final String getTraderId() {
        return (String)this.traderIdProperty().get();
    }

    public final void setTraderId(String traderId) {
        this.traderIdProperty().set((Object)traderId);
    }

    public final StringProperty traderNameProperty() {
        return this.traderName;
    }

    public final String getTraderName() {
        return (String)this.traderNameProperty().get();
    }

    public final void setTraderName(String traderName) {
        this.traderNameProperty().set((Object)traderName);
    }

    public final StringProperty errInfoProperty() {
        return this.errInfo;
    }

    public final String getErrInfo() {
        return (String)this.errInfoProperty().get();
    }

    public final void setErrInfo(String errInfo) {
        this.errInfoProperty().set((Object)errInfo);
    }

    public final StringProperty extOrderIdProperty() {
        return this.extOrderId;
    }

    public final String getExtOrderId() {
        return (String)this.extOrderIdProperty().get();
    }

    public final void setExtOrderId(String extOrderId) {
        this.extOrderIdProperty().set((Object)extOrderId);
    }

    public final StringProperty wthErrInfoProperty() {
        return this.wthErrInfo;
    }

    public final String getWthErrInfo() {
        return (String)this.wthErrInfoProperty().get();
    }

    public final void setWthErrInfo(String wthErrInfo) {
        this.wthErrInfoProperty().set((Object)wthErrInfo);
    }

    public final StringProperty userIdProperty() {
        return this.userId;
    }

    public final String getUserId() {
        return (String)this.userIdProperty().get();
    }

    public final void setUserId(String userId) {
        this.userIdProperty().set((Object)userId);
    }

    public final StringProperty userNameProperty() {
        return this.userName;
    }

    public final String getUserName() {
        return (String)this.userNameProperty().get();
    }

    public final void setUserName(String userName) {
        this.userNameProperty().set((Object)userName);
    }

    public final DoubleProperty leavesQtyProperty() {
        return this.leavesQty;
    }

    public final double getLeavesQty() {
        return this.leavesQtyProperty().get();
    }

    public final void setLeavesQty(double leavesQty) {
        this.leavesQtyProperty().set(leavesQty);
    }

    public final StringProperty sourceProperty() {
        return this.source;
    }

    public final String getSource() {
        return (String)this.sourceProperty().get();
    }

    public final void setSource(String source) {
        this.sourceProperty().set((Object)source);
    }

    public final DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    public final double getAvgPx() {
        return this.avgPxProperty().get();
    }

    public final void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public final DoubleProperty wthQtyProperty() {
        return this.wthQty;
    }

    public final double getWthQty() {
        return this.wthQtyProperty().get();
    }

    public final void setWthQty(double wthQty) {
        this.wthQtyProperty().set(wthQty);
    }

    public final StringProperty securityGroupProperty() {
        return this.securityGroup;
    }

    public final String getSecurityGroup() {
        return (String)this.securityGroupProperty().get();
    }

    public final void setSecurityGroup(String securityGroup) {
        this.securityGroupProperty().set((Object)securityGroup);
    }

    public final DoubleProperty totalValueProperty() {
        return this.totalValue;
    }

    public final double getTotalValue() {
        return this.totalValueProperty().get();
    }

    public final void setTotalValue(double totalValue) {
        this.totalValueProperty().set(totalValue);
    }

    public final StringProperty wthTimeProperty() {
        return this.wthTime;
    }

    public final String getWthTime() {
        return (String)this.wthTimeProperty().get();
    }

    public final void setWthTime(String wthTime) {
        this.wthTimeProperty().set((Object)wthTime);
    }

    public final StringProperty securitySubTypeProperty() {
        return this.securitySubType;
    }

    public final String getSecuritySubType() {
        return (String)this.securitySubTypeProperty().get();
    }

    public final void setSecuritySubType(String securitySubType) {
        this.securitySubTypeProperty().set((Object)securitySubType);
    }

    public final StringProperty ordTypeDescProperty() {
        return this.ordTypeDesc;
    }

    public final String getOrdTypeDesc() {
        return (String)this.ordTypeDescProperty().get();
    }

    public final void setOrdTypeDesc(String ordTypeDesc) {
        this.ordTypeDescProperty().set((Object)ordTypeDesc);
    }

    public final StringProperty ordStatusProperty() {
        return this.ordStatus;
    }

    public final String getOrdStatus() {
        return (String)this.ordStatusProperty().get();
    }

    public final void setOrdStatus(String ordStatus) {
        this.ordStatusProperty().set((Object)ordStatus);
    }

    public final StringProperty matchTypeProperty() {
        return this.matchType;
    }

    public final String getMatchType() {
        return (String)this.matchTypeProperty().get();
    }

    public final void setMatchType(String matchType) {
        this.matchTypeProperty().set((Object)matchType);
    }

    public final StringProperty issueIdProperty() {
        return this.issueId;
    }

    public final String getIssueId() {
        return (String)this.issueIdProperty().get();
    }

    public final void setIssueId(String issueId) {
        this.issueIdProperty().set((Object)issueId);
    }

    public final StringProperty issueNameProperty() {
        return this.issueName;
    }

    public final String getIssueName() {
        return (String)this.issueNameProperty().get();
    }

    public final void setIssueName(String issueName) {
        this.issueNameProperty().set((Object)issueName);
    }

    public final StringProperty investorSecIdProperty() {
        return this.investorSecId;
    }

    public final String getInvestorSecId() {
        return (String)this.investorSecIdProperty().get();
    }

    public final void setInvestorSecId(String investorSecId) {
        this.investorSecIdProperty().set((Object)investorSecId);
    }

    public final StringProperty neeqErrInfoProperty() {
        return this.neeqErrInfo;
    }

    public final String getNeeqErrInfo() {
        return (String)this.neeqErrInfoProperty().get();
    }

    public final void setNeeqErrInfo(String neeqErrInfo) {
        this.neeqErrInfoProperty().set((Object)neeqErrInfo);
    }

    public final StringProperty referenceProperty() {
        return this.reference;
    }

    public final String getReference() {
        return (String)this.referenceProperty().get();
    }

    public final void setReference(String reference) {
        this.referenceProperty().set((Object)reference);
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public final StringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public final String getPortfolioId() {
        return (String)this.portfolioIdProperty().get();
    }

    public final void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set((Object)portfolioId);
    }

    public final StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public final String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public final void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public final StringProperty marketStringProperty() {
        return this.marketString;
    }

    public final String getMarketString() {
        return (String)this.marketStringProperty().get();
    }

    public final void setMarketString(String marketString) {
        this.marketStringProperty().set((Object)marketString);
    }

    public final StringProperty extCashAccntIdProperty() {
        return this.extCashAccntId;
    }

    public final String getExtCashAccntId() {
        return (String)this.extCashAccntIdProperty().get();
    }

    public final void setExtCashAccntId(String extCashAccntId) {
        this.extCashAccntIdProperty().set((Object)extCashAccntId);
    }

    public final StringProperty extSecAccntIdProperty() {
        return this.extSecAccntId;
    }

    public final String getExtSecAccntId() {
        return (String)this.extSecAccntIdProperty().get();
    }

    public final void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntIdProperty().set((Object)extSecAccntId);
    }

    public final StringProperty cxlTimeProperty() {
        return this.cxlTime;
    }

    public final String getCxlTime() {
        return (String)this.cxlTimeProperty().get();
    }

    public final void setCxlTime(String cxlTime) {
        this.cxlTimeProperty().set((Object)cxlTime);
    }

    public final StringProperty tifNameProperty() {
        return this.tifName;
    }

    public final String getTifName() {
        return (String)this.tifNameProperty().get();
    }

    public final void setTifName(String tifName) {
        this.tifNameProperty().set((Object)tifName);
    }

    public final BooleanProperty canCancelProperty() {
        return this.canCancel;
    }

    public final boolean isCanCancel() {
        return this.canCancelProperty().get();
    }

    public final void setCanCancel(boolean canCancel) {
        this.canCancelProperty().set(canCancel);
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public final StringProperty accntIdProperty() {
        return this.accntId;
    }

    public final String getAccntId() {
        return (String)this.accntIdProperty().get();
    }

    public final void setAccntId(String accntId) {
        this.accntIdProperty().set((Object)accntId);
    }

    public final DoubleProperty avalQtyProperty() {
        return this.avalQty;
    }

    public final double getAvalQty() {
        return this.avalQtyProperty().get();
    }

    public final void setAvalQty(double avalQty) {
        this.avalQtyProperty().set(avalQty);
    }

    public final StringProperty statusProperty() {
        return this.status;
    }

    public final String getStatus() {
        return (String)this.statusProperty().get();
    }

    public final void setStatus(String status) {
        this.statusProperty().set((Object)status);
    }

    public final ObjectProperty<MxNode> positionEffectProperty() {
        return this.positionEffect;
    }

    public final MxNode getPositionEffect() {
        return (MxNode)this.positionEffectProperty().get();
    }

    public final void setPositionEffect(MxNode positionEffect) {
        this.positionEffectProperty().set((Object)positionEffect);
    }

    public final StringProperty investorNameProperty() {
        return this.investorName;
    }

    public final String getInvestorName() {
        return (String)this.investorNameProperty().get();
    }

    public final void setInvestorName(String investorName) {
        this.investorNameProperty().set((Object)investorName);
    }
}

