/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.http.api.Instrument;
import cms.tmx.http.neeq.RfqResult;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.utils.StringUtils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObRfqResultNeeq
extends MxObject {
    private StringProperty instrumentId = new SimpleStringProperty("");
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty securityName = new SimpleStringProperty("");
    private StringProperty securityGroup = new SimpleStringProperty("");
    private StringProperty accntId = new SimpleStringProperty("");
    private StringProperty cashAccntId = new SimpleStringProperty("");
    private StringProperty secAccntId = new SimpleStringProperty("");
    private Instrument instrument;
    private Instrument underlying;
    private StringProperty status = new SimpleStringProperty("");
    private StringProperty qtyRange = new SimpleStringProperty("");
    private StringProperty execId = new SimpleStringProperty("");
    private DoubleProperty price = new SimpleDoubleProperty(0.0);
    private StringProperty tradeDate = new SimpleStringProperty("");
    private StringProperty tradeTime = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty investorSecId = new SimpleStringProperty("");
    private StringProperty text = new SimpleStringProperty("");

    public void update(Object obj) {
        if (obj instanceof RfqResult) {
            RfqResult rfq = (RfqResult)obj;
            this.update(rfq);
        } else if (obj instanceof ObRfqResultNeeq) {
            ObRfqResultNeeq rfq = (ObRfqResultNeeq)((Object)obj);
            this.update(rfq);
        }
    }

    public void update(RfqResult r) {
        this.setInstrumentId("");
        this.setSecurityName("");
        this.setSecurityId("");
        if (r.getInstrument() != null) {
            this.setInstrumentId(r.getInstrument().getSecurityId() == null ? "" : r.getInstrument().getSecurityId());
            this.setSecurityName(r.getInstrument().getSymbol());
        }
        if (r.getUnderlying() != null) {
            this.setSecurityId(r.getUnderlying().getSecurityId() == null ? "" : r.getUnderlying().getSecurityId());
        }
        this.setSecurityGroup("\u7cbe\u9009\u5c42");
        this.setStatus(r.getStatus().getDes());
        this.setAccntId(r.getAccntId());
        this.setCashAccntId(r.getCashAccntId());
        this.setExecId(r.getExecId());
        this.setSecAccntId(r.getSecAccntId());
        String min = StringUtils.toStr((double)r.getMinQty(), (int)1);
        String max = StringUtils.toStr((double)r.getMaxQty(), (int)1);
        this.setQtyRange(String.valueOf(min) + "\u2014" + max);
        this.setTradeDate(r.getTradeDate());
        this.setTradeTime(r.getTradeTime());
        this.setInvestorId(r.getInvestorId());
        this.setInvestorSecId(r.getInvestorSecId());
        this.setText(r.getText());
        this.setPrice((double)Math.round(r.getPrice() * 100.0) / 100.0);
    }

    public void update(ObRfqResultNeeq r) {
        this.setInstrumentId(r.getInstrumentId());
        this.setSecurityId(r.getSecurityId());
        this.setSecurityName(r.getSecurityName());
        this.setSecurityGroup(r.getSecurityGroup());
        this.setStatus(r.getStatus());
        this.setAccntId(r.getAccntId());
        this.setCashAccntId(r.getCashAccntId());
        this.setExecId(r.getExecId());
        this.setSecAccntId(r.getSecAccntId());
        this.setPrice(r.getPrice());
        this.setQtyRange(r.getQtyRange());
        this.setTradeDate(r.getTradeDate());
        this.setTradeTime(r.getTradeTime());
        this.setInvestorId(r.getInvestorId());
        this.setInvestorSecId(r.getInvestorSecId());
        this.setText(r.getText());
    }

    public final StringProperty accntIdProperty() {
        return this.accntId;
    }

    public final String getAccntId() {
        return (String)this.accntIdProperty().get();
    }

    public final void setAccntId(String accntId) {
        this.accntIdProperty().set((Object)accntId);
    }

    public final StringProperty cashAccntIdProperty() {
        return this.cashAccntId;
    }

    public final String getCashAccntId() {
        return (String)this.cashAccntIdProperty().get();
    }

    public final void setCashAccntId(String cashAccntId) {
        this.cashAccntIdProperty().set((Object)cashAccntId);
    }

    public final StringProperty secAccntIdProperty() {
        return this.secAccntId;
    }

    public final String getSecAccntId() {
        return (String)this.secAccntIdProperty().get();
    }

    public final void setSecAccntId(String secAccntId) {
        this.secAccntIdProperty().set((Object)secAccntId);
    }

    public final StringProperty execIdProperty() {
        return this.execId;
    }

    public final String getExecId() {
        return (String)this.execIdProperty().get();
    }

    public final void setExecId(String execId) {
        this.execIdProperty().set((Object)execId);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final StringProperty tradeDateProperty() {
        return this.tradeDate;
    }

    public final String getTradeDate() {
        return (String)this.tradeDateProperty().get();
    }

    public final void setTradeDate(String tradeDate) {
        this.tradeDateProperty().set((Object)tradeDate);
    }

    public final StringProperty tradeTimeProperty() {
        return this.tradeTime;
    }

    public final String getTradeTime() {
        return (String)this.tradeTimeProperty().get();
    }

    public final void setTradeTime(String tradeTime) {
        this.tradeTimeProperty().set((Object)tradeTime);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty investorSecIdProperty() {
        return this.investorSecId;
    }

    public final String getInvestorSecId() {
        return (String)this.investorSecIdProperty().get();
    }

    public final void setInvestorSecId(String investorSecId) {
        this.investorSecIdProperty().set((Object)investorSecId);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final String getText() {
        return (String)this.textProperty().get();
    }

    public final void setText(String text) {
        this.textProperty().set((Object)text);
    }

    public final StringProperty instrumentIdProperty() {
        return this.instrumentId;
    }

    public final String getInstrumentId() {
        return (String)this.instrumentIdProperty().get();
    }

    public final void setInstrumentId(String instrumentId) {
        this.instrumentIdProperty().set((Object)instrumentId);
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return this.securityIdProperty().get() == null ? "" : (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public final StringProperty securityGroupProperty() {
        return this.securityGroup;
    }

    public final String getSecurityGroup() {
        return (String)this.securityGroupProperty().get();
    }

    public final void setSecurityGroup(String securityGroup) {
        this.securityGroupProperty().set((Object)securityGroup);
    }

    public final StringProperty statusProperty() {
        return this.status;
    }

    public final String getStatus() {
        return (String)this.statusProperty().get();
    }

    public final void setStatus(String status) {
        this.statusProperty().set((Object)status);
    }

    public final StringProperty qtyRangeProperty() {
        return this.qtyRange;
    }

    public final String getQtyRange() {
        return (String)this.qtyRangeProperty().get();
    }

    public final void setQtyRange(String qtyRange) {
        this.qtyRangeProperty().set((Object)qtyRange);
    }
}

