/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.http.data.IssueInfo;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.utils.StringUtils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObIssueInfoPurchaseNeeq
extends MxSelObj {
    private StringProperty issueId = new SimpleStringProperty("");
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty securityName = new SimpleStringProperty("");
    private StringProperty securityGroup = new SimpleStringProperty("");
    private StringProperty securtiryType = new SimpleStringProperty("");
    private StringProperty effectivePrice = new SimpleStringProperty("");
    private StringProperty qtyRange = new SimpleStringProperty("");
    private DoubleProperty outstandingShare = new SimpleDoubleProperty(0.0);
    private StringProperty startDate = new SimpleStringProperty("");
    private StringProperty tradeStatus = new SimpleStringProperty("");
    private StringProperty purchaseStatus = new SimpleStringProperty("");
    private StringProperty startEndDate = new SimpleStringProperty("");
    private DoubleProperty issuePe = new SimpleDoubleProperty(0.0);
    private double minPrice;
    private double maxPrice;
    private double minQty;
    private double maxQty;

    public void update(Object obj) {
        if (obj instanceof IssueInfo) {
            IssueInfo info = (IssueInfo)obj;
            this.update(info);
        } else if (obj instanceof ObIssueInfoPurchaseNeeq) {
            ObIssueInfoPurchaseNeeq info = (ObIssueInfoPurchaseNeeq)((Object)obj);
            this.update(info);
        }
    }

    public void update(IssueInfo info) {
        if (info.getSecurity() != null && info.getSecurity().getInstrument() != null) {
            this.setIssueId(info.getSecurity().getInstrument().getSecurityId());
            this.setSecurityName(info.getSecurity().getInstrument().getSymbol());
            this.setSecurtiryType(info.getSecurity().getInstrument().getSecurityType());
        }
        if (info.getParams() != null && info.getParams().getUnderlying() != null) {
            this.setSecurityId(info.getParams().getUnderlying().getSecurityId());
            this.setEffectivePrice(String.valueOf(StringUtils.toStr((double)info.getParams().getPriceLowerLimit(), (int)2)) + "--" + StringUtils.toStr((double)info.getParams().getPriceUpperLimit(), (int)2));
            this.setMinPrice(info.getParams().getPriceLowerLimit());
            this.setMaxPrice(info.getParams().getPriceUpperLimit());
            String upperLimit = StringUtils.toStr((double)info.getParams().getQtyUpperLimit(), (int)1);
            String lowerLimit = StringUtils.toStr((double)info.getParams().getQtyLowerLimit(), (int)1);
            this.setQtyRange(String.valueOf(lowerLimit) + "\u2014" + upperLimit);
            this.setMinQty(info.getParams().getQtyLowerLimit());
            this.setMaxQty(info.getParams().getQtyUpperLimit());
            this.setOutstandingShare(info.getParams().getOutstandingShare());
            this.setStartDate(info.getParams().getStartDate());
            this.setStartEndDate(String.valueOf(info.getParams().getStartDate()) + "-" + info.getParams().getEndDate());
            this.setIssuePe(info.getParams().getIssuePe());
        }
        this.setSecurityGroup("\u7cbe\u9009\u5c42");
        if ("F".equals(info.getParams().getUnderlying().getSecuritySubType())) {
            this.setTradeStatus("\u7533\u8d2d");
        } else if ("I".equals(info.getParams().getUnderlying().getSecuritySubType())) {
            this.setTradeStatus("\u8be2\u4ef7");
        }
    }

    public void update(ObIssueInfoPurchaseNeeq order) {
        this.setSecurtiryType(order.getSecurtiryType());
        this.setIssueId(order.getIssueId());
        this.setSecurityId(order.getSecurityId());
        this.setSecurityName(order.getSecurityName());
        this.setSecurityGroup(order.getSecurityGroup());
        this.setEffectivePrice(order.getEffectivePrice());
        this.setQtyRange(order.getQtyRange());
        this.setOutstandingShare(order.getOutstandingShare());
        this.setStartDate(order.getStartDate());
        this.setTradeStatus(order.getTradeStatus());
        this.setPurchaseStatus(order.getPurchaseStatus());
        this.setMinPrice(order.getMinPrice());
        this.setMaxPrice(order.getMaxPrice());
        this.setStartEndDate(order.getStartEndDate());
        this.setIssuePe(order.getIssuePe());
    }

    public double getMinPrice() {
        return this.minPrice;
    }

    public void setMinPrice(double minPrice) {
        this.minPrice = minPrice;
    }

    public double getMaxPrice() {
        return this.maxPrice;
    }

    public void setMaxPrice(double maxPrice) {
        this.maxPrice = maxPrice;
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public final StringProperty securityGroupProperty() {
        return this.securityGroup;
    }

    public final String getSecurityGroup() {
        return (String)this.securityGroupProperty().get();
    }

    public final void setSecurityGroup(String securityGroup) {
        this.securityGroupProperty().set((Object)securityGroup);
    }

    public final StringProperty effectivePriceProperty() {
        return this.effectivePrice;
    }

    public final String getEffectivePrice() {
        return (String)this.effectivePriceProperty().get();
    }

    public final void setEffectivePrice(String effectivePrice) {
        this.effectivePriceProperty().set((Object)effectivePrice);
    }

    public final StringProperty qtyRangeProperty() {
        return this.qtyRange;
    }

    public final String getQtyRange() {
        return (String)this.qtyRangeProperty().get();
    }

    public final void setQtyRange(String qtyRange) {
        this.qtyRangeProperty().set((Object)qtyRange);
    }

    public final DoubleProperty outstandingShareProperty() {
        return this.outstandingShare;
    }

    public final double getOutstandingShare() {
        return this.outstandingShareProperty().get();
    }

    public final void setOutstandingShare(double outstandingShare) {
        this.outstandingShareProperty().set(outstandingShare);
    }

    public final StringProperty startDateProperty() {
        return this.startDate;
    }

    public final String getStartDate() {
        return (String)this.startDateProperty().get();
    }

    public final void setStartDate(String startDate) {
        this.startDateProperty().set((Object)startDate);
    }

    public final StringProperty issueIdProperty() {
        return this.issueId;
    }

    public final String getIssueId() {
        return (String)this.issueIdProperty().get();
    }

    public final void setIssueId(String issueId) {
        this.issueIdProperty().set((Object)issueId);
    }

    public final StringProperty tradeStatusProperty() {
        return this.tradeStatus;
    }

    public final String getTradeStatus() {
        return (String)this.tradeStatusProperty().get();
    }

    public final void setTradeStatus(String tradeStatus) {
        this.tradeStatusProperty().set((Object)tradeStatus);
    }

    public final StringProperty purchaseStatusProperty() {
        return this.purchaseStatus;
    }

    public final String getPurchaseStatus() {
        return (String)this.purchaseStatusProperty().get();
    }

    public final void setPurchaseStatus(String purchaseStatus) {
        this.purchaseStatusProperty().set((Object)purchaseStatus);
    }

    public double getMinQty() {
        return this.minQty;
    }

    public void setMinQty(double minQty) {
        this.minQty = minQty;
    }

    public double getMaxQty() {
        return this.maxQty;
    }

    public void setMaxQty(double maxQty) {
        this.maxQty = maxQty;
    }

    public final StringProperty startEndDateProperty() {
        return this.startEndDate;
    }

    public final String getStartEndDate() {
        return (String)this.startEndDateProperty().get();
    }

    public final void setStartEndDate(String startEndDate) {
        this.startEndDateProperty().set((Object)startEndDate);
    }

    public final StringProperty securtiryTypeProperty() {
        return this.securtiryType;
    }

    public final String getSecurtiryType() {
        return (String)this.securtiryTypeProperty().get();
    }

    public final void setSecurtiryType(String securtiryType) {
        this.securtiryTypeProperty().set((Object)securtiryType);
    }

    public final DoubleProperty issuePeProperty() {
        return this.issuePe;
    }

    public final double getIssuePe() {
        return this.issuePeProperty().get();
    }

    public final void setIssuePe(double issuePe) {
        this.issuePeProperty().set(issuePe);
    }
}

