/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObExecutionXBond
extends MxSelObj {
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty securityName = new SimpleStringProperty("");
    private ObjectProperty<MxNode> side = new SimpleObjectProperty((Object)new MxNode());
    private DoubleProperty lastQty = new SimpleDoubleProperty();
    private DoubleProperty lastPx = new SimpleDoubleProperty();
    private DoubleProperty ytm = new SimpleDoubleProperty();
    private ObjectProperty<MxNode> matchType = new SimpleObjectProperty((Object)new MxNode());
    private ObjectProperty<MxNode> settlType = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty ordCategory = new SimpleStringProperty("");
    private ObjectProperty<MxNode> tradeMethod = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty chName = new SimpleStringProperty("");
    private StringProperty counterTraderId = new SimpleStringProperty("");
    private String userId = "";
    private StringProperty userName = new SimpleStringProperty("");
    private StringProperty traderId = new SimpleStringProperty("");
    private StringProperty termToMaturity = new SimpleStringProperty("");
    private StringProperty execDate = new SimpleStringProperty("");
    private StringProperty execTime = new SimpleStringProperty("");
    private StringProperty execId = new SimpleStringProperty("");
    private StringProperty orderId = new SimpleStringProperty("");
    private StringProperty source = new SimpleStringProperty("");
    private StringProperty sourceId = new SimpleStringProperty("");

    public ObExecutionXBond() {
        this.setSide(new MxNode().load("xbond_side", ""));
        this.setMatchType(new MxNode().load("match_type", ""));
        this.setSettlType(new MxNode().load("settl_type", ""));
        this.setTradeMethod(new MxNode().load("trade_method_xbond", ""));
    }

    public void update(Object obj) {
        if (obj instanceof Execution) {
            Execution exe = (Execution)obj;
            this.update(exe);
        } else if (obj instanceof ObExecutionXBond) {
            ObExecutionXBond exe = (ObExecutionXBond)((Object)obj);
            this.update(exe);
        }
    }

    public void update(Execution d) {
        this.setSecurityId(d.getInstrument().getSecurityId());
        this.setSecurityName(d.getInstrument().getSymbol());
        this.getSide().setRaw(d.getSide().getValue());
        this.setLastPx((double)Math.round(d.getLastPx() * 10000.0) / 10000.0);
        this.setLastQty(d.getLastQty());
        this.setYtm((double)Math.round(d.getYtm() * 10000.0) / 10000.0);
        if (d.getMatchType() != null) {
            this.getMatchType().setRaw(d.getMatchType().getValue());
        }
        if (d.getSettlType() != null) {
            this.getSettlType().setRaw(String.valueOf(d.getSettlType().ordinal()));
        }
        this.setChName(d.getCounterParty().getChName());
        this.setCounterTraderId(d.getCounterParty().getTraderName());
        this.setTermToMaturity(d.getTermToMaturity());
        this.setExecId(d.getExecId());
        this.getTradeMethod().setRaw(d.getTradeMethod().getValue());
        this.setExecDate(d.getExecDate());
        this.setExecTime(d.getExecTime());
        this.setOrderId(d.getOrderId());
        this.setSource(d.getSource());
        this.setSourceId(d.getSourceId());
        this.setOrdCategory(d.getOrdCategory());
        this.setUserId(d.getUserId());
        this.setUserName(d.getUserName());
        this.setTraderId(d.getSelfParty().getTraderId());
    }

    public void update(ObExecutionXBond o) {
        this.setSecurityId(o.getSecurityId());
        this.setSecurityName(o.getSecurityName());
        this.setSide(o.getSide());
        this.setLastPx(o.getLastPx());
        this.setLastQty(o.getLastQty());
        this.setYtm(o.getYtm());
        this.setMatchType(o.getMatchType());
        this.setSettlType(o.getSettlType());
        this.setSource(o.getSource());
        this.setSourceId(o.getSourceId());
        this.setOrdCategory(o.getOrdCategory());
        this.setChName(o.getChName());
        this.setCounterTraderId(o.getCounterTraderId());
        this.setTermToMaturity(o.getTermToMaturity());
        this.setExecId(o.getExecId());
        this.setOrderId(o.getOrderId());
        this.setTradeMethod(o.getTradeMethod());
        this.setExecDate(o.getExecDate());
        this.setExecTime(o.getExecTime());
        this.setSource(o.getSource());
        this.setUserId(o.getUserId());
        this.setUserName(o.getUserName());
        this.setTraderId(o.getTraderId());
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final DoubleProperty lastQtyProperty() {
        return this.lastQty;
    }

    public final double getLastQty() {
        return this.lastQtyProperty().get();
    }

    public final void setLastQty(double lastQty) {
        this.lastQtyProperty().set(lastQty);
    }

    public final DoubleProperty lastPxProperty() {
        return this.lastPx;
    }

    public final double getLastPx() {
        return this.lastPxProperty().get();
    }

    public final void setLastPx(double lastPx) {
        this.lastPxProperty().set(lastPx);
    }

    public final DoubleProperty ytmProperty() {
        return this.ytm;
    }

    public final double getYtm() {
        return this.ytmProperty().get();
    }

    public final void setYtm(double ytm) {
        this.ytmProperty().set(ytm);
    }

    public final ObjectProperty<MxNode> matchTypeProperty() {
        return this.matchType;
    }

    public final MxNode getMatchType() {
        return (MxNode)this.matchTypeProperty().get();
    }

    public final void setMatchType(MxNode matchType) {
        this.matchTypeProperty().set((Object)matchType);
    }

    public final ObjectProperty<MxNode> settlTypeProperty() {
        return this.settlType;
    }

    public final MxNode getSettlType() {
        return (MxNode)this.settlTypeProperty().get();
    }

    public final void setSettlType(MxNode settlType) {
        this.settlTypeProperty().set((Object)settlType);
    }

    public final StringProperty counterTraderIdProperty() {
        return this.counterTraderId;
    }

    public final String getCounterTraderId() {
        return (String)this.counterTraderIdProperty().get();
    }

    public final void setCounterTraderId(String counterTraderId) {
        this.counterTraderIdProperty().set((Object)counterTraderId);
    }

    public final StringProperty termToMaturityProperty() {
        return this.termToMaturity;
    }

    public final String getTermToMaturity() {
        return (String)this.termToMaturityProperty().get();
    }

    public final void setTermToMaturity(String termToMaturity) {
        this.termToMaturityProperty().set((Object)termToMaturity);
    }

    public final StringProperty execIdProperty() {
        return this.execId;
    }

    public final String getExecId() {
        return (String)this.execIdProperty().get();
    }

    public final void setExecId(String execId) {
        this.execIdProperty().set((Object)execId);
    }

    public final StringProperty orderIdProperty() {
        return this.orderId;
    }

    public final String getOrderId() {
        return (String)this.orderIdProperty().get();
    }

    public final void setOrderId(String orderId) {
        this.orderIdProperty().set((Object)orderId);
    }

    public final ObjectProperty<MxNode> tradeMethodProperty() {
        return this.tradeMethod;
    }

    public final MxNode getTradeMethod() {
        return (MxNode)this.tradeMethodProperty().get();
    }

    public final void setTradeMethod(MxNode tradeMethod) {
        this.tradeMethodProperty().set((Object)tradeMethod);
    }

    public final StringProperty execTimeProperty() {
        return this.execTime;
    }

    public final String getExecTime() {
        return (String)this.execTimeProperty().get();
    }

    public final void setExecTime(String execTime) {
        this.execTimeProperty().set((Object)execTime);
    }

    public final StringProperty chNameProperty() {
        return this.chName;
    }

    public final String getChName() {
        return (String)this.chNameProperty().get();
    }

    public final void setChName(String chName) {
        this.chNameProperty().set((Object)chName);
    }

    public final StringProperty sourceProperty() {
        return this.source;
    }

    public final String getSource() {
        return (String)this.sourceProperty().get();
    }

    public final void setSource(String source) {
        this.sourceProperty().set((Object)source);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public final StringProperty userNameProperty() {
        return this.userName;
    }

    public final String getUserName() {
        return (String)this.userNameProperty().get();
    }

    public final void setUserName(String userName) {
        this.userNameProperty().set((Object)userName);
    }

    public final StringProperty traderIdProperty() {
        return this.traderId;
    }

    public final String getTraderId() {
        return (String)this.traderIdProperty().get();
    }

    public final void setTraderId(String traderId) {
        this.traderIdProperty().set((Object)traderId);
    }

    public final StringProperty sourceIdProperty() {
        return this.sourceId;
    }

    public final String getSourceId() {
        return (String)this.sourceIdProperty().get();
    }

    public final void setSourceId(String sourceId) {
        this.sourceIdProperty().set((Object)sourceId);
    }

    public final StringProperty execDateProperty() {
        return this.execDate;
    }

    public final String getExecDate() {
        return (String)this.execDateProperty().get();
    }

    public final void setExecDate(String execDate) {
        this.execDateProperty().set((Object)execDate);
    }

    public final StringProperty ordCategoryProperty() {
        return this.ordCategory;
    }

    public final String getOrdCategory() {
        return (String)this.ordCategoryProperty().get();
    }

    public final void setOrdCategory(String ordCategory) {
        this.ordCategoryProperty().set((Object)ordCategory);
    }
}

