/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class NewStockAuth {
    public static final String YES = "\u6709\u6743\u9650";
    public static final String NO_KEC = "\u65e0\u79d1\u521b\u677f\u6743\u9650";
    public static final String NO_GEM = "\u65e0\u521b\u4e1a\u677f\u6743\u9650";
    public static final String BUSINESS_CTRL_K = "K";
    public static final String BUSINESS_CTRL_E = "E";
    private boolean auth = true;
    private StringProperty desc = new SimpleStringProperty("");

    public void update(NewStockAuth auth) {
        this.setAuth(auth.isAuth());
        this.setDesc(auth.getDesc());
    }

    public void checkAuth(RefItem refItem, SecAccount secAcc) {
        if (refItem == null) {
            this.clear();
            return;
        }
        String code = refItem.getCode();
        String market = refItem.getMarket();
        if ("XSHG".equals(market) && code.startsWith("787")) {
            this.setKEC(secAcc.getBusinessCtrl().contains(BUSINESS_CTRL_K));
        } else if ("XSHE".equals(refItem.getMarket()) && refItem.isGem()) {
            this.setGEM(secAcc.getBusinessCtrl().contains(BUSINESS_CTRL_E));
        } else {
            this.setCommont();
        }
    }

    public void setKEC(boolean auth) {
        this.setAuth(auth);
        this.setDesc(auth ? YES : NO_KEC);
    }

    public void setGEM(boolean auth) {
        this.setAuth(auth);
        this.setDesc(auth ? YES : NO_GEM);
    }

    public void setCommont() {
        this.setAuth(true);
        this.setDesc(YES);
    }

    public void clear() {
        this.setAuth(true);
        this.setDesc("");
    }

    public String toString() {
        return this.getDesc();
    }

    public boolean isAuth() {
        return this.auth;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    public final StringProperty descProperty() {
        return this.desc;
    }

    public final String getDesc() {
        return (String)this.descProperty().get();
    }

    public final void setDesc(String desc) {
        this.descProperty().set((Object)desc);
    }
}

