/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.data.IssueInfo;
import cms.tmx.http.neeq.RfqResult;
import cms.tmx.javafx.obj.MxObject;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class NeeqInquiryDetail
extends MxObject {
    private StringProperty issueId = new SimpleStringProperty("");
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty securityName = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty investorsecId = new SimpleStringProperty("");
    private StringProperty orderId = new SimpleStringProperty("");
    private DoubleProperty price = new SimpleDoubleProperty(0.0);
    private DoubleProperty qty = new SimpleDoubleProperty(0.0);
    private StringProperty inquiryStatus = new SimpleStringProperty("");

    public void update(Object t) {
        if (t instanceof IssueInfo) {
            IssueInfo info = (IssueInfo)IssueInfo.class.cast(t);
            this.update(info);
        } else if (t instanceof SingleOrder) {
            SingleOrder info = (SingleOrder)SingleOrder.class.cast(t);
            this.update(info);
        } else if (t instanceof RfqResult) {
            RfqResult info = (RfqResult)RfqResult.class.cast(t);
            this.update(info);
        }
    }

    private void update(RfqResult info) {
        this.setIssueId(info.getInstrument().getSecurityId());
        this.setSecurityId(info.getUnderlying().getSecurityId());
        this.setSecurityName(info.getInstrument().getSecurityGroup());
        this.setInvestorId(info.getInvestorId());
        this.setInvestorsecId(info.getInvestorSecId());
    }

    private void update(SingleOrder info) {
        this.setIssueId(info.getIssueId());
        this.setSecurityId(info.getSecurityId());
        this.setSecurityName(info.getSecurityName());
        this.setInvestorId(info.getInvestorId());
        this.setInvestorsecId(info.getInvestorSecId());
        this.setOrderId(info.getOrderId());
        this.setPrice(info.getPrice());
        this.setQty(info.getOrderQty());
    }

    private void update(IssueInfo info) {
        this.setIssueId(info.getIssueId());
        this.setSecurityId(info.getSecurityId());
        this.setSecurityName(info.getSecurityName());
    }

    public final StringProperty issueIdProperty() {
        return this.issueId;
    }

    public final String getIssueId() {
        return (String)this.issueIdProperty().get();
    }

    public final void setIssueId(String issueId) {
        this.issueIdProperty().set((Object)issueId);
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty investorsecIdProperty() {
        return this.investorsecId;
    }

    public final String getInvestorsecId() {
        return (String)this.investorsecIdProperty().get();
    }

    public final void setInvestorsecId(String investorsecId) {
        this.investorsecIdProperty().set((Object)investorsecId);
    }

    public final StringProperty orderIdProperty() {
        return this.orderId;
    }

    public final String getOrderId() {
        return (String)this.orderIdProperty().get();
    }

    public final void setOrderId(String orderId) {
        this.orderIdProperty().set((Object)orderId);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final DoubleProperty qtyProperty() {
        return this.qty;
    }

    public final double getQty() {
        return this.qtyProperty().get();
    }

    public final void setQty(double qty) {
        this.qtyProperty().set(qty);
    }

    public final StringProperty inquiryStatusProperty() {
        return this.inquiryStatus;
    }

    public final String getInquiryStatus() {
        return (String)this.inquiryStatusProperty().get();
    }

    public final void setInquiryStatus(String inquiryStatus) {
        this.inquiryStatusProperty().set((Object)inquiryStatus);
    }
}

