/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.javafx.obj.MxObject;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class MonthReport
extends MxObject {
    private Instrument instrument;
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty portfolio = new SimpleStringProperty("");
    private DoubleProperty dividendVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty buyVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty buyAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty sellVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty sellAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty preTotalVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty preHoldCostAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty closingCostAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty investIncome = new SimpleDoubleProperty(0.0);
    private DoubleProperty addedTax = new SimpleDoubleProperty(0.0);
    private DoubleProperty otherComprehensiveIncome = new SimpleDoubleProperty(0.0);
    private DoubleProperty lastTotalVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty lastHoldCostAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty preTotalProfit = new SimpleDoubleProperty(0.0);
    private DoubleProperty preTotalAdjustProfit = new SimpleDoubleProperty(0.0);
    private DoubleProperty closePrice = new SimpleDoubleProperty(0.0);
    private DoubleProperty totalCapitalization = new SimpleDoubleProperty(0.0);
    private DoubleProperty deltaProfit = new SimpleDoubleProperty(0.0);
    private DoubleProperty lastTotalProfit = new SimpleDoubleProperty(0.0);
    private StringProperty month = new SimpleStringProperty("");
    private String secId;
    private String secName;
    private String market;

    public void update(Object obj) {
        if (obj instanceof PCashService.ExtMonthReport) {
            this.update((PCashService.ExtMonthReport)PCashService.ExtMonthReport.class.cast(obj));
        } else if (obj instanceof MonthReport) {
            this.update((MonthReport)((Object)MonthReport.class.cast(obj)));
        }
    }

    private void update(PCashService.ExtMonthReport ca) {
        PCashService.Instrument inst = ca.getInstrument();
        this.getInstrument().update((Object)inst);
        this.setSecId(this.getInstrument().getSecId());
        this.setMarket(this.getInstrument().getMarket().getValue());
        this.setDividendVolume((long)ca.getDividendVolume());
        this.setBuyVolume((long)ca.getBuyInVolume());
        this.setBuyAmt((double)Math.round(ca.getBuyInAmt() * 100.0) / 100.0);
        this.setSellVolume((long)ca.getSellOutVolume());
        this.setSellAmt((double)Math.round(ca.getSellOutAmt() * 100.0) / 100.0);
        this.setPreTotalVolume((long)ca.getPreTotalVolume());
        this.setPreHoldCostAmt((double)Math.round(ca.getPreBuyCostAmt() * 100.0) / 100.0);
        this.setClosingCostAmt((double)Math.round(ca.getClosingCostAmt() * 100.0) / 100.0);
        this.setInvestIncome((double)Math.round(ca.getInvestIncome() * 100.0) / 100.0);
        this.setAddedTax((double)Math.round(ca.getTax() * 100.0) / 100.0);
        this.setOtherComprehensiveIncome((double)Math.round(ca.getOtherComprehensiveIncome() * 100.0) / 100.0);
        this.setLastTotalVolume((long)ca.getTotalVolume());
        this.setLastHoldCostAmt((double)Math.round(ca.getBuyCostAmt() * 100.0) / 100.0);
        this.setPreTotalProfit((double)Math.round(ca.getPreAdjustAmt() * 100.0) / 100.0);
        this.setPreTotalAdjustProfit((double)Math.round(ca.getPreAdjustAmtBalance() * 100.0) / 100.0);
        this.setClosePrice((double)Math.round(ca.getClosePrice() * 1000.0) / 1000.0);
        this.setTotalCapitalization((double)Math.round(ca.getTotalCapitalization() * 100.0) / 100.0);
        this.setDeltaProfit((double)Math.round(ca.getDeltaProfit() * 100.0) / 100.0);
        this.setLastTotalProfit((double)Math.round(ca.getAdjustBalance() * 100.0) / 100.0);
    }

    private void update(MonthReport ca) {
        this.setInstrument(ca.getInstrument());
        this.setSecId(ca.getSecId());
        this.setSecName(ca.getSecName());
        this.setMarket(ca.getMarket());
        this.setInvestorId(ca.getInvestorId());
        this.setPortfolio(ca.getPortfolio());
        this.setDividendVolume(ca.getDividendVolume());
        this.setBuyVolume(ca.getBuyVolume());
        this.setBuyAmt(ca.getBuyAmt());
        this.setSellVolume(ca.getSellVolume());
        this.setSellAmt(ca.getSellAmt());
        this.setPreTotalVolume(ca.getPreTotalVolume());
        this.setPreHoldCostAmt(ca.getPreHoldCostAmt());
        this.setClosingCostAmt(ca.getClosingCostAmt());
        this.setInvestIncome(ca.getInvestIncome());
        this.setAddedTax(ca.getAddedTax());
        this.setOtherComprehensiveIncome(ca.getOtherComprehensiveIncome());
        this.setLastTotalVolume(ca.getLastTotalVolume());
        this.setLastHoldCostAmt(ca.getLastHoldCostAmt());
        this.setPreTotalProfit(ca.getPreTotalProfit());
        this.setPreTotalAdjustProfit(ca.getPreTotalAdjustProfit());
        this.setClosePrice(ca.getClosePrice());
        this.setTotalCapitalization(ca.getTotalCapitalization());
        this.setDeltaProfit(ca.getDeltaProfit());
        this.setLastTotalProfit(ca.getLastTotalProfit());
        this.setMonth(ca.getMonth());
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty portfolioProperty() {
        return this.portfolio;
    }

    public final String getPortfolio() {
        return (String)this.portfolioProperty().get();
    }

    public final void setPortfolio(String portfolio) {
        this.portfolioProperty().set((Object)portfolio);
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public String getSecId() {
        return this.secId;
    }

    public void setSecId(String secId) {
        this.secId = secId;
    }

    public String getSecName() {
        return this.secName;
    }

    public void setSecName(String secName) {
        this.secName = secName;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public final DoubleProperty dividendVolumeProperty() {
        return this.dividendVolume;
    }

    public final double getDividendVolume() {
        return this.dividendVolumeProperty().get();
    }

    public final void setDividendVolume(double dividendVolume) {
        this.dividendVolumeProperty().set(dividendVolume);
    }

    public final DoubleProperty preTotalVolumeProperty() {
        return this.preTotalVolume;
    }

    public final double getPreTotalVolume() {
        return this.preTotalVolumeProperty().get();
    }

    public final void setPreTotalVolume(double preTotalVolume) {
        this.preTotalVolumeProperty().set(preTotalVolume);
    }

    public final DoubleProperty preHoldCostAmtProperty() {
        return this.preHoldCostAmt;
    }

    public final double getPreHoldCostAmt() {
        return this.preHoldCostAmtProperty().get();
    }

    public final void setPreHoldCostAmt(double preHoldCostAmt) {
        this.preHoldCostAmtProperty().set(preHoldCostAmt);
    }

    public final DoubleProperty closingCostAmtProperty() {
        return this.closingCostAmt;
    }

    public final double getClosingCostAmt() {
        return this.closingCostAmtProperty().get();
    }

    public final void setClosingCostAmt(double closingCostAmt) {
        this.closingCostAmtProperty().set(closingCostAmt);
    }

    public final DoubleProperty investIncomeProperty() {
        return this.investIncome;
    }

    public final double getInvestIncome() {
        return this.investIncomeProperty().get();
    }

    public final void setInvestIncome(double investIncome) {
        this.investIncomeProperty().set(investIncome);
    }

    public final DoubleProperty otherComprehensiveIncomeProperty() {
        return this.otherComprehensiveIncome;
    }

    public final double getOtherComprehensiveIncome() {
        return this.otherComprehensiveIncomeProperty().get();
    }

    public final void setOtherComprehensiveIncome(double otherComprehensiveIncome) {
        this.otherComprehensiveIncomeProperty().set(otherComprehensiveIncome);
    }

    public final DoubleProperty lastTotalVolumeProperty() {
        return this.lastTotalVolume;
    }

    public final double getLastTotalVolume() {
        return this.lastTotalVolumeProperty().get();
    }

    public final void setLastTotalVolume(double lastTotalVolume) {
        this.lastTotalVolumeProperty().set(lastTotalVolume);
    }

    public final DoubleProperty lastHoldCostAmtProperty() {
        return this.lastHoldCostAmt;
    }

    public final double getLastHoldCostAmt() {
        return this.lastHoldCostAmtProperty().get();
    }

    public final void setLastHoldCostAmt(double lastHoldCostAmt) {
        this.lastHoldCostAmtProperty().set(lastHoldCostAmt);
    }

    public final DoubleProperty preTotalProfitProperty() {
        return this.preTotalProfit;
    }

    public final double getPreTotalProfit() {
        return this.preTotalProfitProperty().get();
    }

    public final void setPreTotalProfit(double preTotalProfit) {
        this.preTotalProfitProperty().set(preTotalProfit);
    }

    public final DoubleProperty preTotalAdjustProfitProperty() {
        return this.preTotalAdjustProfit;
    }

    public final double getPreTotalAdjustProfit() {
        return this.preTotalAdjustProfitProperty().get();
    }

    public final void setPreTotalAdjustProfit(double preTotalAdjustProfit) {
        this.preTotalAdjustProfitProperty().set(preTotalAdjustProfit);
    }

    public final DoubleProperty closePriceProperty() {
        return this.closePrice;
    }

    public final double getClosePrice() {
        return this.closePriceProperty().get();
    }

    public final void setClosePrice(double closePrice) {
        this.closePriceProperty().set(closePrice);
    }

    public final DoubleProperty totalCapitalizationProperty() {
        return this.totalCapitalization;
    }

    public final double getTotalCapitalization() {
        return this.totalCapitalizationProperty().get();
    }

    public final void setTotalCapitalization(double totalCapitalization) {
        this.totalCapitalizationProperty().set(totalCapitalization);
    }

    public final DoubleProperty deltaProfitProperty() {
        return this.deltaProfit;
    }

    public final double getDeltaProfit() {
        return this.deltaProfitProperty().get();
    }

    public final void setDeltaProfit(double deltaProfit) {
        this.deltaProfitProperty().set(deltaProfit);
    }

    public final DoubleProperty lastTotalProfitProperty() {
        return this.lastTotalProfit;
    }

    public final double getLastTotalProfit() {
        return this.lastTotalProfitProperty().get();
    }

    public final void setLastTotalProfit(double lastTotalProfit) {
        this.lastTotalProfitProperty().set(lastTotalProfit);
    }

    public final DoubleProperty buyVolumeProperty() {
        return this.buyVolume;
    }

    public final double getBuyVolume() {
        return this.buyVolumeProperty().get();
    }

    public final void setBuyVolume(double buyVolume) {
        this.buyVolumeProperty().set(buyVolume);
    }

    public final DoubleProperty buyAmtProperty() {
        return this.buyAmt;
    }

    public final double getBuyAmt() {
        return this.buyAmtProperty().get();
    }

    public final void setBuyAmt(double buyAmt) {
        this.buyAmtProperty().set(buyAmt);
    }

    public final DoubleProperty sellVolumeProperty() {
        return this.sellVolume;
    }

    public final double getSellVolume() {
        return this.sellVolumeProperty().get();
    }

    public final void setSellVolume(double sellVolume) {
        this.sellVolumeProperty().set(sellVolume);
    }

    public final DoubleProperty sellAmtProperty() {
        return this.sellAmt;
    }

    public final double getSellAmt() {
        return this.sellAmtProperty().get();
    }

    public final void setSellAmt(double sellAmt) {
        this.sellAmtProperty().set(sellAmt);
    }

    public final StringProperty monthProperty() {
        return this.month;
    }

    public final String getMonth() {
        return (String)this.monthProperty().get();
    }

    public final void setMonth(String month) {
        this.monthProperty().set((Object)month);
    }

    public final DoubleProperty addedTaxProperty() {
        return this.addedTax;
    }

    public final double getAddedTax() {
        return this.addedTaxProperty().get();
    }

    public final void setAddedTax(double addedTax) {
        this.addedTaxProperty().set(addedTax);
    }
}

