/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.NewCcsSingleEntrust;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.NewOrderSingle;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.query.TimeInForce;
import cms.tmx.http.xt.XtAccount;
import cms.tmx.http.xt.XtNewOrderSingle;
import cms.tmx.http.xt.XtTradeDetail;
import cms.tmx.http.xt.api.XtPledgeServiceApi;
import cms.tmx.http.xt.api.XtSecurityServiceApi;
import java.math.BigDecimal;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginSingleEntrust
extends NewCcsSingleEntrust {
    @Inject
    private XtPledgeServiceApi pledgeServiceApi;
    @Inject
    private XtSecurityServiceApi securityServiceApi;

    @Override
    public void newOrderSingle() throws MException {
        NewOrderSingle req = new NewOrderSingle();
        req.setOpUser(this.apiBase.getHttpOpUser());
        req.setExtCashAccntId(this.getAcc());
        req.setExtSecAccntId(this.getSecAcc());
        req.setInvestorId(this.getInvestorId());
        req.setInvestorSecId(this.getInvestorSecId());
        if (!this.getTransferSecAccountId().isEmpty()) {
            req.setAttachment(this.getTransferSecAccountId());
        }
        Instrument inst = new Instrument();
        inst.setSecurityId(this.getSec());
        inst.setMarket(this.getMarket());
        inst.setMarketIndicator(this.getMarketIndicate());
        inst.setSymbol(this.getSecName());
        inst.setSecurityType(this.getSecType());
        inst.setApplId(this.getApplId());
        inst.setMarketGroup(this.getMarketGroup());
        req.setInstrument(inst);
        req.setOrderQty((double)this.getQuantity());
        req.setPrice(this.getPrice());
        req.setTradePlatformId(this.getFundAccount().getCounterId());
        if (50 == this.getOrderType() || this.getOrderType() == 0) {
            req.setOrdType(OrdType.ORD_TYPE_LIMIT);
        } else if (49 == this.getOrderType()) {
            req.setOrdType(OrdType.ORD_TYPE_MARKET);
            req.setMaxPriceLevels(this.getMaxLevels());
            req.setTif(TimeInForce.getValue((int)this.getTif()));
            req.setStopPx(this.getPrice());
        } else if (80 == this.getOrderType()) {
            req.setOrdType(OrdType.ORD_TYPE_PEGGED);
        }
        this.api.newOrderSingle(req);
    }

    public void newOrderSingleXt() throws MException {
        XtNewOrderSingle req = new XtNewOrderSingle();
        XtAccount account = new XtAccount();
        account.setCashAccntId(this.getAcc());
        account.setSecAccntId(this.getSecAcc());
        account.setInvestorId(this.getInvestorId());
        account.setInvestorSecId(this.getInvestorSecId());
        account.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT.getValue());
        account.setBrokerId(this.getBrokerId());
        XtTradeDetail tradeDetail = new XtTradeDetail();
        tradeDetail.setOrderQty(new BigDecimal(this.getQuantity()).intValue());
        tradeDetail.setPrice(this.getPrice());
        tradeDetail.setPlatformId(this.getBrokerId());
        tradeDetail.setAttachment(this.getTransferSecAccountId().isEmpty() ? "" : this.getTransferSecAccountId());
        Instrument inst = new Instrument();
        inst.setSecurityId(this.getSec());
        inst.setMarket(this.getMarket());
        inst.setMarketIndicator(this.getMarketIndicate());
        inst.setSymbol(this.getSecName());
        inst.setSecurityType(this.getSecType());
        inst.setApplId(this.getApplId());
        inst.setMarketGroup(this.getMarketGroup());
        if (50 == this.getOrderType() || this.getOrderType() == 0) {
            tradeDetail.setOrderType(Integer.parseInt(OrdType.ORD_TYPE_LIMIT.getValue()));
        } else if (49 == this.getOrderType()) {
            tradeDetail.setOrderType(Integer.parseInt(OrdType.ORD_TYPE_MARKET.getValue()));
            tradeDetail.setMaxPriceLevels(this.getMaxLevels());
            tradeDetail.setTif(this.getTif());
            tradeDetail.setStopPx(this.getPrice());
        } else if (80 == this.getOrderType()) {
            tradeDetail.setOrderType(Integer.parseInt(OrdType.ORD_TYPE_PEGGED.getValue()));
        }
        req.setAccount(account);
        req.setInstrument(inst);
        req.setTradeDetai(tradeDetail);
        switch (this.getMarketIndicate()) {
            case "PLEDGE_SELL": 
            case "PLEDGE_BUY": {
                req.setTradeType(this.getMarketIndicate());
                this.pledgeServiceApi.newOrderSingle(req);
                break;
            }
            case "PLEDGE_OUT": 
            case "PLEDGE_IN": {
                req.setTradeType(this.getMarketIndicate());
                this.pledgeServiceApi.newTrans(req);
                break;
            }
            case "CASH_SELL_PAYOFF": 
            case "CASH_BUY": 
            case "POS_SELL": 
            case "POS_BUY_PAYOFF": {
                req.setTradeType(this.getMarketIndicate());
                this.securityServiceApi.newOrderSingle(req);
                break;
            }
        }
    }

    @Override
    public void newTransPos() throws MException {
        switch (this.getMarketIndicate()) {
            case "VOUCHER_PAYOFF": {
                this.MarginVoucherPayOff();
                break;
            }
            case "CASH_PAYOFF": {
                this.MarginCashPayOff();
                break;
            }
        }
    }

    public void newTransPosXt() throws MException {
        switch (this.getMarketIndicate()) {
            case "VOUCHER_PAYOFF": {
                this.MarginVoucherPayOffXt();
                break;
            }
            case "CASH_PAYOFF": {
                this.MarginCashPayOffXt();
                break;
            }
        }
    }

    private void MarginVoucherPayOffXt() throws MException {
        XtNewOrderSingle req = new XtNewOrderSingle();
        Instrument inst = new Instrument();
        inst.setSecurityId(this.getSec());
        inst.setMarket(this.getMarket());
        inst.setMarketIndicator(MarketIndicator.KCREDIT_VOUCHER_PAYOFF.getValue());
        inst.setSymbol(this.getSecName());
        inst.setSecurityType(this.getSecType());
        inst.setApplId("760");
        inst.setMarketGroup("CCS");
        XtTradeDetail tradeDetai = new XtTradeDetail();
        tradeDetai.setOrderQty(new BigDecimal(this.getQuantity()).intValue());
        tradeDetai.setPrice(this.getPrice());
        tradeDetai.setPlatformId(this.getFundAccount().getCounterId());
        XtAccount account = new XtAccount();
        account.setCashAccntId(this.getAcc());
        account.setSecAccntId(this.getSecAcc());
        account.setInvestorId(this.getInvestorId());
        account.setInvestorSecId(this.getInvestorSecId());
        account.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT.getValue());
        account.setBrokerId(this.getBrokerId());
        req.setInstrument(inst);
        req.setTradeDetai(tradeDetai);
        req.setAccount(account);
        req.setTradeType(this.getMarketIndicate());
        this.securityServiceApi.newOrderSingle(req);
    }

    private void MarginCashPayOffXt() throws MException {
        XtNewOrderSingle req = new XtNewOrderSingle();
        Instrument inst = new Instrument();
        inst.setMarketIndicator(MarketIndicator.KCREDIT_CASH_PAYOFF.getValue());
        inst.setApplId("760");
        inst.setMarketGroup("CCS");
        XtTradeDetail tradeDetai = new XtTradeDetail();
        tradeDetai.setOrderAmount(this.getPrice());
        XtAccount account = new XtAccount();
        account.setCashAccntId(this.getAcc());
        account.setSecAccntId(this.getSecAcc());
        account.setInvestorId(this.getInvestorId());
        account.setInvestorSecId(this.getInvestorSecId());
        account.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT.getValue());
        account.setBrokerId(this.getBrokerId());
        req.setInstrument(inst);
        req.setTradeDetai(tradeDetai);
        req.setAccount(account);
        req.setTradeType(this.getMarketIndicate());
        this.securityServiceApi.newOrderSingle(req);
    }

    private void MarginVoucherPayOff() throws MException {
        Instrument inst = new Instrument();
        inst.setSecurityId(this.getSec());
        inst.setMarket(this.getMarket());
        inst.setMarketIndicator(MarketIndicator.KCREDIT_VOUCHER_PAYOFF.getValue());
        inst.setSymbol(this.getSecName());
        inst.setSecurityType(this.getSecType());
        inst.setApplId("750");
        inst.setMarketGroup("CCS");
        NewOrderSingle req = new NewOrderSingle();
        req.setOpUser(this.apiBase.getHttpOpUser());
        req.setInstrument(inst);
        req.setOrderQty((double)this.getQuantity());
        req.setPrice(this.getPrice());
        req.setExtCashAccntId(this.getFundAccount().getNewCashAccntId());
        req.setExtSecAccntId(this.getSecAccount().getExtSecAccntId());
        req.setTradePlatformId(this.getFundAccount().getCounterId());
        this.api.newOrderSingle(req);
    }

    private void MarginCashPayOff() throws MException {
        NewOrderSingle req = new NewOrderSingle();
        req.setOpUser(this.apiBase.getHttpOpUser());
        Instrument inst = new Instrument();
        inst.setMarketIndicator(MarketIndicator.KCREDIT_CASH_PAYOFF.getValue());
        inst.setApplId("750");
        inst.setMarketGroup("CCS");
        req.setInstrument(inst);
        req.setOrderAmount(this.getPrice());
        req.setExtCashAccntId(this.getFundAccount().getNewCashAccntId());
        req.setTradePlatformId(this.getFundAccount().getCounterId());
        this.api.newOrderSingle(req);
    }
}

