/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class Instrument
extends MxChgObj {
    private StringProperty symbol = new SimpleStringProperty("");
    private StringProperty secId = new SimpleStringProperty("");
    private StringProperty secIdSource = new SimpleStringProperty("");
    private StringProperty secType = new SimpleStringProperty("");
    private StringProperty secSubType = new SimpleStringProperty("");
    private ObjectProperty<MxNode> market = new SimpleObjectProperty();
    private StringProperty applId = new SimpleStringProperty("");
    @Inject
    private MObjFactory of;

    @PostConstruct
    public void init() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.setMarket(node);
    }

    public Instrument() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.setMarket(node);
    }

    public void update(Object obj) {
        if (obj instanceof PComponent.Instrument) {
            PComponent.Instrument instr = (PComponent.Instrument)PComponent.Instrument.class.cast(obj);
            this.update(instr);
            this.changed();
        } else if (obj instanceof Instrument) {
            this.update((Instrument)((Object)Instrument.class.cast(obj)));
        } else if (obj instanceof PCashService.Instrument) {
            PCashService.Instrument instr = (PCashService.Instrument)PCashService.Instrument.class.cast(obj);
            this.update(instr);
            this.changed();
        }
    }

    public PComponent.Instrument.Builder getBuilder() {
        PComponent.Instrument.Builder instBuilder = PComponent.Instrument.newBuilder();
        instBuilder.setSecurityId(this.getSecId());
        instBuilder.setMarket(this.getMarket().getRaw());
        instBuilder.setSecurityType(this.getSecType());
        instBuilder.setSecuritySubType(this.getSecSubType());
        instBuilder.setSecurityIdSource(this.getSecIdSource());
        instBuilder.setApplId(this.getApplId());
        instBuilder.setSymbol(this.getSymbol());
        return instBuilder;
    }

    private void update(PComponent.Instrument in) {
        this.setSymbol(in.getSymbol());
        this.setSecId(in.getSecurityId());
        this.setSecIdSource(in.getSecurityIdSource());
        this.setSecType(in.getSecurityType());
        this.setSecSubType(in.getSecuritySubType());
        this.getMarket().setRaw(in.getMarket());
        this.setApplId(in.getApplId());
    }

    private void update(Instrument in) {
        this.setSymbol(in.getSymbol());
        this.setSecId(in.getSecId());
        this.setSecIdSource(in.getSecIdSource());
        this.setSecType(in.getSecType());
        this.setSecSubType(in.getSecSubType());
        this.getMarket().setRaw(in.getMarket().getRaw());
    }

    private void update(PCashService.Instrument in) {
        this.setSymbol(in.getSymbol());
        this.setSecId(in.getSecurityId());
        this.setSecIdSource(in.getSecurityIdSource());
        this.setSecType(in.getSecurityType());
        this.setSecSubType(in.getSecuritySubType());
        this.getMarket().setRaw(in.getMarket());
        this.setApplId(in.getApplId());
    }

    public StringProperty symbolProperty() {
        return this.symbol;
    }

    public String getSymbol() {
        return (String)this.symbolProperty().get();
    }

    public void setSymbol(String symbol) {
        this.symbolProperty().set((Object)symbol);
    }

    public StringProperty secIdProperty() {
        return this.secId;
    }

    public String getSecId() {
        return (String)this.secIdProperty().get();
    }

    public void setSecId(String secId) {
        this.secIdProperty().set((Object)secId);
    }

    public StringProperty secIdSourceProperty() {
        return this.secIdSource;
    }

    public String getSecIdSource() {
        return (String)this.secIdSourceProperty().get();
    }

    public void setSecIdSource(String secIdSource) {
        this.secIdSourceProperty().set((Object)secIdSource);
    }

    public StringProperty secTypeProperty() {
        return this.secType;
    }

    public String getSecType() {
        return (String)this.secTypeProperty().get();
    }

    public void setSecType(String secType) {
        this.secTypeProperty().set((Object)secType);
    }

    public StringProperty secSubTypeProperty() {
        return this.secSubType;
    }

    public String getSecSubType() {
        return (String)this.secSubTypeProperty().get();
    }

    public void setSecSubType(String secSubType) {
        this.secSubTypeProperty().set((Object)secSubType);
    }

    public ObjectProperty<MxNode> marketProperty() {
        return this.market;
    }

    public MxNode getMarket() {
        return (MxNode)this.marketProperty().get();
    }

    public void setMarket(MxNode market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty applIdProperty() {
        return this.applId;
    }

    public final String getApplId() {
        return (String)this.applIdProperty().get();
    }

    public final void setApplId(String applId) {
        this.applIdProperty().set((Object)applId);
    }
}

