/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.proto.strategy.PStrategyMonitor;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class Indicator
extends MxChgObj {
    private ObjectProperty<MxNode> status = new SimpleObjectProperty();
    private ObjectProperty<MxNode> direction = new SimpleObjectProperty();
    private ObjectProperty<MxNode> indicator = new SimpleObjectProperty();
    private DoubleProperty realtimeValue = new SimpleDoubleProperty();
    private PStrategyMonitor.Color realtimeColor = PStrategyMonitor.Color.COLOR_UNDEFINED;
    private PStrategyMonitor.SoundAlert realtimeSound = PStrategyMonitor.SoundAlert.SOUND_ALERT_UNDEFINED;
    private boolean set1 = false;
    private boolean set2 = false;
    private DoubleProperty value1 = new SimpleDoubleProperty();
    private DoubleProperty value2 = new SimpleDoubleProperty();
    private PStrategyMonitor.Color color1 = PStrategyMonitor.Color.COLOR_UNDEFINED;
    private PStrategyMonitor.Color color2 = PStrategyMonitor.Color.COLOR_UNDEFINED;
    private PStrategyMonitor.SoundAlert sound1 = PStrategyMonitor.SoundAlert.SOUND_ALERT_UNDEFINED;
    private PStrategyMonitor.SoundAlert sound2 = PStrategyMonitor.SoundAlert.SOUND_ALERT_UNDEFINED;
    private ObjectProperty<MxNode> operate1 = new SimpleObjectProperty();
    private ObjectProperty<MxNode> operate2 = new SimpleObjectProperty();
    public static final String MONITOR_DIREC = "monit_direc";
    public static final String MONITOR_INDICATOR = "monit_indicator";
    public static final String MONIT_OPSTATUS = "monit_opStatus";
    public static final String STATUS = "accnt_status";
    public static final String STATUS_Q = "1";

    @PostConstruct
    public void init() {
        MxNode node = MxNodeFactory.create((String)STATUS, (String)STATUS_Q);
        this.setStatus(node);
        node = MxNodeFactory.create((String)MONITOR_DIREC, (String)"");
        this.setDirection(node);
        node = MxNodeFactory.create((String)MONITOR_INDICATOR, (String)"");
        this.setIndicator(node);
        node = MxNodeFactory.create((String)MONIT_OPSTATUS, (String)"");
        this.setOperate1(node);
        node = MxNodeFactory.create((String)MONIT_OPSTATUS, (String)"");
        this.setOperate2(node);
    }

    public void update(Object obj) {
        if (obj instanceof PStrategyMonitor.Indicator) {
            PStrategyMonitor.Indicator Indicator2 = (PStrategyMonitor.Indicator)PStrategyMonitor.Indicator.class.cast(obj);
            this.update(Indicator2);
            this.changed();
        } else if (obj instanceof Indicator) {
            Indicator indicator = (Indicator)((Object)Indicator.class.cast(obj));
            this.update(indicator);
            this.changed();
        }
    }

    private void update(PStrategyMonitor.Indicator indicator) {
        this.getStatus().setRaw(Integer.toString(indicator.getStatus()));
        this.getIndicator().setRaw(String.valueOf(indicator.getIndicatorValue()));
        this.getDirection().setRaw(String.valueOf(indicator.getDirectionValue()));
        if (StringUtils.belongto((String)this.getIndicator().getRaw(), (String[])new String[]{STATUS_Q, "2"})) {
            this.setRealtimeValue(indicator.getRealTimeValue() / 60.0);
        } else {
            this.setRealtimeValue(indicator.getRealTimeValue());
        }
        if (indicator.getGearList().size() >= 1) {
            this.setSet1(true);
            this.setValue1(((PStrategyMonitor.Gear)indicator.getGearList().get(0)).getValue());
            this.setColor1(((PStrategyMonitor.Gear)indicator.getGearList().get(0)).getColorAlert());
            this.setSound1(((PStrategyMonitor.Gear)indicator.getGearList().get(0)).getSoundAlert());
            this.getOperate1().setRaw(String.valueOf(((PStrategyMonitor.Gear)indicator.getGearList().get(0)).getOpStatusValue()));
        }
        if (indicator.getGearList().size() >= 2) {
            this.setSet2(true);
            this.setValue2(((PStrategyMonitor.Gear)indicator.getGearList().get(1)).getValue());
            this.setColor2(((PStrategyMonitor.Gear)indicator.getGearList().get(1)).getColorAlert());
            this.setSound2(((PStrategyMonitor.Gear)indicator.getGearList().get(1)).getSoundAlert());
            this.getOperate2().setRaw(String.valueOf(((PStrategyMonitor.Gear)indicator.getGearList().get(1)).getOpStatusValue()));
        }
        if (indicator.getIndicator() == PStrategyMonitor.MonitorIndicator.QUOTE_TIME_IN_DAY || indicator.getIndicator() == PStrategyMonitor.MonitorIndicator.CONSECUTIVE_BIDDING_TIME || indicator.getIndicator() == PStrategyMonitor.MonitorIndicator.NO_OFFER_UNILATERAL_WIDTH || indicator.getIndicator() == PStrategyMonitor.MonitorIndicator.PRICE_GAP_WIDTH) {
            this.setValue1(this.getValue1() / 60.0);
            this.setValue2(this.getValue2() / 60.0);
        }
        this.setRealtimeColorSound();
    }

    private void setRealtimeColorSound() {
        switch (this.getDirection().getValue()) {
            case ">": {
                if (this.isSet1() && this.getRealtimeValue() > this.getValue1()) {
                    this.setRealtimeColor(this.getColor1());
                    this.setRealtimeSound(this.getSound1());
                }
                if (!this.isSet2() || !(this.getRealtimeValue() > this.getValue2())) break;
                this.setRealtimeColor(this.getColor2());
                this.setRealtimeSound(this.getSound2());
                break;
            }
            case "\u2265": {
                if (this.isSet1() && this.getRealtimeValue() >= this.getValue1()) {
                    this.setRealtimeColor(this.getColor1());
                    this.setRealtimeSound(this.getSound1());
                }
                if (!this.isSet2() || !(this.getRealtimeValue() >= this.getValue2())) break;
                this.setRealtimeColor(this.getColor2());
                this.setRealtimeSound(this.getSound2());
                break;
            }
            case "<": {
                if (this.isSet1() && this.getRealtimeValue() < this.getValue1()) {
                    this.setRealtimeColor(this.getColor1());
                    this.setRealtimeSound(this.getSound1());
                }
                if (!this.isSet2() || !(this.getRealtimeValue() < this.getValue2())) break;
                this.setRealtimeColor(this.getColor2());
                this.setRealtimeSound(this.getSound2());
                break;
            }
            case "\u2264": {
                if (this.isSet1() && this.getRealtimeValue() <= this.getValue1()) {
                    this.setRealtimeColor(this.getColor1());
                    this.setRealtimeSound(this.getSound1());
                }
                if (!this.isSet2() || !(this.getRealtimeValue() <= this.getValue2())) break;
                this.setRealtimeColor(this.getColor2());
                this.setRealtimeSound(this.getSound2());
            }
        }
    }

    private void update(Indicator indicator) {
        this.setValue1(indicator.getValue1());
        this.setValue2(indicator.getValue2());
        this.setColor1(indicator.getColor1());
        this.setColor2(indicator.getColor2());
        this.setOperate1(indicator.getOperate1());
        this.setOperate2(indicator.getOperate2());
        this.setRealtimeValue(indicator.getRealtimeValue());
        this.setDirection(indicator.getDirection());
        this.setIndicator(indicator.getIndicator());
        this.setSet1(indicator.isSet1());
        this.setSet2(indicator.isSet2());
        this.setRealtimeColor(indicator.getRealtimeColor());
        this.setRealtimeSound(indicator.getRealtimeSound());
    }

    public PStrategyMonitor.SoundAlert getRealtimeSound() {
        return this.realtimeSound;
    }

    public void setRealtimeSound(PStrategyMonitor.SoundAlert realtimeSound) {
        this.realtimeSound = realtimeSound;
    }

    public boolean isSet1() {
        return this.set1;
    }

    public void setSet1(boolean set1) {
        this.set1 = set1;
    }

    public boolean isSet2() {
        return this.set2;
    }

    public void setSet2(boolean set2) {
        this.set2 = set2;
    }

    public PStrategyMonitor.Color getRealtimeColor() {
        return this.realtimeColor;
    }

    public void setRealtimeColor(PStrategyMonitor.Color realtimeColor) {
        this.realtimeColor = realtimeColor;
    }

    public PStrategyMonitor.SoundAlert getSound1() {
        return this.sound1;
    }

    public void setSound1(PStrategyMonitor.SoundAlert sound1) {
        this.sound1 = sound1;
    }

    public PStrategyMonitor.SoundAlert getSound2() {
        return this.sound2;
    }

    public void setSound2(PStrategyMonitor.SoundAlert sound2) {
        this.sound2 = sound2;
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final ObjectProperty<MxNode> directionProperty() {
        return this.direction;
    }

    public final MxNode getDirection() {
        return (MxNode)this.directionProperty().get();
    }

    public final void setDirection(MxNode direction) {
        this.directionProperty().set((Object)direction);
    }

    public final ObjectProperty<MxNode> indicatorProperty() {
        return this.indicator;
    }

    public final MxNode getIndicator() {
        return (MxNode)this.indicatorProperty().get();
    }

    public final void setIndicator(MxNode indicator) {
        this.indicatorProperty().set((Object)indicator);
    }

    public final DoubleProperty realtimeValueProperty() {
        return this.realtimeValue;
    }

    public final double getRealtimeValue() {
        return this.realtimeValueProperty().get();
    }

    public final void setRealtimeValue(double realtimeValue) {
        this.realtimeValueProperty().set(realtimeValue);
    }

    public final DoubleProperty value1Property() {
        return this.value1;
    }

    public final double getValue1() {
        return this.value1Property().get();
    }

    public final void setValue1(double value1) {
        this.value1Property().set(value1);
    }

    public final DoubleProperty value2Property() {
        return this.value2;
    }

    public final double getValue2() {
        return this.value2Property().get();
    }

    public final void setValue2(double value2) {
        this.value2Property().set(value2);
    }

    public PStrategyMonitor.Color getColor1() {
        return this.color1;
    }

    public void setColor1(PStrategyMonitor.Color color1) {
        this.color1 = color1;
    }

    public PStrategyMonitor.Color getColor2() {
        return this.color2;
    }

    public void setColor2(PStrategyMonitor.Color color2) {
        this.color2 = color2;
    }

    public final ObjectProperty<MxNode> operate1Property() {
        return this.operate1;
    }

    public final MxNode getOperate1() {
        return (MxNode)this.operate1Property().get();
    }

    public final void setOperate1(MxNode operate1) {
        this.operate1Property().set((Object)operate1);
    }

    public final ObjectProperty<MxNode> operate2Property() {
        return this.operate2;
    }

    public final MxNode getOperate2() {
        return (MxNode)this.operate2Property().get();
    }

    public final void setOperate2(MxNode operate2) {
        this.operate2Property().set((Object)operate2);
    }
}

