/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.api.trade.info.IHisQueryPageInfo;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.http.api.Page;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.javafx.utils.FxUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;

public class HisQueryPage<T>
extends MxChgObj
implements IHisQueryPageInfo<T> {
    private StringProperty beginDate = new SimpleStringProperty("");
    private StringProperty endDate = new SimpleStringProperty("");
    private ListProperty<String> extAccntIdList = new SimpleListProperty(FxUtils.newList());
    private ListProperty<String> newAccntIdList = new SimpleListProperty(FxUtils.newList());
    private List<String> subAccntIdList = new LinkedList<String>();
    private List<String> assetGrpIdList = new LinkedList<String>();
    private List<String> assetsGrpIdList = new LinkedList<String>();
    private List<String> accountIdList = new LinkedList<String>();
    private List<String> portfolioIdList = new LinkedList<String>();
    private List<String> productIdList = new LinkedList<String>();
    private List<Integer> tradeTypeList = new LinkedList<Integer>();
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty referenceId = new SimpleStringProperty("");
    private StringProperty marketGrp = new SimpleStringProperty("");
    private StringProperty id = new SimpleStringProperty("");
    private ObjectProperty<T> query = new SimpleObjectProperty();
    private StringProperty dimension = new SimpleStringProperty("");
    private IntegerProperty currentPage = new SimpleIntegerProperty(0);
    private IntegerProperty pageSize = new SimpleIntegerProperty(100);
    private IntegerProperty pageCount = new SimpleIntegerProperty(1);
    private IntegerProperty totalCount = new SimpleIntegerProperty(0);
    private IntegerProperty start = new SimpleIntegerProperty(1);
    private IntegerProperty end = new SimpleIntegerProperty(0);
    private IntegerProperty mod = new SimpleIntegerProperty(100);
    private ObservableList<T> dataList = FxUtils.newList();
    private ObservableList<T> detailList = FxUtils.newList();
    private Map<Integer, List<T>> mapAcc = new HashMap<Integer, List<T>>();
    private Map<Integer, List<T>> mapPort = new HashMap<Integer, List<T>>();
    private Map<T, List<T>> mapDetailList = new HashMap<T, List<T>>();
    private StringProperty positionType = new SimpleStringProperty("");
    private int defaultQuerySize = 150;
    private boolean protect = true;
    private boolean inverval;
    public boolean isSum = false;
    public boolean containsClose = true;
    private String newCashAccntId = "";

    public boolean isSum() {
        return this.isSum;
    }

    public void setSum(boolean isSum) {
        this.isSum = isSum;
    }

    public HisQueryPage() {
        this.currentPage.addListener(ob -> this.updateData());
        this.pageSize.addListener(ob -> {
            this.compPageCount();
            this.clear();
            this.query();
        });
    }

    public void clear() {
        this.protect = false;
        this.mapAcc.clear();
        this.mapPort.clear();
        this.getMapDetailList().clear();
        this.dataList.clear();
        this.currentPage.set(0);
        this.protect = true;
    }

    private void updateData() {
        this.query();
    }

    public void updateData(List<T> list) {
        if (list != null && list.size() > 0) {
            this.getMap().put(this.currentPage.get(), list);
        }
        this.protect = false;
        this.compPageCount();
        this.protect = true;
        this.dataList.setAll(list);
    }

    public void updateDetail(List<T> list) {
        if (list != null && list.size() > 0) {
            this.getMapDetailList().put(this.query.get(), list);
        }
        this.protect = false;
        this.compPageCount();
        this.protect = true;
        this.detailList.setAll(list);
    }

    private Map<Integer, List<T>> getMap() {
        return this.getDimension().equals("1") ? this.mapAcc : this.mapPort;
    }

    private void compPageCount() {
        int tatol = this.totalCount.get();
        if (tatol == 0) {
            this.pageCount.set(1);
            return;
        }
        int size = this.pageSize.get();
        int page = size == 0 ? 0 : tatol / size;
        int remainder = tatol % this.pageSize.get();
        page = remainder == 0 ? page : ++page;
        this.pageCount.set(page);
    }

    public ObservableList<T> getDataList() {
        return this.dataList;
    }

    public void query() {
        if (this.protect) {
            this.changed();
        }
    }

    public void initParam() {
        int size = this.pageSize.get();
        int start = size * this.currentPage.get() + 1;
        int end = start + size;
        this.setStart(start);
        this.setEnd(end);
        this.setMod(size);
    }

    public void updatePage(PBase.Page.Builder builder) {
        int start = this.getStart();
        int size = this.getPageSize();
        int mod = this.getMod();
        if (mod < this.defaultQuerySize) {
            size = mod;
        }
        if (mod > this.defaultQuerySize) {
            size = this.defaultQuerySize;
        }
        builder.setStartRow(start);
        builder.setPageSize(size);
        this.setMod(mod - size);
        this.setStart(start + size);
    }

    public void updatePage(Page builder) {
        int start = this.getStart();
        int size = this.getPageSize();
        int mod = this.getMod();
        if (mod < this.defaultQuerySize) {
            size = mod;
        }
        if (mod > this.defaultQuerySize) {
            size = this.defaultQuerySize;
        }
        builder.setStartRow(start);
        builder.setPageSize(size);
        this.setMod(mod - size);
        this.setStart(start + size);
    }

    public void updatePage(Fragment fragment) {
        int start = this.getStart();
        int size = this.getPageSize();
        int mod = this.getMod();
        if (mod < this.defaultQuerySize) {
            size = mod;
        }
        if (mod > this.defaultQuerySize) {
            size = this.defaultQuerySize;
        }
        fragment.setOffset(start);
        fragment.setSize(size);
        this.setMod(mod - size);
        this.setStart(start + size);
    }

    public void setDefaultQuerySize(int defaultSize) {
        if (defaultSize > 0) {
            this.defaultQuerySize = defaultSize;
        }
    }

    public void updatePager(PBase.Pager.Builder builder) {
        int start = this.getStart();
        int size = this.getPageSize();
        int mod = this.getMod();
        if (mod < this.defaultQuerySize) {
            size = mod;
        }
        if (mod > this.defaultQuerySize) {
            size = this.defaultQuerySize;
        }
        builder.setPageSize(size);
        builder.setStartRow(start);
        builder.setNextId("0");
        this.setMod(mod - size);
        this.setStart(start + size);
    }

    public boolean hasNext(int total) {
        this.setTotalCount(total);
        if (this.getEnd() > total) {
            return this.getStart() <= total;
        }
        return this.getStart() < this.getEnd();
    }

    public ObservableList<T> getDetailList() {
        return this.detailList;
    }

    public void setDetailList(ObservableList<T> detailList) {
        this.detailList = detailList;
    }

    public IntegerProperty currentPageProperty() {
        return this.currentPage;
    }

    public Integer getCurrentPage() {
        return this.currentPageProperty().get();
    }

    public void setCurrentPage(Integer currentPage) {
        int max = this.getPageCount() - 1;
        int page = currentPage;
        if (page > max) {
            page = max;
        } else if (currentPage < 0) {
            page = 0;
        }
        this.currentPageProperty().set(page);
    }

    public ListProperty<String> extAccntIdListProperty() {
        return this.extAccntIdList;
    }

    public List<String> getExtAccntIdList() {
        return (List)this.extAccntIdListProperty().get();
    }

    public void setExtAccntIdList(List<String> extAccntIdList) {
        this.extAccntIdListProperty().setAll(extAccntIdList);
    }

    public IntegerProperty pageSizeProperty() {
        return this.pageSize;
    }

    public Integer getPageSize() {
        return this.pageSizeProperty().get();
    }

    public void setPageSize(Integer pageSize) {
        this.pageSizeProperty().set(pageSize.intValue());
    }

    public IntegerProperty totalCountProperty() {
        return this.totalCount;
    }

    public Integer getTotalCount() {
        return this.totalCountProperty().get();
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCountProperty().set(totalCount.intValue());
    }

    public StringProperty beginDateProperty() {
        return this.beginDate;
    }

    public String getBeginDate() {
        return (String)this.beginDateProperty().get();
    }

    public void setBeginDate(String beginDate) {
        this.beginDateProperty().set((Object)beginDate);
    }

    public StringProperty securityIdProperty() {
        return this.securityId;
    }

    public String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public StringProperty endDateProperty() {
        return this.endDate;
    }

    public String getEndDate() {
        return (String)this.endDateProperty().get();
    }

    public void setEndDate(String endDate) {
        this.endDateProperty().set((Object)endDate);
    }

    public StringProperty marketGrpProperty() {
        return this.marketGrp;
    }

    public String getMarketGrp() {
        return (String)this.marketGrpProperty().get();
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGrpProperty().set((Object)marketGrp);
    }

    public final IntegerProperty pageCountProperty() {
        return this.pageCount;
    }

    public final int getPageCount() {
        return this.pageCountProperty().get();
    }

    public final void setPageCount(int pageCount) {
        this.pageCountProperty().set(pageCount);
    }

    public final StringProperty dimensionProperty() {
        return this.dimension;
    }

    public final String getDimension() {
        return (String)this.dimensionProperty().get();
    }

    public final void setDimension(String dimension) {
        this.dimensionProperty().set((Object)dimension);
    }

    public final IntegerProperty startProperty() {
        return this.start;
    }

    public final int getStart() {
        return this.startProperty().get();
    }

    public final void setStart(int start) {
        this.startProperty().set(start);
    }

    public final IntegerProperty endProperty() {
        return this.end;
    }

    public final int getEnd() {
        return this.endProperty().get();
    }

    public final void setEnd(int end) {
        this.endProperty().set(end);
    }

    public final IntegerProperty modProperty() {
        return this.mod;
    }

    public final int getMod() {
        return this.modProperty().get();
    }

    public final void setMod(int mod) {
        this.modProperty().set(mod);
    }

    public List<String> getSubAccntIdList() {
        return this.subAccntIdList;
    }

    public void setSubAccntIdList(List<String> subAccntIdList) {
        this.subAccntIdList = subAccntIdList;
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final String getId() {
        return (String)this.idProperty().get();
    }

    public final void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public Map<T, List<T>> getMapDetailList() {
        return this.mapDetailList;
    }

    public void setMapDetailList(Map<T, List<T>> mapDetailList) {
        this.mapDetailList = mapDetailList;
    }

    public ObjectProperty<T> queryProperty() {
        return this.query;
    }

    public T getQuery() {
        return (T)this.queryProperty().get();
    }

    public void setQuery(T query) {
        this.queryProperty().set(query);
    }

    public List<String> getAccountIdList() {
        return this.accountIdList;
    }

    public void setAccountIdList(List<String> accountIdList) {
        this.accountIdList = accountIdList;
    }

    public List<String> getPortfolioIdList() {
        return this.portfolioIdList;
    }

    public void setPortfolioIdList(List<String> portfolioIdList) {
        this.portfolioIdList = portfolioIdList;
    }

    public final StringProperty referenceIdProperty() {
        return this.referenceId;
    }

    public final String getReferenceId() {
        return (String)this.referenceIdProperty().get();
    }

    public final void setReferenceId(String referenceId) {
        this.referenceIdProperty().set((Object)referenceId);
    }

    public List<Integer> getTradeTypeList() {
        return this.tradeTypeList;
    }

    public void setTradeTypeList(List<Integer> tradeTypeList) {
        this.tradeTypeList = tradeTypeList;
    }

    public final StringProperty positionTypeProperty() {
        return this.positionType;
    }

    public final String getPositionType() {
        return (String)this.positionTypeProperty().get();
    }

    public final void setPositionType(String positionType) {
        this.positionTypeProperty().set((Object)positionType);
    }

    public List<String> getProductIdList() {
        return this.productIdList;
    }

    public void setProductIdList(List<String> productIdList) {
        this.productIdList = productIdList;
    }

    public boolean isInverval() {
        return this.inverval;
    }

    public void setInverval(boolean inverval) {
        this.inverval = inverval;
    }

    public boolean isContainsClose() {
        return this.containsClose;
    }

    public void setContainsClose(boolean containsClose) {
        this.containsClose = containsClose;
    }

    public List<String> getAssetGrpIdList() {
        return this.assetGrpIdList;
    }

    public void setAssetGrpIdList(List<String> assetGrpIdList) {
        this.assetGrpIdList = assetGrpIdList;
    }

    public List<String> getAssetsGrpIdList() {
        return this.assetsGrpIdList;
    }

    public void setAssetsGrpIdList(List<String> assetsGrpIdList) {
        this.assetsGrpIdList = assetsGrpIdList;
    }

    public String getNewCashAccntId() {
        return this.newCashAccntId;
    }

    public void setNewCashAccntId(String newCashAccntId) {
        this.newCashAccntId = newCashAccntId;
    }

    public final ListProperty<String> newAccntIdListProperty() {
        return this.newAccntIdList;
    }

    public final List<String> getNewAccntIdList() {
        return (List)this.newAccntIdListProperty().get();
    }

    public final void setNewAccntIdList(List<String> newAccntIdList) {
        this.newAccntIdListProperty().setAll(newAccntIdList);
    }
}

