/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.proto.strategy.PHedge;
import cms.tmx.http.api.strategy.dto.HedgeTaskInfo;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import com.google.protobuf.InvalidProtocolBufferException;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class HedgeTask
extends MxSelObj {
    private StringProperty taskId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> strategyType = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty strategyName = new SimpleStringProperty("");
    private ObjectProperty<MxNode> hedgeStatus = new SimpleObjectProperty((Object)new MxNode());
    private DoubleProperty hedgePrice = new SimpleDoubleProperty();
    private ObjectProperty<MxNode> hedgeType = new SimpleObjectProperty((Object)new MxNode());
    private IntegerProperty hedgeQty = new SimpleIntegerProperty();
    private IntegerProperty leavesQty = new SimpleIntegerProperty();
    private DoubleProperty origPrice = new SimpleDoubleProperty();
    private StringProperty text = new SimpleStringProperty("");
    private StringProperty execId = new SimpleStringProperty("");
    private StringProperty code = new SimpleStringProperty("");
    private ObjectProperty<MxNode> hedgeOrdSide = new SimpleObjectProperty((Object)new MxNode());
    private ObjectProperty<MxNode> positionEffect = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty extFundAccntId = new SimpleStringProperty("");
    private StringProperty extSecAccntId = new SimpleStringProperty("");
    private IntegerProperty timeoutFill = new SimpleIntegerProperty();
    private DoubleProperty stoplossFill = new SimpleDoubleProperty();
    private StringProperty hedgePriceCustom = new SimpleStringProperty("");
    private StringProperty parentId = new SimpleStringProperty("");
    private StringProperty hostCrossId = new SimpleStringProperty("");

    public HedgeTask() {
        MxNode node = new MxNode().load("status_hedge", "");
        this.setHedgeStatus(node);
        node = new MxNode().load("xbond_hedge_type", "");
        this.setHedgeType(node);
        node = new MxNode().load("future_strategy_type", "");
        this.setStrategyType(node);
        node = new MxNode().load("position_effect", "");
        this.setPositionEffect(node);
        node = new MxNode().load("xbond_side", "");
        this.setHedgeOrdSide(node);
    }

    public void update(Object obj) {
        if (obj instanceof PHedge.HedgeTaskInfo) {
            PHedge.HedgeTaskInfo en = (PHedge.HedgeTaskInfo)PHedge.HedgeTaskInfo.class.cast(obj);
            try {
                this.update(en);
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        } else if (obj instanceof HedgeTask) {
            HedgeTask en = (HedgeTask)((Object)HedgeTask.class.cast(obj));
            this.update(en);
        } else if (obj instanceof HedgeTaskInfo) {
            this.update((HedgeTaskInfo)HedgeTaskInfo.class.cast(obj));
        }
    }

    private void update(HedgeTask task) {
        this.setExecId(task.getExecId());
        this.setExtFundAccntId(task.getExtFundAccntId());
        this.setExtSecAccntId(task.getExtSecAccntId());
        this.setHedgePrice(task.getHedgePrice());
        this.setHedgeQty(task.getHedgeQty());
        this.setLeavesQty(task.getLeavesQty());
        this.setOrigPrice(task.getOrigPrice());
        this.setStrategyName(task.getStrategyName());
        this.setTaskId(task.getTaskId());
        this.setText(task.getText());
        this.setCode(task.getCode());
        this.setTimeoutFill(task.getTimeoutFill());
        this.setStoplossFill(task.getStoplossFill());
        this.setHedgePriceCustom(task.getHedgePriceCustom());
        this.setParentId(task.getParentId());
        this.setHostCrossId(task.getHostCrossId());
        this.setStrategyType(task.getStrategyType());
        this.setHedgeOrdSide(task.getHedgeOrdSide());
        this.setHedgeStatus(task.getHedgeStatus());
        this.setHedgeType(task.getHedgeType());
        this.setPositionEffect(task.getPositionEffect());
    }

    private void update(PHedge.HedgeTaskInfo f) throws InvalidProtocolBufferException {
        this.setExecId(f.getExecId());
        this.setExtFundAccntId(f.getExtFundAccntId());
        this.setExtSecAccntId(f.getExtSecAccntId());
        this.getHedgeOrdSide().setRaw(String.valueOf(f.getHedgeOrdSideValue()));
        this.setHedgePrice((double)Math.round(f.getHedgePrice() * 1000.0) / 1000.0);
        this.setHedgeQty(f.getHedgeQty());
        this.getHedgeStatus().setRaw(String.valueOf(f.getHedgeStatusValue()));
        this.setLeavesQty(f.getLeavesQty());
        this.setOrigPrice((double)Math.round(f.getOrigPrice() * 1000.0) / 1000.0);
        this.getPositionEffect().setRaw(String.valueOf(f.getPositionEffectValue()));
        this.setStrategyName(f.getStrategyName());
        this.getStrategyType().setRaw(String.valueOf(f.getStrategyTypeValue()));
        this.setTaskId(f.getTaskId());
        this.setText(f.getText());
        this.setCode(f.getInstrument().getSecurityId());
        this.setTimeoutFill(f.getTimeoutFill());
        this.setStoplossFill(f.getStoplossFill());
        this.setHedgePriceCustom(f.getHedgePriceCustom());
        this.setParentId(f.getParentId());
        this.setHostCrossId(f.getHostCrossId());
    }

    private void update(HedgeTaskInfo task) {
        this.setExecId(task.getExecId());
        this.setExtFundAccntId(task.getAccount().getExtFundAccntId());
        this.setExtSecAccntId(task.getAccount().getExtSecAccntId());
        this.getHedgeOrdSide().setRaw(task.getDetails().getHedgeOrdSide().getValue());
        this.setHedgePrice((double)Math.round(task.getDetails().getHedgePrice() * 1000.0) / 1000.0);
        this.setHedgeQty(task.getDetails().getHedgeQty());
        this.getHedgeStatus().setRaw(String.valueOf(task.getHedgeStatus().getValue()));
        this.getHedgeType().setRaw(String.valueOf(task.getHedgeType()));
        this.setLeavesQty(task.getDetails().getLeavesQty());
        this.setOrigPrice((double)Math.round(task.getDetails().getOrigPrice() * 1000.0) / 1000.0);
        if (task.getDetails().getPositionEffect() != null) {
            this.getPositionEffect().setRaw(String.valueOf(task.getDetails().getPositionEffect().getValue()));
        }
        if (task.getOrigAlgoName() != null) {
            this.setStrategyName(task.getOrigAlgoName());
        }
        this.getStrategyType().setRaw(String.valueOf(task.getHedgeType()));
        this.setTaskId(task.getTaskId());
        this.setText(task.getText());
        this.setCode(task.getInstrument().getSecurityId());
        this.setTimeoutFill(task.getDetails().getTimeoutFill() / 1000);
        this.setStoplossFill(task.getDetails().getStoplossFill() * 100.0);
        this.setHedgePriceCustom(task.getDetails().getHedgePriceCustom());
        this.setParentId(task.getDetails().getParentId());
        this.setHostCrossId(task.getDetails().getHostCrossId());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.taskId == null ? 0 : ((String)this.taskId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HedgeTask other = (HedgeTask)((Object)obj);
        return !(this.taskId == null ? other.taskId != null : !((String)this.taskId.get()).equals(other.taskId.get()));
    }

    public final StringProperty taskIdProperty() {
        return this.taskId;
    }

    public final String getTaskId() {
        return (String)this.taskIdProperty().get();
    }

    public final void setTaskId(String taskId) {
        this.taskIdProperty().set((Object)taskId);
    }

    public final ObjectProperty<MxNode> strategyTypeProperty() {
        return this.strategyType;
    }

    public final MxNode getStrategyType() {
        return (MxNode)this.strategyTypeProperty().get();
    }

    public final void setStrategyType(MxNode strategyType) {
        this.strategyTypeProperty().set((Object)strategyType);
    }

    public final StringProperty strategyNameProperty() {
        return this.strategyName;
    }

    public final String getStrategyName() {
        return (String)this.strategyNameProperty().get();
    }

    public final void setStrategyName(String strategyName) {
        this.strategyNameProperty().set((Object)strategyName);
    }

    public final ObjectProperty<MxNode> hedgeStatusProperty() {
        return this.hedgeStatus;
    }

    public final MxNode getHedgeStatus() {
        return (MxNode)this.hedgeStatusProperty().get();
    }

    public final void setHedgeStatus(MxNode hedgeStatus) {
        this.hedgeStatusProperty().set((Object)hedgeStatus);
    }

    public final DoubleProperty hedgePriceProperty() {
        return this.hedgePrice;
    }

    public final double getHedgePrice() {
        return this.hedgePriceProperty().get();
    }

    public final void setHedgePrice(double hedgePrice) {
        this.hedgePriceProperty().set(hedgePrice);
    }

    public final IntegerProperty hedgeQtyProperty() {
        return this.hedgeQty;
    }

    public final int getHedgeQty() {
        return this.hedgeQtyProperty().get();
    }

    public final void setHedgeQty(int hedgeQty) {
        this.hedgeQtyProperty().set(hedgeQty);
    }

    public final IntegerProperty leavesQtyProperty() {
        return this.leavesQty;
    }

    public final int getLeavesQty() {
        return this.leavesQtyProperty().get();
    }

    public final void setLeavesQty(int leavesQty) {
        this.leavesQtyProperty().set(leavesQty);
    }

    public final DoubleProperty origPriceProperty() {
        return this.origPrice;
    }

    public final double getOrigPrice() {
        return this.origPriceProperty().get();
    }

    public final void setOrigPrice(double origPrice) {
        this.origPriceProperty().set(origPrice);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final String getText() {
        return (String)this.textProperty().get();
    }

    public final void setText(String text) {
        this.textProperty().set((Object)text);
    }

    public final StringProperty execIdProperty() {
        return this.execId;
    }

    public final String getExecId() {
        return (String)this.execIdProperty().get();
    }

    public final void setExecId(String execId) {
        this.execIdProperty().set((Object)execId);
    }

    public final ObjectProperty<MxNode> hedgeOrdSideProperty() {
        return this.hedgeOrdSide;
    }

    public final MxNode getHedgeOrdSide() {
        return (MxNode)this.hedgeOrdSideProperty().get();
    }

    public final void setHedgeOrdSide(MxNode hedgeOrdSide) {
        this.hedgeOrdSideProperty().set((Object)hedgeOrdSide);
    }

    public final ObjectProperty<MxNode> positionEffectProperty() {
        return this.positionEffect;
    }

    public final MxNode getPositionEffect() {
        return (MxNode)this.positionEffectProperty().get();
    }

    public final void setPositionEffect(MxNode positionEffect) {
        this.positionEffectProperty().set((Object)positionEffect);
    }

    public final StringProperty extFundAccntIdProperty() {
        return this.extFundAccntId;
    }

    public final String getExtFundAccntId() {
        return (String)this.extFundAccntIdProperty().get();
    }

    public final void setExtFundAccntId(String extFundAccntId) {
        this.extFundAccntIdProperty().set((Object)extFundAccntId);
    }

    public final StringProperty extSecAccntIdProperty() {
        return this.extSecAccntId;
    }

    public final String getExtSecAccntId() {
        return (String)this.extSecAccntIdProperty().get();
    }

    public final void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntIdProperty().set((Object)extSecAccntId);
    }

    public final StringProperty codeProperty() {
        return this.code;
    }

    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public final IntegerProperty timeoutFillProperty() {
        return this.timeoutFill;
    }

    public final int getTimeoutFill() {
        return this.timeoutFillProperty().get();
    }

    public final void setTimeoutFill(int timeoutFill) {
        this.timeoutFillProperty().set(timeoutFill);
    }

    public final DoubleProperty stoplossFillProperty() {
        return this.stoplossFill;
    }

    public final double getStoplossFill() {
        return this.stoplossFillProperty().get();
    }

    public final void setStoplossFill(double stoplossFill) {
        this.stoplossFillProperty().set(stoplossFill);
    }

    public final StringProperty hedgePriceCustomProperty() {
        return this.hedgePriceCustom;
    }

    public final String getHedgePriceCustom() {
        return (String)this.hedgePriceCustomProperty().get();
    }

    public final void setHedgePriceCustom(String hedgePriceCustom) {
        this.hedgePriceCustomProperty().set((Object)hedgePriceCustom);
    }

    public final StringProperty parentIdProperty() {
        return this.parentId;
    }

    public final String getParentId() {
        return (String)this.parentIdProperty().get();
    }

    public final void setParentId(String parentId) {
        this.parentIdProperty().set((Object)parentId);
    }

    public final StringProperty hostCrossIdProperty() {
        return this.hostCrossId;
    }

    public final String getHostCrossId() {
        return (String)this.hostCrossIdProperty().get();
    }

    public final void setHostCrossId(String hostCrossId) {
        this.hostCrossIdProperty().set((Object)hostCrossId);
    }

    public final ObjectProperty<MxNode> hedgeTypeProperty() {
        return this.hedgeType;
    }

    public final MxNode getHedgeType() {
        return (MxNode)this.hedgeTypeProperty().get();
    }

    public final void setHedgeType(MxNode hedgeType) {
        this.hedgeTypeProperty().set((Object)hedgeType);
    }
}

