/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.proto.strategy.PMarketMaking;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;
import java.math.BigDecimal;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureStrategy
extends MxSelObj
implements Serializable {
    private static final long serialVersionUID = -5343627064063654418L;
    private static final Logger logger = LogManager.getLogger(FutureStrategy.class);
    StringProperty name = new SimpleStringProperty("");
    StringProperty contextId = new SimpleStringProperty("");
    String userId = new String("");
    String partyId = new String("");
    String createTime = new String("");
    ObjectProperty<MxNode> status = new SimpleObjectProperty((Object)new MxNode());
    StringProperty errorMsg = new SimpleStringProperty("");
    String postId = new String("");
    String extFundAccntId = new String("");
    String extSecAccntId = new String("");
    StringProperty investorId = new SimpleStringProperty("");
    StringProperty investorSecId = new SimpleStringProperty("");
    String market = new String("");
    StringProperty security = new SimpleStringProperty("");
    String securityType = new String("");
    String refPriceCustom = new String("");
    double priceSlip;
    double hedgeSlip;
    DoubleProperty basePrice = new SimpleDoubleProperty();
    String basePriceType = new String("");
    DoubleProperty baseSpread = new SimpleDoubleProperty();
    DoubleProperty spreadSum = new SimpleDoubleProperty();
    DoubleProperty bidSpread = new SimpleDoubleProperty();
    DoubleProperty askSpread = new SimpleDoubleProperty();
    IntegerProperty bidQty = new SimpleIntegerProperty();
    IntegerProperty askQty = new SimpleIntegerProperty();
    IntegerProperty dealLimit = new SimpleIntegerProperty();
    StringProperty hedgeContract = new SimpleStringProperty("");
    String hedgePriceCustomSell = new String("");
    String hedgePriceCustomBuy = new String("");
    String priceBuyType = new String("");
    String priceSellType = new String("");
    DoubleProperty hedgeSpreadBuy = new SimpleDoubleProperty();
    DoubleProperty hedgeSpreadSell = new SimpleDoubleProperty();
    int marketMakingCount;
    int hedgeCount;
    ObjectProperty<MxNode> tacticsType = new SimpleObjectProperty((Object)new MxNode());
    String shFlag = new String("");
    String ocFlag = new String("");
    boolean buy = true;
    boolean split = false;
    int totalQty = 0;
    public BooleanProperty showUpdateBtn = new SimpleBooleanProperty(false);
    int timeoutFill;
    double stoplossFill;
    DoubleProperty filledQty = new SimpleDoubleProperty();
    boolean inExe = false;
    int index;
    public BooleanProperty parentContext = new SimpleBooleanProperty(false);
    StringProperty parentContextId = new SimpleStringProperty("");

    public String toString() {
        return this.getContextId();
    }

    public FutureStrategy() {
        MxNode node = new MxNode().load("status_strategy", "");
        this.setStatus(node);
        node = new MxNode().load("future_strategy_type", "");
        this.setTacticsType(node);
        this.index = 999;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.contextId == null ? 0 : ((String)this.contextId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FutureStrategy other = (FutureStrategy)obj;
        return !(this.contextId == null ? other.contextId != null : !((String)this.contextId.get()).equals(other.contextId.get()));
    }

    public void update(Object obj) {
        if (obj instanceof PStrategy.ContextSettings) {
            PStrategy.ContextSettings en = (PStrategy.ContextSettings)PStrategy.ContextSettings.class.cast(obj);
            try {
                this.update(en);
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else if (obj instanceof FutureStrategy) {
            FutureStrategy en = (FutureStrategy)FutureStrategy.class.cast(obj);
            this.update(en);
        }
    }

    private void update(FutureStrategy f) {
        this.setName(f.getName());
        this.setContextId(f.getContextId());
        this.setUserId(f.getUserId());
        this.setPartyId(f.getPartyId());
        this.setCreateTime(f.getCreateTime());
        this.setStatus(f.getStatus());
        this.setErrorMsg(f.getErrorMsg());
        this.setPostId(f.getPostId());
        this.setExtFundAccntId(f.getExtFundAccntId());
        this.setExtSecAccntId(f.getExtSecAccntId());
        this.setInvestorId(f.getInvestorId());
        this.setInvestorSecId(f.getInvestorSecId());
        this.setMarket(f.getMarket());
        this.setSecurity(f.getSecurity());
        this.setSecurityType(f.getSecurityType());
        this.setRefPriceCustom(f.getRefPriceCustom());
        this.setPriceSlip(f.getPriceSlip());
        this.setBasePriceType(f.getBasePriceType());
        this.setBaseSpread(f.getBaseSpread());
        this.setSpreadSum(f.getSpreadSum());
        this.setBidSpread(f.getBidSpread());
        this.setAskSpread(f.getAskSpread());
        this.setBidQty(f.getBidQty());
        this.setAskQty(f.getAskQty());
        this.setDealLimit(f.getDealLimit());
        this.setHedgeContract(f.getHedgeContract());
        this.setHedgePriceCustomSell(f.getHedgePriceCustomSell());
        this.setHedgePriceCustomBuy(f.getHedgePriceCustomBuy());
        this.setPriceBuyType(f.getPriceBuyType());
        this.setPriceSellType(f.getPriceSellType());
        this.setHedgeSpreadBuy(f.getHedgeSpreadBuy());
        this.setHedgeSpreadSell(f.getHedgeSpreadSell());
        this.setMarketMakingCount(f.getMarketMakingCount());
        this.setHedgeCount(f.getHedgeCount());
        this.setTacticsType(f.getTacticsType());
        this.setShFlag(f.getShFlag());
        this.setOcFlag(f.getOcFlag());
        this.setTimeoutFill(f.getTimeoutFill());
        this.setStoplossFill(f.getStoplossFill());
        this.setFilledQty(f.getFilledQty());
        this.setInExe(f.isInExe());
        this.setBasePrice(f.getBasePrice());
        this.setShowUpdateBtn(f.isShowUpdateBtn());
        this.setBuy(f.isBuy());
        this.setTotalQty(f.getTotalQty());
        this.setSplit(f.isSplit());
        this.setHedgeSlip(f.getHedgeSlip());
        this.setParentContext(f.isParentContext());
        this.setParentContextId(f.getParentContextId());
    }

    private void update(PStrategy.ContextSettings s) throws InvalidProtocolBufferException {
        this.setName(s.getName().toStringUtf8());
        this.setContextId(s.getContextId());
        this.setUserId(s.getUserId());
        this.setPartyId(s.getPartyId());
        this.setCreateTime(s.getCreateTime());
        this.getStatus().setRaw(String.valueOf(s.getCtxStateValue()));
        if (this.getStatus().getRaw().equals("2")) {
            this.setShowUpdateBtn(true);
        } else {
            this.setShowUpdateBtn(false);
        }
        if (String.valueOf(s.getStrategyTypeValue()).equals("10")) {
            this.getTacticsType().setRaw("9");
            this.setBuy(false);
        } else {
            this.getTacticsType().setRaw(String.valueOf(s.getStrategyTypeValue()));
        }
        this.setErrorMsg(s.getErrorMsg());
        this.setParentContextId(s.getParentContextId());
        this.setParentContext(s.getIsParentContext());
        this.setInExe(s.getCtxSettingStatusValue() == 1);
        Any any = s.getDetails();
        if (any.is(PMarketMaking.MarketMakingContextSettings.class)) {
            PMarketMaking.MarketMakingContextSettings m = (PMarketMaking.MarketMakingContextSettings)any.unpack(PMarketMaking.MarketMakingContextSettings.class);
            this.setExtFundAccntId(m.getAccount().getExtFundAccntId());
            this.setExtSecAccntId(m.getAccount().getExtSecAccntId());
            this.setMarket(m.getSecurity().getInstrument().getMarket());
            this.setSecurity(m.getSecurity().getInstrument().getSecurityId());
            this.setSecurityType(m.getSecurity().getInstrument().getSecurityType());
            this.setRefPriceCustom(m.getSecurity().getRefPriceCustom());
            this.setPriceSlip(m.getSecurity().getPriceSlip());
            this.setBidSpread(m.getSecurity().getBidSpread());
            this.setAskSpread(m.getSecurity().getAskSpread());
            this.setBidQty(m.getSecurity().getBidQty());
            this.setAskQty(m.getSecurity().getAskQty());
            this.setDealLimit(m.getSecurity().getMaxAllowFilledQty());
            this.setHedgeContract(m.getSecurity().getHedgeContract());
            this.setHedgePriceCustomSell(m.getSecurity().getLongHedgePriceCustom().replaceAll("\\[" + m.getSecurity().getInstrument().getSecurityId() + "\\].LAST_FILL_PRICE", "LFP"));
            this.setHedgePriceCustomBuy(m.getSecurity().getShortHedgePriceCustom().replaceAll("\\[" + m.getSecurity().getInstrument().getSecurityId() + "\\].LAST_FILL_PRICE", "LFP"));
            this.setMarketMakingCount(m.getSecurity().getMmContractQtyScale());
            this.setHedgeCount(m.getSecurity().getHedgeContractQtyScale());
            this.setShFlag(String.valueOf(m.getSecurity().getShFlagValue()));
            this.setOcFlag(String.valueOf(m.getSecurity().getPositionEffectValue()));
            this.setTimeoutFill(m.getSecurity().getTimeoutFill());
            this.setStoplossFill(m.getSecurity().getStoplossFill());
            this.setTotalQty(m.getSecurity().getTotalQty());
            if (this.getTotalQty() > 0) {
                this.setSplit(true);
            }
            this.setFilledQty(m.getSecurity().getMaxHaveFilledQty());
            if (!StringUtils.belongto((String)this.getTacticsType().getRaw(), (String[])new String[]{"6", "9", "10"})) {
                this.setBaseSpread(this.getSpreadByFormula(m.getSecurity().getRefPriceCustom()));
            }
            BigDecimal bigSum = new BigDecimal(this.getBidSpread() + this.getAskSpread());
            double sum = bigSum.setScale(3, 4).doubleValue();
            this.setSpreadSum(sum);
            if (!StringUtils.belongto((String)this.getTacticsType().getRaw(), (String[])new String[]{"6", "9", "10"})) {
                this.setHedgeSpreadBuy(this.getSpreadByFormula(m.getSecurity().getShortHedgePriceCustom()));
                this.setHedgeSpreadSell(this.getSpreadByFormula(m.getSecurity().getLongHedgePriceCustom()));
            }
            this.setBasePriceType(this.parse(m.getSecurity().getRefPriceCustom()));
            if (!StringUtils.belongto((String)this.getTacticsType().getRaw(), (String[])new String[]{"6", "9", "10"})) {
                this.setPriceBuyType(this.parse(this.getHedgePriceCustomBuy()));
                this.setPriceSellType(this.parse(this.getHedgePriceCustomSell()));
            }
        }
        if (String.valueOf(s.getStrategyTypeValue()).equals("11")) {
            this.setHedgeSlip((double)Math.round((this.getHedgeSpreadBuy() + this.getBaseSpread() + this.getAskSpread()) * 1000.0) / 1000.0);
        }
    }

    private String parse(String formula) {
        if (formula.contains("LFP")) {
            return "LFP";
        }
        try {
            int begin = formula.indexOf(46);
            int end = formula.indexOf(43);
            if (end < 0) {
                end = formula.indexOf(45);
            }
            if (end > 0) {
                return formula.substring(begin + 1, end).trim();
            }
            return formula.substring(begin + 1).trim();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return "";
        }
    }

    private double getSpreadByFormula(String formula) {
        int index = formula.indexOf(43);
        boolean negative = false;
        if (index < 0) {
            index = formula.indexOf(45);
            negative = true;
        }
        if (index > 0) {
            if (negative) {
                return -1.0 * Double.valueOf(formula.substring(index + 1).trim().replaceAll(",", ""));
            }
            return Double.valueOf(formula.substring(index + 1).trim().replaceAll(",", ""));
        }
        return 0.0;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getPostId() {
        return this.postId;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public String getExtFundAccntId() {
        return this.extFundAccntId;
    }

    public void setExtFundAccntId(String extFundAccntId) {
        this.extFundAccntId = extFundAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public String getRefPriceCustom() {
        return this.refPriceCustom;
    }

    public void setRefPriceCustom(String refPriceCustom) {
        this.refPriceCustom = refPriceCustom;
    }

    public double getPriceSlip() {
        return this.priceSlip;
    }

    public void setPriceSlip(double priceSlip) {
        this.priceSlip = priceSlip;
    }

    public String getBasePriceType() {
        return this.basePriceType;
    }

    public void setBasePriceType(String basePriceType) {
        this.basePriceType = basePriceType;
    }

    public String getHedgePriceCustomSell() {
        return this.hedgePriceCustomSell;
    }

    public void setHedgePriceCustomSell(String hedgePriceCustomSell) {
        this.hedgePriceCustomSell = hedgePriceCustomSell;
    }

    public String getHedgePriceCustomBuy() {
        return this.hedgePriceCustomBuy;
    }

    public void setHedgePriceCustomBuy(String hedgePriceCustomBuy) {
        this.hedgePriceCustomBuy = hedgePriceCustomBuy;
    }

    public String getPriceBuyType() {
        return this.priceBuyType;
    }

    public void setPriceBuyType(String priceBuyType) {
        this.priceBuyType = priceBuyType;
    }

    public String getPriceSellType() {
        return this.priceSellType;
    }

    public void setPriceSellType(String priceSellType) {
        this.priceSellType = priceSellType;
    }

    public int getMarketMakingCount() {
        return this.marketMakingCount;
    }

    public void setMarketMakingCount(int marketMakingCount) {
        this.marketMakingCount = marketMakingCount;
    }

    public int getHedgeCount() {
        return this.hedgeCount;
    }

    public void setHedgeCount(int hedgeCount) {
        this.hedgeCount = hedgeCount;
    }

    public int getTimeoutFill() {
        return this.timeoutFill;
    }

    public void setTimeoutFill(int timeoutFill) {
        this.timeoutFill = timeoutFill;
    }

    public double getStoplossFill() {
        return this.stoplossFill;
    }

    public void setStoplossFill(double stoplossFill) {
        this.stoplossFill = stoplossFill;
    }

    public boolean isInExe() {
        return this.inExe;
    }

    public void setInExe(boolean inExe) {
        this.inExe = inExe;
    }

    public String getShFlag() {
        return this.shFlag;
    }

    public void setShFlag(String shFlag) {
        this.shFlag = shFlag;
    }

    public String getOcFlag() {
        return this.ocFlag;
    }

    public void setOcFlag(String ocFlag) {
        this.ocFlag = ocFlag;
    }

    public final DoubleProperty basePriceProperty() {
        return this.basePrice;
    }

    public final double getBasePrice() {
        return this.basePriceProperty().get();
    }

    public final void setBasePrice(double basePrice) {
        this.basePriceProperty().set(basePrice);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty contextIdProperty() {
        return this.contextId;
    }

    public final String getContextId() {
        return (String)this.contextIdProperty().get();
    }

    public final void setContextId(String contextId) {
        this.contextIdProperty().set((Object)contextId);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty investorSecIdProperty() {
        return this.investorSecId;
    }

    public final String getInvestorSecId() {
        return (String)this.investorSecIdProperty().get();
    }

    public final void setInvestorSecId(String investorSecId) {
        this.investorSecIdProperty().set((Object)investorSecId);
    }

    public final DoubleProperty baseSpreadProperty() {
        return this.baseSpread;
    }

    public final double getBaseSpread() {
        return this.baseSpreadProperty().get();
    }

    public final void setBaseSpread(double baseSpread) {
        this.baseSpreadProperty().set(baseSpread);
    }

    public final DoubleProperty spreadSumProperty() {
        return this.spreadSum;
    }

    public final double getSpreadSum() {
        return this.spreadSumProperty().get();
    }

    public final void setSpreadSum(double spreadSum) {
        this.spreadSumProperty().set(spreadSum);
    }

    public final DoubleProperty bidSpreadProperty() {
        return this.bidSpread;
    }

    public final double getBidSpread() {
        return this.bidSpreadProperty().get();
    }

    public final void setBidSpread(double bidSpread) {
        this.bidSpreadProperty().set(bidSpread);
    }

    public final DoubleProperty askSpreadProperty() {
        return this.askSpread;
    }

    public final double getAskSpread() {
        return this.askSpreadProperty().get();
    }

    public final void setAskSpread(double askSpread) {
        this.askSpreadProperty().set(askSpread);
    }

    public final IntegerProperty bidQtyProperty() {
        return this.bidQty;
    }

    public final int getBidQty() {
        return this.bidQtyProperty().get();
    }

    public final void setBidQty(int bidQty) {
        this.bidQtyProperty().set(bidQty);
    }

    public final IntegerProperty askQtyProperty() {
        return this.askQty;
    }

    public final int getAskQty() {
        return this.askQtyProperty().get();
    }

    public final void setAskQty(int askQty) {
        this.askQtyProperty().set(askQty);
    }

    public final IntegerProperty dealLimitProperty() {
        return this.dealLimit;
    }

    public final int getDealLimit() {
        return this.dealLimitProperty().get();
    }

    public final void setDealLimit(int dealLimit) {
        this.dealLimitProperty().set(dealLimit);
    }

    public final StringProperty hedgeContractProperty() {
        return this.hedgeContract;
    }

    public final String getHedgeContract() {
        return (String)this.hedgeContractProperty().get();
    }

    public final void setHedgeContract(String hedgeContract) {
        this.hedgeContractProperty().set((Object)hedgeContract);
    }

    public final DoubleProperty hedgeSpreadBuyProperty() {
        return this.hedgeSpreadBuy;
    }

    public final double getHedgeSpreadBuy() {
        return this.hedgeSpreadBuyProperty().get();
    }

    public final void setHedgeSpreadBuy(double hedgeSpreadBuy) {
        this.hedgeSpreadBuyProperty().set(hedgeSpreadBuy);
    }

    public final DoubleProperty hedgeSpreadSellProperty() {
        return this.hedgeSpreadSell;
    }

    public final double getHedgeSpreadSell() {
        return this.hedgeSpreadSellProperty().get();
    }

    public final void setHedgeSpreadSell(double hedgeSpreadSell) {
        this.hedgeSpreadSellProperty().set(hedgeSpreadSell);
    }

    public final DoubleProperty filledQtyProperty() {
        return this.filledQty;
    }

    public final double getFilledQty() {
        return this.filledQtyProperty().get();
    }

    public final void setFilledQty(double filledQty) {
        this.filledQtyProperty().set(filledQty);
    }

    public final StringProperty errorMsgProperty() {
        return this.errorMsg;
    }

    public final String getErrorMsg() {
        return (String)this.errorMsgProperty().get();
    }

    public final void setErrorMsg(String errorMsg) {
        this.errorMsgProperty().set((Object)errorMsg);
    }

    public final ObjectProperty<MxNode> tacticsTypeProperty() {
        return this.tacticsType;
    }

    public final MxNode getTacticsType() {
        return (MxNode)this.tacticsTypeProperty().get();
    }

    public final void setTacticsType(MxNode tacticsType) {
        this.tacticsTypeProperty().set((Object)tacticsType);
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public final BooleanProperty showUpdateBtnProperty() {
        return this.showUpdateBtn;
    }

    public final boolean isShowUpdateBtn() {
        return this.showUpdateBtnProperty().get();
    }

    public final void setShowUpdateBtn(boolean showUpdateBtn) {
        this.showUpdateBtnProperty().set(showUpdateBtn);
    }

    public boolean isBuy() {
        return this.buy;
    }

    public void setBuy(boolean buy) {
        this.buy = buy;
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public int getTotalQty() {
        return this.totalQty;
    }

    public void setTotalQty(int totalQty) {
        this.totalQty = totalQty;
    }

    public double getHedgeSlip() {
        return this.hedgeSlip;
    }

    public void setHedgeSlip(double hedgeSlip) {
        this.hedgeSlip = hedgeSlip;
    }

    public final StringProperty parentContextIdProperty() {
        return this.parentContextId;
    }

    public final String getParentContextId() {
        return (String)this.parentContextIdProperty().get();
    }

    public final void setParentContextId(String parentContextId) {
        this.parentContextIdProperty().set((Object)parentContextId);
    }

    public final BooleanProperty parentContextProperty() {
        return this.parentContext;
    }

    public final boolean isParentContext() {
        return this.parentContextProperty().get();
    }

    public final void setParentContext(boolean parentContext) {
        this.parentContextProperty().set(parentContext);
    }
}

