/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgSelObj;
import cms.tmx.utils.MarketUtils;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FutureCrossOrder
extends MxChgSelObj
implements Comparable<Object> {
    private String market;
    private String code;
    private String instName;
    private String type;
    private String id;
    private String source;
    private String clCrossId;
    private Integer crossType;
    private String accntId;
    private String secAccntId;
    private String investorId;
    private String investorSecId;
    private Integer ordStatus;
    private String legStatus;
    private String modeType;
    private Integer modeAutoId;
    private String ordTime;
    private String ordDate;
    private Integer ordType;
    private Integer sortNum;
    private Double price;
    private String user;
    int buyQty;
    double buyPrice;
    int buyDealQty;
    int sellQty;
    double sellPrice;
    int sellDealQty;
    double spread;
    private String marketName = "";
    private MxNode node;
    private StringProperty statusDetail = new SimpleStringProperty("");

    public FutureCrossOrder() {
        this.node = new MxNode().load("ord_status", "");
    }

    private String getOrderText(int ordStatus) {
        this.node.setRaw(Integer.toString(ordStatus / 100));
        String groupStatus = "\u4e70\u5355" + this.node.getValue();
        this.node.setRaw(Integer.toString(ordStatus % 100));
        groupStatus = String.valueOf(groupStatus) + ",\u5356\u5355" + this.node.getValue();
        return groupStatus;
    }

    public void update(Object obj) {
        if (obj instanceof POrderService.CrossOrder) {
            POrderService.CrossOrder cOrder = (POrderService.CrossOrder)POrderService.CrossOrder.class.cast(obj);
            this.update(cOrder);
            this.changed();
        } else if (obj instanceof FutureCrossOrder) {
            FutureCrossOrder order = (FutureCrossOrder)FutureCrossOrder.class.cast(obj);
            this.update(order);
        }
    }

    private void update(POrderService.CrossOrder order) {
        this.setMarket(order.getInstrument().getMarket());
        this.setMarketName(MarketUtils.getMarketNameById((String)this.getMarket()));
        this.setCode(order.getInstrument().getSecurityId());
        this.setInstName(order.getInstrument().getSymbol());
        this.setType(order.getInstrument().getSecurityType());
        this.setId(order.getCrossId());
        this.setSource(order.getExecMode().getEmName());
        if (order.getExecMode().getEmType() == PField.ExecModeType.EXEC_MODE_TYPE_MANUAL) {
            this.setModeType("EXEC_MODE_TYPE_MANUAL");
        } else if (order.getExecMode().getEmType() == PField.ExecModeType.EXEC_MODE_TYPE_MARKETMAKING) {
            this.setModeType("EXEC_MODE_TYPE_MARKETMAKING");
        }
        if (this.getLeg(order.getOrdStatus()).equals("\u6709\u6548\u72b6\u6001")) {
            this.setSortNum(1);
        } else if (this.getLeg(order.getOrdStatus()).equals("\u5b8c\u7ed3\u72b6\u6001")) {
            this.setSortNum(2);
        }
        this.setLegStatus(this.getLeg(order.getOrdStatus()));
        this.setClCrossId(order.getClCrossId());
        this.setCrossType(order.getCrossType());
        this.setOrdTime(order.getOrdTime());
        this.setOrdDate(order.getOrdDate());
        this.setAccntId(order.getExtAccntId());
        this.setSecAccntId(order.getExtSecAccntId());
        this.setOrdStatus(order.getOrdStatus());
        this.setOrdType(order.getOrdType());
        this.setPrice(order.getPrice());
        this.setUser(order.getUserId());
        this.setModeAutoId(order.getExecMode().getEmId());
        this.setBuyQty(order.getBuyQty());
        this.setBuyPrice(order.getBuyPrice());
        this.setBuyDealQty(order.getBuyCumQty());
        this.setSellQty(order.getSellQty());
        this.setSellPrice(order.getSellPrice());
        this.setSellDealQty(order.getSellCumQty());
        this.setSpread(order.getSellPrice() - order.getBuyPrice());
        this.setStatusDetail(this.getOrderText(this.getOrdStatus()));
    }

    private void update(FutureCrossOrder order) {
        this.setMarket(order.getMarket());
        this.setMarketName(order.getMarketName());
        this.setCode(order.getCode());
        this.setInstName(order.getInstName());
        this.setType(order.getType());
        this.setId(order.getId());
        this.setSource(order.getSource());
        this.setModeType(order.getModeType());
        this.setSortNum(order.getSortNum());
        if (order.getOrdStatus() != null) {
            this.setLegStatus(this.getLeg(order.getOrdStatus()));
        }
        this.setClCrossId(order.getClCrossId());
        this.setCrossType(order.getCrossType());
        this.setOrdTime(order.getOrdTime());
        this.setOrdDate(order.getOrdDate());
        this.setAccntId(order.getAccntId());
        this.setSecAccntId(order.getSecAccntId());
        this.setInvestorId(order.getInvestorId());
        this.setInvestorSecId(order.getInvestorSecId());
        this.setOrdStatus(order.getOrdStatus());
        this.setOrdType(order.getOrdType());
        this.setPrice(order.getPrice());
        this.setUser(order.getUser());
        this.setModeAutoId(order.getModeAutoId());
        this.setBuyQty(order.getBuyQty());
        this.setBuyPrice(order.getBuyPrice());
        this.setBuyDealQty(order.getBuyDealQty());
        this.setSellQty(order.getSellQty());
        this.setSellPrice(order.getSellPrice());
        this.setSellDealQty(order.getSellDealQty());
        this.setSpread(order.getSellPrice() - order.getBuyPrice());
        this.setStatusDetail(order.getStatusDetail());
    }

    private String getLeg(int crossOrderStatus) {
        boolean flag;
        int firstLegStatus = crossOrderStatus / 100;
        int secondLegStatus = crossOrderStatus % 100;
        boolean bl = flag = this.isOver(firstLegStatus) && this.isOver(secondLegStatus);
        if (flag) {
            return "\u5b8c\u7ed3\u72b6\u6001";
        }
        return "\u6709\u6548\u72b6\u6001";
    }

    private boolean isOver(int legOrderStatus) {
        return legOrderStatus == Integer.valueOf("50") || legOrderStatus == Integer.valueOf("56") || legOrderStatus == Integer.valueOf("52") || legOrderStatus == Integer.valueOf("70");
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.ordDate == null ? 0 : this.ordDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FutureCrossOrder other = (FutureCrossOrder)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.ordDate == null ? other.ordDate != null : !this.ordDate.equals(other.ordDate));
    }

    @Override
    public int compareTo(Object o) {
        FutureCrossOrder u;
        if (this == o) {
            return 0;
        }
        if (o != null && o instanceof FutureCrossOrder && (u = (FutureCrossOrder)o).getSortNum() < this.getSortNum()) {
            return 1;
        }
        return -1;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getInstName() {
        return this.instName;
    }

    public void setInstName(String instName) {
        this.instName = instName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getClCrossId() {
        return this.clCrossId;
    }

    public void setClCrossId(String clCrossId) {
        this.clCrossId = clCrossId;
    }

    public Integer getCrossType() {
        return this.crossType;
    }

    public void setCrossType(Integer crossType) {
        this.crossType = crossType;
    }

    public String getAccntId() {
        return this.accntId;
    }

    public void setAccntId(String accntId) {
        this.accntId = accntId;
    }

    public String getSecAccntId() {
        return this.secAccntId;
    }

    public void setSecAccntId(String secAccntId) {
        this.secAccntId = secAccntId;
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }

    public String getInvestorSecId() {
        return this.investorSecId;
    }

    public void setInvestorSecId(String investorSecId) {
        this.investorSecId = investorSecId;
    }

    public Integer getOrdStatus() {
        return this.ordStatus;
    }

    public void setOrdStatus(Integer ordStatus) {
        this.ordStatus = ordStatus;
    }

    public String getLegStatus() {
        return this.legStatus;
    }

    public void setLegStatus(String legStatus) {
        this.legStatus = legStatus;
    }

    public String getModeType() {
        return this.modeType;
    }

    public void setModeType(String modeType) {
        this.modeType = modeType;
    }

    public Integer getModeAutoId() {
        return this.modeAutoId;
    }

    public void setModeAutoId(Integer modeAutoId) {
        this.modeAutoId = modeAutoId;
    }

    public String getOrdTime() {
        return this.ordTime;
    }

    public void setOrdTime(String ordTime) {
        this.ordTime = ordTime;
    }

    public String getOrdDate() {
        return this.ordDate;
    }

    public void setOrdDate(String ordDate) {
        this.ordDate = ordDate;
    }

    public Integer getOrdType() {
        return this.ordType;
    }

    public void setOrdType(Integer ordType) {
        this.ordType = ordType;
    }

    public Integer getSortNum() {
        return this.sortNum;
    }

    public void setSortNum(Integer sortNum) {
        this.sortNum = sortNum;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getBuyQty() {
        return this.buyQty;
    }

    public void setBuyQty(int buyQty) {
        this.buyQty = buyQty;
    }

    public double getBuyPrice() {
        return this.buyPrice;
    }

    public void setBuyPrice(double buyPrice) {
        this.buyPrice = buyPrice;
    }

    public int getBuyDealQty() {
        return this.buyDealQty;
    }

    public void setBuyDealQty(int buyDealQty) {
        this.buyDealQty = buyDealQty;
    }

    public int getSellQty() {
        return this.sellQty;
    }

    public void setSellQty(int sellQty) {
        this.sellQty = sellQty;
    }

    public double getSellPrice() {
        return this.sellPrice;
    }

    public void setSellPrice(double sellPrice) {
        this.sellPrice = sellPrice;
    }

    public int getSellDealQty() {
        return this.sellDealQty;
    }

    public void setSellDealQty(int sellDealQty) {
        this.sellDealQty = sellDealQty;
    }

    public double getSpread() {
        return this.spread;
    }

    public void setSpread(double spread) {
        this.spread = spread;
    }

    public String getMarketName() {
        return this.marketName;
    }

    public void setMarketName(String marketName) {
        this.marketName = marketName;
    }

    public final StringProperty statusDetailProperty() {
        return this.statusDetail;
    }

    public final String getStatusDetail() {
        return (String)this.statusDetailProperty().get();
    }

    public final void setStatusDetail(String statusDetail) {
        this.statusDetailProperty().set((Object)statusDetail);
    }

    public String getSelected() {
        return "";
    }
}

