/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import java.math.BigDecimal;
import javax.annotation.PostConstruct;

public class ExtTransRecord {
    private String fundAccId;
    private String masterPortId;
    private String slavePortId;
    private String transAmt;
    private String currency;
    private String operDate;
    private String operTime;
    private String userId;
    private String partyId;
    private static MxNode nodeCurr;

    @PostConstruct
    public void init() {
        if (nodeCurr == null) {
            nodeCurr = MxNodeFactory.create((String)"currency_type", (String)"\u4eba\u6c11\u5e01");
        }
    }

    public void update(Object obj) {
        if (obj instanceof PCashService.CashTransRecord) {
            this.update((PCashService.CashTransRecord)PCashService.CashTransRecord.class.cast(obj));
        }
    }

    private void update(PCashService.CashTransRecord record) {
        this.setFundAccId(record.getExtAccntId().replaceAll("[_A-Z]$*", ""));
        String srcProtf = record.getSrcPortfolioId();
        String dstProtf = record.getDstPortfolioId();
        this.setMasterPortId(srcProtf.isEmpty() ? this.getFundAccId() : srcProtf);
        this.setSlavePortId(dstProtf.isEmpty() ? this.getFundAccId() : dstProtf);
        BigDecimal big = new BigDecimal(record.getTransAmt());
        String amt = big.setScale(2, 4).toString();
        this.setTransAmt(amt);
        nodeCurr.setRaw(record.getCurrency());
        this.setCurrency(nodeCurr.getValue());
        this.setUserId(record.getUserId());
        this.setPartyId(record.getUserPartyId());
        this.setOperDate(record.getOperDate());
        this.setOperTime(record.getOperTime());
    }

    public String getFundAccId() {
        return this.fundAccId;
    }

    public void setFundAccId(String fundAccId) {
        this.fundAccId = fundAccId;
    }

    public String getMasterPortId() {
        return this.masterPortId;
    }

    public void setMasterPortId(String masterPortId) {
        this.masterPortId = masterPortId;
    }

    public String getSlavePortId() {
        return this.slavePortId;
    }

    public void setSlavePortId(String slavePortId) {
        this.slavePortId = slavePortId;
    }

    public String getTransAmt() {
        return this.transAmt;
    }

    public void setTransAmt(String transAmt) {
        this.transAmt = transAmt;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getOperDate() {
        return this.operDate;
    }

    public void setOperDate(String operDate) {
        this.operDate = operDate;
    }

    public String getOperTime() {
        return this.operTime;
    }

    public void setOperTime(String operTime) {
        this.operTime = operTime;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }
}

