/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PAssetService;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgObj;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class Deal
extends MxChgObj {
    private Instrument instrument;
    private MxNode side;
    private double lastQty = 0.0;
    private String unit = "";
    private double lastPx = 0.0;
    private double lastAmount = 0.0;
    private double lastAmountSum = 0.0;
    private String sysOrderId = "";
    private String orderId = "";
    private String execId = "";
    private String execDate = "";
    private String execTime = "";
    private String execDateTime = "";
    private String ordDateTime = "";
    private double execFee = 0.0;
    private double nowPrice = 0.0;
    private String extAccntId = "";
    private String extSecAccntId = "";
    private String investorId = "";
    private String investorName = "";
    private String inverstorSecId = "";
    private MxNode market;
    private long dealCount = 1L;
    private double tradeAmt = 0.0;
    private double incurredAmt = 0.0;
    private String marketGrp = "";
    private double useMargin;
    private double realFee = 0.0;
    private double commision = 0.0;
    private double chgOwnerFee = 0.0;
    private double stampTax = 0.0;
    private double handleFee = 0.0;
    private double secAdminFee = 0.0;
    private double otherFee = 0.0;
    private String baseId = "";
    private int execModeType;
    private String reference = "";
    private String secId;
    private String secName;
    private String exSide;
    private String exMarket;
    private String parentId;
    private String source;
    private String type;
    private String interval;
    private String userId = "";
    private String userName;
    private String sumDate = "";
    private String accntGrpName = "";
    private String portGrpName = "";
    private double rate;
    private double doneAmount = 0.0;

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.execDate == null ? 0 : this.execDate.hashCode());
        result = 31 * result + (this.execId == null ? 0 : this.execId.hashCode());
        result = 31 * result + (this.sysOrderId == null ? 0 : this.sysOrderId.hashCode());
        return result;
    }

    public int hashCodeObj() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Deal other = (Deal)((Object)obj);
        if (this.execDate == null ? other.execDate != null : !this.execDate.equals(other.execDate)) {
            return false;
        }
        if (this.execId == null ? other.execId != null : !this.execId.equals(other.execId)) {
            return false;
        }
        return !(this.sysOrderId == null ? other.sysOrderId != null : !this.sysOrderId.equals(other.sysOrderId));
    }

    public void update(Object obj) {
        if (obj instanceof POrderService.Execution) {
            POrderService.Execution en = (POrderService.Execution)POrderService.Execution.class.cast(obj);
            this.update(en);
        } else if (obj instanceof PAssetService.ExecutionsCollect) {
            PAssetService.ExecutionsCollect en = (PAssetService.ExecutionsCollect)PAssetService.ExecutionsCollect.class.cast(obj);
            this.update(en);
        } else if (obj instanceof Deal) {
            this.update((Deal)((Object)Deal.class.cast(obj)));
        }
    }

    private void update(POrderService.Execution deal) {
        PComponent.Instrument instr = deal.getInstrument();
        this.getInstrument().update((Object)instr);
        this.getSide().setRaw(Integer.toString(deal.getSideValue()));
        this.setLastQty(deal.getLastQty());
        this.setLastAmount(deal.getLastAmount());
        this.setLastPx((double)Math.round(deal.getLastPx() * 10000.0) / 10000.0);
        this.setExecFee((double)Math.round(deal.getExecFee() * 1000.0) / 1000.0);
        this.setExecTime(deal.getExecTime());
        this.setExecDate(deal.getExecDate());
        this.setOrdDateTime(deal.getOrdDatetime());
        String exeDateTime = deal.getExecDatetime();
        if (deal.getExecTime().contains(".")) {
            exeDateTime = String.valueOf(exeDateTime) + deal.getExecTime().substring(deal.getExecTime().indexOf("."));
        }
        this.setExecDateTime(exeDateTime);
        this.getMarket().setRaw(deal.getInstrument().getMarket());
        this.setOrderId(deal.getOrderId());
        this.setExecId(deal.getExecId());
        this.setExtAccntId(deal.getExtAccntId());
        this.setExtSecAccntId(deal.getExtSecAccntId());
        if (deal.getExecMode().getEmName().contains("_")) {
            String str = deal.getExecMode().getEmName();
            this.setBaseId(str.substring(0, str.indexOf("_")));
        } else {
            this.setBaseId(deal.getExecMode().getEmName());
        }
        this.setExecModeType(deal.getExecMode().getEmTypeValue());
        this.setReference(deal.getInstructionId());
        this.setSecId(this.getInstrument().getSecId());
        this.setSecName(this.getInstrument().getSymbol());
        this.setExMarket(this.getInstrument().getMarket().getValue());
        this.setExSide(this.getSide().getValue());
        this.setParentId(deal.getParentId());
        this.setSource(deal.getExecMode().getEmName());
        this.transferType(deal);
        this.setSysOrderId(deal.getSysOrderId());
        this.setUserId(deal.getUserId());
        this.setRate((double)Math.round(deal.getExchangeRate() * 10000.0) / 10000.0);
    }

    private void update(PAssetService.ExecutionsCollect deal) {
        PComponent.Instrument instr = deal.getInstrument();
        this.getInstrument().update((Object)instr);
        this.getSide().setRaw(Integer.toString(deal.getSideValue()));
        this.setLastQty(deal.getMatchQty());
        this.setLastPx((double)Math.round(deal.getMatchPx() * 10000.0) / 10000.0);
        this.setExtAccntId(deal.getExtAccntId());
        this.setExtSecAccntId(deal.getPortfolioId());
        this.setTradeAmt(deal.getTradeAmount());
        this.setRealFee(deal.getMatchFee());
        this.setCommision(deal.getCommision());
        this.setChgOwnerFee(deal.getChgOwnerFee());
        this.setStampTax(deal.getStampTax());
        this.setHandleFee(deal.getHandleFee());
        this.setSecAdminFee(deal.getSecAdminFee());
        this.setOtherFee(deal.getOtherFee());
        this.setInterval(deal.getOrdDate());
        this.setSumDate(deal.getOrdDate());
        this.setAccntGrpName(deal.getAssetGroupId());
        this.setPortGrpName(deal.getAssetGroupId());
        this.setDoneAmount(deal.getDoneAmount());
        this.setSecId(this.getInstrument().getSecId());
        this.setSecName(this.getInstrument().getSymbol());
        this.setExMarket(this.getInstrument().getMarket().getValue());
        this.setExSide(this.getSide().getValue());
    }

    private void update(Deal deal) {
        this.setInstrument(deal.getInstrument());
        this.setSide(deal.getSide());
        this.setLastQty(deal.getLastQty());
        this.setLastAmount(deal.getLastAmount());
        this.setLastPx(deal.getLastPx());
        this.setExecFee(deal.getExecFee());
        this.setExecTime(deal.getExecTime());
        this.setExecDate(deal.getExecDate());
        this.setMarket(deal.getMarket());
        this.setOrderId(deal.getOrderId());
        this.setExecId(deal.getExecId());
        this.setExtAccntId(deal.getExtAccntId());
        this.setExtSecAccntId(deal.getExtSecAccntId());
        this.setInvestorId(deal.getInvestorId());
        this.setInvestorName(deal.getInvestorName());
        this.setInverstorSecId(deal.getInverstorSecId());
        this.setDealCount(deal.getDealCount());
        this.setBaseId(deal.getBaseId());
        this.setExecModeType(deal.getExecModeType());
        this.setUnit(deal.getUnit());
        this.setTradeAmt(deal.getTradeAmt());
        this.setReference(deal.getReference());
        this.setType(deal.getType());
        this.setSecId(deal.getSecId());
        this.setSecName(deal.getSecName());
        this.setExSide(deal.getExSide());
        this.setExMarket(this.exMarket);
        this.setRealFee(deal.getRealFee());
        this.setCommision(deal.getCommision());
        this.setChgOwnerFee(deal.getChgOwnerFee());
        this.setStampTax(deal.getStampTax());
        this.setHandleFee(deal.getHandleFee());
        this.setSecAdminFee(deal.getSecAdminFee());
        this.setOtherFee(deal.getOtherFee());
        this.setSysOrderId(deal.getSysOrderId());
        this.setInterval(deal.getInterval());
        this.setSumDate(deal.getInterval());
        this.setIncurredAmt(deal.getIncurredAmt());
        this.setUserId(deal.getUserId());
        this.setUserName(deal.getUserName());
        this.setAccntGrpName(deal.getAccntGrpName());
        this.setPortGrpName(deal.getPortGrpName());
        this.setRate(deal.getRate());
    }

    private void transferType(POrderService.Execution deal) {
        if (this.getExecModeType() == 6) {
            if (deal.getClOrdId().contains(deal.getParentId())) {
                this.setType("\u505a\u5e02\u5355");
            }
        } else if (this.getExecModeType() == 7) {
            this.setType("\u5bf9\u51b2\u5355");
        } else if (this.getExecModeType() == 1) {
            this.setType("\u505a\u5e02\u5355");
        } else if (this.getExecModeType() == 8) {
            this.setType("\u6807\u503a\u8fdc\u671f\u5957\u5229\u7b56\u7565");
        } else if (this.getExecModeType() == 9) {
            this.setType("\u5957\u5229\u5355");
        } else if (this.getExecModeType() == 10) {
            this.setType("\u624b\u5de5\u5bf9\u51b2\u5355");
        } else if (this.getExecModeType() == 21) {
            this.setType("\u7b97\u6cd5\u5355");
        } else if (this.getExecModeType() == 22) {
            this.setType("\u7b97\u6cd5\u5bf9\u51b2\u5355");
        } else if (this.getExecModeType() == 3) {
            this.setType("\u7ec4\u5408\u5957\u5229");
        } else {
            this.setType("\u666e\u901a\u5355");
        }
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public MxNode getSide() {
        return this.side;
    }

    public void setSide(MxNode side) {
        this.side = side;
    }

    public double getLastQty() {
        return this.lastQty;
    }

    public void setLastQty(double lastQty) {
        this.lastQty = lastQty;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public double getLastPx() {
        return this.lastPx;
    }

    public void setLastPx(double lastPx) {
        this.lastPx = lastPx;
    }

    public double getLastAmount() {
        return this.lastAmount;
    }

    public void setLastAmount(double lastAmount) {
        this.lastAmount = lastAmount;
    }

    public String getSysOrderId() {
        return this.sysOrderId;
    }

    public void setSysOrderId(String sysOrderId) {
        this.sysOrderId = sysOrderId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getExecId() {
        return this.execId;
    }

    public void setExecId(String execId) {
        this.execId = execId;
    }

    public String getExecDate() {
        return this.execDate;
    }

    public void setExecDate(String execDate) {
        this.execDate = execDate;
    }

    public String getExecTime() {
        return this.execTime;
    }

    public void setExecTime(String execTime) {
        this.execTime = execTime;
    }

    public double getExecFee() {
        return this.execFee;
    }

    public void setExecFee(double execFee) {
        this.execFee = execFee;
    }

    public double getNowPrice() {
        return this.nowPrice;
    }

    public void setNowPrice(double nowPrice) {
        this.nowPrice = nowPrice;
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }

    public String getInverstorSecId() {
        return this.inverstorSecId;
    }

    public void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecId = inverstorSecId;
    }

    public MxNode getMarket() {
        return this.market;
    }

    public void setMarket(MxNode market) {
        this.market = market;
    }

    public long getDealCount() {
        return this.dealCount;
    }

    public void setDealCount(long dealCount) {
        this.dealCount = dealCount;
    }

    public double getTradeAmt() {
        return this.tradeAmt;
    }

    public void setTradeAmt(double tradeAmt) {
        this.tradeAmt = tradeAmt;
    }

    public String getMarketGrp() {
        return this.marketGrp;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGrp = marketGrp;
    }

    public double getUseMargin() {
        return this.useMargin;
    }

    public void setUseMargin(double useMargin) {
        this.useMargin = useMargin;
    }

    public double getRealFee() {
        return this.realFee;
    }

    public void setRealFee(double realFee) {
        this.realFee = realFee;
    }

    public double getCommision() {
        return this.commision;
    }

    public void setCommision(double commision) {
        this.commision = commision;
    }

    public double getChgOwnerFee() {
        return this.chgOwnerFee;
    }

    public void setChgOwnerFee(double chgOwnerFee) {
        this.chgOwnerFee = chgOwnerFee;
    }

    public double getStampTax() {
        return this.stampTax;
    }

    public void setStampTax(double stampTax) {
        this.stampTax = stampTax;
    }

    public double getHandleFee() {
        return this.handleFee;
    }

    public void setHandleFee(double handleFee) {
        this.handleFee = handleFee;
    }

    public double getSecAdminFee() {
        return this.secAdminFee;
    }

    public void setSecAdminFee(double secAdminFee) {
        this.secAdminFee = secAdminFee;
    }

    public double getOtherFee() {
        return this.otherFee;
    }

    public void setOtherFee(double otherFee) {
        this.otherFee = otherFee;
    }

    public String getBaseId() {
        return this.baseId;
    }

    public void setBaseId(String baseId) {
        this.baseId = baseId;
    }

    public int getExecModeType() {
        return this.execModeType;
    }

    public void setExecModeType(int execModeType) {
        this.execModeType = execModeType;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getSecId() {
        return this.secId;
    }

    public void setSecId(String secId) {
        this.secId = secId;
    }

    public String getSecName() {
        return this.secName;
    }

    public void setSecName(String secName) {
        this.secName = secName;
    }

    public String getExSide() {
        return this.exSide;
    }

    public void setExSide(String exSide) {
        this.exSide = exSide;
    }

    public String getExMarket() {
        return this.exMarket;
    }

    public void setExMarket(String exMarket) {
        this.exMarket = exMarket;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public double getIncurredAmt() {
        return this.incurredAmt;
    }

    public void setIncurredAmt(double incurredAmt) {
        this.incurredAmt = incurredAmt;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getInvestorName() {
        return this.investorName;
    }

    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }

    public String getAccntGrpName() {
        return this.accntGrpName;
    }

    public void setAccntGrpName(String accntGrpName) {
        this.accntGrpName = accntGrpName;
    }

    public double getLastAmountSum() {
        return this.lastAmountSum;
    }

    public void setLastAmountSum(double lastAmountSum) {
        this.lastAmountSum = lastAmountSum;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public double getDoneAmount() {
        return this.doneAmount;
    }

    public void setDoneAmount(double doneAmount) {
        this.doneAmount = doneAmount;
    }

    public String getSumDate() {
        return this.sumDate;
    }

    public void setSumDate(String sumDate) {
        this.sumDate = sumDate;
    }

    public String getPortGrpName() {
        return this.portGrpName;
    }

    public void setPortGrpName(String portGrpName) {
        this.portGrpName = portGrpName;
    }

    public String getExecDateTime() {
        return this.execDateTime;
    }

    public void setExecDateTime(String execDateTime) {
        this.execDateTime = execDateTime;
    }

    public String getOrdDateTime() {
        return this.ordDateTime;
    }

    public void setOrdDateTime(String ordDateTime) {
        this.ordDateTime = ordDateTime;
    }
}

