/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PCtpExtra;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.entity.trade.Position;
import cms.tmx.javafx.MxNode;
import com.google.protobuf.InvalidProtocolBufferException;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CtpPosition
extends Position {
    private ObjectProperty<MxNode> posiDirection = new SimpleObjectProperty();
    private ObjectProperty<MxNode> hedgeFlag = new SimpleObjectProperty();
    private String exPosiDirection;
    private String exHedgeFlag;
    private LongProperty position = new SimpleLongProperty(0L);
    private DoubleProperty useMargin = new SimpleDoubleProperty(0.0);
    private DoubleProperty positionProfit = new SimpleDoubleProperty(0.0);
    private int longFrozen;
    private int shortFrozen;
    private double longFrozenAmount;
    private double shortFrozenAmount;
    private int openVolume;
    private int closeVolume;
    private double openAmount;
    private double closeAmount;
    private double positionCost;
    private double preMargin;
    private double frozenMargin;
    private double frozenCash;
    private double frozenCommission;
    private double cashIn;
    private double commission;
    private double closeProfit;
    private double preSettlementPrice;
    private double settlementPrice;
    private String settlementId = "";
    private double openCost;
    private double exchangeMargin;
    private int combPosition;
    private int combLongFrozen;
    private int combShortFrozen;
    private double closeProfitBydate;
    private double closeProfitBytrade;
    private double marginRateBymoney;
    private double marginRateByvolume;
    private double ydLongFrozen;
    private double ydShortFrozen;
    private double tdLongFrozen;
    private double tdShortFrozen;
    private LongProperty tdPosition = new SimpleLongProperty(0L);
    private LongProperty canCloseTdLong = new SimpleLongProperty(0L);
    private LongProperty canCloseYdLong = new SimpleLongProperty(0L);
    private LongProperty canCloseTdShort = new SimpleLongProperty(0L);
    private LongProperty canCloseYdShort = new SimpleLongProperty(0L);
    private LongProperty canCloseTdTotal = new SimpleLongProperty(0L);
    private LongProperty canCloseYdTotal = new SimpleLongProperty(0L);
    private LongProperty ydPosition = new SimpleLongProperty(0L);
    private LongProperty canClose = new SimpleLongProperty(0L);
    private DoubleProperty secValue = new SimpleDoubleProperty(0.0);
    private static final Logger logger = LogManager.getLogger(CtpPosition.class);

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.hedgeFlag.get() == null ? 0 : ((MxNode)this.hedgeFlag.get()).getRaw().hashCode());
        result = 31 * result + (this.posiDirection.get() == null ? 0 : ((MxNode)this.posiDirection.get()).getRaw().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CtpPosition other = (CtpPosition)((Object)obj);
        if (this.hedgeFlag.get() == null ? other.hedgeFlag.get() != null : !((MxNode)this.hedgeFlag.get()).getRaw().equals(((MxNode)other.hedgeFlag.get()).getRaw())) {
            return false;
        }
        return !(this.posiDirection.get() == null ? other.posiDirection.get() != null : !((MxNode)this.posiDirection.get()).getRaw().equals(((MxNode)other.posiDirection.get()).getRaw()));
    }

    @Override
    public void update(Object obj) {
        try {
            if (obj instanceof PPositionService.ExtPosition) {
                PPositionService.ExtPosition position = (PPositionService.ExtPosition)PPositionService.ExtPosition.class.cast(obj);
                super.update((Object)position);
                PCtpExtra.CTPExtPosition ctp = (PCtpExtra.CTPExtPosition)position.getObject().unpack(PCtpExtra.CTPExtPosition.class);
                this.update(ctp);
            } else if (obj instanceof CtpPosition) {
                CtpPosition pos = (CtpPosition)((Object)CtpPosition.class.cast(obj));
                super.update((Object)pos);
                this.update(pos);
            }
        }
        catch (InvalidProtocolBufferException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void update(CtpPosition po) {
        this.setPosiDirection(po.getPosiDirection());
        this.setHedgeFlag(po.getHedgeFlag());
        this.setPosition(po.getPosition());
        this.setUseMargin(po.getUseMargin());
        this.setTdPosition(po.getTdPosition());
        this.setPositionProfit(po.getPositionProfit());
        this.setCloseProfit(po.getCloseProfit());
        this.setCanCloseTdLong(po.getCanCloseTdLong());
        this.setCanCloseYdLong(po.getCanCloseYdLong());
        this.setCanCloseTdShort(po.getCanCloseTdShort());
        this.setCanCloseYdShort(po.getCanCloseYdShort());
        this.setTradingDay(po.getTradingDay());
        this.setYdPosition(po.getYdPosition());
        this.setCanCloseTdTotal(po.getCanCloseTdTotal());
        this.setCanCloseYdTotal(po.getCanCloseYdTotal());
        this.setCanClose(po.getCanClose());
        this.setExPosiDirection(po.getExPosiDirection());
        this.setExHedgeFlag(po.getExHedgeFlag());
        this.setSecValue(po.getSecValue());
    }

    private void update(PCtpExtra.CTPExtPosition po) {
        this.getPosiDirection().setRaw(Integer.toString(po.getPosiDirection()));
        this.getHedgeFlag().setRaw(Integer.toString(po.getHedgeFlag()));
        this.setPosition(po.getPosition());
        this.setUseMargin((double)Math.round(po.getUseMargin() * 1000.0) / 1000.0);
        this.setTdPosition(po.getTdPosition());
        this.setPositionProfit((double)Math.round(po.getPositionProfit() * 1000.0) / 1000.0);
        this.setCloseProfit((double)Math.round(po.getCloseProfit() * 1000.0) / 1000.0);
        this.setTradingDay(po.getTradingDay());
        if (po.getPosiDirection() == Integer.parseInt("1")) {
            this.setCanCloseTdLong(new Double((double)po.getTdPosition() - po.getTdShortFrozen()).longValue());
            this.setCanCloseYdLong(new Double((double)(po.getPosition() - po.getTdPosition()) - po.getYdShortFrozen()).longValue());
            this.setCanCloseTdTotal(this.getCanCloseTdLong());
            this.setCanCloseYdTotal(this.getCanCloseYdLong());
            this.setCanClose(po.getPosition() - po.getShortFrozen());
        } else {
            this.setCanCloseTdShort(new Double((double)po.getTdPosition() - po.getTdLongFrozen()).longValue());
            this.setCanCloseYdShort(new Double((double)(po.getPosition() - po.getTdPosition()) - po.getYdLongFrozen()).longValue());
            this.setCanCloseTdTotal(this.getCanCloseTdShort());
            this.setCanCloseYdTotal(this.getCanCloseYdShort());
            this.setCanClose(po.getPosition() - po.getLongFrozen());
        }
        this.setYdPosition(po.getPosition() - po.getTdPosition());
        this.setExPosiDirection(this.getPosiDirection().getValue());
        this.setExHedgeFlag(this.getHedgeFlag().getValue());
    }

    public LongProperty ydPositionProperty() {
        return this.ydPosition;
    }

    public long getYdPosition() {
        return this.ydPositionProperty().get();
    }

    public void setYdPosition(long ydPosition) {
        this.ydPositionProperty().set(ydPosition);
    }

    public LongProperty positionProperty() {
        return this.position;
    }

    public long getPosition() {
        return this.positionProperty().get();
    }

    public void setPosition(long position) {
        this.positionProperty().set(position);
    }

    public DoubleProperty useMarginProperty() {
        return this.useMargin;
    }

    public double getUseMargin() {
        return this.useMarginProperty().get();
    }

    public void setUseMargin(double useMargin) {
        this.useMarginProperty().set(useMargin);
    }

    public DoubleProperty positionProfitProperty() {
        return this.positionProfit;
    }

    public double getPositionProfit() {
        return this.positionProfitProperty().get();
    }

    public void setPositionProfit(double positionProfit) {
        this.positionProfitProperty().set(positionProfit);
    }

    public LongProperty tdPositionProperty() {
        return this.tdPosition;
    }

    public long getTdPosition() {
        return this.tdPositionProperty().get();
    }

    public void setTdPosition(long tdPosition) {
        this.tdPositionProperty().set(tdPosition);
    }

    public ObjectProperty<MxNode> posiDirectionProperty() {
        return this.posiDirection;
    }

    public MxNode getPosiDirection() {
        return (MxNode)this.posiDirectionProperty().get();
    }

    public void setPosiDirection(MxNode posiDirection) {
        this.posiDirectionProperty().set((Object)posiDirection);
    }

    public ObjectProperty<MxNode> hedgeFlagProperty() {
        return this.hedgeFlag;
    }

    public MxNode getHedgeFlag() {
        return (MxNode)this.hedgeFlagProperty().get();
    }

    public void setHedgeFlag(MxNode hedgeFlag) {
        this.hedgeFlagProperty().set((Object)hedgeFlag);
    }

    public final LongProperty canCloseTdLongProperty() {
        return this.canCloseTdLong;
    }

    public final long getCanCloseTdLong() {
        return this.canCloseTdLongProperty().get();
    }

    public final void setCanCloseTdLong(long canCloseTdLong) {
        this.canCloseTdLongProperty().set(canCloseTdLong);
    }

    public final LongProperty canCloseYdLongProperty() {
        return this.canCloseYdLong;
    }

    public final long getCanCloseYdLong() {
        return this.canCloseYdLongProperty().get();
    }

    public final void setCanCloseYdLong(long canCloseYdLong) {
        this.canCloseYdLongProperty().set(canCloseYdLong);
    }

    public final LongProperty canCloseTdShortProperty() {
        return this.canCloseTdShort;
    }

    public final long getCanCloseTdShort() {
        return this.canCloseTdShortProperty().get();
    }

    public final void setCanCloseTdShort(long canCloseTdShort) {
        this.canCloseTdShortProperty().set(canCloseTdShort);
    }

    public final LongProperty canCloseYdShortProperty() {
        return this.canCloseYdShort;
    }

    public final long getCanCloseYdShort() {
        return this.canCloseYdShortProperty().get();
    }

    public final void setCanCloseYdShort(long canCloseYdShort) {
        this.canCloseYdShortProperty().set(canCloseYdShort);
    }

    public LongProperty canCloseTdTotalProperty() {
        return this.canCloseTdTotal;
    }

    public long getCanCloseTdTotal() {
        return this.canCloseTdTotalProperty().get();
    }

    public void setCanCloseTdTotal(long canCloseTdTotal) {
        this.canCloseTdTotalProperty().set(canCloseTdTotal);
    }

    public LongProperty canCloseYdTotalProperty() {
        return this.canCloseYdTotal;
    }

    public long getCanCloseYdTotal() {
        return this.canCloseYdTotalProperty().get();
    }

    public void setCanCloseYdTotal(long canCloseYdTotal) {
        this.canCloseYdTotalProperty().set(canCloseYdTotal);
    }

    @Override
    public String getPstDirInfo() {
        return this.getPosiDirection().getRaw();
    }

    @Override
    public String getHedgeFlagInfo() {
        return this.getHedgeFlag().getRaw();
    }

    public final LongProperty canCloseProperty() {
        return this.canClose;
    }

    public final long getCanClose() {
        return this.canCloseProperty().get();
    }

    public final void setCanClose(long canClose) {
        this.canCloseProperty().set(canClose);
    }

    public double getCloseProfit() {
        return this.closeProfit;
    }

    public void setCloseProfit(double closeProfit) {
        this.closeProfit = closeProfit;
    }

    public String getExPosiDirection() {
        return this.exPosiDirection;
    }

    public void setExPosiDirection(String exPosiDirection) {
        this.exPosiDirection = exPosiDirection;
    }

    public String getExHedgeFlag() {
        return this.exHedgeFlag;
    }

    public void setExHedgeFlag(String exHedgeFlag) {
        this.exHedgeFlag = exHedgeFlag;
    }

    public final DoubleProperty secValueProperty() {
        return this.secValue;
    }

    public final double getSecValue() {
        return this.secValueProperty().get();
    }

    public final void setSecValue(double secValue) {
        this.secValueProperty().set(secValue);
    }
}

