/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PCtpExtra;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CtpOrder
extends Order {
    private MxNode ocFlag;
    private MxNode shFlag;
    private String subAccntId = "";
    private double wthQty;
    private String wthTime = "";
    private String portfolioId = "";
    private String currencyId = "";
    private String frontId = "";
    private String sessionId = "";
    private String parentId = "";
    private String execType = "";
    private String exOcFlag = "";
    private String exShFlag = "";
    private String exOrdStatus = "";
    private MxNode legMode;
    private String clContractId;
    String accName = "";
    protected static final Logger logger = LogManager.getLogger(CtpOrder.class);

    public CtpOrder() {
        Instrument ins = new Instrument();
        this.setInstrument(ins);
        this.setSide(MxNodeFactory.create((String)"side", (String)""));
        this.setOrdStatus(MxNodeFactory.create((String)"ord_status", (String)""));
        this.setLegMode(MxNodeFactory.create((String)"leg_mode", (String)""));
        this.setOcFlag(MxNodeFactory.create((String)"oc_flag", (String)""));
        this.setShFlag(MxNodeFactory.create((String)"sh_flag", (String)""));
    }

    @Override
    public void update(Object obj) {
        try {
            if (obj instanceof POrderService.SingleOrder) {
                super.update(obj);
                POrderService.SingleOrder order = (POrderService.SingleOrder)POrderService.SingleOrder.class.cast(obj);
                PCtpExtra.CTPSingleOrderExtra ctp = (PCtpExtra.CTPSingleOrderExtra)order.getObject().unpack(PCtpExtra.CTPSingleOrderExtra.class);
                this.update(ctp);
            } else if (obj instanceof PStrategy.SingleOrder) {
                PStrategy.SingleOrder en = (PStrategy.SingleOrder)PStrategy.SingleOrder.class.cast(obj);
                this.update(en);
            } else if (obj instanceof CtpOrder) {
                super.update(obj);
                CtpOrder order = (CtpOrder)((Object)CtpOrder.class.cast(obj));
                this.update(order);
            }
        }
        catch (InvalidProtocolBufferException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void update(CtpOrder en) {
        this.setOcFlag(en.getOcFlag());
        this.setShFlag(en.getShFlag());
        this.setExtAccntId(en.getExtAccntId());
        this.setSubAccntId(en.getSubAccntId());
        this.setPortfolioId(en.getPortfolioId());
        this.setCurrencyId(en.getCurrencyId());
        this.setWthErrCode(en.getWthErrCode());
        this.setWthErrInfo(en.getWthErrInfo());
        this.setErrCode(en.getErrCode());
        this.setErrInfo(en.getErrInfo());
        this.setFrontId(en.getFrontId());
        this.setSessionId(en.getSessionId());
        this.setWthTime(en.getWthTime());
        this.setWthQty(en.getWthQty());
        this.setExecType(en.getExecType());
        this.setExOcFlag(en.getExOcFlag());
        this.setExShFlag(en.getExShFlag());
        this.setExOrdStatus(en.getExOrdStatus());
        this.setAttachment(en.getAttachment());
        this.setAccName(en.getAccName());
    }

    private void update(PCtpExtra.CTPSingleOrderExtra en) {
        this.getOcFlag().setRaw(String.valueOf(en.getOcFlag()));
        this.getShFlag().setRaw(String.valueOf(en.getShFlag()));
        this.setExtAccntId(en.getExtAccntId());
        this.setSubAccntId(en.getSubAccntId());
        this.setPortfolioId(en.getPortfolioId());
        this.setCurrencyId(en.getCurrencyId());
        this.setWthErrCode(en.getWthErrCode());
        this.setWthErrInfo(en.getWthErrInfo());
        this.setErrCode(en.getErrCode());
        this.setErrInfo(this.transferErrInfo(en));
        this.setFrontId(en.getFrontId());
        this.setSessionId(en.getSessionId());
        this.setWthTime(en.getWthTime());
        this.setWthQty(en.getWthQty());
        this.setParentId(en.getParentId());
        this.getLegMode().setRaw(Integer.toString(en.getLegModeValue()));
        this.transferType(en);
        this.setExOcFlag(this.getOcFlag().getValue());
        this.setExShFlag(this.getShFlag().getValue());
        this.setExOrdStatus(this.getOrdStatus().getValue());
    }

    private void update(PStrategy.SingleOrder en) {
        PComponent.Instrument inst = en.getInstrument();
        this.getInstrument().update((Object)inst);
        this.setOrderId(en.getOrdId());
        this.setSysOrderId(en.getOrdId());
        this.setClOrdId(en.getCrossId());
        this.getSide().setRaw(Integer.toString(en.getSideValue()));
        this.setOrdType(en.getOrdTypeValue());
        this.setOrderQty((int)en.getOrderQty());
        this.setPrice((double)Math.round(en.getPrice() * 1000.0) / 1000.0);
        this.setApplId(en.getInstrument().getApplId());
        this.setExecModeType(en.getModeTypeValue());
        this.setSource(en.getExecModeName());
        this.getOrdStatus().setRaw(Integer.toString(en.getOrdStausValue()));
        this.getOcFlag().setRaw(String.valueOf(en.getOcFlag()));
        this.getShFlag().setRaw(String.valueOf(en.getShFlag()));
        this.setExtAccntId(en.getExtAccntId());
        this.setExtSecAccntId(en.getExtSecAccntId());
        this.setErrInfo(en.getText());
        this.setCumQty(en.getRejectQty());
        if (this.getExecModeType() == 6) {
            if (this.getClOrdId().contains(en.getCrossId())) {
                this.setExecType("\u505a\u5e02\u5355");
            }
        } else if (this.getExecModeType() == 7) {
            this.setExecType("\u5bf9\u51b2\u5355");
        } else if (this.getExecModeType() == 1) {
            this.setExecType("\u505a\u5e02\u5355");
        } else if (this.getExecModeType() == 8) {
            this.setExecType("\u6807\u503a\u8fdc\u671f\u5957\u5229\u7b56\u7565");
        } else if (this.getExecModeType() == 9) {
            this.setExecType("\u5957\u5229\u5355");
        } else if (this.getExecModeType() == 10) {
            this.setExecType("\u624b\u5de5\u5bf9\u51b2\u5355");
        } else if (this.getExecModeType() == 21) {
            this.setExecType("\u7b97\u6cd5\u5355");
        } else if (this.getExecModeType() == 22) {
            this.setExecType("\u7b97\u6cd5\u5bf9\u51b2\u5355");
        } else if (this.getExecModeType() == 3) {
            this.setExecType("\u7ec4\u5408\u5957\u5229");
        } else {
            this.setExecType("\u666e\u901a\u5355");
        }
        this.setAttachment(en.getAttachment());
        this.setClContractId(en.getClOrdId());
    }

    private String transferErrInfo(PCtpExtra.CTPSingleOrderExtra en) {
        StringBuilder errorInfo = new StringBuilder();
        if (1 != en.getErrCode() && !StringUtils.isEmpty((String)en.getErrInfo())) {
            errorInfo.append("\u4e0b\u5355\u9519\u8bef\uff08").append(en.getErrInfo()).append("\uff09");
        } else {
            errorInfo.append(en.getErrInfo()).append(" ");
        }
        if (1 != en.getWthErrCode() && !StringUtils.isEmpty((String)en.getWthErrInfo())) {
            errorInfo.append("\u64a4\u5355\u9519\u8bef\uff08").append(en.getWthErrInfo()).append("\uff09");
        }
        if (!StringUtils.isEmpty((String)this.getRiskDetail())) {
            errorInfo.append("\u98ce\u63a7\u8be6\u60c5\uff08").append(this.getRiskDetail()).append("\uff09");
        }
        return errorInfo.toString();
    }

    private void transferType(PCtpExtra.CTPSingleOrderExtra en) {
        if (this.getExecModeType() == 6) {
            if (this.getClOrdId().contains(en.getParentId())) {
                this.setExecType("\u505a\u5e02\u5355");
            }
        } else if (this.getExecModeType() == 7) {
            this.setExecType("\u5bf9\u51b2\u5355");
        } else if (this.getExecModeType() == 1) {
            this.setExecType("\u505a\u5e02\u5355");
        } else if (this.getExecModeType() == 8) {
            this.setExecType("\u6807\u503a\u8fdc\u671f\u5957\u5229\u7b56\u7565");
        } else if (this.getExecModeType() == 9) {
            this.setExecType("\u5957\u5229\u5355");
        } else if (this.getExecModeType() == 10) {
            this.setExecType("\u624b\u5de5\u5bf9\u51b2\u5355");
        } else if (this.getExecModeType() == 21) {
            this.setExecType("\u7b97\u6cd5\u5355");
        } else if (this.getExecModeType() == 22) {
            this.setExecType("\u7b97\u6cd5\u5bf9\u51b2\u5355");
        } else if (this.getExecModeType() == 3) {
            this.setExecType("\u7ec4\u5408\u5957\u5229");
        } else {
            this.setExecType("\u666e\u901a\u5355");
        }
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String toString() {
        return String.valueOf(this.getAttachment()) + "- " + this.getInvestorId() + "_" + this.getInstrument().getSecId() + "_" + this.getPrice() + "_" + (this.getOrderQty() - this.getCumQty());
    }

    public MxNode getOcFlag() {
        return this.ocFlag;
    }

    public void setOcFlag(MxNode ocFlag) {
        this.ocFlag = ocFlag;
    }

    public MxNode getShFlag() {
        return this.shFlag;
    }

    public void setShFlag(MxNode shFlag) {
        this.shFlag = shFlag;
    }

    public String getSubAccntId() {
        return this.subAccntId;
    }

    public void setSubAccntId(String subAccntId) {
        this.subAccntId = subAccntId;
    }

    public double getWthQty() {
        return this.wthQty;
    }

    public void setWthQty(double wthQty) {
        this.wthQty = wthQty;
    }

    @Override
    public String getWthTime() {
        return this.wthTime;
    }

    @Override
    public void setWthTime(String wthTime) {
        this.wthTime = wthTime;
    }

    @Override
    public String getPortfolioId() {
        return this.portfolioId;
    }

    @Override
    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getFrontId() {
        return this.frontId;
    }

    public void setFrontId(String frontId) {
        this.frontId = frontId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getExecType() {
        return this.execType;
    }

    public void setExecType(String execType) {
        this.execType = execType;
    }

    public String getExOcFlag() {
        return this.exOcFlag;
    }

    public void setExOcFlag(String exOcFlag) {
        this.exOcFlag = exOcFlag;
    }

    public String getExShFlag() {
        return this.exShFlag;
    }

    public void setExShFlag(String exShFlag) {
        this.exShFlag = exShFlag;
    }

    public MxNode getLegMode() {
        return this.legMode;
    }

    public void setLegMode(MxNode legMode) {
        this.legMode = legMode;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getExOrdStatus() {
        return this.exOrdStatus;
    }

    @Override
    public void setExOrdStatus(String exOrdStatus) {
        this.exOrdStatus = exOrdStatus;
    }

    public String getClContractId() {
        return this.clContractId;
    }

    public void setClContractId(String clContractId) {
        this.clContractId = clContractId;
    }

    public String getAccName() {
        return this.accName;
    }

    public void setAccName(String accName) {
        this.accName = accName;
    }
}

