/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PAssetService;
import cms.tmx.datatype.message.PCtpExtra;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.trade.Deal;
import cms.tmx.javafx.MxNode;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CtpDeal
extends Deal {
    private MxNode ocFlag;
    private MxNode shFlag;
    private String portfolioId = "";
    private String ordDate = "";
    private String summary = "";
    private String ordTime = "";
    private MxNode dealType;
    private String exOcFlag = "";
    private String exShFlag = "";
    private static final Logger logger = LogManager.getLogger(CtpDeal.class);

    @Override
    public void update(Object obj) {
        try {
            if (obj instanceof POrderService.Execution) {
                super.update(obj);
                POrderService.Execution en = (POrderService.Execution)POrderService.Execution.class.cast(obj);
                PCtpExtra.CTPExecution deal = (PCtpExtra.CTPExecution)en.getObject().unpack(PCtpExtra.CTPExecution.class);
                this.update(deal);
            } else if (obj instanceof CtpDeal) {
                super.update(obj);
                this.update((CtpDeal)((Object)CtpDeal.class.cast(obj)));
            } else if (obj instanceof PAssetService.ExecutionsCollect) {
                PAssetService.ExecutionsCollect deal = (PAssetService.ExecutionsCollect)PAssetService.ExecutionsCollect.class.cast(obj);
                super.update((Object)deal);
                this.update(deal);
            }
        }
        catch (InvalidProtocolBufferException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void update(PCtpExtra.CTPExecution deal) {
        this.getOcFlag().setRaw(String.valueOf(deal.getOcFlag()));
        this.getShFlag().setRaw(String.valueOf(deal.getShFlag()));
        this.setPortfolioId(deal.getPortfolioId());
        this.setOrdDate(deal.getOrdDate());
        this.setSummary(deal.getSummary());
        this.setOrdTime(deal.getOrdTime());
        String ordDateTime = this.getOrdDateTime();
        if (deal.getOrdTime().contains(".")) {
            ordDateTime = String.valueOf(ordDateTime) + deal.getOrdTime().substring(deal.getOrdTime().indexOf("."));
        }
        this.setOrdDateTime(ordDateTime);
        if (deal.getDiffTimeMs() > 1000) {
            this.getDealType().setRaw("2");
        } else {
            this.getDealType().setRaw("1");
        }
        this.setExOcFlag(this.getOcFlag().getValue());
        this.setExShFlag(this.getShFlag().getValue());
    }

    private void update(CtpDeal deal) {
        this.setOcFlag(deal.getOcFlag());
        this.setShFlag(deal.getShFlag());
        this.setPortfolioId(deal.getPortfolioId());
        this.setOrdDate(deal.getOrdDate());
        this.setSummary(deal.getSummary());
        this.setOrdTime(deal.getOrdTime());
        this.setDealType(deal.getDealType());
        this.setExOcFlag(deal.getExOcFlag());
        this.setExShFlag(deal.getExShFlag());
    }

    private void update(PAssetService.ExecutionsCollect deal) {
        this.getOcFlag().setRaw(String.valueOf(deal.getOcFlag()));
        this.getShFlag().setRaw(String.valueOf(deal.getShFlag()));
        this.setExOcFlag(this.getOcFlag().getValue());
        this.setExShFlag(this.getShFlag().getValue());
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public String getOrdDate() {
        return this.ordDate;
    }

    public void setOrdDate(String orderDate) {
        this.ordDate = orderDate;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getExOcFlag() {
        return this.exOcFlag;
    }

    public void setExOcFlag(String exOcFlag) {
        this.exOcFlag = exOcFlag;
    }

    public String getExShFlag() {
        return this.exShFlag;
    }

    public void setExShFlag(String exShFlag) {
        this.exShFlag = exShFlag;
    }

    public MxNode getOcFlag() {
        return this.ocFlag;
    }

    public void setOcFlag(MxNode ocFlag) {
        this.ocFlag = ocFlag;
    }

    public MxNode getShFlag() {
        return this.shFlag;
    }

    public void setShFlag(MxNode shFlag) {
        this.shFlag = shFlag;
    }

    public String getOrdTime() {
        return this.ordTime;
    }

    public void setOrdTime(String ordTime) {
        this.ordTime = ordTime;
    }

    public MxNode getDealType() {
        return this.dealType;
    }

    public void setDealType(MxNode dealType) {
        this.dealType = dealType;
    }
}

