/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgSelObj;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CrossOrder
extends MxChgSelObj
implements Comparable<Object> {
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty instName = new SimpleStringProperty("");
    private StringProperty type = new SimpleStringProperty("");
    private StringProperty id = new SimpleStringProperty("");
    private StringProperty source = new SimpleStringProperty("");
    private StringProperty clCrossId = new SimpleStringProperty("");
    private IntegerProperty crossType = new SimpleIntegerProperty();
    private StringProperty accntId = new SimpleStringProperty("");
    private StringProperty secAccntId = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty inverstorSecId = new SimpleStringProperty("");
    private IntegerProperty ordStatus = new SimpleIntegerProperty();
    private StringProperty legStatus = new SimpleStringProperty("");
    private StringProperty modeType = new SimpleStringProperty("");
    private IntegerProperty modeAutoId = new SimpleIntegerProperty();
    private StringProperty ordTime = new SimpleStringProperty("");
    private StringProperty ordDate = new SimpleStringProperty("");
    private IntegerProperty ordType = new SimpleIntegerProperty();
    private IntegerProperty sortNum = new SimpleIntegerProperty();
    private DoubleProperty price = new SimpleDoubleProperty();
    private StringProperty user = new SimpleStringProperty("");
    private String exLegStatus;
    private String exOrdStatus;
    private ObjectProperty<MxNode> firstOrdStatus = new SimpleObjectProperty();
    private ObjectProperty<MxNode> secondOrdStatus = new SimpleObjectProperty();

    public void update(Object obj) {
        if (obj instanceof POrderService.CrossOrder) {
            POrderService.CrossOrder cOrder = (POrderService.CrossOrder)POrderService.CrossOrder.class.cast(obj);
            this.update(cOrder);
            this.changed();
        } else if (obj instanceof CrossOrder) {
            CrossOrder order = (CrossOrder)CrossOrder.class.cast(obj);
            this.update(order);
        }
    }

    private void update(POrderService.CrossOrder order) {
        this.setMarket(order.getInstrument().getMarket());
        this.setCode(order.getInstrument().getSecurityId());
        this.setInstName(order.getInstrument().getSymbol());
        this.setType(order.getInstrument().getSecurityType());
        this.setId(order.getCrossId());
        this.setSource(order.getExecMode().getEmName());
        if (order.getExecMode().getEmType() == PField.ExecModeType.EXEC_MODE_TYPE_MANUAL) {
            this.setModeType("EXEC_MODE_TYPE_MANUAL");
        } else if (order.getExecMode().getEmType() == PField.ExecModeType.EXEC_MODE_TYPE_MARKETMAKING) {
            this.setModeType("EXEC_MODE_TYPE_MARKETMAKING");
        }
        if (this.getLeg(order.getOrdStatus()).equals("leg_pending")) {
            this.setSortNum(1);
        } else if (this.getLeg(order.getOrdStatus()).equals("leg_over")) {
            this.setSortNum(2);
        }
        this.setLegStatus(this.getLeg(order.getOrdStatus()));
        this.setClCrossId(order.getClCrossId());
        this.setCrossType(order.getCrossType());
        this.setOrdTime(order.getOrdTime());
        this.setOrdDate(order.getOrdDate());
        this.setAccntId(order.getExtAccntId());
        this.setSecAccntId(order.getExtSecAccntId());
        this.setOrdStatus(order.getOrdStatus());
        this.setOrdType(order.getOrdType());
        this.setPrice(order.getPrice());
        this.setUser(order.getUserId());
        this.setModeAutoId(order.getExecMode().getEmId());
        if (this.getLegStatus().equals("leg_pending")) {
            this.setExLegStatus("\u6709\u6548\u72b6\u6001");
        } else if (this.getLegStatus().equals("leg_over")) {
            this.setExLegStatus("\u5b8c\u7ed3\u72b6\u6001");
        }
        this.getFirstOrdStatus().setRaw(String.valueOf(this.getFirstLeg(this.getOrdStatus())));
        this.getSecondOrdStatus().setRaw(String.valueOf(this.getSecondLeg(this.getOrdStatus())));
        this.setExOrdStatus("\u4e70\u5355" + this.getFirstOrdStatus().getValue() + "\uff0c\u5356\u5355" + this.getSecondOrdStatus().getValue());
    }

    private void update(CrossOrder order) {
        this.setMarket(order.getMarket());
        this.setCode(order.getCode());
        this.setInstName(order.getInstName());
        this.setType(order.getType());
        this.setId(order.getId());
        this.setSource(order.getSource());
        this.setModeType(order.getModeType());
        this.setSortNum(order.getSortNum());
        this.setLegStatus(this.getLeg(order.getOrdStatus()));
        this.setClCrossId(order.getClCrossId());
        this.setCrossType(order.getCrossType());
        this.setOrdTime(order.getOrdTime());
        this.setOrdDate(order.getOrdDate());
        this.setAccntId(order.getAccntId());
        this.setSecAccntId(order.getSecAccntId());
        this.setInvestorId(order.getInvestorId());
        this.setInverstorSecId(order.getInverstorSecId());
        this.setOrdStatus(order.getOrdStatus());
        this.setOrdType(order.getOrdType());
        this.setPrice(order.getPrice());
        this.setUser(order.getUser());
        this.setModeAutoId(order.getModeAutoId());
        if (this.getLegStatus().equals("leg_pending")) {
            this.setExLegStatus("\u6709\u6548\u72b6\u6001");
        } else if (this.getLegStatus().equals("leg_over")) {
            this.setExLegStatus("\u5b8c\u7ed3\u72b6\u6001");
        }
        this.setFirstOrdStatus(order.getFirstOrdStatus());
        this.setSecondOrdStatus(order.getSecondOrdStatus());
        this.setExOrdStatus("\u4e70\u5355" + order.getFirstOrdStatus().getValue() + "\uff0c\u5356\u5355" + order.getSecondOrdStatus().getValue());
    }

    private String getLeg(int crossOrderStatus) {
        boolean flag;
        boolean bl = flag = this.legCanBeCancel(this.getFirstLeg(crossOrderStatus)) && this.legCanBeCancel(this.getSecondLeg(crossOrderStatus));
        if (flag) {
            return "leg_over";
        }
        return "leg_pending";
    }

    private int getFirstLeg(int crossOrderStatus) {
        int firstLegStatus = crossOrderStatus / 100;
        return firstLegStatus;
    }

    private int getSecondLeg(int crossOrderStatus) {
        int secondLegStatus = crossOrderStatus % 100;
        return secondLegStatus;
    }

    private boolean legCanBeCancel(int legOrderStatus) {
        return legOrderStatus == Integer.valueOf("50") || legOrderStatus == Integer.valueOf("56") || legOrderStatus == Integer.valueOf("52") || legOrderStatus == Integer.valueOf("70");
    }

    public String toString() {
        return (String)this.id.get();
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty codeProperty() {
        return this.code;
    }

    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public final StringProperty typeProperty() {
        return this.type;
    }

    public final String getType() {
        return (String)this.typeProperty().get();
    }

    public final void setType(String type) {
        this.typeProperty().set((Object)type);
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final String getId() {
        return (String)this.idProperty().get();
    }

    public final void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public final StringProperty clCrossIdProperty() {
        return this.clCrossId;
    }

    public final String getClCrossId() {
        return (String)this.clCrossIdProperty().get();
    }

    public final void setClCrossId(String clCrossId) {
        this.clCrossIdProperty().set((Object)clCrossId);
    }

    public final IntegerProperty crossTypeProperty() {
        return this.crossType;
    }

    public final int getCrossType() {
        return this.crossTypeProperty().get();
    }

    public final void setCrossType(int crossType) {
        this.crossTypeProperty().set(crossType);
    }

    public final StringProperty accntIdProperty() {
        return this.accntId;
    }

    public final String getAccntId() {
        return (String)this.accntIdProperty().get();
    }

    public final void setAccntId(String accntId) {
        this.accntIdProperty().set((Object)accntId);
    }

    public final StringProperty secAccntIdProperty() {
        return this.secAccntId;
    }

    public final String getSecAccntId() {
        return (String)this.secAccntIdProperty().get();
    }

    public final void setSecAccntId(String secAccntId) {
        this.secAccntIdProperty().set((Object)secAccntId);
    }

    public final IntegerProperty ordStatusProperty() {
        return this.ordStatus;
    }

    public final int getOrdStatus() {
        return this.ordStatusProperty().get();
    }

    public final void setOrdStatus(int ordStatus) {
        this.ordStatusProperty().set(ordStatus);
    }

    public final IntegerProperty ordTypeProperty() {
        return this.ordType;
    }

    public final int getOrdType() {
        return this.ordTypeProperty().get();
    }

    public final void setOrdType(int ordType) {
        this.ordTypeProperty().set(ordType);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final StringProperty userProperty() {
        return this.user;
    }

    public final String getUser() {
        return (String)this.userProperty().get();
    }

    public final void setUser(String user) {
        this.userProperty().set((Object)user);
    }

    public final StringProperty ordTimeProperty() {
        return this.ordTime;
    }

    public final String getOrdTime() {
        return (String)this.ordTimeProperty().get();
    }

    public final void setOrdTime(String ordTime) {
        this.ordTimeProperty().set((Object)ordTime);
    }

    public final StringProperty instNameProperty() {
        return this.instName;
    }

    public final String getInstName() {
        return (String)this.instNameProperty().get();
    }

    public final void setInstName(String instName) {
        this.instNameProperty().set((Object)instName);
    }

    public final StringProperty ordDateProperty() {
        return this.ordDate;
    }

    public final String getOrdDate() {
        return (String)this.ordDateProperty().get();
    }

    public final void setOrdDate(String ordDate) {
        this.ordDateProperty().set((Object)ordDate);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id.get() == null ? 0 : ((String)this.id.get()).hashCode());
        result = 31 * result + (this.ordDate.get() == null ? 0 : ((String)this.ordDate.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CrossOrder other = (CrossOrder)obj;
        if (this.id.get() == null ? other.id.get() != null : !((String)this.id.get()).equals(other.id.get())) {
            return false;
        }
        return !(this.ordDate.get() == null ? other.ordDate.get() != null : !((String)this.ordDate.get()).equals(other.ordDate.get()));
    }

    public final StringProperty sourceProperty() {
        return this.source;
    }

    public final String getSource() {
        return (String)this.sourceProperty().get();
    }

    public final void setSource(String source) {
        this.sourceProperty().set((Object)source);
    }

    public final StringProperty modeTypeProperty() {
        return this.modeType;
    }

    public final String getModeType() {
        return (String)this.modeTypeProperty().get();
    }

    public final void setModeType(String modeType) {
        this.modeTypeProperty().set((Object)modeType);
    }

    public final StringProperty legStatusProperty() {
        return this.legStatus;
    }

    public final String getLegStatus() {
        return (String)this.legStatusProperty().get();
    }

    public final void setLegStatus(String legStatus) {
        this.legStatusProperty().set((Object)legStatus);
    }

    public final IntegerProperty sortNumProperty() {
        return this.sortNum;
    }

    public final int getSortNum() {
        return this.sortNumProperty().get();
    }

    public final void setSortNum(int sortNum) {
        this.sortNumProperty().set(sortNum);
    }

    @Override
    public int compareTo(Object o) {
        CrossOrder u;
        if (this == o) {
            return 0;
        }
        if (o != null && o instanceof CrossOrder && (u = (CrossOrder)o).getSortNum() < this.getSortNum()) {
            return 1;
        }
        return -1;
    }

    public final IntegerProperty modeAutoIdProperty() {
        return this.modeAutoId;
    }

    public final int getModeAutoId() {
        return this.modeAutoIdProperty().get();
    }

    public final void setModeAutoId(int modeAutoId) {
        this.modeAutoIdProperty().set(modeAutoId);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty inverstorSecIdProperty() {
        return this.inverstorSecId;
    }

    public final String getInverstorSecId() {
        return (String)this.inverstorSecIdProperty().get();
    }

    public final void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecIdProperty().set((Object)inverstorSecId);
    }

    public String getExLegStatus() {
        return this.exLegStatus;
    }

    public void setExLegStatus(String exLegStatus) {
        this.exLegStatus = exLegStatus;
    }

    public String getExOrdStatus() {
        return this.exOrdStatus;
    }

    public void setExOrdStatus(String exOrdStatus) {
        this.exOrdStatus = exOrdStatus;
    }

    public final ObjectProperty<MxNode> firstOrdStatusProperty() {
        return this.firstOrdStatus;
    }

    public final MxNode getFirstOrdStatus() {
        return (MxNode)this.firstOrdStatusProperty().get();
    }

    public final void setFirstOrdStatus(MxNode firstOrdStatus) {
        this.firstOrdStatusProperty().set((Object)firstOrdStatus);
    }

    public final ObjectProperty<MxNode> secondOrdStatusProperty() {
        return this.secondOrdStatus;
    }

    public final MxNode getSecondOrdStatus() {
        return (MxNode)this.secondOrdStatusProperty().get();
    }

    public final void setSecondOrdStatus(MxNode secondOrdStatus) {
        this.secondOrdStatusProperty().set((Object)secondOrdStatus);
    }
}

