/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PCcsRefdata;
import cms.tmx.datatype.message.PRefData;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.data.IssueInfo;
import com.google.protobuf.Any;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConvertibleBond
extends RefItem {
    private static final Logger logger = LogManager.getLogger(ConvertibleBond.class);
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty type = new SimpleStringProperty("");
    private StringProperty subType = new SimpleStringProperty("");
    private DoubleProperty subPrice = new SimpleDoubleProperty(0.0);
    private StringProperty secCode = new SimpleStringProperty("");
    private StringProperty secName = new SimpleStringProperty("");
    private DoubleProperty outstandingShare = new SimpleDoubleProperty(0.0);
    private DoubleProperty priceUpperLimit = new SimpleDoubleProperty(0.0);
    private DoubleProperty priceLowerLimit = new SimpleDoubleProperty(0.0);
    private DoubleProperty tradeUnit = new SimpleDoubleProperty(0.0);
    private DoubleProperty qtyUpperLimit = new SimpleDoubleProperty(0.0);
    private DoubleProperty qtyLowerLimit = new SimpleDoubleProperty(0.0);
    private StringProperty startDate = new SimpleStringProperty("");
    private StringProperty endDate = new SimpleStringProperty("");
    private DoubleProperty subLine = new SimpleDoubleProperty(0.0);

    @Override
    public void update(Object obj) {
        super.update(obj);
        try {
            if (obj instanceof PRefData.SecListItem) {
                PRefData.SecListItem refData = (PRefData.SecListItem)PRefData.SecListItem.class.cast(obj);
                Any any = refData.getObject();
                if (any.is(PCcsRefdata.IssueInfo.class)) {
                    PCcsRefdata.IssueInfo bond = (PCcsRefdata.IssueInfo)any.unpack(PCcsRefdata.IssueInfo.class);
                    this.updateBond(bond);
                    this.changed();
                }
            } else if (obj instanceof IssueInfo) {
                this.update((IssueInfo)IssueInfo.class.cast(obj));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private void updateBond(PCcsRefdata.IssueInfo bond) {
        this.setCode(bond.getSecurityId());
        this.setName(bond.getSecurityName());
        this.setMarket(bond.getMarket());
        this.setType(bond.getSecurityType());
        this.setSubType(bond.getSecuritySubType());
        this.setSubSecurityType(bond.getSecuritySubType());
        this.setSubPrice(Double.valueOf(String.format("%.4f", bond.getSubscriptionPrice())));
        this.setSecCode(bond.getProductSecurityId());
        this.setSecName(bond.getProductSecurityName());
        this.setOutstandingShare(bond.getOutstandingShare());
        this.setPriceUpperLimit(bond.getPriceUpperLimit());
        this.setPriceLowerLimit(bond.getPriceLowerLimit());
        this.setTradeUnit(bond.getTradeUnit());
        this.setQtyUpperLimit(bond.getQtyUpperLimit());
        this.setQtyLowerLimit(bond.getQtyLowerLimit());
        this.setStartDate(bond.getStartDate());
        this.setEndDate(bond.getEndDate());
        this.setNoProfit(bond.getNoProfit());
        this.setWeightedVotingRights(bond.getWeightedVotingRights());
        this.setIsVIE(bond.getIsVIE());
        this.setIsRegistration(bond.getIsRegistration());
    }

    public void update(IssueInfo info) {
        if (info.getSecurity() != null) {
            this.setCode(info.getSecurity().getInstrument().getSecurityId());
            this.setName(info.getSecurity().getInstrument().getSymbol());
            this.setMarket(info.getSecurity().getInstrument().getMarket());
            this.setType(info.getSecurity().getInstrument().getSecurityType());
            this.setSubType(info.getSecurity().getInstrument().getSecuritySubType());
            this.setSubType(info.getSecurity().getInstrument().getSecuritySubType());
            this.setSubSecurityType(info.getSecurity().getInstrument().getSecuritySubType());
        }
        if (info.getParams() != null) {
            this.setSecCode(info.getParams().getUnderlying().getSecurityId());
            this.setSecName(info.getParams().getUnderlying().getSymbol());
            this.setOutstandingShare(info.getParams().getOutstandingShare());
            this.setPriceUpperLimit(info.getParams().getPriceUpperLimit());
            this.setPriceLowerLimit(info.getParams().getPriceLowerLimit());
            this.setQtyUpperLimit(info.getParams().getQtyUpperLimit());
            this.setQtyLowerLimit(info.getParams().getQtyLowerLimit());
            this.setStartDate(info.getParams().getStartDate());
            this.setEndDate(info.getParams().getEndDate());
            this.setSubPrice(Double.valueOf(String.format("%.4f", info.getParams().getIssuePrice())));
            this.setTradeUnit(info.getParams().getTradeUnit());
        }
    }

    @Override
    public boolean isGem() {
        return "XSHE".equals(this.market.get()) && ((String)this.code.get()).startsWith("30");
    }

    @Override
    public final StringProperty codeProperty() {
        return this.code;
    }

    @Override
    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    @Override
    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    @Override
    public final StringProperty nameProperty() {
        return this.name;
    }

    @Override
    public final String getName() {
        return (String)this.nameProperty().get();
    }

    @Override
    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty typeProperty() {
        return this.type;
    }

    @Override
    public final String getType() {
        return (String)this.typeProperty().get();
    }

    @Override
    public final void setType(String type) {
        this.typeProperty().set((Object)type);
    }

    public final DoubleProperty subPriceProperty() {
        return this.subPrice;
    }

    public final double getSubPrice() {
        return this.subPriceProperty().get();
    }

    public final void setSubPrice(double subPrice) {
        this.subPriceProperty().set(subPrice);
    }

    public final StringProperty secCodeProperty() {
        return this.secCode;
    }

    public final String getSecCode() {
        return (String)this.secCodeProperty().get();
    }

    public final void setSecCode(String secCode) {
        this.secCodeProperty().set((Object)secCode);
    }

    public final DoubleProperty outstandingShareProperty() {
        return this.outstandingShare;
    }

    public final double getOutstandingShare() {
        return this.outstandingShareProperty().get();
    }

    public final void setOutstandingShare(double outstandingShare) {
        this.outstandingShareProperty().set(outstandingShare);
    }

    public final DoubleProperty priceUpperLimitProperty() {
        return this.priceUpperLimit;
    }

    public final double getPriceUpperLimit() {
        return this.priceUpperLimitProperty().get();
    }

    public final void setPriceUpperLimit(double priceUpperLimit) {
        this.priceUpperLimitProperty().set(priceUpperLimit);
    }

    public final DoubleProperty priceLowerLimitProperty() {
        return this.priceLowerLimit;
    }

    public final double getPriceLowerLimit() {
        return this.priceLowerLimitProperty().get();
    }

    public final void setPriceLowerLimit(double priceLowerLimit) {
        this.priceLowerLimitProperty().set(priceLowerLimit);
    }

    public final DoubleProperty tradeUnitProperty() {
        return this.tradeUnit;
    }

    @Override
    public final double getTradeUnit() {
        return this.tradeUnitProperty().get();
    }

    @Override
    public final void setTradeUnit(double tradeUnit) {
        this.tradeUnitProperty().set(tradeUnit);
    }

    public final DoubleProperty qtyUpperLimitProperty() {
        return this.qtyUpperLimit;
    }

    public final double getQtyUpperLimit() {
        return this.qtyUpperLimitProperty().get();
    }

    public final void setQtyUpperLimit(double qtyUpperLimit) {
        this.qtyUpperLimitProperty().set(qtyUpperLimit);
    }

    public final DoubleProperty qtyLowerLimitProperty() {
        return this.qtyLowerLimit;
    }

    public final double getQtyLowerLimit() {
        return this.qtyLowerLimitProperty().get();
    }

    public final void setQtyLowerLimit(double qtyLowerLimit) {
        this.qtyLowerLimitProperty().set(qtyLowerLimit);
    }

    public final StringProperty startDateProperty() {
        return this.startDate;
    }

    public final String getStartDate() {
        return (String)this.startDateProperty().get();
    }

    public final void setStartDate(String startDate) {
        this.startDateProperty().set((Object)startDate);
    }

    public final StringProperty endDateProperty() {
        return this.endDate;
    }

    public final String getEndDate() {
        return (String)this.endDateProperty().get();
    }

    public final void setEndDate(String endDate) {
        this.endDateProperty().set((Object)endDate);
    }

    public final StringProperty subTypeProperty() {
        return this.subType;
    }

    public final String getSubType() {
        return (String)this.subTypeProperty().get();
    }

    public final void setSubType(String subType) {
        this.subTypeProperty().set((Object)subType);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    @Override
    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    @Override
    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final DoubleProperty subLineProperty() {
        return this.subLine;
    }

    public final double getSubLine() {
        return this.subLineProperty().get();
    }

    public final void setSubLine(double subLine) {
        this.subLineProperty().set(subLine);
    }

    public final StringProperty secNameProperty() {
        return this.secName;
    }

    public final String getSecName() {
        return (String)this.secNameProperty().get();
    }

    public final void setSecName(String secName) {
        this.secNameProperty().set((Object)secName);
    }

    @Override
    public String toString() {
        return (String)this.code.get();
    }
}

