/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.http.api.Instrument;
import cms.tmx.http.futures.dto.FutureYtmCalcSetting;
import cms.tmx.http.security.dto.FutureInfo;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ConversionParam {
    private StringProperty contract = new SimpleStringProperty("");
    private ObjectProperty<Instrument> conSec = new SimpleObjectProperty();
    private ObjectProperty<Instrument> ctdSec = new SimpleObjectProperty();
    private ObjectProperty<List<Instrument>> listCtd = new SimpleObjectProperty(new LinkedList());
    private DoubleProperty costCapital = new SimpleDoubleProperty(0.0);

    public void update(Object obj) {
        if (obj instanceof FutureInfo) {
            this.update((FutureInfo)FutureInfo.class.cast(obj));
        } else if (obj instanceof FutureYtmCalcSetting) {
            this.update((FutureYtmCalcSetting)FutureYtmCalcSetting.class.cast(obj));
        }
    }

    public void update(FutureInfo info) {
        this.setContract(info.getSecurity().getInstrument().getSecurityId());
        this.setConSec(info.getSecurity().getInstrument());
        List listUly = info.getParams().getUnderlying();
        if (listUly != null) {
            listUly.forEach(underly -> {
                if ("XCFE".equals(underly.getInstrument().getMarket())) {
                    this.getListCtd().add(underly.getInstrument());
                }
            });
        }
    }

    public void update(FutureYtmCalcSetting ytm) {
        this.setConSec(ytm.getCtd());
        this.setCtdSec(ytm.getCtd());
        this.setCostCapital(ytm.getCapitalCost());
    }

    public final ObjectProperty<Instrument> ctdSecProperty() {
        return this.ctdSec;
    }

    public final Instrument getCtdSec() {
        return (Instrument)this.ctdSecProperty().get();
    }

    public final void setCtdSec(Instrument ctdSec) {
        this.ctdSecProperty().set((Object)ctdSec);
    }

    public final ObjectProperty<List<Instrument>> listCtdProperty() {
        return this.listCtd;
    }

    public final List<Instrument> getListCtd() {
        return (List)this.listCtdProperty().get();
    }

    public final void setListCtd(List<Instrument> listCtd) {
        this.listCtdProperty().set(listCtd);
    }

    public final DoubleProperty costCapitalProperty() {
        return this.costCapital;
    }

    public final double getCostCapital() {
        return this.costCapitalProperty().get();
    }

    public final void setCostCapital(double costCapital) {
        this.costCapitalProperty().set(costCapital);
    }

    public final StringProperty contractProperty() {
        return this.contract;
    }

    public final String getContract() {
        return (String)this.contractProperty().get();
    }

    public final void setContract(String contract) {
        this.contractProperty().set((Object)contract);
    }

    public final ObjectProperty<Instrument> conSecProperty() {
        return this.conSec;
    }

    public final Instrument getConSec() {
        return (Instrument)this.conSecProperty().get();
    }

    public final void setConSec(Instrument conSec) {
        this.conSecProperty().set((Object)conSec);
    }
}

