/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.entity.data.RefItem;
import cms.tmx.http.condition.dto.CondOrderWithAccnt;
import cms.tmx.http.condition.dto.ConditionalOrder;
import cms.tmx.http.condition.dto.ConditionalOrderEvent;
import cms.tmx.http.condition.dto.PriceCondition;
import cms.tmx.http.condition.dto.PriceLevel;
import cms.tmx.http.condition.dto.TimeCondition;
import cms.tmx.http.condition.dto.TriggerLeg;
import cms.tmx.http.query.Condition;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class Condition
extends MxObject {
    private BooleanProperty selected = new SimpleBooleanProperty(false);
    private StringProperty condOrdId = new SimpleStringProperty("");
    private StringProperty entrustId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> type = new SimpleObjectProperty();
    private StringProperty triggerCond = new SimpleStringProperty("");
    private ObjectProperty<MxNode> status = new SimpleObjectProperty();
    private StringProperty secId = new SimpleStringProperty("");
    private StringProperty secName = new SimpleStringProperty("");
    private String secType = "";
    private String market = "";
    private ObjectProperty<MxNode> side = new SimpleObjectProperty();
    private StringProperty expireDate = new SimpleStringProperty("");
    private StringProperty commitDate = new SimpleStringProperty("");
    private StringProperty execDate = new SimpleStringProperty("");
    private StringProperty ordPrice = new SimpleStringProperty("");
    private StringProperty ordCount = new SimpleStringProperty("");
    private StringProperty unit = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty investorSecId = new SimpleStringProperty("");
    private StringProperty remark = new SimpleStringProperty("");
    private String extAccntId = "";
    private String extSecAccntId = "";
    private MxNode condJudge;
    private MxNode condTrigger;
    private MxNode priceStg;
    private RefItem refItem;

    public Condition() {
        MxNode node = MxNodeFactory.create((String)"condition_type");
        this.setType(node);
        node = MxNodeFactory.create((String)"condition_status");
        this.setStatus(node);
        node = MxNodeFactory.create((String)"condition_side");
        this.setSide(node);
        this.condTrigger = node = MxNodeFactory.create((String)"trigger_condition");
        this.condJudge = node = MxNodeFactory.create((String)"condition_judge");
        node = MxNodeFactory.create((String)"condition_price", (String)"11");
        this.setPriceStg(node);
    }

    public void update(Object obj) {
        if (obj instanceof Condition) {
            this.update((Condition)((Object)Condition.class.cast(obj)));
        } else if (obj instanceof CondOrderWithAccnt) {
            this.update((CondOrderWithAccnt)CondOrderWithAccnt.class.cast(obj));
        } else if (obj instanceof ConditionalOrderEvent) {
            this.update((ConditionalOrderEvent)ConditionalOrderEvent.class.cast(obj));
        }
    }

    private void update(Condition cond) {
        this.setSelected(cond.isSelected());
        this.setCondOrdId(cond.getCondOrdId());
        this.setEntrustId(cond.getEntrustId());
        this.getType().setRaw(cond.getType().getRaw());
        this.setTriggerCond(cond.getTriggerCond());
        this.getStatus().setRaw(cond.getStatus().getRaw());
        this.setSecId(cond.getSecId());
        this.setSecName(cond.getSecName());
        this.getSide().setRaw(cond.getSide().getRaw());
        this.setExpireDate(cond.getExpireDate());
        this.setCommitDate(cond.getCommitDate());
        this.setExecDate(cond.getExecDate());
        this.setOrdPrice(cond.getOrdPrice());
        this.setOrdCount(cond.getOrdCount());
        this.setUnit(cond.getUnit());
    }

    private void update(CondOrderWithAccnt cond) {
        this.setExtAccntId(cond.getExtCashAccntId());
        this.setExtSecAccntId(cond.getExtSecAccntId());
        ConditionalOrder order = cond.getOrder();
        this.setCondOrdId(order.getCondOrdId());
        this.getType().setRaw(String.valueOf(order.getCondType().getValue()));
        this.setTriggerCond(this.parseTriggerCond(order));
        this.getStatus().setRaw(String.valueOf(order.getStatus().getValue()));
        this.setSecId(order.getInstrument().getSecurityId());
        this.setSecName(order.getInstrument().getSymbol());
        this.setSecType(order.getInstrument().getSecurityType());
        this.setMarket(order.getInstrument().getMarket());
        if (order.getSide() != null) {
            this.getSide().setRaw(String.valueOf(order.getSide().getValue()));
        }
        this.setExpireDate(order.getExpireDate());
        this.setCommitDate(String.valueOf(order.getCommitDate()) + " " + order.getCommitTime());
        if (order.getLeg() != null && order.getLeg().size() > 0) {
            TriggerLeg leg = (TriggerLeg)order.getLeg().get(0);
            this.setEntrustId(leg.getLegId());
            this.setOrdPrice(StringUtils.toStr((double)leg.getPrice(), (int)this.getScale()));
            this.setOrdCount(StringUtils.toThousands((Number)leg.getQty()));
            this.setExecDate(String.valueOf(leg.getTriggerDate()) + " " + leg.getTriggerTime());
            this.setRemark(leg.getErrInfo());
        }
    }

    private int getScale() {
        return this.refItem == null ? 3 : this.refItem.getScale();
    }

    private void update(ConditionalOrderEvent order) {
        TriggerLeg leg = order.getLeg();
        this.setEntrustId(leg.getLegId());
        if (leg.getPrice() != 0.0) {
            this.setOrdPrice(String.valueOf(leg.getPrice()));
        }
        if (leg.getQty() != 0.0) {
            this.setOrdCount(StringUtils.toThousands((Number)leg.getQty()));
        }
        this.getStatus().setRaw(String.valueOf(order.getStatus().getValue()));
        if (leg.getTriggerDate() != null && leg.getTriggerTime() != null) {
            this.setExecDate(String.valueOf(leg.getTriggerDate()) + " " + leg.getTriggerTime());
        }
        this.setRemark(leg.getErrInfo());
    }

    private String parseTriggerCond(ConditionalOrder order) {
        StringBuffer triggerCond = new StringBuffer();
        if ("2".equals(this.getType().getRaw())) {
            PriceCondition priceCond = order.getPriceCond();
            this.condTrigger.setRaw(String.valueOf(priceCond.getType().getValue()));
            String trigger = this.condTrigger.getValue();
            this.condJudge.setRaw(this.getJudge(priceCond.getCond().getOp()));
            String judge = this.condJudge.getValue();
            String price = StringUtils.toThousands((Number)priceCond.getCond().getDoubleVal(), (int)this.getScale());
            triggerCond.append(trigger).append(judge).append(price);
        } else {
            TimeCondition timeCond = order.getTimeCond();
            triggerCond.append(timeCond.getExecTime());
        }
        triggerCond.append("\uff0c");
        if (order.getPriceLevel() != 0) {
            this.priceStg.setRaw(this.parsePriceLevel(order.getPriceLevel()));
            triggerCond.append(this.priceStg.getValue()).append("\uff0c\u6d6e\u52a8").append(order.getFloatRatio()).append("%");
        } else {
            triggerCond.append(this.priceStg.getValue()).append("\uff0c").append(StringUtils.toStr((double)order.getPrice(), (int)this.getScale()));
        }
        triggerCond.append("\uff0c").append((int)order.getOrderQty());
        return triggerCond.toString();
    }

    private String getJudge(Condition.OP op) {
        switch (op) {
            case EQ: {
                return "6";
            }
            case GT: {
                return "1";
            }
            case GE: {
                return "2";
            }
            case LT: {
                return "3";
            }
            case LE: {
                return "4";
            }
        }
        return null;
    }

    private String parsePriceLevel(int level) {
        if (PriceLevel.PRICE_LAST_PRICE.getValue() == level) {
            return "0";
        }
        if (PriceLevel.PRICE_MAX.getValue() == level) {
            return "100";
        }
        if (PriceLevel.PRICE_MIN.getValue() == level) {
            return "99";
        }
        if (PriceLevel.PRICE_BUY_1.getValue() == level) {
            return "1";
        }
        if (PriceLevel.PRICE_BUY_2.getValue() == level) {
            return "2";
        }
        if (PriceLevel.PRICE_BUY_3.getValue() == level) {
            return "3";
        }
        if (PriceLevel.PRICE_BUY_4.getValue() == level) {
            return "4";
        }
        if (PriceLevel.PRICE_BUY_5.getValue() == level) {
            return "5";
        }
        if (PriceLevel.PRICE_SELL_1.getValue() == level) {
            return "-1";
        }
        if (PriceLevel.PRICE_SELL_2.getValue() == level) {
            return "-2";
        }
        if (PriceLevel.PRICE_SELL_3.getValue() == level) {
            return "-3";
        }
        if (PriceLevel.PRICE_SELL_4.getValue() == level) {
            return "-4";
        }
        if (PriceLevel.PRICE_SELL_5.getValue() == level) {
            return "-5";
        }
        return "";
    }

    public boolean canOperation() {
        switch (this.getStatus().getRaw()) {
            case "3": 
            case "4": 
            case "5": {
                return false;
            }
        }
        return true;
    }

    public final ObjectProperty<MxNode> typeProperty() {
        return this.type;
    }

    public final MxNode getType() {
        return (MxNode)this.typeProperty().get();
    }

    public final void setType(MxNode type) {
        this.typeProperty().set((Object)type);
    }

    public final StringProperty secIdProperty() {
        return this.secId;
    }

    public final String getSecId() {
        return (String)this.secIdProperty().get();
    }

    public final void setSecId(String secId) {
        this.secIdProperty().set((Object)secId);
    }

    public final StringProperty secNameProperty() {
        return this.secName;
    }

    public final String getSecName() {
        return (String)this.secNameProperty().get();
    }

    public final void setSecName(String secName) {
        this.secNameProperty().set((Object)secName);
    }

    public final StringProperty expireDateProperty() {
        return this.expireDate;
    }

    public final String getExpireDate() {
        return (String)this.expireDateProperty().get();
    }

    public final void setExpireDate(String expireDate) {
        this.expireDateProperty().set((Object)expireDate);
    }

    public final StringProperty commitDateProperty() {
        return this.commitDate;
    }

    public final String getCommitDate() {
        return (String)this.commitDateProperty().get();
    }

    public final void setCommitDate(String commitDate) {
        this.commitDateProperty().set((Object)commitDate);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty investorSecIdProperty() {
        return this.investorSecId;
    }

    public final String getInvestorSecId() {
        return (String)this.investorSecIdProperty().get();
    }

    public final void setInvestorSecId(String investorSecId) {
        this.investorSecIdProperty().set((Object)investorSecId);
    }

    public final StringProperty ordPriceProperty() {
        return this.ordPrice;
    }

    public final String getOrdPrice() {
        return (String)this.ordPriceProperty().get();
    }

    public final void setOrdPrice(String ordPrice) {
        this.ordPriceProperty().set((Object)ordPrice);
    }

    public final StringProperty ordCountProperty() {
        return this.ordCount;
    }

    public final String getOrdCount() {
        return (String)this.ordCountProperty().get();
    }

    public final void setOrdCount(String ordCount) {
        this.ordCountProperty().set((Object)ordCount);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final BooleanProperty selectedProperty() {
        return this.selected;
    }

    public final boolean isSelected() {
        return this.selectedProperty().get();
    }

    public final void setSelected(boolean selected) {
        this.selectedProperty().set(selected);
    }

    public final StringProperty triggerCondProperty() {
        return this.triggerCond;
    }

    public final String getTriggerCond() {
        return (String)this.triggerCondProperty().get();
    }

    public final void setTriggerCond(String triggerCond) {
        this.triggerCondProperty().set((Object)triggerCond);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public MxNode getPriceStg() {
        return this.priceStg;
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStg = priceStg;
    }

    public final StringProperty execDateProperty() {
        return this.execDate;
    }

    public final String getExecDate() {
        return (String)this.execDateProperty().get();
    }

    public final void setExecDate(String execData) {
        this.execDateProperty().set((Object)execData);
    }

    public final StringProperty condOrdIdProperty() {
        return this.condOrdId;
    }

    public final String getCondOrdId() {
        return (String)this.condOrdIdProperty().get();
    }

    public final void setCondOrdId(String condOrdId) {
        this.condOrdIdProperty().set((Object)condOrdId);
    }

    public final StringProperty entrustIdProperty() {
        return this.entrustId;
    }

    public final String getEntrustId() {
        return (String)this.entrustIdProperty().get();
    }

    public final void setEntrustId(String entrustId) {
        this.entrustIdProperty().set((Object)entrustId);
    }

    public final StringProperty remarkProperty() {
        return this.remark;
    }

    public final String getRemark() {
        return (String)this.remarkProperty().get();
    }

    public final void setRemark(String remark) {
        this.remarkProperty().set((Object)remark);
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final String getUnit() {
        return (String)this.unitProperty().get();
    }

    public final void setUnit(String unit) {
        this.unitProperty().set((Object)unit);
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }
}

