/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.entity.factory.LegStipulationFactory;
import cms.tmx.entity.trade.LegStipulation;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import java.text.DecimalFormat;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CfetsLeg
extends MxObject {
    private ObservableList<LegStipulation> legStipulationList = FxUtils.newList();
    private StringProperty legSecurityID = new SimpleStringProperty("");
    private ObjectProperty<MxNode> legSide = new SimpleObjectProperty();
    private DoubleProperty legPrice = new SimpleDoubleProperty(0.0);
    private DoubleProperty legDirtyPrice = new SimpleDoubleProperty(0.0);
    private DoubleProperty legAccruedInterestAmt = new SimpleDoubleProperty(0.0);
    private IntegerProperty legOrderQty = new SimpleIntegerProperty(0);
    private DoubleProperty legTradeCashAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty legAccruedInterestTotalAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty legSettlCurrAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty legSettlCurrFxRate = new SimpleDoubleProperty(0.0);
    private ObjectProperty<MxNode> legClearingMethod = new SimpleObjectProperty();
    private ObjectProperty<MxNode> legSettlType = new SimpleObjectProperty();
    private StringProperty legSettlDate = new SimpleStringProperty("");
    private StringProperty legPrincipal = new SimpleStringProperty("");
    private StringProperty legTotalPrincipal = new SimpleStringProperty("");
    private DoubleProperty legLeaveQty = new SimpleDoubleProperty(0.0);
    @Inject
    private MObjFactory of;
    @Inject
    private LegStipulationFactory lsf;
    private static MxNode legSideNode;
    private static MxNode legClearingMethodNode;
    private static MxNode legSettlTypeNode;

    public LegStipulationFactory getLsf() {
        return this.lsf;
    }

    public void setLsf(LegStipulationFactory lsf) {
        this.lsf = lsf;
    }

    @PostConstruct
    public void init() {
        if (legSideNode == null) {
            legSideNode = MxNodeFactory.create((String)"side", (String)"");
        }
        this.setLegSide(legSideNode.clone());
        if (legClearingMethodNode == null) {
            legClearingMethodNode = MxNodeFactory.create((String)"clearing_method", (String)"");
        }
        this.setLegClearingMethod(legClearingMethodNode.clone());
        if (legSettlTypeNode == null) {
            legSettlTypeNode = MxNodeFactory.create((String)"settl_type", (String)"");
        }
        this.setLegSettlType(legSettlTypeNode.clone());
    }

    public void update(Object obj) {
        if (obj instanceof PComponent.CfetsLeg) {
            PComponent.CfetsLeg en = (PComponent.CfetsLeg)PComponent.CfetsLeg.class.cast(obj);
            this.update(en);
        } else if (obj instanceof CfetsLeg) {
            CfetsLeg en = (CfetsLeg)((Object)CfetsLeg.class.cast(obj));
            this.update(en);
        }
    }

    private void update(PComponent.CfetsLeg en) {
        DecimalFormat dfTwo = new DecimalFormat("#0.00");
        DecimalFormat dfFour = new DecimalFormat("#0.0000");
        DecimalFormat dfFive = new DecimalFormat("#0.00000");
        for (PComponent.LegStipulation legStipulation : en.getLegStipulationsList()) {
            LegStipulation ls = this.lsf.create();
            ls.update((Object)legStipulation);
            this.legStipulationList.add((Object)ls);
        }
        this.setLegSecurityID(en.getLegSecurityID());
        this.getLegSide().setRaw(Integer.toString(en.getLegSide().getNumber()));
        this.setLegPrice(Double.valueOf(dfFour.format(en.getLegPrice())));
        this.setLegDirtyPrice(Double.valueOf(dfFour.format(en.getLegDirtyPrice())));
        this.setLegAccruedInterestAmt(Double.valueOf(dfFive.format(en.getLegAccruedInterestAmt())));
        this.setLegOrderQty(en.getLegOrderQty() / 10000);
        this.setLegTradeCashAmt(Double.valueOf(dfTwo.format(en.getLegTradeCashAmt() / 10000.0)));
        this.setLegAccruedInterestTotalAmt(Double.valueOf(dfTwo.format(en.getLegAccruedInterestTotalAmt())));
        this.setLegSettlCurrAmt(Double.valueOf(dfTwo.format(en.getLegSettlCurrAmt())));
        this.setLegSettlCurrFxRate(Double.valueOf(dfFour.format(en.getLegSettlCurrFxRate())));
        this.getLegClearingMethod().setRaw(Integer.toString(en.getLegClearingMethod().getNumber()));
        this.getLegSettlType().setRaw(Integer.toString(en.getLegSettlType().getNumber()));
        this.setLegSettlDate(en.getLegSettlDate());
        if (!"".equals(en.getLegPrincipal())) {
            this.setLegPrincipal(dfTwo.format(Double.valueOf(en.getLegPrincipal())));
        }
        this.setLegTotalPrincipal(dfTwo.format(Double.valueOf(en.getLegTotalPrincipal())));
        this.setLegLeaveQty(Double.valueOf(dfFour.format(en.getLegLeaveQty() / 10000)));
    }

    private void update(CfetsLeg en) {
        for (LegStipulation legStipulation : en.getLegStipulationList()) {
            this.legStipulationList.add((Object)legStipulation);
        }
        this.setLegSecurityID(en.getLegSecurityID());
        this.setLegSide(en.getLegSide());
        this.setLegPrice(en.getLegPrice());
        this.setLegDirtyPrice(en.getLegDirtyPrice());
        this.setLegAccruedInterestAmt(en.getLegAccruedInterestAmt());
        this.setLegOrderQty(en.getLegOrderQty());
        this.setLegTradeCashAmt(en.getLegTradeCashAmt());
        this.setLegAccruedInterestTotalAmt(en.getLegAccruedInterestTotalAmt());
        this.setLegSettlCurrAmt(en.getLegSettlCurrAmt());
        this.setLegSettlCurrFxRate(en.getLegSettlCurrFxRate());
        this.setLegClearingMethod(en.getLegClearingMethod());
        this.setLegSettlType(en.getLegSettlType());
        this.setLegSettlDate(en.getLegSettlDate());
        this.setLegPrincipal(en.getLegPrincipal());
        this.setLegTotalPrincipal(en.getLegTotalPrincipal());
        this.setLegLeaveQty(en.getLegLeaveQty());
    }

    public ObservableList<LegStipulation> getLegStipulationList() {
        return this.legStipulationList;
    }

    public void setLegStipulationList(ObservableList<LegStipulation> legStipulationList) {
        this.legStipulationList = legStipulationList;
    }

    public final StringProperty legSecurityIDProperty() {
        return this.legSecurityID;
    }

    public final String getLegSecurityID() {
        return (String)this.legSecurityIDProperty().get();
    }

    public final void setLegSecurityID(String legSecurityID) {
        this.legSecurityIDProperty().set((Object)legSecurityID);
    }

    public final ObjectProperty<MxNode> legSideProperty() {
        return this.legSide;
    }

    public final MxNode getLegSide() {
        return (MxNode)this.legSideProperty().get();
    }

    public final void setLegSide(MxNode legSide) {
        this.legSideProperty().set((Object)legSide);
    }

    public final DoubleProperty legPriceProperty() {
        return this.legPrice;
    }

    public final double getLegPrice() {
        return this.legPriceProperty().get();
    }

    public final void setLegPrice(double legPrice) {
        this.legPriceProperty().set(legPrice);
    }

    public final DoubleProperty legDirtyPriceProperty() {
        return this.legDirtyPrice;
    }

    public final double getLegDirtyPrice() {
        return this.legDirtyPriceProperty().get();
    }

    public final void setLegDirtyPrice(double legDirtyPrice) {
        this.legDirtyPriceProperty().set(legDirtyPrice);
    }

    public final DoubleProperty legAccruedInterestAmtProperty() {
        return this.legAccruedInterestAmt;
    }

    public final double getLegAccruedInterestAmt() {
        return this.legAccruedInterestAmtProperty().get();
    }

    public final void setLegAccruedInterestAmt(double legAccruedInterestAmt) {
        this.legAccruedInterestAmtProperty().set(legAccruedInterestAmt);
    }

    public final IntegerProperty legOrderQtyProperty() {
        return this.legOrderQty;
    }

    public final int getLegOrderQty() {
        return this.legOrderQtyProperty().get();
    }

    public final void setLegOrderQty(int legOrderQty) {
        this.legOrderQtyProperty().set(legOrderQty);
    }

    public final DoubleProperty legTradeCashAmtProperty() {
        return this.legTradeCashAmt;
    }

    public final double getLegTradeCashAmt() {
        return this.legTradeCashAmtProperty().get();
    }

    public final void setLegTradeCashAmt(double legTradeCashAmt) {
        this.legTradeCashAmtProperty().set(legTradeCashAmt);
    }

    public final DoubleProperty legAccruedInterestTotalAmtProperty() {
        return this.legAccruedInterestTotalAmt;
    }

    public final double getLegAccruedInterestTotalAmt() {
        return this.legAccruedInterestTotalAmtProperty().get();
    }

    public final void setLegAccruedInterestTotalAmt(double legAccruedInterestTotalAmt) {
        this.legAccruedInterestTotalAmtProperty().set(legAccruedInterestTotalAmt);
    }

    public final DoubleProperty legSettlCurrAmtProperty() {
        return this.legSettlCurrAmt;
    }

    public final double getLegSettlCurrAmt() {
        return this.legSettlCurrAmtProperty().get();
    }

    public final void setLegSettlCurrAmt(double legSettlCurrAmt) {
        this.legSettlCurrAmtProperty().set(legSettlCurrAmt);
    }

    public final DoubleProperty legSettlCurrFxRateProperty() {
        return this.legSettlCurrFxRate;
    }

    public final double getLegSettlCurrFxRate() {
        return this.legSettlCurrFxRateProperty().get();
    }

    public final void setLegSettlCurrFxRate(double legSettlCurrFxRate) {
        this.legSettlCurrFxRateProperty().set(legSettlCurrFxRate);
    }

    public final ObjectProperty<MxNode> legClearingMethodProperty() {
        return this.legClearingMethod;
    }

    public final MxNode getLegClearingMethod() {
        return (MxNode)this.legClearingMethodProperty().get();
    }

    public final void setLegClearingMethod(MxNode legClearingMethod) {
        this.legClearingMethodProperty().set((Object)legClearingMethod);
    }

    public final ObjectProperty<MxNode> legSettlTypeProperty() {
        return this.legSettlType;
    }

    public final MxNode getLegSettlType() {
        return (MxNode)this.legSettlTypeProperty().get();
    }

    public final void setLegSettlType(MxNode legSettlType) {
        this.legSettlTypeProperty().set((Object)legSettlType);
    }

    public final StringProperty legSettlDateProperty() {
        return this.legSettlDate;
    }

    public final String getLegSettlDate() {
        return (String)this.legSettlDateProperty().get();
    }

    public final void setLegSettlDate(String legSettlDate) {
        this.legSettlDateProperty().set((Object)legSettlDate);
    }

    public final StringProperty legPrincipalProperty() {
        return this.legPrincipal;
    }

    public final String getLegPrincipal() {
        return (String)this.legPrincipalProperty().get();
    }

    public final void setLegPrincipal(String legPrincipal) {
        this.legPrincipalProperty().set((Object)legPrincipal);
    }

    public final StringProperty legTotalPrincipalProperty() {
        return this.legTotalPrincipal;
    }

    public final String getLegTotalPrincipal() {
        return (String)this.legTotalPrincipalProperty().get();
    }

    public final void setLegTotalPrincipal(String legTotalPrincipal) {
        this.legTotalPrincipalProperty().set((Object)legTotalPrincipal);
    }

    public final DoubleProperty legLeaveQtyProperty() {
        return this.legLeaveQty;
    }

    public final double getLegLeaveQty() {
        return this.legLeaveQtyProperty().get();
    }

    public final void setLegLeaveQty(double legLeaveQty) {
        this.legLeaveQtyProperty().set(legLeaveQty);
    }
}

