/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.factory.DeliveryTypeOptionFactory;
import cms.tmx.entity.factory.StipulationFactory;
import cms.tmx.entity.trade.CfetsParty;
import cms.tmx.entity.trade.Deal;
import cms.tmx.entity.trade.DeliveryTypeOption;
import cms.tmx.entity.trade.PartySub;
import cms.tmx.entity.trade.Stipulation;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import com.google.protobuf.Any;
import java.text.NumberFormat;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import message.CfetsExtra;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CfetsBondMarketDeal
extends Deal {
    private static final Logger logger = LogManager.getLogger(CfetsBondMarketDeal.class);
    private ObjectProperty<MxNode> tradeMethod = new SimpleObjectProperty();
    private DoubleProperty price = new SimpleDoubleProperty(0.0);
    private DoubleProperty yield = new SimpleDoubleProperty(0.0);
    private StringProperty grossTradeAmt = new SimpleStringProperty("");
    private ObjectProperty<MxNode> settlType = new SimpleObjectProperty();
    private DoubleProperty accruedInterestAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty dirtyPrice = new SimpleDoubleProperty(0.0);
    private StringProperty accruedInterestTotalAmt = new SimpleStringProperty("");
    private StringProperty settlCurrAmt = new SimpleStringProperty("");
    private StringProperty settlDate = new SimpleStringProperty("");
    private StringProperty partySubId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> execType = new SimpleObjectProperty();
    private StringProperty text = new SimpleStringProperty("");
    private ObjectProperty<MxNode> clearingMethod = new SimpleObjectProperty();
    private ObjectProperty<Stipulation> stipulation = new SimpleObjectProperty();
    private ObjectProperty<DeliveryTypeOption> deliveryTypeOption = new SimpleObjectProperty();
    private ObservableList<CfetsParty> cfetsPartyList = FxUtils.newList();
    private StringProperty sellPsd = new SimpleStringProperty("");
    private StringProperty sellPsdName = new SimpleStringProperty("");
    private StringProperty sellPsdInsName = new SimpleStringProperty("");
    private String tradeName = "TRADE_NAME";
    private String slcnof = "SHORT_LEGAL_CHINESE_NAME_OF_FIRM";
    private String buy = "49";
    private String sell = "50";
    private String buyer = "BUYER";
    private String seller = "SELLER";
    @Inject
    private MObjFactory of;
    @Inject
    private StipulationFactory sf;
    @Inject
    private DeliveryTypeOptionFactory dtof;
    private static MxNode tradeMethodNode;
    private static MxNode settlTypeNode;
    private static MxNode execTypeNode;
    private static MxNode clearingMethodNode;

    @PostConstruct
    public void init() {
        if (tradeMethodNode == null) {
            tradeMethodNode = MxNodeFactory.create((String)"trade_method", (String)"");
        }
        this.setTradeMethod(tradeMethodNode.clone());
        if (settlTypeNode == null) {
            settlTypeNode = MxNodeFactory.create((String)"settl_type", (String)"");
        }
        this.setSettlType(settlTypeNode.clone());
        if (execTypeNode == null) {
            execTypeNode = MxNodeFactory.create((String)"exec_type", (String)"");
        }
        this.setExecType(execTypeNode.clone());
        if (clearingMethodNode == null) {
            clearingMethodNode = MxNodeFactory.create((String)"clearing_method", (String)"");
        }
        this.setClearingMethod(clearingMethodNode.clone());
    }

    @Override
    public void update(Object obj) {
        try {
            if (obj instanceof POrderService.Execution) {
                POrderService.Execution execution = (POrderService.Execution)POrderService.Execution.class.cast(obj);
                super.update(obj);
                Any any = execution.getObject();
                if (any.is(CfetsExtra.CfetsExecutionExtra.class)) {
                    CfetsExtra.CfetsExecutionExtra cfetsExecutionExtra = (CfetsExtra.CfetsExecutionExtra)any.unpack(CfetsExtra.CfetsExecutionExtra.class);
                    this.update(cfetsExecutionExtra);
                    this.changed();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private void update(CfetsExtra.CfetsExecutionExtra cee) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(4);
        this.getTradeMethod().setRaw(cee.getTradeMethod());
        this.setPrice(Double.valueOf(nf.format(cee.getPrice())));
        this.setYield(Double.valueOf(nf.format(cee.getYieldData().getYield())));
        this.setLastQty(Double.valueOf(nf.format(this.getLastQty() / 10000.0)));
        this.setGrossTradeAmt(nf.format(cee.getGrossTradeamt()));
        this.getSettlType().setRaw(Integer.toString(cee.getSettlType().getNumber()));
        this.setAccruedInterestAmt(cee.getAccruedInterestAmt());
        this.setDirtyPrice(Double.valueOf(nf.format(cee.getDirtyPrice())));
        this.setAccruedInterestTotalAmt(nf.format(cee.getAccruedInterestTotalAmt()));
        this.setSettlCurrAmt(nf.format(cee.getSettlCurrAmt()));
        this.setSettlDate(cee.getSettlDate());
        PComponent.DeliveryTypeOption deliveryTypeOption = cee.getDeliveryTypeOption();
        if (this.getDeliveryTypeOption() == null) {
            this.setDeliveryTypeOption(this.dtof.create());
        }
        this.getDeliveryTypeOption().update((Object)deliveryTypeOption);
        this.getExecType().setRaw(Character.valueOf((char)cee.getExecType().getNumber()).toString());
        this.setText(cee.getText());
        this.getClearingMethod().setRaw(Integer.toString(cee.getClearingMethod().getNumber()));
        PComponent.Stipulation stipulation = cee.getStipulation();
        if (this.getStipulation() == null) {
            this.setStipulation(this.sf.create());
        }
        this.getStipulation().update((Object)stipulation);
        for (PComponent.Party party : cee.getPartyList()) {
            CfetsParty cp = new CfetsParty();
            cp.update((Object)party);
            String side = super.getSide().getRaw();
            if (this.sell.equals(side) && this.buyer.equalsIgnoreCase(cp.getPartyRole())) {
                for (PartySub partySub : cp.getPartySubList()) {
                    if (this.tradeName.equalsIgnoreCase(partySub.getPartySubIDType())) {
                        this.sellPsdName.set((Object)partySub.getPartySubID());
                    }
                    if (!this.slcnof.equals(partySub.getPartySubIDType())) continue;
                    this.sellPsdInsName.set((Object)partySub.getPartySubID());
                    this.sellPsd.set((Object)partySub.getPartySubID());
                }
            } else if (this.buy.equals(side) && this.seller.equals(cp.getPartyRole())) {
                for (PartySub partySub : cp.getPartySubList()) {
                    if (this.tradeName.equalsIgnoreCase(partySub.getPartySubIDType())) {
                        this.sellPsdName.set((Object)partySub.getPartySubID());
                    }
                    if (!this.slcnof.equals(partySub.getPartySubIDType())) continue;
                    this.sellPsdInsName.set((Object)partySub.getPartySubID());
                    this.sellPsd.set((Object)partySub.getPartySubID());
                }
            }
            this.cfetsPartyList.add((Object)cp);
        }
    }

    public final ObjectProperty<MxNode> tradeMethodProperty() {
        return this.tradeMethod;
    }

    public final MxNode getTradeMethod() {
        return (MxNode)this.tradeMethodProperty().get();
    }

    public final void setTradeMethod(MxNode tradeMethod) {
        this.tradeMethodProperty().set((Object)tradeMethod);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final DoubleProperty yieldProperty() {
        return this.yield;
    }

    public final double getYield() {
        return this.yieldProperty().get();
    }

    public final void setYield(double yield) {
        this.yieldProperty().set(yield);
    }

    public final StringProperty grossTradeAmtProperty() {
        return this.grossTradeAmt;
    }

    public final String getGrossTradeAmt() {
        return (String)this.grossTradeAmtProperty().get();
    }

    public final void setGrossTradeAmt(String grossTradeAmt) {
        this.grossTradeAmtProperty().set((Object)grossTradeAmt);
    }

    public final ObjectProperty<MxNode> settlTypeProperty() {
        return this.settlType;
    }

    public final MxNode getSettlType() {
        return (MxNode)this.settlTypeProperty().get();
    }

    public final void setSettlType(MxNode settlType) {
        this.settlTypeProperty().set((Object)settlType);
    }

    public final DoubleProperty accruedInterestAmtProperty() {
        return this.accruedInterestAmt;
    }

    public final double getAccruedInterestAmt() {
        return this.accruedInterestAmtProperty().get();
    }

    public final void setAccruedInterestAmt(double accruedInterestAmt) {
        this.accruedInterestAmtProperty().set(accruedInterestAmt);
    }

    public final DoubleProperty dirtyPriceProperty() {
        return this.dirtyPrice;
    }

    public final double getDirtyPrice() {
        return this.dirtyPriceProperty().get();
    }

    public final void setDirtyPrice(double dirtyPrice) {
        this.dirtyPriceProperty().set(dirtyPrice);
    }

    public final StringProperty accruedInterestTotalAmtProperty() {
        return this.accruedInterestTotalAmt;
    }

    public final String getAccruedInterestTotalAmt() {
        return (String)this.accruedInterestTotalAmtProperty().get();
    }

    public final void setAccruedInterestTotalAmt(String accruedInterestTotalAmt) {
        this.accruedInterestTotalAmtProperty().set((Object)accruedInterestTotalAmt);
    }

    public final StringProperty settlCurrAmtProperty() {
        return this.settlCurrAmt;
    }

    public final String getSettlCurrAmt() {
        return (String)this.settlCurrAmtProperty().get();
    }

    public final void setSettlCurrAmt(String settlCurrAmt) {
        this.settlCurrAmtProperty().set((Object)settlCurrAmt);
    }

    public final StringProperty settlDateProperty() {
        return this.settlDate;
    }

    public final String getSettlDate() {
        return (String)this.settlDateProperty().get();
    }

    public final void setSettlDate(String settlDate) {
        this.settlDateProperty().set((Object)settlDate);
    }

    public final StringProperty partySubIdProperty() {
        return this.partySubId;
    }

    public final String getPartySubId() {
        return (String)this.partySubIdProperty().get();
    }

    public final void setPartySubId(String partySubId) {
        this.partySubIdProperty().set((Object)partySubId);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final String getText() {
        return (String)this.textProperty().get();
    }

    public final void setText(String text) {
        this.textProperty().set((Object)text);
    }

    public final ObjectProperty<MxNode> clearingMethodProperty() {
        return this.clearingMethod;
    }

    public final MxNode getClearingMethod() {
        return (MxNode)this.clearingMethodProperty().get();
    }

    public final void setClearingMethod(MxNode clearingMethod) {
        this.clearingMethodProperty().set((Object)clearingMethod);
    }

    public final ObjectProperty<Stipulation> stipulationProperty() {
        return this.stipulation;
    }

    public final Stipulation getStipulation() {
        return (Stipulation)((Object)this.stipulationProperty().get());
    }

    public final void setStipulation(Stipulation stipulation) {
        this.stipulationProperty().set((Object)stipulation);
    }

    public final StringProperty sellPsdProperty() {
        return this.sellPsd;
    }

    public final String getSellPsd() {
        return (String)this.sellPsdProperty().get();
    }

    public final void setSellPsd(String sellPsd) {
        this.sellPsdProperty().set((Object)sellPsd);
    }

    public final StringProperty sellPsdNameProperty() {
        return this.sellPsdName;
    }

    public final String getSellPsdName() {
        return (String)this.sellPsdNameProperty().get();
    }

    public final void setSellPsdName(String sellPsdName) {
        this.sellPsdNameProperty().set((Object)sellPsdName);
    }

    public final StringProperty sellPsdInsNameProperty() {
        return this.sellPsdInsName;
    }

    public final String getSellPsdInsName() {
        return (String)this.sellPsdInsNameProperty().get();
    }

    public final void setSellPsdInsName(String sellPsdInsName) {
        this.sellPsdInsNameProperty().set((Object)sellPsdInsName);
    }

    public final ObjectProperty<MxNode> execTypeProperty() {
        return this.execType;
    }

    public final MxNode getExecType() {
        return (MxNode)this.execTypeProperty().get();
    }

    public final void setExecType(MxNode execType) {
        this.execTypeProperty().set((Object)execType);
    }

    public final ObjectProperty<DeliveryTypeOption> deliveryTypeOptionProperty() {
        return this.deliveryTypeOption;
    }

    public final DeliveryTypeOption getDeliveryTypeOption() {
        return (DeliveryTypeOption)((Object)this.deliveryTypeOptionProperty().get());
    }

    public final void setDeliveryTypeOption(DeliveryTypeOption deliveryTypeOption) {
        this.deliveryTypeOptionProperty().set((Object)deliveryTypeOption);
    }
}

