/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.entity.trade.Position;
import cms.tmx.javafx.MxNode;
import com.google.protobuf.InvalidProtocolBufferException;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcsRepoPosition
extends Position {
    private ObjectProperty<MxNode> side = new SimpleObjectProperty();
    private LongProperty qty = new SimpleLongProperty();
    private DoubleProperty amount = new SimpleDoubleProperty();
    private DoubleProperty interest = new SimpleDoubleProperty();
    private DoubleProperty avgInterestRate = new SimpleDoubleProperty();
    private DoubleProperty retAmount = new SimpleDoubleProperty();
    private StringProperty firstDeliveryDay = new SimpleStringProperty("");
    private StringProperty expireDeliveryDay = new SimpleStringProperty("");
    private StringProperty legalRepurchaseDay = new SimpleStringProperty("");
    private StringProperty actualRepurchaseDay = new SimpleStringProperty("");
    private IntegerProperty daysOfInterestBearing = new SimpleIntegerProperty();
    private static final Logger logger = LogManager.getLogger(CcsRepoPosition.class);

    @Override
    public void update(Object obj) {
        try {
            if (obj instanceof PPositionService.ExtPosition) {
                super.update(obj);
                PPositionService.ExtPosition position = (PPositionService.ExtPosition)PPositionService.ExtPosition.class.cast(obj);
                PCcsExtra.CcsExtPositionExtra ccs = (PCcsExtra.CcsExtPositionExtra)position.getObject().unpack(PCcsExtra.CcsExtPositionExtra.class);
                PCcsExtra.CcsRepoPosition cOrder = (PCcsExtra.CcsRepoPosition)PCcsExtra.CcsRepoPosition.class.cast(ccs.getRepoPosition());
                this.update(cOrder);
            } else if (obj instanceof PPositionService.SubPosition) {
                super.update(obj);
                PPositionService.SubPosition position = (PPositionService.SubPosition)PPositionService.SubPosition.class.cast(obj);
                PCcsExtra.CcsSubPositionExtra ccs = (PCcsExtra.CcsSubPositionExtra)position.getObject().unpack(PCcsExtra.CcsSubPositionExtra.class);
                PCcsExtra.CcsRepoPosition ccsP = (PCcsExtra.CcsRepoPosition)PCcsExtra.CcsRepoPosition.class.cast(ccs.getRepoPosition());
                this.update(ccsP);
            } else if (obj instanceof CcsRepoPosition) {
                super.update(obj);
                CcsRepoPosition order = (CcsRepoPosition)((Object)CcsRepoPosition.class.cast(obj));
                this.update(order);
            }
        }
        catch (InvalidProtocolBufferException e) {
            logger.error((Object)e);
        }
    }

    private void update(CcsRepoPosition positon) {
        this.setSide(positon.getSide());
        this.setQty(positon.getQty());
        this.setAmount(positon.getAmount());
        this.setInterest(positon.getInterest());
        this.setAvgInterestRate(positon.getAvgInterestRate());
        this.setTradingDay(positon.getTradingDay());
        this.setFirstDeliveryDay(positon.getFirstDeliveryDay());
        this.setExpireDeliveryDay(positon.getExpireDeliveryDay());
        this.setLegalRepurchaseDay(positon.getLegalRepurchaseDay());
        this.setActualRepurchaseDay(positon.getActualRepurchaseDay());
        this.setDaysOfInterestBearing(positon.getDaysOfInterestBearing());
        this.setRetAmount((positon.getAmount() + positon.getInterest()) * -1.0);
    }

    private void update(PCcsExtra.CcsRepoPosition positon) {
        this.getSide().setRaw(String.valueOf(positon.getSideValue()));
        this.setQty(positon.getQty());
        this.setAmount((double)Math.round(positon.getAmount() * 1000.0) / 1000.0);
        this.setInterest((double)Math.round(positon.getInterest() * 1000.0) / 1000.0);
        this.setAvgInterestRate((double)Math.round(positon.getAvgInterestRate() * 1000.0) / 1000.0);
        this.setTradingDay(positon.getTradingDay());
        this.setFirstDeliveryDay(positon.getFirstDeliveryDay());
        this.setExpireDeliveryDay(positon.getExpireDeliveryDay());
        this.setLegalRepurchaseDay(positon.getLegalRepurchaseDay());
        this.setActualRepurchaseDay(positon.getActualRepurchaseDay());
        this.setDaysOfInterestBearing(positon.getDaysOfInterestBearing());
        this.setRetAmount((double)Math.round((positon.getAmount() + positon.getInterest()) * -1.0 * 1000.0) / 1000.0);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final LongProperty qtyProperty() {
        return this.qty;
    }

    public final long getQty() {
        return this.qtyProperty().get();
    }

    public final void setQty(long qty) {
        this.qtyProperty().set(qty);
    }

    public final DoubleProperty amountProperty() {
        return this.amount;
    }

    public final double getAmount() {
        return this.amountProperty().get();
    }

    public final void setAmount(double amount) {
        this.amountProperty().set(amount);
    }

    public final DoubleProperty interestProperty() {
        return this.interest;
    }

    public final double getInterest() {
        return this.interestProperty().get();
    }

    public final void setInterest(double interest) {
        this.interestProperty().set(interest);
    }

    public final DoubleProperty avgInterestRateProperty() {
        return this.avgInterestRate;
    }

    public final double getAvgInterestRate() {
        return this.avgInterestRateProperty().get();
    }

    public final void setAvgInterestRate(double avgInterestRate) {
        this.avgInterestRateProperty().set(avgInterestRate);
    }

    public final StringProperty firstDeliveryDayProperty() {
        return this.firstDeliveryDay;
    }

    public final String getFirstDeliveryDay() {
        return (String)this.firstDeliveryDayProperty().get();
    }

    public final void setFirstDeliveryDay(String firstDeliveryDay) {
        this.firstDeliveryDayProperty().set((Object)firstDeliveryDay);
    }

    public final StringProperty expireDeliveryDayProperty() {
        return this.expireDeliveryDay;
    }

    public final String getExpireDeliveryDay() {
        return (String)this.expireDeliveryDayProperty().get();
    }

    public final void setExpireDeliveryDay(String expireDeliveryDay) {
        this.expireDeliveryDayProperty().set((Object)expireDeliveryDay);
    }

    public final StringProperty legalRepurchaseDayProperty() {
        return this.legalRepurchaseDay;
    }

    public final String getLegalRepurchaseDay() {
        return (String)this.legalRepurchaseDayProperty().get();
    }

    public final void setLegalRepurchaseDay(String legalRepurchaseDay) {
        this.legalRepurchaseDayProperty().set((Object)legalRepurchaseDay);
    }

    public final StringProperty actualRepurchaseDayProperty() {
        return this.actualRepurchaseDay;
    }

    public final String getActualRepurchaseDay() {
        return (String)this.actualRepurchaseDayProperty().get();
    }

    public final void setActualRepurchaseDay(String actualRepurchaseDay) {
        this.actualRepurchaseDayProperty().set((Object)actualRepurchaseDay);
    }

    public final IntegerProperty daysOfInterestBearingProperty() {
        return this.daysOfInterestBearing;
    }

    public final int getDaysOfInterestBearing() {
        return this.daysOfInterestBearingProperty().get();
    }

    public final void setDaysOfInterestBearing(int daysOfInterestBearing) {
        this.daysOfInterestBearingProperty().set(daysOfInterestBearing);
    }

    public final DoubleProperty retAmountProperty() {
        return this.retAmount;
    }

    public final double getRetAmount() {
        return this.retAmountProperty().get();
    }

    public final void setRetAmount(double retAmount) {
        this.retAmountProperty().set(retAmount);
    }
}

