/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.entity.trade.PledgeInfo;
import cms.tmx.entity.trade.Position;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcsPosition
extends Position {
    private LongProperty canVol = new SimpleLongProperty(0L);
    private double canVolDouble = 0.0;
    private DoubleProperty frozenVol = new SimpleDoubleProperty(0.0);
    private LongProperty totalVol = new SimpleLongProperty(0L);
    private DoubleProperty buyIn = new SimpleDoubleProperty(0.0);
    private DoubleProperty buyInFrozen = new SimpleDoubleProperty(0.0);
    private DoubleProperty sellOut = new SimpleDoubleProperty(0.0);
    private DoubleProperty sellOutFrozen = new SimpleDoubleProperty(0.0);
    private DoubleProperty net = new SimpleDoubleProperty(0.0);
    private double transferIn;
    private double transferOut;
    private double manualFrozen;
    private double manualUnfrozen;
    private DoubleProperty buyInAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty sellOutAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty impawnIn = new SimpleDoubleProperty(0.0);
    private int impawnInFrozen;
    private double impawnOut;
    private double availImpawnOut;
    private double standardTicket;
    private double standardTicketFrozen;
    private DoubleProperty profit = new SimpleDoubleProperty(0.0);
    private DoubleProperty totalProfit = new SimpleDoubleProperty(0.0);
    private DoubleProperty cost = new SimpleDoubleProperty(0.0);
    private DoubleProperty buyCost = new SimpleDoubleProperty(0.0);
    private DoubleProperty buyCostAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty realizedPl = new SimpleDoubleProperty(0.0);
    private DoubleProperty todayRealizedPl = new SimpleDoubleProperty(0.0);
    private DoubleProperty yield = new SimpleDoubleProperty(0.0);
    private DoubleProperty carryYield = new SimpleDoubleProperty(0.0);
    private DoubleProperty costAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty nowPrice = new SimpleDoubleProperty(0.0);
    private DoubleProperty percent = new SimpleDoubleProperty(0.0);
    private DoubleProperty capitalization = new SimpleDoubleProperty(0.0);
    private DoubleProperty curDividend = new SimpleDoubleProperty(0.0);
    private DoubleProperty preCapitalization = new SimpleDoubleProperty(0.0);
    private DoubleProperty preTotalQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty reduceQty = new SimpleDoubleProperty(0.0);
    private double limitedReduceQty;
    private DoubleProperty preFrozenQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty floatPl = new SimpleDoubleProperty(0.0);
    private DoubleProperty totalPl = new SimpleDoubleProperty(0.0);
    private DoubleProperty capitalPrecent = new SimpleDoubleProperty(0.0);
    private DoubleProperty totalProfitLossPrecent = new SimpleDoubleProperty(0.0);
    private LongProperty countVarition = new SimpleLongProperty(0L);
    private DoubleProperty costVarition = new SimpleDoubleProperty(0.0);
    private DoubleProperty todayFloatPl = new SimpleDoubleProperty(0.0);
    private DoubleProperty todayRealPl = new SimpleDoubleProperty(0.0);
    private DoubleProperty todayTotalPl = new SimpleDoubleProperty(0.0);
    private DoubleProperty priceFloatPercent = new SimpleDoubleProperty(0.0);
    private DoubleProperty preBuyCostAmt = new SimpleDoubleProperty(0.0);
    private StringProperty totalStockPercent = new SimpleStringProperty("");
    private DoubleProperty carryBuyCostAmtNew = new SimpleDoubleProperty(0.0);
    private DoubleProperty preCarryBuyCostAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty carryBuyCostAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty carryBuyCost = new SimpleDoubleProperty(0.0);
    private DoubleProperty preCarryRealizedPl = new SimpleDoubleProperty(0.0);
    private DoubleProperty carryRealizedPl = new SimpleDoubleProperty(0.0);
    protected StringProperty restrictedSecurityType = new SimpleStringProperty("");
    protected StringProperty circulationType = new SimpleStringProperty("");
    protected StringProperty equityType = new SimpleStringProperty("");
    protected StringProperty listingYear = new SimpleStringProperty("");
    private DoubleProperty preRealizedPl = new SimpleDoubleProperty(0.0);
    private double closePrice = 0.0;
    private double exchangeRate;
    private PledgeInfo refItem;
    private DoubleProperty avail = new SimpleDoubleProperty(0.0);
    private DoubleProperty totalVolStd = new SimpleDoubleProperty(0.0);
    private DoubleProperty plRate = new SimpleDoubleProperty(0.0);
    private Boolean sell;
    private DoubleProperty carryBuyCostAmtRate = new SimpleDoubleProperty(0.0);
    private DoubleProperty posiCapitalRate = new SimpleDoubleProperty(0.0);
    private static final Logger logger = LogManager.getLogger(CcsPosition.class);

    public String unique() {
        return String.valueOf(this.getExtSecAccId()) + this.getSecId();
    }

    @Override
    public void update(Object obj) {
        try {
            if (obj instanceof PPositionService.ExtPosition) {
                super.update(obj);
                PPositionService.ExtPosition position = (PPositionService.ExtPosition)PPositionService.ExtPosition.class.cast(obj);
                PCcsExtra.CcsExtPositionExtra ccs = (PCcsExtra.CcsExtPositionExtra)position.getObject().unpack(PCcsExtra.CcsExtPositionExtra.class);
                PCcsExtra.CcsPosition ccsP = (PCcsExtra.CcsPosition)PCcsExtra.CcsPosition.class.cast(ccs.getPosition());
                this.update(ccsP);
            } else if (obj instanceof PPositionService.SubPosition) {
                super.update(obj);
            } else if (obj instanceof CcsPosition) {
                super.update(obj);
                CcsPosition pos = (CcsPosition)((Object)CcsPosition.class.cast(obj));
                this.update(pos);
            } else if (obj instanceof BasketSecurityInst) {
                this.update((BasketSecurityInst)((Object)BasketSecurityInst.class.cast(obj)));
            } else if (obj instanceof BasketAlgoItem) {
                this.update((BasketAlgoItem)((Object)BasketAlgoItem.class.cast(obj)));
            }
        }
        catch (InvalidProtocolBufferException e) {
            logger.error(e.getMessage());
        }
    }

    private void update(CcsPosition po) {
        this.setTotalVol(po.getTotalVol());
        this.setBuyIn(po.getBuyIn());
        this.setSellOut(po.getSellOut());
        this.setBuyInAmount(po.getBuyInAmount());
        this.setSellOutAmount(po.getSellOutAmount());
        this.setImpawnIn(po.getImpawnIn());
        this.setAvailImpawnOut(po.getAvailImpawnOut());
        this.setProfit(po.getProfit());
        this.setTotalProfit(po.getTotalProfit());
        this.setCost(po.getCost());
        this.setBuyCost(po.getBuyCost());
        this.setBuyCostAmt(po.getBuyCostAmt());
        this.setRealizedPl(po.getRealizedPl());
        this.setYield(po.getYield());
        this.setCarryYield(po.getCarryYield());
        this.setCapitalization(po.getCapitalization());
        this.setFrozenVol(po.getFrozenVol());
        this.setCanVol(po.getCanVol());
        this.setCanVolDouble(po.getCanVolDouble());
        this.setNowPrice(po.getNowPrice());
        this.setPercent(po.getPercent());
        this.setPreTotalQty(po.getPreTotalQty());
        this.setPreCapitalization(po.getPreCapitalization());
        this.setCurDividend(po.getCurDividend());
        this.setCostAmt(po.getCostAmt());
        this.setReduceQty(po.getReduceQty());
        this.setLimitedReduceQty(po.getLimitedReduceQty());
        this.setSellOutFrozen(po.getSellOutFrozen());
        this.setManualFrozen(po.getManualFrozen());
        this.setManualUnfrozen(po.getManualUnfrozen());
        this.setTransferIn(po.getTransferIn());
        this.setTransferOut(po.getTransferOut());
        this.setTodayRealizedPl(po.getTodayRealizedPl());
        this.setBuyInFrozen(po.getBuyInFrozen());
        this.setPreFrozenQty(po.getPreFrozenQty());
        this.setPreBuyCostAmt(po.getPreBuyCostAmt());
        this.setFloatPl(po.getFloatPl());
        this.setTotalPl(po.getTotalPl());
        this.setCountVarition(po.getCountVarition());
        this.setCostVarition(po.getCostVarition());
        this.setTodayFloatPl(po.getTodayFloatPl());
        this.setTodayRealPl(po.getTodayRealPl());
        this.setTodayTotalPl(po.getTodayTotalPl());
        this.setPriceFloatPercent(po.getPriceFloatPercent());
        this.setCapitalPrecent(po.getCapitalPrecent());
        this.setTotalProfitLossPrecent(po.getTotalProfitLossPrecent());
        this.setClosePrice(po.getClosePrice());
        this.setTotalStockPercent(po.getTotalStockPercent());
        this.setPreCarryBuyCostAmt(po.getPreCarryBuyCostAmt());
        this.setCarryRealizedPl(po.getCarryRealizedPl());
        this.setCarryBuyCostAmt(po.getCarryBuyCostAmt());
        this.setCarryBuyCostAmtNew(po.getCarryBuyCostAmtNew());
        this.setCarryBuyCost(po.getCarryBuyCost());
        this.setPreCarryRealizedPl(po.getPreCarryRealizedPl());
        this.setRestrictedSecurityType(po.getRestrictedSecurityType());
        this.setCirculationType(po.getCirculationType());
        this.setEquityType(po.getEquityType());
        this.setListingYear(po.getListingYear());
        this.setNet(po.getNet());
        this.setExchangeRate(po.getExchangeRate());
        this.setInverstorSecId(po.getInverstorSecId());
        this.setCounterName(po.getCounterName());
        this.setAvail(po.getAvail());
        this.setTotalVolStd(new BigDecimal(po.getReduceQty() - po.getPreTotalQty() + (double)po.getTotalVol()).setScale(0, 5).doubleValue());
        this.setPlRate(this.formatScale(this.getCarryBuyCostAmtNew() == 0.0 ? 0.0 : this.getFloatPl() / this.getCarryBuyCostAmtNew(), 2));
        this.setCarryBuyCostAmtRate(po.getCarryBuyCostAmtRate());
        this.setPosiCapitalRate(po.getPosiCapitalRate());
    }

    protected void update(PCcsExtra.CcsPosition po) {
        if (po.getRestrictedSecurityType() != "") {
            this.setRestrictedSecurityType(po.getRestrictedSecurityType());
            this.setCirculationType(po.getCirculationType());
            this.setEquityType(po.getEquityType());
            this.setListingYear(po.getListingYear());
        }
        this.setPreCarryBuyCostAmt(po.getPreCarryBuyCostAmt());
        this.setCarryRealizedPl(po.getCarryRealizedPl());
        this.setCarryBuyCostAmt(po.getCarryBuyCostAmt());
        this.setCarryBuyCost(po.getCarryBuyCost());
        this.setPreCarryRealizedPl(po.getPreCarryRealizedPl());
        this.setTotalVol((long)po.getTotalVol());
        this.setBuyIn(po.getBuyIn());
        this.setSellOut(po.getSellOut());
        this.setBuyInAmount(po.getBuyInAmount());
        this.setSellOutAmount(po.getSellOutAmount());
        this.setImpawnIn(po.getImpawnIn());
        this.setAvailImpawnOut(po.getAvailImpawnOut());
        this.setCost((double)Math.round(po.getCost() * 10000.0) / 10000.0);
        this.setCostAmt((double)Math.round(po.getHoldCostAmt() * 1000.0) / 1000.0);
        this.setBuyCost((double)Math.round(po.getBuyCost() * 1000.0) / 1000.0);
        this.setBuyCostAmt((double)Math.round(po.getBuyCostAmt() * 1000.0) / 1000.0);
        this.setCarryBuyCost((double)Math.round(po.getCarryBuyCost() * 1000.0) / 1000.0);
        this.setCarryBuyCostAmt((double)Math.round(po.getCarryBuyCostAmt() * 1000.0) / 1000.0);
        this.setNowPrice((double)Math.round(po.getLastPx() * 1000.0) / 1000.0);
        this.setRealizedPl(this.formatScale((double)Math.round(po.getCarryRealizedPl() * 1000.0) / 1000.0, 2));
        this.setTodayRealizedPl((double)Math.round((po.getCarryRealizedPl() - po.getPreCarryRealizedPl()) * 1000.0) / 1000.0);
        this.setCapitalization(po.getCapitalization());
        this.setFrozenVol(po.getTotalVol() - po.getAvail() - po.getImpawnIn());
        this.setCanVol((long)po.getAvail());
        this.setCanVolDouble(po.getAvail());
        this.setPreTotalQty(po.getPreTotalQty());
        this.setPreCapitalization(po.getPreCapitalization());
        this.setCurDividend(po.getCurDividend());
        this.setReduceQty(po.getReduceQty());
        this.setLimitedReduceQty(po.getLimitedReduceQty());
        if ("STD_BOND".equals(this.getSecType())) {
            this.setProfit(0.0);
            this.setTotalProfit(0.0);
        } else {
            this.setProfit((double)Math.round((po.getCapitalization() - po.getCarryBuyCostAmt()) * 1000.0) / 1000.0);
            this.setTotalProfit(this.getProfit() + this.getCarryRealizedPl());
        }
        this.setTradingDay(po.getTradingDay());
        this.setSellOutFrozen(po.getSellOutFrozen());
        this.setManualFrozen(po.getManualFrozen());
        this.setManualUnfrozen(po.getManualUnfrozen());
        this.setTransferIn(po.getTransferIn());
        this.setTransferOut(po.getTransferOut());
        this.setBuyInFrozen(po.getBuyInNodeal());
        this.setPreFrozenQty(po.getPreFrozenQty());
        this.setPreBuyCostAmt(po.getPreBuyCostAmt());
        this.setCountVarition(Double.valueOf(po.getTotalVol() - po.getPreTotalQty()).longValue());
        this.setCostVarition(po.getCarryBuyCostAmt() - po.getPreCarryBuyCostAmt());
        this.setTodayRealPl(this.formatScale(po.getCarryRealizedPl() - po.getPreCarryRealizedPl(), 2));
        this.setPreRealizedPl(po.getPreRealizedPl());
        this.setExchangeRate(po.getExchangeRate());
        this.setCarryBuyCostAmtNew(CcsPosition.calAmountByMarketAndSecType(this.getMarket().getRaw(), this.getSecType(), this.getTotalVol(), this.getCarryBuyCost()));
        this.setAvail(po.getAvail());
        this.setTotalVolStd(new BigDecimal(po.getReduceQty() - po.getPreTotalQty() + po.getTotalVol()).setScale(0, 5).doubleValue());
        this.setPlRate(this.formatScale(this.getCarryBuyCostAmtNew() == 0.0 ? 0.0 : this.getFloatPl() / this.getCarryBuyCostAmtNew(), 2));
    }

    private double formatScale(double d, int scale) {
        return new BigDecimal(d).setScale(scale, 4).doubleValue();
    }

    private void update(BasketAlgoItem item) {
        this.setExtAccId(item.getExtAccntId());
        this.setSecId(item.getCode());
        this.getMarket().setRaw(item.getMarket().getRaw());
        this.setExtSecAccId(item.getExtSecAccntId());
        this.setSecType(item.getType());
    }

    private void update(BasketSecurityInst inst) {
        this.setExtAccId(inst.getExtAccntId());
        this.setSecId(inst.getSecurityId());
        this.getMarket().setRaw(inst.getMarket());
        this.setExtSecAccId(inst.getExtSecAccntId());
        this.setSecType(inst.getSecurityType());
    }

    public void updateProfit() {
        this.setCarryBuyCostAmtNew(CcsPosition.calAmountByMarketAndSecType(this.getMarket().getRaw(), this.getSecType(), this.getTotalVol(), this.getCarryBuyCost()));
        this.setFloatPl(this.formatScale(this.getCapitalization() - this.getCarryBuyCostAmtNew(), 2));
        if ("STD_BOND".equals(this.getSecType())) {
            this.setProfit(0.0);
            this.setTotalProfit(0.0);
        } else {
            this.setProfit((double)Math.round((this.getCapitalization() - this.getCarryBuyCostAmt()) * 1000.0) / 1000.0);
            this.setTotalProfit(this.getProfit() + this.getCarryRealizedPl());
        }
        this.setTodayFloatPl(this.formatScale(this.getFloatPl() - (this.getPreCapitalization() - this.getPreCarryBuyCostAmt()), 4));
        this.setTotalPl(this.formatScale(this.getFloatPl() + this.getCarryRealizedPl(), 2));
        this.setPlRate(this.formatScale(this.getCarryBuyCostAmtNew() == 0.0 ? 0.0 : this.getFloatPl() / this.getCarryBuyCostAmtNew(), 2));
    }

    public static double calAmountByMarketAndSecType(String market, String secType, double qty, double price) {
        double amount = 0.0;
        switch (secType) {
            case "STD_BOND": {
                amount = qty * (double)("XSHG".equals(market) ? 1000 : 100);
                break;
            }
            case "BOND": {
                amount = qty * price * (double)("XSHG".equals(market) ? 10 : 1);
                break;
            }
            default: {
                amount = qty * price;
            }
        }
        return amount;
    }

    public DoubleProperty buyInProperty() {
        return this.buyIn;
    }

    public double getBuyIn() {
        return this.buyInProperty().get();
    }

    public void setBuyIn(double buyIn) {
        this.buyInProperty().set(buyIn);
    }

    public DoubleProperty sellOutProperty() {
        return this.sellOut;
    }

    public double getSellOut() {
        return this.sellOutProperty().get();
    }

    public void setSellOut(double sellOut) {
        this.sellOutProperty().set(sellOut);
    }

    public DoubleProperty buyInAmountProperty() {
        return this.buyInAmount;
    }

    public double getBuyInAmount() {
        return this.buyInAmountProperty().get();
    }

    public void setBuyInAmount(double buyInAmount) {
        this.buyInAmountProperty().set(buyInAmount);
    }

    public DoubleProperty sellOutAmountProperty() {
        return this.sellOutAmount;
    }

    public double getSellOutAmount() {
        return this.sellOutAmountProperty().get();
    }

    public void setSellOutAmount(double sellOutAmount) {
        this.sellOutAmountProperty().set(sellOutAmount);
    }

    public DoubleProperty impawnInProperty() {
        return this.impawnIn;
    }

    public double getImpawnIn() {
        return this.impawnInProperty().get();
    }

    public void setImpawnIn(double impawnIn) {
        this.impawnInProperty().set(impawnIn);
    }

    public DoubleProperty profitProperty() {
        return this.profit;
    }

    public double getProfit() {
        return this.profitProperty().get();
    }

    public void setProfit(double profit) {
        this.profitProperty().set(profit);
    }

    public DoubleProperty costProperty() {
        return this.cost;
    }

    public double getCost() {
        return this.costProperty().get();
    }

    public void setCost(double cost) {
        this.costProperty().set(cost);
    }

    public DoubleProperty capitalizationProperty() {
        return this.capitalization;
    }

    public double getCapitalization() {
        return this.capitalizationProperty().get();
    }

    public void setCapitalization(double capitalization) {
        this.capitalizationProperty().set(capitalization);
    }

    public LongProperty canVolProperty() {
        return this.canVol;
    }

    public long getCanVol() {
        return this.canVolProperty().get();
    }

    public void setCanVol(long canVol) {
        this.canVolProperty().set(canVol);
    }

    public DoubleProperty frozenVolProperty() {
        return this.frozenVol;
    }

    public double getFrozenVol() {
        return this.frozenVolProperty().get();
    }

    public void setFrozenVol(double frozenVol) {
        this.frozenVolProperty().set(frozenVol);
    }

    public LongProperty totalVolProperty() {
        return this.totalVol;
    }

    public long getTotalVol() {
        return this.totalVolProperty().get();
    }

    public void setTotalVol(long totalVol) {
        this.totalVolProperty().set(totalVol);
    }

    public PledgeInfo getRefItem() {
        return this.refItem;
    }

    public void setRefItem(PledgeInfo refItem) {
        this.refItem = refItem;
    }

    public double getAvailImpawnOut() {
        return this.availImpawnOut;
    }

    public void setAvailImpawnOut(double availImpawnOut) {
        this.availImpawnOut = availImpawnOut;
    }

    public final DoubleProperty nowPriceProperty() {
        return this.nowPrice;
    }

    public final double getNowPrice() {
        return this.nowPriceProperty().get();
    }

    public final void setNowPrice(double nowPrice) {
        this.nowPriceProperty().set(nowPrice);
    }

    public DoubleProperty curDividendProperty() {
        return this.curDividend;
    }

    public double getCurDividend() {
        return this.curDividendProperty().get();
    }

    public void setCurDividend(double curDividend) {
        this.curDividendProperty().set(curDividend);
    }

    public DoubleProperty preCapitalizationProperty() {
        return this.preCapitalization;
    }

    public double getPreCapitalization() {
        return this.preCapitalizationProperty().get();
    }

    public void setPreCapitalization(double preCapitalization) {
        this.preCapitalizationProperty().set(preCapitalization);
    }

    public DoubleProperty preTotalQtyProperty() {
        return this.preTotalQty;
    }

    public double getPreTotalQty() {
        return this.preTotalQtyProperty().get();
    }

    public void setPreTotalQty(double preTotalQty) {
        this.preTotalQtyProperty().set(preTotalQty);
    }

    public final DoubleProperty costAmtProperty() {
        return this.costAmt;
    }

    public final double getCostAmt() {
        return this.costAmtProperty().get();
    }

    public final void setCostAmt(double costAmt) {
        this.costAmtProperty().set(costAmt);
    }

    public double getLimitedReduceQty() {
        return this.limitedReduceQty;
    }

    public void setLimitedReduceQty(double limitedReduceQty) {
        this.limitedReduceQty = limitedReduceQty;
    }

    public final DoubleProperty yieldProperty() {
        return this.yield;
    }

    public final double getYield() {
        return this.yieldProperty().get();
    }

    public final void setYield(double yield) {
        this.yieldProperty().set(yield);
    }

    public final DoubleProperty buyCostProperty() {
        return this.buyCost;
    }

    public final double getBuyCost() {
        return this.buyCostProperty().get();
    }

    public final void setBuyCost(double buyCost) {
        this.buyCostProperty().set(buyCost);
    }

    public final DoubleProperty percentProperty() {
        return this.percent;
    }

    public final double getPercent() {
        return this.percentProperty().get();
    }

    public final void setPercent(double percent) {
        this.percentProperty().set(percent);
    }

    public final DoubleProperty realizedPlProperty() {
        return this.realizedPl;
    }

    public final double getRealizedPl() {
        return this.realizedPlProperty().get();
    }

    public final void setRealizedPl(double realizedPl) {
        this.realizedPlProperty().set(realizedPl);
    }

    public double getManualFrozen() {
        return this.manualFrozen;
    }

    public void setManualFrozen(double manualFrozen) {
        this.manualFrozen = manualFrozen;
    }

    public double getManualUnfrozen() {
        return this.manualUnfrozen;
    }

    public void setManualUnfrozen(double manualUnfrozen) {
        this.manualUnfrozen = manualUnfrozen;
    }

    public double getTransferIn() {
        return this.transferIn;
    }

    public void setTransferIn(double transferIn) {
        this.transferIn = transferIn;
    }

    public double getTransferOut() {
        return this.transferOut;
    }

    public void setTransferOut(double transferOut) {
        this.transferOut = transferOut;
    }

    public final DoubleProperty totalProfitProperty() {
        return this.totalProfit;
    }

    public final double getTotalProfit() {
        return this.totalProfitProperty().get();
    }

    public final void setTotalProfit(double totalProfit) {
        this.totalProfitProperty().set(totalProfit);
    }

    public final DoubleProperty todayRealizedPlProperty() {
        return this.todayRealizedPl;
    }

    public final double getTodayRealizedPl() {
        return this.todayRealizedPlProperty().get();
    }

    public final void setTodayRealizedPl(double todayRealizedPl) {
        this.todayRealizedPlProperty().set(todayRealizedPl);
    }

    public final DoubleProperty sellOutFrozenProperty() {
        return this.sellOutFrozen;
    }

    public final double getSellOutFrozen() {
        return this.sellOutFrozenProperty().get();
    }

    public final void setSellOutFrozen(double sellOutFrozen) {
        this.sellOutFrozenProperty().set(sellOutFrozen);
    }

    public final DoubleProperty buyInFrozenProperty() {
        return this.buyInFrozen;
    }

    public final double getBuyInFrozen() {
        return this.buyInFrozenProperty().get();
    }

    public final void setBuyInFrozen(double buyInFrozen) {
        this.buyInFrozenProperty().set(buyInFrozen);
    }

    public final DoubleProperty preFrozenQtyProperty() {
        return this.preFrozenQty;
    }

    public final double getPreFrozenQty() {
        return this.preFrozenQtyProperty().get();
    }

    public final void setPreFrozenQty(double preFrozenQty) {
        this.preFrozenQtyProperty().set(preFrozenQty);
    }

    public final DoubleProperty buyCostAmtProperty() {
        return this.buyCostAmt;
    }

    public final double getBuyCostAmt() {
        return this.buyCostAmtProperty().get();
    }

    public final void setBuyCostAmt(double buyCostAmt) {
        this.buyCostAmtProperty().set(buyCostAmt);
    }

    public final DoubleProperty capitalPrecentProperty() {
        return this.capitalPrecent;
    }

    public final double getCapitalPrecent() {
        return this.capitalPrecentProperty().get();
    }

    public final void setCapitalPrecent(double capitalPrecent) {
        this.capitalPrecentProperty().set(capitalPrecent);
    }

    public final DoubleProperty totalProfitLossPrecentProperty() {
        return this.totalProfitLossPrecent;
    }

    public final double getTotalProfitLossPrecent() {
        return this.totalProfitLossPrecentProperty().get();
    }

    public final void setTotalProfitLossPrecent(double totalProfitLossPrecent) {
        this.totalProfitLossPrecentProperty().set(totalProfitLossPrecent);
    }

    public final LongProperty countVaritionProperty() {
        return this.countVarition;
    }

    public final long getCountVarition() {
        return this.countVaritionProperty().get();
    }

    public final void setCountVarition(long countVarition) {
        this.countVaritionProperty().set(countVarition);
    }

    public final DoubleProperty costVaritionProperty() {
        return this.costVarition;
    }

    public final double getCostVarition() {
        return this.costVaritionProperty().get();
    }

    public final void setCostVarition(double costVarition) {
        this.costVaritionProperty().set(costVarition);
    }

    public final DoubleProperty priceFloatPercentProperty() {
        return this.priceFloatPercent;
    }

    public final double getPriceFloatPercent() {
        return this.priceFloatPercentProperty().get();
    }

    public final void setPriceFloatPercent(double priceFloatPercent) {
        this.priceFloatPercentProperty().set(priceFloatPercent);
    }

    public DoubleProperty preBuyCostAmtProperty() {
        return this.preBuyCostAmt;
    }

    public double getPreBuyCostAmt() {
        return this.preBuyCostAmtProperty().get();
    }

    public void setPreBuyCostAmt(double preBuyCostAmt) {
        this.preBuyCostAmtProperty().set(preBuyCostAmt);
    }

    public double getClosePrice() {
        return this.closePrice;
    }

    public void setClosePrice(double closePrice) {
        this.closePrice = closePrice;
    }

    public final DoubleProperty floatPlProperty() {
        return this.floatPl;
    }

    public final double getFloatPl() {
        return this.floatPlProperty().get();
    }

    public final void setFloatPl(double floatPl) {
        this.floatPlProperty().set(floatPl);
    }

    public final DoubleProperty totalPlProperty() {
        return this.totalPl;
    }

    public final double getTotalPl() {
        return this.totalPlProperty().get();
    }

    public final void setTotalPl(double totalPl) {
        this.totalPlProperty().set(totalPl);
    }

    public final DoubleProperty todayRealPlProperty() {
        return this.todayRealPl;
    }

    public final double getTodayRealPl() {
        return this.todayRealPlProperty().get();
    }

    public final void setTodayRealPl(double todayRealPl) {
        this.todayRealPlProperty().set(todayRealPl);
    }

    public final DoubleProperty todayTotalPlProperty() {
        return this.todayTotalPl;
    }

    public final double getTodayTotalPl() {
        return this.todayTotalPlProperty().get();
    }

    public final void setTodayTotalPl(double todayTotalPl) {
        this.todayTotalPlProperty().set(todayTotalPl);
    }

    public final DoubleProperty todayFloatPlProperty() {
        return this.todayFloatPl;
    }

    public final double getTodayFloatPl() {
        return this.todayFloatPlProperty().get();
    }

    public final void setTodayFloatPl(double todayFloatPl) {
        this.todayFloatPlProperty().set(todayFloatPl);
    }

    public final StringProperty totalStockPercentProperty() {
        return this.totalStockPercent;
    }

    public final String getTotalStockPercent() {
        return (String)this.totalStockPercentProperty().get();
    }

    public final void setTotalStockPercent(String totalStockPercent) {
        this.totalStockPercentProperty().set((Object)totalStockPercent);
    }

    public void updateCalValue(CcsPosition ccsPosition) {
        if (ccsPosition == null) {
            return;
        }
        this.setNowPrice(ccsPosition.getNowPrice());
        this.setYield(ccsPosition.getYield());
        this.setCarryYield(ccsPosition.getCarryYield());
        this.setCapitalization(ccsPosition.getCapitalization());
        this.setPriceFloatPercent(ccsPosition.getPriceFloatPercent());
        this.setPercent(ccsPosition.getPercent());
        this.setFloatPl(ccsPosition.getFloatPl());
        this.setTodayFloatPl(ccsPosition.getTodayFloatPl());
        this.setTotalPl(ccsPosition.getTotalPl());
        this.setCapitalPrecent(ccsPosition.getCapitalPrecent());
        this.setTotalProfitLossPrecent(ccsPosition.getTotalProfitLossPrecent());
        this.setTodayTotalPl(ccsPosition.getTodayTotalPl());
        this.setPlRate(this.formatScale(ccsPosition.getCarryBuyCostAmtNew() == 0.0 ? 0.0 : ccsPosition.getFloatPl() / ccsPosition.getCarryBuyCostAmtNew(), 2));
    }

    public DoubleProperty preCarryBuyCostAmtProperty() {
        return this.preCarryBuyCostAmt;
    }

    public double getPreCarryBuyCostAmt() {
        return this.preCarryBuyCostAmtProperty().get();
    }

    public void setPreCarryBuyCostAmt(double preCarryBuyCostAmt) {
        this.preCarryBuyCostAmtProperty().set(preCarryBuyCostAmt);
    }

    public DoubleProperty carryBuyCostAmtProperty() {
        return this.carryBuyCostAmt;
    }

    public double getCarryBuyCostAmt() {
        return this.carryBuyCostAmtProperty().get();
    }

    public void setCarryBuyCostAmt(double carryBuyCostAmt) {
        this.carryBuyCostAmtProperty().set(carryBuyCostAmt);
    }

    public DoubleProperty carryBuyCostProperty() {
        return this.carryBuyCost;
    }

    public double getCarryBuyCost() {
        return this.carryBuyCostProperty().get();
    }

    public void setCarryBuyCost(double carryBuyCost) {
        this.carryBuyCostProperty().set(carryBuyCost);
    }

    public DoubleProperty preCarryRealizedPlProperty() {
        return this.preCarryRealizedPl;
    }

    public double getPreCarryRealizedPl() {
        return this.preCarryRealizedPlProperty().get();
    }

    public void setPreCarryRealizedPl(double preCarryRealizedPl) {
        this.preCarryRealizedPlProperty().set(preCarryRealizedPl);
    }

    public DoubleProperty carryRealizedPlProperty() {
        return this.carryRealizedPl;
    }

    public double getCarryRealizedPl() {
        return this.carryRealizedPlProperty().get();
    }

    public void setCarryRealizedPl(double carryRealizedPl) {
        this.carryRealizedPlProperty().set(carryRealizedPl);
    }

    public DoubleProperty carryYieldProperty() {
        return this.carryYield;
    }

    public double getCarryYield() {
        return this.carryYieldProperty().get();
    }

    public void setCarryYield(double carryYield) {
        this.carryYieldProperty().set(carryYield);
    }

    public double getCanVolDouble() {
        return this.canVolDouble;
    }

    public void setCanVolDouble(double canVolDouble) {
        this.canVolDouble = canVolDouble;
    }

    public final StringProperty restrictedSecurityTypeProperty() {
        return this.restrictedSecurityType;
    }

    public final String getRestrictedSecurityType() {
        return (String)this.restrictedSecurityTypeProperty().get();
    }

    public final void setRestrictedSecurityType(String restrictedSecurityType) {
        this.restrictedSecurityTypeProperty().set((Object)restrictedSecurityType);
    }

    public final StringProperty circulationTypeProperty() {
        return this.circulationType;
    }

    public final String getCirculationType() {
        return (String)this.circulationTypeProperty().get();
    }

    public final void setCirculationType(String circulationType) {
        this.circulationTypeProperty().set((Object)circulationType);
    }

    public final StringProperty equityTypeProperty() {
        return this.equityType;
    }

    public final String getEquityType() {
        return (String)this.equityTypeProperty().get();
    }

    public final void setEquityType(String equityType) {
        this.equityTypeProperty().set((Object)equityType);
    }

    public final StringProperty listingYearProperty() {
        return this.listingYear;
    }

    public final String getListingYear() {
        return (String)this.listingYearProperty().get();
    }

    public final void setListingYear(String listingYear) {
        this.listingYearProperty().set((Object)listingYear);
    }

    public final DoubleProperty preRealizedPlProperty() {
        return this.preRealizedPl;
    }

    public final double getPreRealizedPl() {
        return this.preRealizedPlProperty().get();
    }

    public final void setPreRealizedPl(double preRealizedPl) {
        this.preRealizedPlProperty().set(preRealizedPl);
    }

    public final DoubleProperty netProperty() {
        return this.net;
    }

    public final double getNet() {
        return this.netProperty().get();
    }

    public final void setNet(double net) {
        this.netProperty().set(net);
    }

    public double getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(double exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public final DoubleProperty carryBuyCostAmtNewProperty() {
        return this.carryBuyCostAmtNew;
    }

    public final double getCarryBuyCostAmtNew() {
        return this.carryBuyCostAmtNewProperty().get();
    }

    public final void setCarryBuyCostAmtNew(double carryBuyCostAmtNew) {
        this.carryBuyCostAmtNewProperty().set(carryBuyCostAmtNew);
    }

    public final DoubleProperty availProperty() {
        return this.avail;
    }

    public final double getAvail() {
        return this.availProperty().get();
    }

    public final void setAvail(double avail) {
        this.availProperty().set(avail);
    }

    public final DoubleProperty totalVolStdProperty() {
        return this.totalVolStd;
    }

    public final double getTotalVolStd() {
        return this.totalVolStdProperty().get();
    }

    public final void setTotalVolStd(double totalVolStd) {
        this.totalVolStdProperty().set(totalVolStd);
    }

    public final DoubleProperty reduceQtyProperty() {
        return this.reduceQty;
    }

    public final double getReduceQty() {
        return this.reduceQtyProperty().get();
    }

    public final void setReduceQty(double reduceQty) {
        this.reduceQtyProperty().set(reduceQty);
    }

    public final DoubleProperty plRateProperty() {
        return this.plRate;
    }

    public final double getPlRate() {
        return this.plRateProperty().get();
    }

    public final void setPlRate(double plRate) {
        this.plRateProperty().set(plRate);
    }

    public Boolean isSell() {
        return this.sell;
    }

    public void setSell(Boolean sell) {
        this.sell = sell;
    }

    public final DoubleProperty carryBuyCostAmtRateProperty() {
        return this.carryBuyCostAmtRate;
    }

    public final double getCarryBuyCostAmtRate() {
        return this.carryBuyCostAmtRateProperty().get();
    }

    public final void setCarryBuyCostAmtRate(double carryBuyCostAmtRate) {
        this.carryBuyCostAmtRateProperty().set(carryBuyCostAmtRate);
    }

    public final DoubleProperty posiCapitalRateProperty() {
        return this.posiCapitalRate;
    }

    public final double getPosiCapitalRate() {
        return this.posiCapitalRateProperty().get();
    }

    public final void setPosiCapitalRate(double posiCapitalRate) {
        this.posiCapitalRateProperty().set(posiCapitalRate);
    }
}

