/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.api.trade.info.ICcsPortfPostQueryInfo;
import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import cms.tmx.http.api.strategy.dto.PositionNew;
import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcsPortfPosition
extends CcsPosition
implements ICcsPortfPostQueryInfo {
    private StringProperty portfolioId = new SimpleStringProperty("");
    private StringProperty portfolioName = new SimpleStringProperty("");
    private StringProperty subAccntId = new SimpleStringProperty("");
    private StringProperty subSecAccntId = new SimpleStringProperty("");
    private StringProperty remark = new SimpleStringProperty("");
    private DoubleProperty transferCount = new SimpleDoubleProperty(-1.0);
    private DoubleProperty priceNow = new SimpleDoubleProperty();
    private StringProperty otcMarket = new SimpleStringProperty("");
    private DoubleProperty canVolDoubleOTC = new SimpleDoubleProperty(0.0);
    private DoubleProperty totalDoubleOTC = new SimpleDoubleProperty(0.0);
    private String linkSecAccntId;
    private String linkSubAccntId;
    private MarketItem mktItem;
    private static final Logger logger = LogManager.getLogger(CcsPortfPosition.class);

    public MarketItem getMktItem() {
        return this.mktItem;
    }

    public void setMktItem(MarketItem item) {
        this.mktItem = item;
    }

    @Override
    public String unique() {
        return String.valueOf(this.getSubSecAccntId()) + this.getSecId();
    }

    @Override
    public void update(Object obj) {
        try {
            if (obj instanceof PPositionService.SubPosition) {
                PPositionService.SubPosition position = (PPositionService.SubPosition)PPositionService.SubPosition.class.cast(obj);
                this.update(position);
                PCcsExtra.CcsSubPositionExtra ccs = (PCcsExtra.CcsSubPositionExtra)position.getObject().unpack(PCcsExtra.CcsSubPositionExtra.class);
                PCcsExtra.CcsPosition ccsP = (PCcsExtra.CcsPosition)PCcsExtra.CcsPosition.class.cast(ccs.getPosition());
                super.update(ccsP);
            } else if (obj instanceof CcsPortfPosition) {
                super.update(obj);
                CcsPortfPosition pos = (CcsPortfPosition)((Object)CcsPortfPosition.class.cast(obj));
                this.update(pos);
            } else if (obj instanceof BasketSecurityInst) {
                this.update((BasketSecurityInst)((Object)BasketSecurityInst.class.cast(obj)));
            } else if (obj instanceof BasketAlgoItem) {
                this.update((BasketAlgoItem)((Object)BasketAlgoItem.class.cast(obj)));
            } else if (obj instanceof PositionNew) {
                PositionNew s = (PositionNew)PositionNew.class.cast(obj);
                this.update(s);
            }
        }
        catch (InvalidProtocolBufferException e) {
            logger.error(e.getMessage());
        }
    }

    private void update(PositionNew p) {
        this.setInvestorId(p.getInvestorId());
        this.setSecId(p.getInstrument().getSecurityId());
        this.setSecName(p.getInstrument().getSymbol());
        this.setSecType(p.getInstrument().getSecurityType() == null ? "" : p.getInstrument().getSecurityType());
        this.setPriceNow(p.getCost());
        this.setOtcMarket("XOTC".equals(p.getInstrument().getMarket()) ? "\u573a\u5916" : "");
        System.err.println(String.valueOf(p.getInstrument().getSecurityId()) + "|" + p.getAccntId() + "|" + p.getInstrument().getMarket() + "|" + p.getSubAccntId() + "|" + p.getSecAccntId());
        this.setExtAccId(p.getAccntId());
        this.setSubSecAccntId(p.getSecAccntId());
        this.setSubAccntId(p.getSubAccntId());
        this.setLinkSecAccntId(p.getLinkSecAccntId());
        this.setLinkSubAccntId(p.getLinkSubAccntId());
        this.setTotalVol(new Double(p.getAvail()).longValue());
        this.setTotalDoubleOTC(new BigDecimal(p.getBalance()).doubleValue());
        this.setCanVol(new Double(p.getAvail()).longValue());
        this.setCanVolDouble(new BigDecimal(p.getAvail()).doubleValue());
        this.setCanVolDoubleOTC(new BigDecimal(p.getAvail()).doubleValue());
        this.setFrozenVol(p.getFrozen());
        this.setNowPrice((double)Math.round(p.getLastPx() * 10000.0) / 10000.0);
        this.setClosePrice((double)Math.round(p.getLastPx() * 10000.0) / 10000.0);
        this.setBuyCost((double)Math.round(p.getBuyCost() * 10000.0) / 10000.0);
        this.setBuyCostAmt(p.getBuyCostAmt());
        this.setPortfolioId(p.getPortfolioId());
        this.setPortfolioName(p.getPortfolioName());
        this.setYield((double)Math.round(p.getYield() * 10000.0) / 100.0);
    }

    private void update(BasketAlgoItem item) {
        this.setExtAccId(item.getExtAccntId());
        this.setExtSecAccId(item.getExtSecAccntId());
        this.setSubAccntId(item.getSubAccntId());
        this.setSubSecAccntId(item.getSubSecAccntId());
        this.setSecId(item.getCode());
        this.getMarket().setRaw(item.getMarket().getRaw());
        this.setSecType(item.getType());
    }

    private void update(BasketSecurityInst inst) {
        this.setExtAccId(inst.getExtAccntId());
        this.setExtSecAccId(inst.getExtSecAccntId());
        this.setSubAccntId(inst.getSubAccntId());
        this.setSubSecAccntId(inst.getSubSecAccntId());
        this.setSecId(inst.getSecurityId());
        this.getMarket().setRaw(inst.getMarket());
        this.setSecType(inst.getSecurityType());
    }

    private void update(PPositionService.SubPosition sp) {
        super.update(sp);
        this.setPortfolioId(sp.getPortfolioId());
        this.setSubAccntId(sp.getSubAccntId());
        this.setSubSecAccntId(sp.getSubSecAccntId());
    }

    private void update(CcsPortfPosition po) {
        this.setTotalVol(po.getTotalVol());
        this.setBuyIn(po.getBuyIn());
        this.setSellOut(po.getSellOut());
        this.setBuyInAmount(po.getBuyInAmount());
        this.setSellOutAmount(po.getSellOutAmount());
        this.setImpawnIn(po.getImpawnIn());
        this.setProfit(po.getProfit());
        this.setCost(BigDecimal.valueOf(po.getCost()).setScale(3, 4).doubleValue());
        this.setCapitalization(po.getCapitalization());
        this.setCostAmt(po.getCostAmt());
        this.setTradingDay(po.getTradingDay());
        this.setFrozenVol(po.getTotalVol() - po.getCanVol());
        this.setCanVol(po.getCanVol());
        this.setCanVolDouble(po.getCanVolDouble());
        this.setTotalDoubleOTC(po.getTotalDoubleOTC());
        this.setCanVolDoubleOTC(po.getCanVolDoubleOTC());
        this.setSecId(po.getSecId());
        this.setExtAccId(po.getExtAccId());
        this.setExtSecAccId(po.getExtSecAccId());
        this.setMarketGrp(po.getMarketGrp());
        this.setSecName(po.getSecName());
        this.setSecType(po.getSecType());
        if (po.getMarket() != null) {
            this.getMarket().setRaw(po.getMarket().getRaw());
        }
        this.setPortfolioId(po.getPortfolioId());
        this.setPortfolioName(po.getPortfolioName());
        this.setSubAccntId(po.getSubAccntId());
        this.setSubSecAccntId(po.getSubSecAccntId());
        this.setPreTotalQty(po.getPreTotalQty());
        this.setPreCapitalization(po.getPreCapitalization());
        this.setCurDividend(po.getCurDividend());
    }

    public final StringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    @Override
    public final String getPortfolioId() {
        return (String)this.portfolioIdProperty().get();
    }

    @Override
    public final void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set((Object)portfolioId);
    }

    public final StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    @Override
    public final String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    @Override
    public final void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public final StringProperty subAccntIdProperty() {
        return this.subAccntId;
    }

    public String getSubAccntId() {
        return (String)this.subAccntIdProperty().get();
    }

    public final void setSubAccntId(String subAccntId) {
        this.subAccntIdProperty().set((Object)subAccntId);
    }

    public final StringProperty subSecAccntIdProperty() {
        return this.subSecAccntId;
    }

    public final String getSubSecAccntId() {
        return (String)this.subSecAccntIdProperty().get();
    }

    public final void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntIdProperty().set((Object)subSecAccntId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.subAccntId.get() == null ? 0 : ((String)this.subAccntId.get()).hashCode());
        result = 31 * result + (this.subSecAccntId.get() == null ? 0 : ((String)this.subSecAccntId.get()).hashCode());
        result = 31 * result + (this.restrictedSecurityType.get() == null ? 0 : ((String)this.restrictedSecurityType.get()).hashCode());
        result = 31 * result + (this.circulationType.get() == null ? 0 : ((String)this.circulationType.get()).hashCode());
        result = 31 * result + (this.equityType.get() == null ? 0 : ((String)this.equityType.get()).hashCode());
        result = 31 * result + (this.listingYear.get() == null ? 0 : ((String)this.listingYear.get()).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CcsPortfPosition other = (CcsPortfPosition)((Object)obj);
        if (this.subAccntId.get() == null ? other.subAccntId.get() != null : !((String)this.subAccntId.get()).equals(other.subAccntId.get())) {
            return false;
        }
        return !(this.subSecAccntId.get() == null ? other.subSecAccntId.get() != null : !((String)this.subSecAccntId.get()).equals(other.subSecAccntId.get()));
    }

    @Override
    public String toString() {
        return "CcsPortfPosition [subAccntId=" + this.subAccntId + ", subSecAccntId=" + this.subSecAccntId + "]";
    }

    public StringProperty remarkProperty() {
        return this.remark;
    }

    public String getRemark() {
        return (String)this.remarkProperty().get();
    }

    public void setRemark(String remark) {
        this.remarkProperty().set((Object)remark);
    }

    public final DoubleProperty priceNowProperty() {
        return this.priceNow;
    }

    public final double getPriceNow() {
        return this.priceNowProperty().get();
    }

    public final void setPriceNow(double priceNow) {
        this.priceNowProperty().set(priceNow);
    }

    public final StringProperty otcMarketProperty() {
        return this.otcMarket;
    }

    public final String getOtcMarket() {
        return (String)this.otcMarketProperty().get();
    }

    public final void setOtcMarket(String otcMarket) {
        this.otcMarketProperty().set((Object)otcMarket);
    }

    public String getLinkSecAccntId() {
        return this.linkSecAccntId;
    }

    public void setLinkSecAccntId(String linkSecAccntId) {
        this.linkSecAccntId = linkSecAccntId;
    }

    public String getLinkSubAccntId() {
        return this.linkSubAccntId;
    }

    public void setLinkSubAccntId(String linkSubAccntId) {
        this.linkSubAccntId = linkSubAccntId;
    }

    public final DoubleProperty transferCountProperty() {
        return this.transferCount;
    }

    public final double getTransferCount() {
        return this.transferCountProperty().get();
    }

    public final void setTransferCount(double transferCount) {
        this.transferCountProperty().set(transferCount);
    }

    public final DoubleProperty totalDoubleOTCProperty() {
        return this.totalDoubleOTC;
    }

    public final double getTotalDoubleOTC() {
        return this.totalDoubleOTCProperty().get();
    }

    public final void setTotalDoubleOTC(double totalDoubleOTC) {
        this.totalDoubleOTCProperty().set(totalDoubleOTC);
    }

    public final DoubleProperty canVolDoubleOTCProperty() {
        return this.canVolDoubleOTC;
    }

    public final double getCanVolDoubleOTC() {
        return this.canVolDoubleOTCProperty().get();
    }

    public final void setCanVolDoubleOTC(double canVolDoubleOTC) {
        this.canVolDoubleOTCProperty().set(canVolDoubleOTC);
    }
}

