/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.InvalidProtocolBufferException;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcsOrder
extends Order {
    private String subAccntId = "";
    private String currencyId = "";
    private String brokerId = "";
    private int preOrdStatus;
    private double filledAvgPrice;
    private DoubleProperty avgPx = new SimpleDoubleProperty(0.0);
    String accName = "";
    String counterName = "";
    private long frozenQty;
    private long wthQty;
    private long wthAmt;
    private String parentId = "";
    private String basketId = "";
    private MxNode legMode;
    private PBase.OpStatus opStatus;
    private double productOfAvgAndQty = 0.0;
    private int val = 0;
    private static final Logger logger = LogManager.getLogger(CcsOrder.class);

    public CcsOrder() {
        Instrument ins = new Instrument();
        this.setInstrument(ins);
        this.setSide(MxNodeFactory.create((String)"side", (String)""));
        this.setOrdStatus(MxNodeFactory.create((String)"ord_status", (String)""));
        this.setLegMode(MxNodeFactory.create((String)"leg_mode", (String)""));
    }

    @Override
    public void update(Object obj) {
        try {
            if (obj instanceof POrderService.SingleOrder) {
                super.update(obj);
                POrderService.SingleOrder order = (POrderService.SingleOrder)POrderService.SingleOrder.class.cast(obj);
                if (order.getObject() != null) {
                    PCcsExtra.CcsSingleOrderExtra ccs = (PCcsExtra.CcsSingleOrderExtra)order.getObject().unpack(PCcsExtra.CcsSingleOrderExtra.class);
                    this.update(ccs);
                }
            } else if (obj instanceof CcsOrder) {
                super.update(obj);
                CcsOrder order = (CcsOrder)((Object)CcsOrder.class.cast(obj));
                this.update(order);
            }
        }
        catch (InvalidProtocolBufferException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void update(CcsOrder en) {
        this.setExtAccntId(en.getExtAccntId());
        this.setSubAccntId(en.getSubAccntId());
        this.setPortfolioId(en.getPortfolioId());
        this.setCurrencyId(en.getCurrencyId());
        this.setInvestorId(en.getInvestorId());
        this.setBrokerId(en.getBrokerId());
        this.setFrozenQty(en.getFrozenQty());
        this.setAvgPx(en.getAvgPx());
        this.setAccName(en.getAccName());
        this.setTotalValue(en.getTotalValue());
        this.setWthQty(en.getWthQty());
        this.setWthAmt(en.getWthAmt());
        this.setWthErrCode(en.getWthErrCode());
        this.setWthErrInfo(en.getWthErrInfo());
        this.setErrCode(en.getErrCode());
        this.setErrInfo(en.getErrInfo());
        this.setParentId(en.getParentId());
        this.setBasketId(en.getBasketId());
        this.setLegMode(en.getLegMode());
        if (en.getNowPrice() != 0.0) {
            this.setNowPrice(en.getNowPrice());
        }
        this.setBasketName(en.getBasketName());
        this.setExecExpectQty(en.getExecExpectQty());
        this.setExecExpectAmt(en.getExecExpectAmt());
        this.setCounterName(en.getCounterName());
    }

    private void update(PCcsExtra.CcsSingleOrderExtra en) {
        this.setExtAccntId(en.getExtAccntId());
        this.setSubAccntId(en.getSubAccntId());
        this.setPortfolioId(en.getPortfolioId());
        this.setCurrencyId(en.getCurrencyId());
        this.setInvestorId(en.getInvestorId());
        this.setBrokerId(en.getBrokerId());
        this.setFrozenQty(en.getFrozenQty());
        this.setWthQty(en.getWthQty());
        this.setWthErrCode(en.getWthErrCode());
        this.setWthErrInfo(en.getWthErrInfo());
        this.setErrCode(en.getErrCode());
        this.setErrInfo(this.transferErrInfo(en));
        this.getLegMode().setRaw(Integer.toString(en.getLegModeValue()));
        if ("2".equals(this.getLegMode().getRaw())) {
            this.setBasketId(en.getParentId());
        } else {
            this.setParentId(en.getParentId());
        }
    }

    private String transferErrInfo(PCcsExtra.CcsSingleOrderExtra en) {
        StringBuilder errorInfo = new StringBuilder();
        if (1 != en.getErrCode() && !StringUtils.isEmpty((String)en.getErrInfo())) {
            errorInfo.append("\u4e0b\u5355\u9519\u8bef\uff08").append(en.getErrInfo()).append("\uff09");
        } else {
            errorInfo.append(en.getErrInfo()).append(" ");
        }
        if (1 != en.getWthErrCode() && !StringUtils.isEmpty((String)en.getWthErrInfo())) {
            errorInfo.append("\u64a4\u5355\u9519\u8bef\uff08").append(en.getWthErrInfo()).append("\uff09");
        }
        if (!StringUtils.isEmpty((String)this.getRiskDetail())) {
            errorInfo.append("\u98ce\u63a7\u8be6\u60c5\uff08").append(this.getRiskDetail()).append("\uff09");
        }
        return errorInfo.toString();
    }

    public static double calAmountByMarketAndSecType(String market, String secType, double qty, double price) {
        double amount = 0.0;
        switch (secType) {
            case "STD_BOND": {
                amount = qty * (double)("XSHG".equals(market) ? 1000 : 100);
                break;
            }
            case "BOND": {
                amount = qty * price * (double)("XSHG".equals(market) ? 10 : 1);
                break;
            }
            default: {
                amount = qty * price;
            }
        }
        return amount;
    }

    public PBase.OpStatus getOpStatus() {
        return this.opStatus;
    }

    public void setOpStatus(PBase.OpStatus opStatus) {
        this.opStatus = opStatus;
    }

    public String getSubAccntId() {
        return this.subAccntId;
    }

    public void setSubAccntId(String subAccntId) {
        this.subAccntId = subAccntId;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    @Override
    public String getBrokerId() {
        return this.brokerId;
    }

    @Override
    public void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }

    public long getFrozenQty() {
        return this.frozenQty;
    }

    public void setFrozenQty(long frozenQty) {
        this.frozenQty = frozenQty;
    }

    public long getWthQty() {
        return this.wthQty;
    }

    public void setWthQty(long wthQty) {
        this.wthQty = wthQty;
    }

    public int getPreOrdStatus() {
        return this.preOrdStatus;
    }

    public void setPreOrdStatus(int preOrdStatus) {
        this.preOrdStatus = preOrdStatus;
    }

    public double getFilledAvgPrice() {
        return this.filledAvgPrice;
    }

    public void setFilledAvgPrice(double filledAvgPrice) {
        this.filledAvgPrice = filledAvgPrice;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public MxNode getLegMode() {
        return this.legMode;
    }

    public void setLegMode(MxNode legMode) {
        this.legMode = legMode;
    }

    public String getBasketId() {
        return this.basketId;
    }

    public void setBasketId(String basketId) {
        this.basketId = basketId;
    }

    public double getProductOfAvgAndQty() {
        return this.productOfAvgAndQty;
    }

    public void setProductOfAvgAndQty(double productOfAvgAndQty) {
        this.productOfAvgAndQty = productOfAvgAndQty;
    }

    public int getVal() {
        return this.val;
    }

    public void setVal(int val) {
        this.val = val;
    }

    public final DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    @Override
    public final double getAvgPx() {
        return this.avgPxProperty().get();
    }

    @Override
    public final void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public String getAccName() {
        return this.accName;
    }

    public void setAccName(String accName) {
        this.accName = accName;
    }

    public long getWthAmt() {
        if (this.getMarket() == null || this.getInstrument() == null) {
            return (long)((double)this.wthQty * this.getPrice());
        }
        return (long)CcsOrder.calAmountByMarketAndSecType(this.getInstrument().getMarket().getRaw(), this.getInstrument().getSecType(), this.wthQty, this.getPrice());
    }

    public void setWthAmt(long wthAmt) {
        this.wthAmt = wthAmt;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public void setCounterName(String counterName) {
        this.counterName = counterName;
    }
}

