/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PAssetService;
import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.trade.Deal;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcsDeal
extends Deal {
    private String portfolioId = "";
    private String portfolioName = "";
    private String ordTime = "";
    private double orderQty;
    private double orderPrice;
    private double orderAmount;
    private String counterName;
    private static final Logger logger = LogManager.getLogger(CcsDeal.class);

    @Override
    public void update(Object obj) {
        try {
            if (obj instanceof POrderService.Execution) {
                super.update(obj);
                POrderService.Execution en = (POrderService.Execution)POrderService.Execution.class.cast(obj);
                PCcsExtra.CcsExecutionExtra ccs = (PCcsExtra.CcsExecutionExtra)en.getObject().unpack(PCcsExtra.CcsExecutionExtra.class);
                this.update(ccs);
            } else if (obj instanceof CcsDeal) {
                super.update(obj);
                this.update((CcsDeal)((Object)CcsDeal.class.cast(obj)));
            } else if (obj instanceof PAssetService.ExecutionsCollect) {
                PAssetService.ExecutionsCollect deal = (PAssetService.ExecutionsCollect)PAssetService.ExecutionsCollect.class.cast(obj);
                super.update((Object)deal);
                this.update(deal);
            }
        }
        catch (InvalidProtocolBufferException e) {
            logger.error(e.getMessage());
        }
    }

    private void update(PAssetService.ExecutionsCollect deal) {
        this.setPortfolioId(deal.getPortfolioId());
    }

    private void update(CcsDeal en) {
        this.setPortfolioId(en.getPortfolioId());
        this.setPortfolioName(en.getPortfolioName());
        this.setOrdTime(en.getOrdTime());
        this.setOrderQty(en.getOrderQty());
        this.setOrderPrice((double)Math.round(en.getOrderPrice() * 10000.0) / 10000.0);
        this.setOrderAmount(en.getOrderAmount());
        this.setCounterName(en.getCounterName());
    }

    private void update(PCcsExtra.CcsExecutionExtra en) {
        this.setPortfolioId(en.getPortfolioId());
        this.setOrdTime(en.getOrdTime());
        this.setOrderQty(en.getOrderQty());
        this.setOrderPrice(en.getOrderPrice());
        this.setOrderAmount(en.getOrderAmount());
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public String getPortfolioName() {
        return this.portfolioName;
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioName = portfolioName;
    }

    public String getOrdTime() {
        return this.ordTime;
    }

    public void setOrdTime(String ordTime) {
        this.ordTime = ordTime;
    }

    public double getOrderQty() {
        return this.orderQty;
    }

    public void setOrderQty(double orderQty) {
        this.orderQty = orderQty;
    }

    public double getOrderPrice() {
        return this.orderPrice;
    }

    public void setOrderPrice(double orderPrice) {
        this.orderPrice = orderPrice;
    }

    public double getOrderAmount() {
        return this.orderAmount;
    }

    public void setOrderAmount(double orderAmount) {
        this.orderAmount = orderAmount;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public void setCounterName(String counterName) {
        this.counterName = counterName;
    }
}

