/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.proto.trade.PMiscService;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BusinessRef
extends MxChgObj {
    private StringProperty id = new SimpleStringProperty("");
    private StringProperty businessCode = new SimpleStringProperty("");
    private StringProperty businessName = new SimpleStringProperty("");
    private ObjectProperty<MxNode> sourceFlag = new SimpleObjectProperty();
    private ObjectProperty<MxNode> side = new SimpleObjectProperty();
    private StringProperty operate = new SimpleStringProperty("");
    private StringProperty lastUpdateTime = new SimpleStringProperty("");
    public static final String BUSINESS_SOURCE_FLAG = "business_source_flag";
    public static final String BUSINESS_SIDE = "business_side";

    @PostConstruct
    public void init() {
        MxNode node = MxNodeFactory.create((String)BUSINESS_SOURCE_FLAG, (String)"");
        this.setSourceFlag(node);
        node = MxNodeFactory.create((String)BUSINESS_SIDE, (String)"");
        this.setSide(node);
    }

    public void update(Object obj) {
        this.init();
        if (obj instanceof PMiscService.BusinessRefData) {
            PMiscService.BusinessRefData busi = (PMiscService.BusinessRefData)PMiscService.BusinessRefData.class.cast(obj);
            this.update(busi);
            this.changed();
        } else if (obj instanceof BusinessRef) {
            BusinessRef busi = (BusinessRef)((Object)BusinessRef.class.cast(obj));
            this.update(busi);
            this.changed();
        }
    }

    private void update(PMiscService.BusinessRefData busi) {
        this.setId(busi.getId());
        this.setBusinessCode(busi.getBusinessCode());
        this.setBusinessName(busi.getBusinessName());
        this.getSourceFlag().setRaw(Integer.toString(busi.getSourceFlag()));
        this.getSide().setRaw(busi.getSide() == null ? "" : busi.getSide());
        this.setLastUpdateTime(busi.getLastUpdateTime());
    }

    private void update(BusinessRef busi) {
        this.setId(busi.getId());
        this.setBusinessCode(busi.getBusinessCode());
        this.setBusinessName(busi.getBusinessName());
        this.getSourceFlag().setRaw(busi.getSourceFlag().getRaw());
        this.getSide().setRaw(busi.getSide().getRaw());
        this.setLastUpdateTime(busi.getLastUpdateTime());
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final String getId() {
        return (String)this.idProperty().get();
    }

    public final void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public final StringProperty businessCodeProperty() {
        return this.businessCode;
    }

    public final String getBusinessCode() {
        return (String)this.businessCodeProperty().get();
    }

    public final void setBusinessCode(String businessCode) {
        this.businessCodeProperty().set((Object)businessCode);
    }

    public final StringProperty businessNameProperty() {
        return this.businessName;
    }

    public final String getBusinessName() {
        return (String)this.businessNameProperty().get();
    }

    public final void setBusinessName(String businessName) {
        this.businessNameProperty().set((Object)businessName);
    }

    public final StringProperty operateProperty() {
        return this.operate;
    }

    public final String getOperate() {
        return (String)this.operateProperty().get();
    }

    public final void setOperate(String operate) {
        this.operateProperty().set((Object)operate);
    }

    public final StringProperty lastUpdateTimeProperty() {
        return this.lastUpdateTime;
    }

    public final String getLastUpdateTime() {
        return (String)this.lastUpdateTimeProperty().get();
    }

    public final void setLastUpdateTime(String lastUpdateTime) {
        this.lastUpdateTimeProperty().set((Object)lastUpdateTime);
    }

    public final ObjectProperty<MxNode> sourceFlagProperty() {
        return this.sourceFlag;
    }

    public final MxNode getSourceFlag() {
        return (MxNode)this.sourceFlagProperty().get();
    }

    public final void setSourceFlag(MxNode sourceFlag) {
        this.sourceFlagProperty().set((Object)sourceFlag);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }
}

