/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PPostTrade;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class BlockOrder
extends MxSelObj {
    private static List<String> BLOCK_CANNOT_CANCEL_STATUS = Arrays.asList("3", "5", "6", "7");
    private String extAccntId = "";
    private String subAccntId = "";
    private String secAccntId = "";
    private String subSecAccntId = "";
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty investorName = new SimpleStringProperty("");
    private StringProperty inverstorSecId = new SimpleStringProperty("");
    private StringProperty orderId = new SimpleStringProperty("");
    private StringProperty sysOrderId = new SimpleStringProperty("");
    private Instrument instrument = new Instrument();
    private ObjectProperty<MxNode> side = new SimpleObjectProperty();
    private DoubleProperty price = new SimpleDoubleProperty(0.0);
    private LongProperty orderQty = new SimpleLongProperty(0L);
    private StringProperty unit = new SimpleStringProperty("");
    private LongProperty dealQty = new SimpleLongProperty(0L);
    private ObjectProperty<MxNode> status = new SimpleObjectProperty();
    private ObjectProperty<MxNode> type = new SimpleObjectProperty();
    private StringProperty date = new SimpleStringProperty("");
    private StringProperty time = new SimpleStringProperty("");
    private StringProperty sysTrader = new SimpleStringProperty("");
    private StringProperty contractNo = new SimpleStringProperty("");
    private StringProperty oppositeTradingUnit = new SimpleStringProperty("");
    private StringProperty oppositeTrader = new SimpleStringProperty("");
    private StringProperty contact = new SimpleStringProperty("");
    private StringProperty remark = new SimpleStringProperty("");
    private StringProperty reference = new SimpleStringProperty("");
    private boolean canCancel = false;
    private String secId = "";
    private String secName = "";
    private String market = "";
    private String exSide = "";
    private String exOrdStatus = "";

    public BlockOrder() {
        MxNode node = MxNodeFactory.create((String)"side");
        this.setSide(node);
        node = MxNodeFactory.create((String)"rpt_status", (String)"");
        this.setStatus(node);
        node = MxNodeFactory.create((String)"block_fixed_ord_type", (String)"");
        this.setType(node);
    }

    public void update(Object obj) {
        if (obj instanceof PPostTrade.TradeCaptureReport) {
            this.update((PPostTrade.TradeCaptureReport)PPostTrade.TradeCaptureReport.class.cast(obj));
        } else if (obj instanceof BlockOrder) {
            this.update((BlockOrder)((Object)BlockOrder.class.cast(obj)));
        }
    }

    public void update(PPostTrade.TradeCaptureReport report) {
        PComponent.Instrument inst = report.getInstrument();
        Instrument in = new Instrument();
        in.update((Object)inst);
        this.setInstrument(in);
        this.setExtAccntId(report.getExtAccntId());
        this.setSecAccntId(report.getExtSecAccntId());
        String side = String.valueOf(report.getSides().getSide(0).getSideValue());
        this.getSide().setRaw(side);
        String type = String.valueOf(report.getApplType());
        this.getType().setRaw(type);
        this.setPrice(BigDecimal.valueOf(report.getLastPx()).setScale(4, 4).doubleValue());
        this.setOrderQty((long)report.getLastQty());
        this.setDealQty((long)report.getCumQty());
        String status = String.valueOf(report.getTradeRptStatus().getNumber());
        this.getStatus().setRaw(status);
        this.setCanCancel(status);
        this.setOrderId(report.getTradeId());
        this.setSysOrderId(report.getTradeReportId());
        this.setDate(report.getOrigTradeDate());
        this.setTime(report.getOrigTradeTime());
        this.setContractNo(report.getConfirmId());
        this.setOppositeTradingUnit(report.getSides().getSide(0).getPartyIds().getPartyId(0).getPartyId());
        this.setSysTrader(report.getOpUser().getUserId());
        this.setOppositeTrader(report.getTrader().getTraderId());
        this.setContact(report.getTrader().getContactNo());
        this.setRemark(this.parseRemark(report));
        this.setReference(report.getReference());
        this.setSecId(this.getInstrument().getSecId());
        this.setSecName(this.getInstrument().getSymbol());
        this.setMarket(this.getInstrument().getMarket().getValue());
        this.setExSide(this.getSide().getValue());
        this.setExOrdStatus(this.getStatus().getValue());
    }

    private String parseRemark(PPostTrade.TradeCaptureReport report) {
        int errCode = report.getErrCode();
        String errInfo = report.getErrInfo();
        String rejInfo = report.getRejectText();
        int wthCode = report.getWthErrCode();
        String wthInfo = report.getWthErrInfo();
        String riskInfo = report.getRiskCheckInfo();
        StringBuilder remark = new StringBuilder();
        if (1 != errCode && !errInfo.isEmpty()) {
            this.append(remark, "\u4e0b\u5355\u9519\u8bef", errInfo);
        } else if (!rejInfo.isEmpty()) {
            this.append(remark, "\u4e0b\u5355\u9519\u8bef", rejInfo);
        } else {
            remark.append(errInfo);
        }
        if (1 != wthCode && !wthInfo.isEmpty()) {
            this.append(remark, "\u64a4\u5355\u9519\u8bef", wthInfo);
        }
        if (!riskInfo.isEmpty()) {
            this.append(remark, "\u98ce\u63a7\u8be6\u60c5", riskInfo);
        }
        return remark.toString();
    }

    private StringBuilder append(StringBuilder remark, String type, String info) {
        return remark.append(type).append("\uff08").append(info).append("\uff09");
    }

    public void update(BlockOrder order) {
        this.setOrderId(order.getOrderId());
        this.setSysOrderId(order.getSysOrderId());
        this.setInvestorId(order.getInvestorId());
        this.setInverstorSecId(order.getInverstorSecId());
        this.setSide(order.getSide());
        this.setOrderQty(order.getOrderQty());
        this.setUnit(order.getUnit());
        this.setPrice(order.getPrice());
        this.setDate(order.getDate());
        this.setStatus(order.getStatus());
        this.setCanCancel(this.getStatus().getRaw());
        this.getInstrument().update((Object)order.getInstrument());
        this.setType(order.getType());
        this.setDealQty(order.getDealQty());
        this.setTime(order.getTime());
        this.setSysTrader(order.getSysTrader());
        this.setContractNo(order.getContractNo());
        this.setOppositeTradingUnit(order.getOppositeTradingUnit());
        this.setOppositeTrader(order.getOppositeTrader());
        this.setContact(order.getContact());
        this.setRemark(order.getRemark());
        this.setSecId(order.getSecId());
        this.setSecName(order.getSecName());
        this.setMarket(order.getMarket());
        this.setExSide(order.getExSide());
        this.setExOrdStatus(order.getExOrdStatus());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.date.get() == null ? 0 : ((String)this.date.get()).hashCode());
        result = 31 * result + (this.sysOrderId.get() == null ? 0 : ((String)this.sysOrderId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BlockOrder other = (BlockOrder)((Object)obj);
        if (this.date.get() == null ? other.date.get() != null : !((String)this.date.get()).equals(other.date.get())) {
            return false;
        }
        return !(this.sysOrderId.get() == null ? other.sysOrderId.get() != null : !((String)this.sysOrderId.get()).equals(other.sysOrderId.get()));
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public final StringProperty inverstorSecIdProperty() {
        return this.inverstorSecId;
    }

    public final String getInverstorSecId() {
        return (String)this.inverstorSecIdProperty().get();
    }

    public final void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecIdProperty().set((Object)inverstorSecId);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final LongProperty orderQtyProperty() {
        return this.orderQty;
    }

    public final long getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public final void setOrderQty(long orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final String getUnit() {
        return (String)this.unitProperty().get();
    }

    public final void setUnit(String unit) {
        this.unitProperty().set((Object)unit);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final StringProperty dateProperty() {
        return this.date;
    }

    public final String getDate() {
        return (String)this.dateProperty().get();
    }

    public final void setDate(String date) {
        this.dateProperty().set((Object)date);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty sysTraderProperty() {
        return this.sysTrader;
    }

    public final String getSysTrader() {
        return (String)this.sysTraderProperty().get();
    }

    public final void setSysTrader(String sysTrader) {
        this.sysTraderProperty().set((Object)sysTrader);
    }

    public final StringProperty contractNoProperty() {
        return this.contractNo;
    }

    public final String getContractNo() {
        return (String)this.contractNoProperty().get();
    }

    public final void setContractNo(String contractNo) {
        this.contractNoProperty().set((Object)contractNo);
    }

    public final StringProperty oppositeTradingUnitProperty() {
        return this.oppositeTradingUnit;
    }

    public final String getOppositeTradingUnit() {
        return (String)this.oppositeTradingUnitProperty().get();
    }

    public final void setOppositeTradingUnit(String oppositeTradingUnit) {
        this.oppositeTradingUnitProperty().set((Object)oppositeTradingUnit);
    }

    public final StringProperty oppositeTraderProperty() {
        return this.oppositeTrader;
    }

    public final String getOppositeTrader() {
        return (String)this.oppositeTraderProperty().get();
    }

    public final void setOppositeTrader(String oppositeTrader) {
        this.oppositeTraderProperty().set((Object)oppositeTrader);
    }

    public final StringProperty contactProperty() {
        return this.contact;
    }

    public final String getContact() {
        return (String)this.contactProperty().get();
    }

    public final void setContact(String contact) {
        this.contactProperty().set((Object)contact);
    }

    public final StringProperty timeProperty() {
        return this.time;
    }

    public final String getTime() {
        return (String)this.timeProperty().get();
    }

    public final void setTime(String time) {
        this.timeProperty().set((Object)time);
    }

    public final ObjectProperty<MxNode> typeProperty() {
        return this.type;
    }

    public final MxNode getType() {
        return (MxNode)this.typeProperty().get();
    }

    public final void setType(MxNode type) {
        this.typeProperty().set((Object)type);
    }

    public String getSubAccntId() {
        return this.subAccntId;
    }

    public void setSubAccntId(String subAccntId) {
        this.subAccntId = subAccntId;
    }

    public String getSecAccntId() {
        return this.secAccntId;
    }

    public void setSecAccntId(String secAccntId) {
        this.secAccntId = secAccntId;
    }

    public String getSubSecAccntId() {
        return this.subSecAccntId;
    }

    public void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntId = subSecAccntId;
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public final StringProperty orderIdProperty() {
        return this.orderId;
    }

    public final String getOrderId() {
        return (String)this.orderIdProperty().get();
    }

    public final void setOrderId(String orderId) {
        this.orderIdProperty().set((Object)orderId);
    }

    public final LongProperty dealQtyProperty() {
        return this.dealQty;
    }

    public final long getDealQty() {
        return this.dealQtyProperty().get();
    }

    public final void setDealQty(long dealQty) {
        this.dealQtyProperty().set(dealQty);
    }

    public final StringProperty remarkProperty() {
        return this.remark;
    }

    public final String getRemark() {
        return (String)this.remarkProperty().get();
    }

    public final void setRemark(String remark) {
        this.remarkProperty().set((Object)remark);
    }

    public final StringProperty referenceProperty() {
        return this.reference;
    }

    public final String getReference() {
        return (String)this.referenceProperty().get();
    }

    public final void setReference(String reference) {
        this.referenceProperty().set((Object)reference);
    }

    public boolean isCanCancel() {
        return this.canCancel;
    }

    public void setCanCancel(String status) {
        this.canCancel = !BLOCK_CANNOT_CANCEL_STATUS.contains(status);
    }

    public String getSecId() {
        return this.secId;
    }

    public void setSecId(String secId) {
        this.secId = secId;
    }

    public String getSecName() {
        return this.secName;
    }

    public void setSecName(String secName) {
        this.secName = secName;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getExSide() {
        return this.exSide;
    }

    public void setExSide(String exSide) {
        this.exSide = exSide;
    }

    public String getExOrdStatus() {
        return this.exOrdStatus;
    }

    public void setExOrdStatus(String exOrdStatus) {
        this.exOrdStatus = exOrdStatus;
    }

    public final StringProperty sysOrderIdProperty() {
        return this.sysOrderId;
    }

    public final String getSysOrderId() {
        return (String)this.sysOrderIdProperty().get();
    }

    public final void setSysOrderId(String sysOrderId) {
        this.sysOrderIdProperty().set((Object)sysOrderId);
    }

    public final StringProperty investorNameProperty() {
        return this.investorName;
    }

    public final String getInvestorName() {
        return (String)this.investorNameProperty().get();
    }

    public final void setInvestorName(String investorName) {
        this.investorNameProperty().set((Object)investorName);
    }
}

