/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PPostTrade;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class BlockDeal
extends MxSelObj {
    private String extAccntId = "";
    private String subAccntId = "";
    private String secAccntId = "";
    private String subSecAccntId = "";
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty inverstorSecId = new SimpleStringProperty("");
    private StringProperty orderId = new SimpleStringProperty("");
    private StringProperty dealId = new SimpleStringProperty("");
    private Instrument instrument = new Instrument();
    private ObjectProperty<MxNode> side = new SimpleObjectProperty();
    private DoubleProperty price = new SimpleDoubleProperty(0.0);
    private StringProperty unit = new SimpleStringProperty("");
    private LongProperty dealQty = new SimpleLongProperty();
    private DoubleProperty dealAmount = new SimpleDoubleProperty(0.0);
    private ObjectProperty<MxNode> status = new SimpleObjectProperty();
    private ObjectProperty<MxNode> type = new SimpleObjectProperty();
    private StringProperty date = new SimpleStringProperty("");
    private StringProperty time = new SimpleStringProperty("");
    private StringProperty reference = new SimpleStringProperty("");
    private StringProperty execDate = new SimpleStringProperty("");
    private StringProperty execTime = new SimpleStringProperty("");
    private StringProperty investorName = new SimpleStringProperty("");
    private String secId;
    private String secName;
    private String exSide;
    private String exMarket;

    public BlockDeal() {
        MxNode node = MxNodeFactory.create((String)"side");
        this.setSide(node);
        node = MxNodeFactory.create((String)"rpt_status", (String)"");
        this.setStatus(node);
        node = MxNodeFactory.create((String)"block_fixed_ord_type", (String)"");
        this.setType(node);
    }

    public void update(Object obj) {
        if (obj instanceof PPostTrade.TradeCaptureReport) {
            this.update((PPostTrade.TradeCaptureReport)PPostTrade.TradeCaptureReport.class.cast(obj));
        } else if (obj instanceof BlockDeal) {
            this.update((BlockDeal)((Object)BlockDeal.class.cast(obj)));
        }
    }

    public void update(PPostTrade.TradeCaptureReport report) {
        PComponent.Instrument inst = report.getInstrument();
        Instrument in = new Instrument();
        in.update((Object)inst);
        this.setInstrument(in);
        this.setExtAccntId(report.getExtAccntId());
        this.setSecAccntId(report.getExtSecAccntId());
        String side = String.valueOf(report.getSides().getSide(0).getSideValue());
        this.getSide().setRaw(side);
        String type = String.valueOf(report.getTrdType());
        this.getType().setRaw(type);
        this.setPrice(BigDecimal.valueOf(report.getLastPx()).setScale(4, 4).doubleValue());
        this.setDealQty((long)report.getCumQty());
        this.setDealAmount(BigDecimal.valueOf(report.getCashOrderQty()).setScale(4, 4).doubleValue());
        String status = String.valueOf(report.getTradeRptStatus().getNumber());
        this.getStatus().setRaw(status);
        this.setOrderId(report.getTradeId());
        this.setDealId(report.getExecId());
        this.setDate(report.getOrigTradeDate());
        this.setTime(report.getOrigTradeTime());
        this.setExecDate(report.getExecDate());
        this.setExecTime(report.getExecTime());
        this.setReference(report.getReference());
        this.setSecId(this.getInstrument().getSecId());
        this.setSecName(this.getInstrument().getSymbol());
        this.setExMarket(this.getInstrument().getMarket().getValue());
        this.setExSide(this.getSide().getValue());
    }

    public void update(BlockDeal order) {
        this.setOrderId(order.getOrderId());
        this.setInvestorId(order.getInvestorId());
        this.setInvestorName(order.getInvestorName());
        this.setInverstorSecId(order.getInverstorSecId());
        this.setSide(order.getSide());
        this.setUnit(order.getUnit());
        this.setPrice(order.getPrice());
        this.setDate(order.getDate());
        this.setStatus(order.getStatus());
        this.getInstrument().update((Object)order.getInstrument());
        this.setType(order.getType());
        this.setDealQty(order.getDealQty());
        this.setTime(order.getTime());
        this.setExecDate(order.getExecDate());
        this.setExecTime(order.getExecTime());
        this.setDealAmount(order.getDealAmount());
        this.setSecId(order.getSecId());
        this.setSecName(order.getSecName());
        this.setExSide(order.getExSide());
        this.setExMarket(order.getExMarket());
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getSubAccntId() {
        return this.subAccntId;
    }

    public void setSubAccntId(String subAccntId) {
        this.subAccntId = subAccntId;
    }

    public String getSecAccntId() {
        return this.secAccntId;
    }

    public void setSecAccntId(String secAccntId) {
        this.secAccntId = secAccntId;
    }

    public String getSubSecAccntId() {
        return this.subSecAccntId;
    }

    public void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntId = subSecAccntId;
    }

    public void setInvestorId(StringProperty investorId) {
        this.investorId = investorId;
    }

    public void setInverstorSecId(StringProperty inverstorSecId) {
        this.inverstorSecId = inverstorSecId;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty inverstorSecIdProperty() {
        return this.inverstorSecId;
    }

    public final String getInverstorSecId() {
        return (String)this.inverstorSecIdProperty().get();
    }

    public final void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecIdProperty().set((Object)inverstorSecId);
    }

    public final StringProperty orderIdProperty() {
        return this.orderId;
    }

    public final String getOrderId() {
        return (String)this.orderIdProperty().get();
    }

    public final void setOrderId(String orderId) {
        this.orderIdProperty().set((Object)orderId);
    }

    public final StringProperty dealIdProperty() {
        return this.dealId;
    }

    public final String getDealId() {
        return (String)this.dealIdProperty().get();
    }

    public final void setDealId(String dealId) {
        this.dealIdProperty().set((Object)dealId);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final String getUnit() {
        return (String)this.unitProperty().get();
    }

    public final void setUnit(String unit) {
        this.unitProperty().set((Object)unit);
    }

    public final LongProperty dealQtyProperty() {
        return this.dealQty;
    }

    public final long getDealQty() {
        return this.dealQtyProperty().get();
    }

    public final void setDealQty(long dealQty) {
        this.dealQtyProperty().set(dealQty);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final ObjectProperty<MxNode> typeProperty() {
        return this.type;
    }

    public final MxNode getType() {
        return (MxNode)this.typeProperty().get();
    }

    public final void setType(MxNode type) {
        this.typeProperty().set((Object)type);
    }

    public final StringProperty dateProperty() {
        return this.date;
    }

    public final String getDate() {
        return (String)this.dateProperty().get();
    }

    public final void setDate(String date) {
        this.dateProperty().set((Object)date);
    }

    public final StringProperty timeProperty() {
        return this.time;
    }

    public final String getTime() {
        return (String)this.timeProperty().get();
    }

    public final void setTime(String time) {
        this.timeProperty().set((Object)time);
    }

    public final DoubleProperty dealAmountProperty() {
        return this.dealAmount;
    }

    public final double getDealAmount() {
        return this.dealAmountProperty().get();
    }

    public final void setDealAmount(double dealAmount) {
        this.dealAmountProperty().set(dealAmount);
    }

    public final StringProperty referenceProperty() {
        return this.reference;
    }

    public final String getReference() {
        return (String)this.referenceProperty().get();
    }

    public final void setReference(String reference) {
        this.referenceProperty().set((Object)reference);
    }

    public final StringProperty execDateProperty() {
        return this.execDate;
    }

    public final String getExecDate() {
        return (String)this.execDateProperty().get();
    }

    public final void setExecDate(String execDate) {
        this.execDateProperty().set((Object)execDate);
    }

    public String getSecId() {
        return this.secId;
    }

    public void setSecId(String secId) {
        this.secId = secId;
    }

    public String getSecName() {
        return this.secName;
    }

    public void setSecName(String secName) {
        this.secName = secName;
    }

    public String getExSide() {
        return this.exSide;
    }

    public void setExSide(String exSide) {
        this.exSide = exSide;
    }

    public String getExMarket() {
        return this.exMarket;
    }

    public void setExMarket(String exMarket) {
        this.exMarket = exMarket;
    }

    public final StringProperty execTimeProperty() {
        return this.execTime;
    }

    public final String getExecTime() {
        return (String)this.execTimeProperty().get();
    }

    public final void setExecTime(String execTime) {
        this.execTimeProperty().set((Object)execTime);
    }

    public final StringProperty investorNameProperty() {
        return this.investorName;
    }

    public final String getInvestorName() {
        return (String)this.investorNameProperty().get();
    }

    public final void setInvestorName(String investorName) {
        this.investorNameProperty().set((Object)investorName);
    }
}

