/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.message.PMainTenance;
import cms.tmx.entity.FundAccount;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class Bank
extends MxObject {
    private StringProperty bankName = new SimpleStringProperty("");
    private StringProperty bankId = new SimpleStringProperty("");
    private StringProperty bankAccountId = new SimpleStringProperty("");
    private StringProperty cardTail = new SimpleStringProperty("");
    private ObjectProperty<MxNode> bankType = new SimpleObjectProperty();
    private ObjectProperty<MxNode> currency = new SimpleObjectProperty();
    private ObjectProperty<MxNode> passwordFlag = new SimpleObjectProperty();
    private StringProperty bankPwd = new SimpleStringProperty("");
    private static final String BANK_TYPE = "bank_type";
    private static final String PASSWORD_FLAG = "password_flag";
    private ObjectProperty<FundAccount> fund = new SimpleObjectProperty();

    public Bank() {
        MxNode node = MxNodeFactory.create((String)BANK_TYPE);
        this.setBankType(node);
        node = MxNodeFactory.create((String)"currency_type");
        this.setCurrency(node);
        node = MxNodeFactory.create((String)PASSWORD_FLAG);
        this.setPasswordFlag(node);
    }

    public void update(Object obj) {
        if (obj instanceof PMainTenance.BankAccount) {
            this.update((PMainTenance.BankAccount)PMainTenance.BankAccount.class.cast(obj));
        }
    }

    public void update(PMainTenance.BankAccount bank) {
        this.setBankName(bank.getBankName());
        this.setBankId(bank.getBankNo());
        this.setBankAccountId(bank.getBankAccountNo().trim());
        this.getBankType().setRaw(bank.getBankType());
        this.getCurrency().setRaw(bank.getCurrencyId());
        this.setCardTail(this.getBankAccountId().substring(this.getBankAccountId().length() - 4));
        this.getPasswordFlag().setRaw(bank.getPasswordFlag());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getBankName());
        builder.append(this.getCardTail());
        builder.append("[");
        builder.append(this.getCurrency());
        builder.append("]");
        return builder.toString();
    }

    public final StringProperty bankNameProperty() {
        return this.bankName;
    }

    public final String getBankName() {
        return (String)this.bankNameProperty().get();
    }

    public final void setBankName(String bankName) {
        this.bankNameProperty().set((Object)bankName);
    }

    public final StringProperty bankIdProperty() {
        return this.bankId;
    }

    public final String getBankId() {
        return (String)this.bankIdProperty().get();
    }

    public final void setBankId(String bankId) {
        this.bankIdProperty().set((Object)bankId);
    }

    public final StringProperty bankAccountIdProperty() {
        return this.bankAccountId;
    }

    public final String getBankAccountId() {
        return (String)this.bankAccountIdProperty().get();
    }

    public final void setBankAccountId(String bankAccountId) {
        this.bankAccountIdProperty().set((Object)bankAccountId);
    }

    public final ObjectProperty<MxNode> bankTypeProperty() {
        return this.bankType;
    }

    public final MxNode getBankType() {
        return (MxNode)this.bankTypeProperty().get();
    }

    public final void setBankType(MxNode bankType) {
        this.bankTypeProperty().set((Object)bankType);
    }

    public final ObjectProperty<MxNode> currencyProperty() {
        return this.currency;
    }

    public final MxNode getCurrency() {
        return (MxNode)this.currencyProperty().get();
    }

    public final void setCurrency(MxNode currencyId) {
        this.currencyProperty().set((Object)currencyId);
    }

    public final StringProperty cardTailProperty() {
        return this.cardTail;
    }

    public final String getCardTail() {
        return (String)this.cardTailProperty().get();
    }

    public final void setCardTail(String cardTail) {
        this.cardTailProperty().set((Object)cardTail);
    }

    public final ObjectProperty<FundAccount> fundProperty() {
        return this.fund;
    }

    public final FundAccount getFund() {
        return (FundAccount)((Object)this.fundProperty().get());
    }

    public final void setFund(FundAccount fund) {
        this.fundProperty().set((Object)fund);
    }

    public final ObjectProperty<MxNode> passwordFlagProperty() {
        return this.passwordFlag;
    }

    public final MxNode getPasswordFlag() {
        return (MxNode)this.passwordFlagProperty().get();
    }

    public final void setPasswordFlag(MxNode passwordFlag) {
        this.passwordFlagProperty().set((Object)passwordFlag);
    }

    public final StringProperty bankPwdProperty() {
        return this.bankPwd;
    }

    public final String getBankPwd() {
        return (String)this.bankPwdProperty().get();
    }

    public final void setBankPwd(String bankPwd) {
        this.bankPwdProperty().set((Object)bankPwd);
    }
}

