/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxClrObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class Algorithm
extends MxClrObj {
    private IntegerProperty type = new SimpleIntegerProperty();
    private StringProperty name = new SimpleStringProperty("");
    private IntegerProperty level = new SimpleIntegerProperty();
    private StringProperty remark = new SimpleStringProperty("");
    private IntegerProperty clazz = new SimpleIntegerProperty();
    private StringProperty info = new SimpleStringProperty("");
    private AlgoParam algoParam = new AlgoParam();
    private boolean readOnly = false;
    private boolean update = false;

    public Algorithm() {
    }

    public Algorithm(int type, String name) {
        this.setType(type);
        this.setName(name);
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public AlgoParam getAlgoParam() {
        return this.algoParam;
    }

    public void setAlgoParam(AlgoParam algoParam) {
        this.algoParam = algoParam;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String toString() {
        return this.getName();
    }

    public void update(Object t) {
        if (t instanceof Algorithm) {
            Algorithm algo = (Algorithm)((Object)Algorithm.class.cast(t));
            this.update(algo);
        } else if (t instanceof PAlgorithmTrade.AlgorithmInfo) {
            PAlgorithmTrade.AlgorithmInfo algo = (PAlgorithmTrade.AlgorithmInfo)PAlgorithmTrade.AlgorithmInfo.class.cast(t);
            this.update(algo);
        }
    }

    public void update(Algorithm algo) {
        this.setType(algo.getType());
        this.setName(algo.getName());
        this.setLevel(algo.getLevel());
        this.setRemark(algo.getRemark());
        this.setClazz(algo.getClazz());
        this.setInfo(algo.getInfo());
    }

    public void update(PAlgorithmTrade.AlgorithmInfo algo) {
        this.setType(algo.getAlgoTypeValue());
        MxNode node = MxNodeFactory.create((String)"algo_name", (String)"0");
        node.setRaw(String.valueOf(this.getType()));
        this.setName(node.getValue());
        this.setLevel(algo.getAlgoLevelValue());
        this.setRemark(algo.getAlgoRemark());
        this.setClazz(algo.getAlgoClassValue());
        this.setInfo(algo.getExtraInfo());
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final IntegerProperty typeProperty() {
        return this.type;
    }

    public final int getType() {
        return this.typeProperty().get();
    }

    public final void setType(int type) {
        this.typeProperty().set(type);
    }

    public final IntegerProperty clazzProperty() {
        return this.clazz;
    }

    public final int getClazz() {
        return this.clazzProperty().get();
    }

    public final void setClazz(int clazz) {
        this.clazzProperty().set(clazz);
    }

    public final StringProperty remarkProperty() {
        return this.remark;
    }

    public final String getRemark() {
        return (String)this.remarkProperty().get();
    }

    public final void setRemark(String remark) {
        this.remarkProperty().set((Object)remark);
    }

    public final StringProperty infoProperty() {
        return this.info;
    }

    public final String getInfo() {
        return (String)this.infoProperty().get();
    }

    public final void setInfo(String info) {
        this.infoProperty().set((Object)info);
    }

    public final IntegerProperty levelProperty() {
        return this.level;
    }

    public final int getLevel() {
        return this.levelProperty().get();
    }

    public final void setLevel(int level) {
        this.levelProperty().set(level);
    }
}

