/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IAlgoParam;
import cms.tmx.api.trade.IAlgorithmTradeApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.datatype.proto.strategy.PFollowUp;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AlgoParam
extends MxObject
implements IAlgoParam {
    private static final Logger logger = LogManager.getLogger(AlgoParam.class);
    private ObjectProperty<Algorithm> algorithm = new SimpleObjectProperty();
    private StringProperty type = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private BooleanProperty buy = new SimpleBooleanProperty(true);
    private int side;
    private DoubleProperty price = new SimpleDoubleProperty();
    private IntegerProperty count = new SimpleIntegerProperty();
    private double amount;
    private IntegerProperty orderAvailableQuantity = new SimpleIntegerProperty();
    private IntegerProperty startHour = new SimpleIntegerProperty();
    private IntegerProperty endHour = new SimpleIntegerProperty();
    private IntegerProperty startMinute = new SimpleIntegerProperty();
    private IntegerProperty endMinute = new SimpleIntegerProperty();
    private IntegerProperty aggress = new SimpleIntegerProperty();
    private IntegerProperty slice = new SimpleIntegerProperty();
    private BooleanProperty isRise = new SimpleBooleanProperty(false);
    private DoubleProperty percentRise = new SimpleDoubleProperty();
    private IntegerProperty basePrice = new SimpleIntegerProperty();
    private IntegerProperty depth = new SimpleIntegerProperty();
    private DoubleProperty percentDepth = new SimpleDoubleProperty();
    private IntegerProperty delay = new SimpleIntegerProperty();
    private DoubleProperty priceMost = new SimpleDoubleProperty();
    private DoubleProperty priceUp = new SimpleDoubleProperty();
    private DoubleProperty priceLow = new SimpleDoubleProperty();
    private ObjectProperty<MxNode> priceterms = new SimpleObjectProperty();
    private DoubleProperty exceedPrice = new SimpleDoubleProperty();
    private ObjectProperty<MxNode> datumQty = new SimpleObjectProperty();
    private IntegerProperty datumPercent = new SimpleIntegerProperty();
    private IntegerProperty orderIntevel = new SimpleIntegerProperty();
    private IntegerProperty cancelIntevel = new SimpleIntegerProperty();
    private IntegerProperty minitabQty = new SimpleIntegerProperty();
    private IntegerProperty waveRang = new SimpleIntegerProperty();
    private IntegerProperty minQty = new SimpleIntegerProperty();
    private IntegerProperty maxQty = new SimpleIntegerProperty();
    private IntegerProperty orderTime = new SimpleIntegerProperty();
    private IntegerProperty sumMinute = new SimpleIntegerProperty();
    private DoubleProperty marketPercent = new SimpleDoubleProperty();
    private IntegerProperty priceType = new SimpleIntegerProperty();
    private IntegerProperty qtyExposed = new SimpleIntegerProperty();
    private DoubleProperty limitPrice = new SimpleDoubleProperty();
    private IntegerProperty floatWay = new SimpleIntegerProperty();
    private DoubleProperty floatNum = new SimpleDoubleProperty();
    private DoubleProperty floatPercent = new SimpleDoubleProperty();
    private IntegerProperty diskWay = new SimpleIntegerProperty();
    private DoubleProperty diskNum = new SimpleDoubleProperty();
    private DoubleProperty diskPercent = new SimpleDoubleProperty();
    private StringProperty fundAccId = new SimpleStringProperty("");
    private StringProperty secAccId = new SimpleStringProperty("");
    private StringProperty subFundId = new SimpleStringProperty("");
    private StringProperty subSecId = new SimpleStringProperty("");
    private StringProperty portfolio = new SimpleStringProperty("");
    private StringProperty portfolioName = new SimpleStringProperty("");
    private StringProperty productId = new SimpleStringProperty("");
    private StringProperty resourceId = new SimpleStringProperty("");
    private StringProperty reference = new SimpleStringProperty("");
    private StringProperty flowAttriId = new SimpleStringProperty("");
    private StringProperty stepAttrId = new SimpleStringProperty("");
    private IntegerProperty instructionType = new SimpleIntegerProperty();
    private StringProperty instructionPanelType = new SimpleStringProperty("");
    private String postil = "";
    private IntegerProperty accntLevel = new SimpleIntegerProperty();
    private List<AccntSecInfo> accSecInfoList = new ArrayList<AccntSecInfo>();
    private String sysId;
    private int dealCount;
    private String insExpiredDate = "";
    private int algoNewType;
    private StringProperty buyType = new SimpleStringProperty("");
    private StringProperty sellType = new SimpleStringProperty("");
    private StringProperty maxPriceDiff = new SimpleStringProperty("");
    private DoubleProperty priceSlip = new SimpleDoubleProperty();
    private StringProperty rollInterval = new SimpleStringProperty("");
    private StringProperty startTime = new SimpleStringProperty("");
    private MxNode algoTypeNode;
    @Inject
    private IAlgorithmTradeApi algoApi;
    @Inject
    private IBaseApi iba;
    @Inject
    private IInstructionApi insApi;
    @Inject
    private MObjFactory of;

    public String getSysId() {
        return this.sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public int getDealCount() {
        return this.dealCount;
    }

    public void setDealCount(int dealCount) {
        this.dealCount = dealCount;
    }

    @PostConstruct
    private void init() {
        this.initNode();
    }

    public AlgoParam() {
        this.initNode();
    }

    private void initNode() {
        MxNode node = MxNodeFactory.create((String)"price_terms", (String)"0");
        this.setPriceterms(node);
        node = MxNodeFactory.create((String)"datum_qty", (String)"0");
        this.setDatumQty(node);
    }

    public void update(Object obj) {
        if (obj instanceof AlgoParam) {
            this.update((AlgoParam)((Object)AlgoParam.class.cast(obj)));
        } else if (obj instanceof PAlgorithmTrade.BaseOrderInfomation) {
            this.update((PAlgorithmTrade.BaseOrderInfomation)PAlgorithmTrade.BaseOrderInfomation.class.cast(obj));
        } else if (obj instanceof PStrategy.BaseOrderInfo) {
            this.update((PStrategy.BaseOrderInfo)PStrategy.BaseOrderInfo.class.cast(obj));
        } else if (obj instanceof Any) {
            try {
                this.update((Any)Any.class.cast(obj));
            }
            catch (InvalidProtocolBufferException e) {
                logger.error((Object)e, (Throwable)e);
            }
        } else if (obj instanceof PInstruction.AlgorithmOrderAdvice) {
            try {
                this.update((PInstruction.AlgorithmOrderAdvice)PInstruction.AlgorithmOrderAdvice.class.cast(obj));
            }
            catch (InvalidProtocolBufferException e) {
                logger.error((Object)e, (Throwable)e);
            }
        } else if (obj instanceof MEvent) {
            this.update((MEvent)MEvent.class.cast(obj));
        }
    }

    private void update(MEvent event) {
        JsonArray basketArr;
        String remark;
        JsonObject jsonRemark;
        String extra = event.getStr("extra_fields");
        Gson gson = new Gson();
        JsonObject json = (JsonObject)gson.fromJson(extra, JsonObject.class);
        String startTime = json.get("start_time").getAsString();
        String endTime = json.get("end_time").getAsString();
        this.setStartHour(Integer.parseInt(startTime.substring(0, 2)));
        this.setStartMinute(Integer.parseInt(startTime.substring(2, 4)));
        this.setEndHour(Integer.parseInt(endTime.substring(0, 2)));
        this.setEndMinute(Integer.parseInt(endTime.substring(2, 4)));
        if (json.get("base_price_type") != null) {
            this.getPriceterms().setRaw(json.get("base_price_type").getAsString());
        }
        if (json.get("above_price_rate") != null) {
            this.setExceedPrice(json.get("above_price_rate").getAsDouble());
        }
        if (json.get("base_vol_type") != null) {
            this.getDatumQty().setRaw(json.get("base_vol_type").getAsString());
        }
        if (json.get("base_vol_rate") != null) {
            this.setDatumPercent(json.get("base_vol_rate").getAsInt());
        }
        if (json.get("entrust_interval") != null) {
            this.setOrderIntevel(json.get("entrust_interval").getAsInt());
        }
        if (json.get("withdraw_interval") != null) {
            this.setCancelIntevel(json.get("withdraw_interval").getAsInt());
        }
        if (json.get("above_price_index") != null) {
            this.setMinitabQty(json.get("above_price_index").getAsInt());
        }
        if (json.get("price_limit_range") != null) {
            this.setWaveRang(json.get("price_limit_range").getAsInt());
        }
        if (json.get("min_order_vol") != null) {
            this.setMinQty(json.get("min_order_vol").getAsInt());
        }
        if (json.get("max_order_vol") != null) {
            this.setMaxQty(json.get("max_order_vol").getAsInt());
        }
        if (json.get("max_entrust_num") != null) {
            this.setOrderTime(json.get("max_entrust_num").getAsInt());
        }
        if (json.get("aggressiveLevel") != null) {
            this.setAggress(json.get("aggressiveLevel").getAsInt());
        }
        if (json.get("numSlice") != null) {
            this.setSlice(json.get("numSlice").getAsInt());
        }
        if (json.get("base_vol_rate") != null) {
            this.setDatumPercent(json.get("base_vol_rate").getAsInt());
        }
        if (json.get("price_type") != null) {
            this.setPriceType(json.get("price_type").getAsInt());
        }
        if (json.get("qty_exposed") != null) {
            this.setQtyExposed(json.get("qty_exposed").getAsInt());
        }
        if (json.get("limit_price") != null) {
            this.setLimitPrice(json.get("limit_price").getAsDouble());
        }
        if ((jsonRemark = (JsonObject)gson.fromJson(remark = json.get("remark").getAsString(), JsonObject.class)).get("side") != null) {
            this.setSide(jsonRemark.get("side").getAsInt());
        }
        if (jsonRemark.get("type") != null) {
            this.setType(jsonRemark.get("type").getAsString());
        }
        if (jsonRemark.get("code") != null) {
            this.setCode(jsonRemark.get("code").getAsString());
        }
        if (jsonRemark.get("market") != null) {
            this.setMarket(jsonRemark.get("market").getAsString());
        }
        if (jsonRemark.get("sumMinute") != null) {
            this.setSumMinute(jsonRemark.get("sumMinute").getAsInt());
        }
        if (jsonRemark.get("marketPercent") != null) {
            this.setMarketPercent(jsonRemark.get("marketPercent").getAsDouble());
        }
        if (!(this.getCode().isEmpty() || this.getType().isEmpty() || this.getMarket().isEmpty() || (basketArr = json.get("basket").getAsJsonArray()).size() != 1)) {
            JsonArray bskArr = basketArr.get(0).getAsJsonArray();
            this.setCount(bskArr.get(3).getAsInt());
            if (jsonRemark.get("marketPercent").getAsDouble() == 0.0) {
                String[] reserved1 = bskArr.get(7).getAsString().split("#", 2);
                if (reserved1.length >= 1 && !reserved1[0].isEmpty()) {
                    this.setPriceUp(Double.parseDouble(reserved1[0]));
                }
                if (reserved1.length >= 2 && !reserved1[1].isEmpty()) {
                    this.setPriceLow(Double.parseDouble(reserved1[1]));
                }
            } else {
                String reserved1 = bskArr.get(7).getAsString();
                JsonObject jsonReserved1 = (JsonObject)gson.fromJson(reserved1, JsonObject.class);
                if (jsonReserved1.get("lp") != null) {
                    String lp = jsonReserved1.get("lp").getAsString();
                    String[] splitLp = lp.split("#");
                    if (splitLp.length >= 1 && !splitLp[0].isEmpty()) {
                        this.setPriceUp(Double.parseDouble(splitLp[0]));
                    }
                    if (splitLp.length >= 2 && !splitLp[1].isEmpty()) {
                        this.setPriceLow(Double.parseDouble(splitLp[1]));
                    }
                }
            }
            if (this.getLimitPrice() > 0.0) {
                if (this.getSide() == 50) {
                    this.setPriceLow(this.getLimitPrice());
                } else {
                    this.setPriceUp(this.getLimitPrice());
                }
            }
        }
    }

    private void update(AlgoParam param) {
        this.setSysId(param.getSysId());
        this.setDealCount(param.getDealCount());
        this.setAlgorithm(param.getAlgorithm());
        this.setBuy(param.isBuy());
        this.setSide(param.getSide());
        this.setMarket(param.getMarket());
        this.setType(param.getType());
        this.setCode(param.getCode());
        this.setName(param.getName());
        this.setPrice(param.getPrice());
        this.setCount(param.getCount());
        this.setStartHour(param.getStartHour());
        this.setStartMinute(param.getStartMinute());
        this.setEndHour(param.getEndHour());
        this.setEndMinute(param.getEndMinute());
        this.setAggress(param.getAggress());
        this.setSlice(param.getSlice());
        this.setRise(param.isRise());
        this.setPercentRise(param.getPercentRise());
        this.setBasePrice(param.getBasePrice());
        this.setDepth(param.getDepth());
        this.setPercentDepth(param.getPercentDepth());
        this.setDelay(param.getDelay());
        this.setPriceMost(param.getPriceMost());
        this.setPriceUp(param.getPriceUp());
        this.setPriceLow(param.getPriceLow());
        this.setFundAccId(param.getFundAccId());
        this.setSecAccId(param.getSecAccId());
        this.setSubFundId(param.getSubFundId());
        this.setSubSecId(param.getSubSecId());
        this.setPortfolio(param.getPortfolio());
        this.setPortfolioName(param.getPortfolioName());
        this.setResourceId(param.getResourceId());
        this.setReference(param.getReference());
        this.setAccntLevel(param.getAccntLevel());
        this.setPriceterms(param.getPriceterms());
        this.setExceedPrice(param.getExceedPrice());
        this.setDatumQty(param.getDatumQty());
        this.setDatumPercent(param.getDatumPercent());
        this.setOrderIntevel(param.getOrderIntevel());
        this.setCancelIntevel(param.getCancelIntevel());
        this.setMinitabQty(param.getMinitabQty());
        this.setWaveRang(param.getWaveRang());
        this.setMinQty(param.getMinQty());
        this.setMaxQty(param.getMaxQty());
        this.setOrderTime(param.getOrderTime());
        this.setSumMinute(param.getSumMinute());
        this.setMarketPercent(param.getMarketPercent());
        this.setPriceType(param.getPriceType());
        this.setQtyExposed(param.getQtyExposed());
        this.setLimitPrice(param.getLimitPrice());
        this.setPostil(param.getPostil());
        this.setFloatWay(param.getFloatWay());
        this.setFloatNum(param.getFloatNum());
        this.setFloatPercent(param.getFloatPercent());
        this.setDiskWay(param.getDiskWay());
        this.setDiskNum(param.getDiskNum());
        this.setDiskPercent(param.getDiskPercent());
        this.setAmount(param.getAmount());
        this.getAccSecInfoList().clear();
        for (AccntSecInfo oldInfo : param.getAccSecInfoList()) {
            AccntSecInfo accSecInfo = new AccntSecInfo();
            accSecInfo.update((Object)oldInfo);
            this.getAccSecInfoList().add(accSecInfo);
        }
        Collections.sort(this.getAccSecInfoList());
        this.setAlgoTypeNode(param.getAlgoTypeNode());
    }

    private void update(PInstruction.AlgorithmOrderAdvice soa) throws InvalidProtocolBufferException {
        this.update(soa.getObject());
        Algorithm algo = new Algorithm();
        algo.setType(soa.getAlgorithmTypeValue());
        this.setAlgorithm(algo);
        this.setBuy(soa.getSideValue() == 49 || soa.getSideValue() == 71);
        this.setSide(soa.getSideValue());
        this.setMarket(soa.getInstrument().getMarket());
        this.setType(soa.getInstrument().getSecurityType());
        this.setCode(soa.getInstrument().getSecurityId());
        this.setName(soa.getInstrument().getSymbol());
        this.setAccntLevel(soa.getAccntLevelValue());
        int orderQty = 0;
        for (PInstruction.AccntSecInfo accntSecInfo : soa.getAccntSecInfoList()) {
            AccntSecInfo accSecInfo = new AccntSecInfo();
            accSecInfo.update((Object)accntSecInfo);
            orderQty = (int)((long)orderQty + accSecInfo.getOrderQty());
            this.getAccSecInfoList().add(accSecInfo);
        }
        Collections.sort(this.getAccSecInfoList());
        this.setCount(orderQty);
    }

    private void update(PAlgorithmTrade.BaseOrderInfomation info) {
        this.setBuy(info.getSideValue() == 49 || info.getSideValue() == 71);
        this.setSide(info.getSideValue());
        this.setCount(info.getOrderQty());
        this.setMarket(info.getInstrument().getMarket());
        this.setType(info.getInstrument().getSecurityType());
        this.setCode(info.getInstrument().getSecurityId());
        this.setName(info.getInstrument().getSymbol());
        this.setFundAccId(info.getExtAccntId().replaceAll("[_A-Z]*$", ""));
        this.setSecAccId(info.getExtSecAccntId().replaceAll("[_A-Z]*$", ""));
        this.setSubFundId(info.getSubAccntId().replaceAll("[_A-Z]*$", ""));
        this.setSubSecId(info.getSubSecAccntId().replaceAll("[_A-Z]*$", ""));
        this.setPortfolio(info.getPortfolioId());
        this.setResourceId(info.getResourceId());
        this.setReference(info.getReference());
    }

    private void update(PStrategy.BaseOrderInfo info) {
        this.setBuy(info.getSideValue() == 49 || info.getSideValue() == 71);
        this.setSide(info.getSideValue());
        this.setCount(info.getOrderQty());
        this.setMarket(info.getInstrument().getMarket());
        this.setType(info.getInstrument().getSecurityType());
        this.setCode(info.getInstrument().getSecurityId());
        this.setName(info.getInstrument().getSymbol());
    }

    private void update(Any any) throws InvalidProtocolBufferException {
        if (any.is(PAlgorithmTrade.BlockTradingParam.class)) {
            PAlgorithmTrade.BlockTradingParam block = (PAlgorithmTrade.BlockTradingParam)any.unpack(PAlgorithmTrade.BlockTradingParam.class);
            this.setPriceUp(new BigDecimal(Double.toString(block.getPriceUpperLimit())).doubleValue());
            this.setPriceLow(new BigDecimal(Double.toString(block.getPriceLowerLimit())).doubleValue());
            this.setDepth(block.getOrderDepthValue());
            this.setSlice(block.getTimeSlice());
        } else if (any.is(PAlgorithmTrade.WapAlgoParam.class)) {
            PAlgorithmTrade.WapAlgoParam wap = (PAlgorithmTrade.WapAlgoParam)any.unpack(PAlgorithmTrade.WapAlgoParam.class);
            this.setStartHour(wap.getStartHour());
            this.setStartMinute(wap.getStartMinute());
            this.setEndHour(wap.getEndHour());
            this.setEndMinute(wap.getEndMinute());
            this.setAggress(wap.getAlgoBehaviorLevelValue());
            this.setSlice(wap.getTimeSliceCount());
        } else if (any.is(PAlgorithmTrade.EnhancedLiquidityParam.class)) {
            PAlgorithmTrade.EnhancedLiquidityParam liquidity = (PAlgorithmTrade.EnhancedLiquidityParam)any.unpack(PAlgorithmTrade.EnhancedLiquidityParam.class);
            this.setPriceMost(new BigDecimal(Double.toString(liquidity.getMostPrice())).doubleValue());
            this.setPercentRise(liquidity.getCalcBasePricePercent());
            this.setDepth(liquidity.getOrderDepthValue());
            this.setPercentDepth(liquidity.getOrderQtyPercent());
            this.setDelay(liquidity.getWithdrawInterval());
            this.setBasePrice(liquidity.getBasePriceTypeValue());
        } else if (any.is(PAlgorithmTrade.HighLowLimitWapParam.class)) {
            PAlgorithmTrade.HighLowLimitWapParam limit = (PAlgorithmTrade.HighLowLimitWapParam)any.unpack(PAlgorithmTrade.HighLowLimitWapParam.class);
            this.setPriceUp(new BigDecimal(Double.toString(limit.getPriceUpperLimit())).doubleValue());
            this.setPriceLow(new BigDecimal(Double.toString(limit.getPriceLowerLimit())).doubleValue());
            this.setStartHour(limit.getStartHour());
            this.setStartMinute(limit.getStartMinute());
            this.setEndHour(limit.getEndHour());
            this.setEndMinute(limit.getEndMinute());
            this.setAggress(limit.getAlgoBehaviorLevelValue());
            this.setSlice(limit.getTimeSliceCount());
        } else if (any.is(PFollowUp.FollowUpParam.class)) {
            PFollowUp.FollowUpParam followUp = (PFollowUp.FollowUpParam)any.unpack(PFollowUp.FollowUpParam.class);
            this.setPriceMost(new BigDecimal(Double.toString(followUp.getPriceLimit())).doubleValue());
            this.setBasePrice(followUp.getRefPriceTypeValue());
            this.setFloatWay(followUp.getPriceAdjustTypeValue());
            this.setFloatNum(followUp.getPriceAdjustValue());
            this.setFloatPercent(followUp.getPriceAdjustRate());
            this.setDiskWay(followUp.getQtyAdjustTypeValue());
            this.setDiskNum(followUp.getQtyAdjustValue());
            this.setDiskPercent(followUp.getQtyAdjustRate());
            this.setDelay(followUp.getCancelTimeout());
            this.getAccSecInfoList().clear();
            for (PFollowUp.FundAccountSetting fundInfo : followUp.getFundAccountSettingsList()) {
                for (PFollowUp.SecAccountSetting secInfo : fundInfo.getSecAccountSettingsList()) {
                    AccntSecInfo accSecInfo = new AccntSecInfo();
                    accSecInfo.update((Object)fundInfo);
                    accSecInfo.update((Object)secInfo);
                    this.getAccSecInfoList().add(accSecInfo);
                }
            }
        }
    }

    public InstructionSubmitResult submit() throws MException {
        InstructionSubmitResult result = new InstructionSubmitResult();
        Any any = this.buildAlgorithmOrderAdvice();
        PInstruction.Instruction.Builder insb = PInstruction.Instruction.newBuilder();
        insb.setName(this.getName());
        insb.setPortfolioId((String)this.portfolio.get());
        insb.setProductId((String)this.productId.get());
        insb.setStepAttrId(this.getStepAttrId());
        insb.setFlowAttrId(this.getFlowAttriId());
        insb.setDetails(any);
        insb.setType(this.getInstructionType());
        insb.setEstimatedOrderAmount(this.getAmount());
        if (StringUtils.isEmpty((String)this.getInsExpiredDate())) {
            insb.setExpireDate(DateTimeUtils.getDate());
        } else {
            insb.setExpireDate(this.getInsExpiredDate());
        }
        String instructionId = this.insApi.newInstruction(insb.build(), this.getActionId());
        String reason = this.insApi.submitInstruction(instructionId, this.getPostil());
        result.setInstructionId(instructionId);
        result.setReason(reason);
        return result;
    }

    private int getActionId() {
        int actionId = 0;
        if ("2".equals(this.instructionPanelType.get())) {
            actionId = 20;
        } else if ("1".equals(this.instructionPanelType.get())) {
            actionId = 21;
        }
        return actionId;
    }

    private Any buildAlgorithmOrderAdvice() {
        PInstruction.AlgorithmOrderAdvice.Builder builder = PInstruction.AlgorithmOrderAdvice.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        PComponent.Instrument.Builder instrument = PComponent.Instrument.newBuilder();
        instrument.setSecurityId(this.getCode());
        instrument.setSymbol(this.getName());
        instrument.setMarket(this.getMarket());
        instrument.setSecurityType(this.getType());
        instrument.setApplId(this.getType().equals("REPO") ? "110" : "010");
        builder.setInstrument(instrument.build());
        if (this.getType().equals("REPO")) {
            builder.setSide(this.isBuy() ? PField.Side.SIDE_BORROW : PField.Side.SIDE_LEND);
        } else {
            builder.setSide(this.isBuy() ? PField.Side.SIDE_BUY : PField.Side.SIDE_SELL);
        }
        builder.setAlgorithmTypeValue(((Algorithm)((Object)this.algorithm.get())).getType());
        builder.setAccntLevelValue(this.getAccntLevel());
        Any a = this.algoApi.pack((IAlgoParam)this);
        if (a != null) {
            builder.setObject(a);
        }
        for (AccntSecInfo accSecInfo : this.accSecInfoList) {
            PInstruction.AccntSecInfo.Builder accSecB = accSecInfo.getBuilder();
            builder.addAccntSecInfo(accSecB.build());
        }
        builder.setEstimatedOrderAmount(this.getAmount());
        Any any = Any.pack((Message)builder.build());
        return any;
    }

    public ObjectProperty<Algorithm> algorithmProperty() {
        return this.algorithm;
    }

    public Algorithm getAlgorithm() {
        return (Algorithm)((Object)this.algorithmProperty().get());
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithmProperty().set((Object)algorithm);
    }

    public BooleanProperty buyProperty() {
        return this.buy;
    }

    public boolean isBuy() {
        return this.buyProperty().get();
    }

    public void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public IntegerProperty countProperty() {
        return this.count;
    }

    public int getCount() {
        return this.countProperty().get();
    }

    public void setCount(int count) {
        this.countProperty().set(count);
    }

    public IntegerProperty startHourProperty() {
        return this.startHour;
    }

    public int getStartHour() {
        return this.startHourProperty().get();
    }

    public void setStartHour(int startHour) {
        this.startHourProperty().set(startHour);
    }

    public IntegerProperty endHourProperty() {
        return this.endHour;
    }

    public int getEndHour() {
        return this.endHourProperty().get();
    }

    public void setEndHour(int endHour) {
        this.endHourProperty().set(endHour);
    }

    public IntegerProperty startMinuteProperty() {
        return this.startMinute;
    }

    public int getStartMinute() {
        return this.startMinuteProperty().get();
    }

    public void setStartMinute(int startMinute) {
        this.startMinuteProperty().set(startMinute);
    }

    public IntegerProperty endMinuteProperty() {
        return this.endMinute;
    }

    public int getEndMinute() {
        return this.endMinuteProperty().get();
    }

    public void setEndMinute(int endMinute) {
        this.endMinuteProperty().set(endMinute);
    }

    public IntegerProperty aggressProperty() {
        return this.aggress;
    }

    public int getAggress() {
        return this.aggressProperty().get();
    }

    public void setAggress(int aggress) {
        this.aggressProperty().set(aggress);
    }

    public IntegerProperty sliceProperty() {
        return this.slice;
    }

    public int getSlice() {
        return this.sliceProperty().get();
    }

    public void setSlice(int slice) {
        this.sliceProperty().set(slice);
    }

    public IntegerProperty basePriceProperty() {
        return this.basePrice;
    }

    public int getBasePrice() {
        return this.basePriceProperty().get();
    }

    public void setBasePrice(int basePrice) {
        this.basePriceProperty().set(basePrice);
    }

    public IntegerProperty delayProperty() {
        return this.delay;
    }

    public int getDelay() {
        return this.delayProperty().get();
    }

    public void setDelay(int delay) {
        this.delayProperty().set(delay);
    }

    public int getAlgoType() {
        return ((Algorithm)((Object)this.algorithm.get())).getType();
    }

    public DoubleProperty priceUpProperty() {
        return this.priceUp;
    }

    public double getPriceUp() {
        return this.priceUpProperty().get();
    }

    public void setPriceUp(double priceUp) {
        this.priceUpProperty().set(priceUp);
    }

    public IntegerProperty depthProperty() {
        return this.depth;
    }

    public int getDepth() {
        return this.depthProperty().get();
    }

    public void setDepth(int depth) {
        this.depthProperty().set(depth);
    }

    public DoubleProperty priceMostProperty() {
        return this.priceMost;
    }

    public double getPriceMost() {
        return this.priceMostProperty().get();
    }

    public void setPriceMost(double priceMost) {
        this.priceMostProperty().set(priceMost);
    }

    public BooleanProperty isRiseProperty() {
        return this.isRise;
    }

    public boolean isRise() {
        return this.isRiseProperty().get();
    }

    public void setRise(boolean isRise) {
        this.isRiseProperty().set(isRise);
    }

    public DoubleProperty percentRiseProperty() {
        return this.percentRise;
    }

    public double getPercentRise() {
        return this.percentRiseProperty().get();
    }

    public void setPercentRise(double percentRise) {
        this.percentRiseProperty().set(percentRise);
    }

    public DoubleProperty percentDepthProperty() {
        return this.percentDepth;
    }

    public double getPercentDepth() {
        return this.percentDepthProperty().get();
    }

    public void setPercentDepth(double percentDepth) {
        this.percentDepthProperty().set(percentDepth);
    }

    public final DoubleProperty priceLowProperty() {
        return this.priceLow;
    }

    public final double getPriceLow() {
        return this.priceLowProperty().get();
    }

    public final void setPriceLow(double priceLow) {
        this.priceLowProperty().set(priceLow);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty codeProperty() {
        return this.code;
    }

    public String getCode() {
        return (String)this.codeProperty().get();
    }

    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty typeProperty() {
        return this.type;
    }

    public String getType() {
        return (String)this.typeProperty().get();
    }

    public final void setType(String type) {
        this.typeProperty().set((Object)type);
    }

    public final StringProperty fundAccIdProperty() {
        return this.fundAccId;
    }

    public final String getFundAccId() {
        return (String)this.fundAccIdProperty().get();
    }

    public final void setFundAccId(String fundAccId) {
        this.fundAccIdProperty().set((Object)fundAccId);
    }

    public final StringProperty secAccIdProperty() {
        return this.secAccId;
    }

    public final String getSecAccId() {
        return (String)this.secAccIdProperty().get();
    }

    public final void setSecAccId(String secAccId) {
        this.secAccIdProperty().set((Object)secAccId);
    }

    public final StringProperty subFundIdProperty() {
        return this.subFundId;
    }

    public final String getSubFundId() {
        return (String)this.subFundIdProperty().get();
    }

    public final void setSubFundId(String subfundId) {
        this.subFundIdProperty().set((Object)subfundId);
    }

    public final StringProperty portfolioProperty() {
        return this.portfolio;
    }

    public final String getPortfolio() {
        return (String)this.portfolioProperty().get();
    }

    public final void setPortfolio(String portfolio) {
        this.portfolioProperty().set((Object)portfolio);
    }

    public final StringProperty subSecIdProperty() {
        return this.subSecId;
    }

    public final String getSubSecId() {
        return (String)this.subSecIdProperty().get();
    }

    public final void setSubSecId(String subSecId) {
        this.subSecIdProperty().set((Object)subSecId);
    }

    public final StringProperty flowAttriIdProperty() {
        return this.flowAttriId;
    }

    public final String getFlowAttriId() {
        return (String)this.flowAttriIdProperty().get();
    }

    public final void setFlowAttriId(String flowAttriId) {
        this.flowAttriIdProperty().set((Object)flowAttriId);
    }

    public final StringProperty stepAttrIdProperty() {
        return this.stepAttrId;
    }

    public final String getStepAttrId() {
        return (String)this.stepAttrIdProperty().get();
    }

    public final void setStepAttrId(String stepAttrId) {
        this.stepAttrIdProperty().set((Object)stepAttrId);
    }

    public final IntegerProperty instructionTypeProperty() {
        return this.instructionType;
    }

    public final int getInstructionType() {
        return this.instructionTypeProperty().get();
    }

    public final void setInstructionType(int instructionType) {
        this.instructionTypeProperty().set(instructionType);
    }

    public final IntegerProperty accntLevelProperty() {
        return this.accntLevel;
    }

    public final int getAccntLevel() {
        return this.accntLevelProperty().get();
    }

    public final void setAccntLevel(int accntLevel) {
        this.accntLevelProperty().set(accntLevel);
    }

    public List<AccntSecInfo> getAccSecInfoList() {
        return this.accSecInfoList;
    }

    public void setAccSecInfoList(List<AccntSecInfo> accSecInfoList) {
        this.accSecInfoList = accSecInfoList;
    }

    public final StringProperty productIdProperty() {
        return this.productId;
    }

    public final String getProductId() {
        return (String)this.productIdProperty().get();
    }

    public final void setProductId(String productId) {
        this.productIdProperty().set((Object)productId);
    }

    public StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public StringProperty instructionPanelTypeProperty() {
        return this.instructionPanelType;
    }

    public String getInstructionPanelType() {
        return (String)this.instructionPanelTypeProperty().get();
    }

    public void setInstructionPanelType(String instructionPanelType) {
        this.instructionPanelTypeProperty().set((Object)instructionPanelType);
    }

    public final StringProperty resourceIdProperty() {
        return this.resourceId;
    }

    public final String getResourceId() {
        return (String)this.resourceIdProperty().get();
    }

    public final void setResourceId(String resourceId) {
        this.resourceIdProperty().set((Object)resourceId);
    }

    public final StringProperty referenceProperty() {
        return this.reference;
    }

    public final String getReference() {
        return (String)this.referenceProperty().get();
    }

    public final void setReference(String reference) {
        this.referenceProperty().set((Object)reference);
    }

    public boolean isSub() {
        return this.getAccntLevel() == 1;
    }

    public final IntegerProperty orderAvailableQuantityProperty() {
        return this.orderAvailableQuantity;
    }

    public final int getOrderAvailableQuantity() {
        return this.orderAvailableQuantityProperty().get();
    }

    public final void setOrderAvailableQuantity(int orderAvailableQuantity) {
        this.orderAvailableQuantityProperty().set(orderAvailableQuantity);
    }

    public final DoubleProperty exceedPriceProperty() {
        return this.exceedPrice;
    }

    public final double getExceedPrice() {
        return this.exceedPriceProperty().get();
    }

    public final void setExceedPrice(double exceedPrice) {
        this.exceedPriceProperty().set(exceedPrice);
    }

    public final IntegerProperty datumPercentProperty() {
        return this.datumPercent;
    }

    public final int getDatumPercent() {
        return this.datumPercentProperty().get();
    }

    public final void setDatumPercent(int datumPercent) {
        this.datumPercentProperty().set(datumPercent);
    }

    public final IntegerProperty orderIntevelProperty() {
        return this.orderIntevel;
    }

    public final int getOrderIntevel() {
        return this.orderIntevelProperty().get();
    }

    public final void setOrderIntevel(int orderIntevel) {
        this.orderIntevelProperty().set(orderIntevel);
    }

    public final IntegerProperty cancelIntevelProperty() {
        return this.cancelIntevel;
    }

    public final int getCancelIntevel() {
        return this.cancelIntevelProperty().get();
    }

    public final void setCancelIntevel(int cancelIntevel) {
        this.cancelIntevelProperty().set(cancelIntevel);
    }

    public final IntegerProperty minitabQtyProperty() {
        return this.minitabQty;
    }

    public final int getMinitabQty() {
        return this.minitabQtyProperty().get();
    }

    public final void setMinitabQty(int minitabQty) {
        this.minitabQtyProperty().set(minitabQty);
    }

    public final IntegerProperty waveRangProperty() {
        return this.waveRang;
    }

    public final int getWaveRang() {
        return this.waveRangProperty().get();
    }

    public final void setWaveRang(int waveRang) {
        this.waveRangProperty().set(waveRang);
    }

    public final IntegerProperty minQtyProperty() {
        return this.minQty;
    }

    public final int getMinQty() {
        return this.minQtyProperty().get();
    }

    public final void setMinQty(int minQty) {
        this.minQtyProperty().set(minQty);
    }

    public final IntegerProperty maxQtyProperty() {
        return this.maxQty;
    }

    public final int getMaxQty() {
        return this.maxQtyProperty().get();
    }

    public final void setMaxQty(int maxQty) {
        this.maxQtyProperty().set(maxQty);
    }

    public final IntegerProperty orderTimeProperty() {
        return this.orderTime;
    }

    public final int getOrderTime() {
        return this.orderTimeProperty().get();
    }

    public final void setOrderTime(int orderTime) {
        this.orderTimeProperty().set(orderTime);
    }

    public final ObjectProperty<MxNode> pricetermsProperty() {
        return this.priceterms;
    }

    public final MxNode getPriceterms() {
        return (MxNode)this.pricetermsProperty().get();
    }

    public final void setPriceterms(MxNode priceterms) {
        this.pricetermsProperty().set((Object)priceterms);
    }

    public final ObjectProperty<MxNode> datumQtyProperty() {
        return this.datumQty;
    }

    public final MxNode getDatumQty() {
        return (MxNode)this.datumQtyProperty().get();
    }

    public final void setDatumQty(MxNode datumQty) {
        this.datumQtyProperty().set((Object)datumQty);
    }

    public final IntegerProperty floatWayProperty() {
        return this.floatWay;
    }

    public final int getFloatWay() {
        return this.floatWayProperty().get();
    }

    public final void setFloatWay(int floatWay) {
        this.floatWayProperty().set(floatWay);
    }

    public final DoubleProperty floatNumProperty() {
        return this.floatNum;
    }

    public final double getFloatNum() {
        return this.floatNumProperty().get();
    }

    public final void setFloatNum(double floatNum) {
        this.floatNumProperty().set(floatNum);
    }

    public final DoubleProperty floatPercentProperty() {
        return this.floatPercent;
    }

    public final double getFloatPercent() {
        return this.floatPercentProperty().get();
    }

    public final void setFloatPercent(double floatPercent) {
        this.floatPercentProperty().set(floatPercent);
    }

    public final IntegerProperty diskWayProperty() {
        return this.diskWay;
    }

    public final int getDiskWay() {
        return this.diskWayProperty().get();
    }

    public final void setDiskWay(int diskWay) {
        this.diskWayProperty().set(diskWay);
    }

    public final DoubleProperty diskNumProperty() {
        return this.diskNum;
    }

    public final double getDiskNum() {
        return this.diskNumProperty().get();
    }

    public final void setDiskNum(double diskNum) {
        this.diskNumProperty().set(diskNum);
    }

    public final DoubleProperty diskPercentProperty() {
        return this.diskPercent;
    }

    public final double getDiskPercent() {
        return this.diskPercentProperty().get();
    }

    public final void setDiskPercent(double diskPercent) {
        this.diskPercentProperty().set(diskPercent);
    }

    public int getSide() {
        return this.side;
    }

    public void setSide(int side) {
        this.side = side;
    }

    public String getPostil() {
        return this.postil;
    }

    public void setPostil(String postil) {
        this.postil = postil;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String getInsExpiredDate() {
        return this.insExpiredDate;
    }

    public void setInsExpiredDate(String insExpiredDate) {
        this.insExpiredDate = insExpiredDate;
    }

    public final IntegerProperty sumMinuteProperty() {
        return this.sumMinute;
    }

    public final int getSumMinute() {
        return this.sumMinuteProperty().get();
    }

    public final void setSumMinute(int sumMinute) {
        this.sumMinuteProperty().set(sumMinute);
    }

    public final DoubleProperty marketPercentProperty() {
        return this.marketPercent;
    }

    public final double getMarketPercent() {
        return this.marketPercentProperty().get();
    }

    public final void setMarketPercent(double marketPercent) {
        this.marketPercentProperty().set(marketPercent);
    }

    public final IntegerProperty priceTypeProperty() {
        return this.priceType;
    }

    public final int getPriceType() {
        return this.priceTypeProperty().get();
    }

    public final void setPriceType(int priceType) {
        this.priceTypeProperty().set(priceType);
    }

    public final IntegerProperty qtyExposedProperty() {
        return this.qtyExposed;
    }

    public final int getQtyExposed() {
        return this.qtyExposedProperty().get();
    }

    public final void setQtyExposed(int qtyExposed) {
        this.qtyExposedProperty().set(qtyExposed);
    }

    public int getAlgoNewType() {
        return this.algoNewType;
    }

    public void setAlgoNewType(int algoNewType) {
        this.algoNewType = algoNewType;
    }

    public final DoubleProperty limitPriceProperty() {
        return this.limitPrice;
    }

    public final double getLimitPrice() {
        return this.limitPriceProperty().get();
    }

    public final void setLimitPrice(double limitPrice) {
        this.limitPriceProperty().set(limitPrice);
    }

    public final StringProperty buyTypeProperty() {
        return this.buyType;
    }

    public final String getBuyType() {
        return (String)this.buyTypeProperty().get();
    }

    public final void setBuyType(String buyType) {
        this.buyTypeProperty().set((Object)buyType);
    }

    public final StringProperty sellTypeProperty() {
        return this.sellType;
    }

    public final String getSellType() {
        return (String)this.sellTypeProperty().get();
    }

    public final void setSellType(String sellType) {
        this.sellTypeProperty().set((Object)sellType);
    }

    public final DoubleProperty priceSlipProperty() {
        return this.priceSlip;
    }

    public final double getPriceSlip() {
        return this.priceSlipProperty().get();
    }

    public final void setPriceSlip(double priceSlip) {
        this.priceSlipProperty().set(priceSlip);
    }

    public final StringProperty rollIntervalProperty() {
        return this.rollInterval;
    }

    public final String getRollInterval() {
        return (String)this.rollIntervalProperty().get();
    }

    public final void setRollInterval(String rollInterval) {
        this.rollIntervalProperty().set((Object)rollInterval);
    }

    public final StringProperty startTimeProperty() {
        return this.startTime;
    }

    public final String getStartTime() {
        return (String)this.startTimeProperty().get();
    }

    public final void setStartTime(String startTime) {
        this.startTimeProperty().set((Object)startTime);
    }

    public final StringProperty maxPriceDiffProperty() {
        return this.maxPriceDiff;
    }

    public final String getMaxPriceDiff() {
        return (String)this.maxPriceDiffProperty().get();
    }

    public final void setMaxPriceDiff(String maxPriceDiff) {
        this.maxPriceDiffProperty().set((Object)maxPriceDiff);
    }

    public MxNode getAlgoTypeNode() {
        return this.algoTypeNode;
    }

    public void setAlgoTypeNode(MxNode algoTypeNode) {
        this.algoTypeNode = algoTypeNode;
    }
}

