/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.entity.futures.arbitrage.Data;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;

public class AlgoCtpOrder
extends CtpOrder {
    private SimpleStringProperty algoId = new SimpleStringProperty("");
    private SimpleStringProperty algoName = new SimpleStringProperty("");
    private SimpleStringProperty errInfo = new SimpleStringProperty("");
    private SimpleStringProperty statusValue = new SimpleStringProperty("");
    private MxNode algoStatus = MxNodeFactory.create((String)"algo_status", (String)"");
    private static final List<String> CAN_CANCEL_STATUS = Arrays.asList("0", "1", "6", "7", "8");
    private BooleanProperty canCancel = new SimpleBooleanProperty(false);

    @Override
    public void update(Object obj) {
        super.update(obj);
        if (obj instanceof Data) {
            Data data = (Data)Data.class.cast(obj);
            this.setAlgoId(data.getAlgo_order_id());
            this.setSecId(data.getAlgo_info().getAlgo_params().getCode());
            this.setSecName(data.getAlgo_info().getAlgo_params().getName());
            this.setOrdDate(data.getEntrust_date());
            this.setOrdTime(data.getEntrust_time());
            this.getAlgoStatus().setRaw(data.getAlgo_status());
            this.setStatusValue(this.getAlgoStatus().getValue());
            if ("01".equals(data.getAlgo_info().getAlgo_params().getBs())) {
                this.getSide().setRaw("49");
            } else {
                this.getSide().setRaw("50");
            }
            this.setOrderQty(data.getAlgo_info().getAlgo_params().getQuantity());
            this.setPrice(data.getAlgo_info().getAlgo_params().getPrice());
            this.setUserId(data.getFutures().getUser_id());
            this.setErrInfo(data.getRemark());
            if (!this.getAlgoStatus().getRaw().isEmpty()) {
                if (CAN_CANCEL_STATUS.contains(this.getAlgoStatus().getRaw())) {
                    this.setCanCancel(true);
                } else {
                    this.setCanCancel(false);
                }
            }
            if (data.getAlgo_info().getAlgo_stat() != null) {
                if ("01".equals(data.getAlgo_info().getAlgo_params().getBs())) {
                    this.setCumQty((int)data.getAlgo_info().getAlgo_stat().getBuy_executed_qty());
                } else {
                    this.setCumQty((int)data.getAlgo_info().getAlgo_stat().getSale_executed_qty());
                }
            }
            double per = 0.0;
            if (this.getCumQty() > 0 && this.getOrderQty() > 0) {
                per = (double)this.getCumQty() * 100.0 / (double)this.getOrderQty();
            }
            this.setDonePercent(per);
        } else if (obj instanceof AlgoCtpOrder) {
            AlgoCtpOrder order = (AlgoCtpOrder)((Object)AlgoCtpOrder.class.cast(obj));
            this.setOrderId(order.getOrderId());
            this.setAlgoId(order.getAlgoId());
            this.setAlgoName(order.getAlgoName());
            this.setErrInfo(order.getErrInfo());
            this.setCanCancel(order.isCanCancel());
            this.setAlgoStatus(order.getAlgoStatus());
            this.setStatusValue(order.getStatusValue());
        } else if (obj instanceof CtpOrder) {
            CtpOrder order = (CtpOrder)((Object)CtpOrder.class.cast(obj));
            this.setOrderId(order.getOrderId());
        }
    }

    public MxNode getAlgoStatus() {
        return this.algoStatus;
    }

    public void setAlgoStatus(MxNode algoStatus) {
        this.algoStatus = algoStatus;
    }

    public final BooleanProperty canCancelProperty() {
        return this.canCancel;
    }

    @Override
    public final boolean isCanCancel() {
        return this.canCancelProperty().get();
    }

    @Override
    public final void setCanCancel(boolean canCancel) {
        this.canCancelProperty().set(canCancel);
    }

    public final SimpleStringProperty algoIdProperty() {
        return this.algoId;
    }

    public final String getAlgoId() {
        return this.algoIdProperty().get();
    }

    public final void setAlgoId(String algoId) {
        this.algoIdProperty().set(algoId);
    }

    public final SimpleStringProperty algoNameProperty() {
        return this.algoName;
    }

    public final String getAlgoName() {
        return this.algoNameProperty().get();
    }

    public final void setAlgoName(String algoName) {
        this.algoNameProperty().set(algoName);
    }

    public final SimpleStringProperty errInfoProperty() {
        return this.errInfo;
    }

    @Override
    public final String getErrInfo() {
        return this.errInfoProperty().get();
    }

    @Override
    public final void setErrInfo(String errInfo) {
        this.errInfoProperty().set(errInfo);
    }

    public final SimpleStringProperty statusValueProperty() {
        return this.statusValue;
    }

    public final String getStatusValue() {
        return this.statusValueProperty().get();
    }

    public final void setStatusValue(String statusValue) {
        this.statusValueProperty().set(statusValue);
    }

    @Override
    public String toString() {
        return String.valueOf(this.algoId.get()) + "---" + this.orderId;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.algoId.get() == null ? 0 : this.algoId.get().hashCode());
        result = 31 * result + (this.ordDate == null ? 0 : this.ordDate.hashCode());
        result = 31 * result + (this.sysOrderId == null ? 0 : this.sysOrderId.hashCode());
        result = 31 * result + (this.orderId == null ? 0 : this.orderId.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AlgoCtpOrder other = (AlgoCtpOrder)((Object)obj);
        if (this.algoId.get() == null ? other.algoId.get() != null : !this.algoId.get().equals(other.algoId.get())) {
            return false;
        }
        if (this.ordDate == null ? other.ordDate != null : !this.ordDate.equals(other.ordDate)) {
            return false;
        }
        if (this.sysOrderId == null ? other.sysOrderId != null : !this.sysOrderId.equals(other.sysOrderId)) {
            return false;
        }
        if (this.orderId == null ? other.orderId != null : !this.orderId.equals(other.orderId)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }
}

