/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.core.MEvent;
import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AlgoBaseOrder
extends MxObject {
    private StringProperty id = new SimpleStringProperty("");
    private StringProperty baseId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> type = new SimpleObjectProperty();
    private StringProperty subAcct = new SimpleStringProperty("");
    private StringProperty subSecAcct = new SimpleStringProperty("");
    private ObjectProperty<MxNode> status = new SimpleObjectProperty();
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private String secType = "";
    private ObjectProperty<MxNode> side = new SimpleObjectProperty();
    private IntegerProperty count = new SimpleIntegerProperty();
    private IntegerProperty dealCount = new SimpleIntegerProperty();
    private DoubleProperty dealAmount = new SimpleDoubleProperty();
    private DoubleProperty dealPer = new SimpleDoubleProperty();
    private StringProperty avgPrice = new SimpleStringProperty("");
    private IntegerProperty errorCode = new SimpleIntegerProperty();
    private StringProperty errorMsg = new SimpleStringProperty("");
    private DoubleProperty exe = new SimpleDoubleProperty(0.0);
    private String portfolioId = "";
    private StringProperty portfolioName = new SimpleStringProperty("");
    private StringProperty orderDate = new SimpleStringProperty("");
    private StringProperty orderStartTime = new SimpleStringProperty("");
    private StringProperty orderEndTime = new SimpleStringProperty("");
    private StringProperty orderErrInfo = new SimpleStringProperty("");
    private StringProperty instructionId = new SimpleStringProperty("");
    private ObjectProperty<Algorithm> algorithm = new SimpleObjectProperty((Object)new Algorithm());
    private ObjectProperty<AlgoParam> algoParam = new SimpleObjectProperty((Object)new AlgoParam());
    private boolean param = false;
    private String investorId = "";
    private String investorSecId = "";
    private String subFundId = "";
    private String subSecId = "";
    private boolean miseSingleSecuirty = false;

    public AlgoBaseOrder() {
        MxNode node = MxNodeFactory.create((String)"side");
        this.setSide(node);
        node = MxNodeFactory.create((String)"algo_status");
        this.setStatus(node);
        node = MxNodeFactory.create((String)"algo_name");
        this.setType(node);
    }

    public void update(Object obj) {
        if (obj instanceof PAlgorithmTrade.BaseOrderInfomation) {
            this.update((PAlgorithmTrade.BaseOrderInfomation)PAlgorithmTrade.BaseOrderInfomation.class.cast(obj));
        } else if (obj instanceof AlgoBaseOrder) {
            this.update((AlgoBaseOrder)((Object)AlgoBaseOrder.class.cast(obj)));
        } else if (obj instanceof PStrategy.BaseOrderInfo) {
            this.update((PStrategy.BaseOrderInfo)PStrategy.BaseOrderInfo.class.cast(obj));
        } else if (obj instanceof MEvent) {
            this.update((MEvent)MEvent.class.cast(obj));
        }
    }

    private void update(MEvent event) {
        block80: {
            String[] temp;
            String name;
            JsonObject json;
            String type;
            block83: {
                block81: {
                    this.getStatus().setRaw(event.getStr("algo_status"));
                    type = "";
                    switch (event.getStr("algo_type").trim()) {
                        case "BasketTrade": {
                            type = "14";
                            break;
                        }
                        case "TWAPBasketTrade": {
                            type = "15";
                            break;
                        }
                        case "VWAPBasketTrade": {
                            type = "16";
                            break;
                        }
                        case "BasketPosAdj": {
                            type = "17";
                            break;
                        }
                        case "HighLowLimitTWAP": {
                            type = "19";
                            break;
                        }
                        case "HighLowLimitVWAP": {
                            type = "20";
                            break;
                        }
                        case "TWAPOV": {
                            type = "21";
                            break;
                        }
                        case "ICEBERG": {
                            type = "22";
                            break;
                        }
                        case "HighLowLimitTWAPOV": {
                            type = "23";
                        }
                    }
                    String extra = event.getStr("extra_fields");
                    json = (JsonObject)new Gson().fromJson(extra, JsonObject.class);
                    if (json == null || json.get("remark") == null) break block80;
                    String remark = json.get("remark").getAsString();
                    if (!remark.isEmpty()) {
                        JsonObject jsonRemark = (JsonObject)new Gson().fromJson(remark, JsonObject.class);
                        if (jsonRemark.get("side") != null) {
                            this.getSide().setRaw(jsonRemark.get("side").getAsString());
                        }
                        if (jsonRemark.get("code") != null) {
                            this.setCode(jsonRemark.get("code").getAsString());
                        } else if (jsonRemark.get("basket_id") != null) {
                            this.setCode(jsonRemark.get("basket_id").getAsString().replaceAll("_[A-Za-z]*", ""));
                        }
                        if (jsonRemark.get("name") != null) {
                            this.setName(jsonRemark.get("name").getAsString());
                        } else if (jsonRemark.get("basket_name") != null) {
                            this.setName(jsonRemark.get("basket_name").getAsString());
                        }
                        if (jsonRemark.get("market") != null) {
                            this.setMarket(jsonRemark.get("market").getAsString());
                        }
                        if (jsonRemark.get("name") != null) {
                            this.setName(jsonRemark.get("name").getAsString());
                        }
                        if (jsonRemark.get("investorId") != null) {
                            this.setInvestorId(jsonRemark.get("investorId").getAsString());
                        }
                        if (jsonRemark.get("investorSecId") != null) {
                            this.setInvestorSecId(jsonRemark.get("investorSecId").getAsString());
                        }
                        if (jsonRemark.get("portfolio_name") != null) {
                            this.setPortfolioName(jsonRemark.get("portfolio_name").getAsString());
                        }
                        if (jsonRemark.get("type") != null) {
                            this.setMiseSingleSecuirty(true);
                            this.setSecType(jsonRemark.get("type").getAsString());
                        } else {
                            this.setName(jsonRemark.get("basket_name").getAsString());
                        }
                    }
                    if (!type.isEmpty()) {
                        this.getAlgorithm().setType(Integer.valueOf(type));
                    }
                    name = "";
                    if (!this.isMiseSingleSecuirty()) break block81;
                    switch (type) {
                        case "15": 
                        case "16": 
                        case "19": 
                        case "20": 
                        case "21": 
                        case "22": 
                        case "23": {
                            this.getType().setRaw(String.valueOf(type) + "0");
                            name = this.getType().getNode(String.valueOf(type) + "0").getValue();
                        }
                    }
                    break block83;
                }
                this.getType().setRaw(type);
                name = this.getType().getValue();
            }
            this.getAlgorithm().setName(name);
            this.id.set((Object)event.getStr("algo_order_id"));
            this.setBaseId(event.getStr("algo_order_id"));
            String side = event.getStr("trade_direction");
            if ("17".equals(type)) {
                side = String.valueOf(99);
                this.getSide().setRaw(side);
            }
            this.orderDate.set((Object)event.getStr("entrust_date"));
            this.orderStartTime.set((Object)event.getStr("entrust_time"));
            if (this.getStatus().getRaw().equals("2") || this.getStatus().getRaw().equals("3") || this.getStatus().getRaw().equals("5")) {
                this.orderEndTime.set((Object)event.getStr("update_time"));
            }
            this.orderErrInfo.set((Object)event.getStr("remark"));
            this.subAcct.set((Object)event.getStr("biz_acct"));
            this.setInvestorId(event.getStr("investorId"));
            if (json != null && json.get("gateway_data") != null && (temp = json.get("gateway_data").getAsString().split("#")).length >= 7) {
                this.getAlgoParam().setReference(temp[6]);
                this.setInstructionId(temp[6]);
            }
            if (StringUtils.belongto((String)type, (String[])new String[]{"14", "15", "16", "19", "20", "21", "22", "23"})) {
                if (json.get("target_vol") != null) {
                    this.setCount(json.get("target_vol").getAsInt());
                }
                if (json.get("executed_qty") != null) {
                    this.setDealCount(json.get("executed_qty").getAsInt());
                }
                if (json.get("executed_qty_percent") != null) {
                    this.setExe(Double.valueOf(this.convert(json.get("executed_qty_percent").getAsDouble() * 100.0, 2)));
                }
            }
            if (this.getType().getRaw().equals("17")) {
                if (json.get("buy_target_vol") != null && json.get("sale_target_vol") != null) {
                    this.setCount(json.get("buy_target_vol").getAsInt() + json.get("sale_target_vol").getAsInt());
                }
                if (json.get("buy_executed_qty") != null && json.get("sale_executed_qty") != null) {
                    this.setDealCount(json.get("buy_executed_qty").getAsInt() + json.get("sale_executed_qty").getAsInt());
                }
                if (json.get("buy_executed_percent") != null && json.get("sale_executed_percent") != null) {
                    if (this.getCount() != 0) {
                        this.setExe(Double.valueOf(this.convert((double)this.getDealCount() * 100.0 / (double)this.getCount(), 2)));
                    } else {
                        this.setExe(0.0);
                    }
                }
            }
        }
    }

    private String convert(double num, int scale) {
        BigDecimal big = new BigDecimal(num);
        double decimal = big.setScale(scale, 4).doubleValue();
        return StringUtils.toStr((double)decimal, (int)scale);
    }

    private void update(PAlgorithmTrade.BaseOrderInfomation info) {
        this.setId(info.getAlgoSysOrderId());
        this.setBaseId(info.getAlgoBaseOrderId());
        this.getType().setRaw(String.valueOf(info.getAlgoTypeValue()));
        this.setSubAcct(info.getSubAccntId());
        this.setSubSecAcct(info.getSubSecAccntId());
        this.getStatus().setRaw(String.valueOf(info.getBaseOrderStatusValue()));
        this.setSecType(info.getInstrument().getSecurityType());
        this.setCode(info.getInstrument().getSecurityId());
        this.setMarket(info.getInstrument().getMarket());
        this.setName(info.getInstrument().getSymbol());
        this.getSide().setRaw(String.valueOf(info.getSideValue()));
        this.setCount(info.getOrderQty());
        this.setDealCount(info.getCumQty());
        this.setDealPer(info.getExecutedQtyPercent());
        this.setErrorCode(info.getErrorCode());
        this.setErrorMsg(info.getErrorInfo());
        this.setPortfolioId(info.getPortfolioId());
        this.setOrderDate(info.getOrderDate());
        this.setOrderStartTime(info.getOrderStartTime());
        this.setOrderEndTime(info.getOrderEndTime());
        this.setOrderErrInfo(info.getOrderErrInfo());
        this.setInstructionId(info.getReference());
        BigDecimal bigExe = new BigDecimal(info.getExecutedQtyPercent());
        double exe = bigExe.setScale(2, 4).doubleValue();
        this.setExe(exe);
        BigDecimal bigAvg = new BigDecimal(info.getFilledAvgPrice());
        double avg = bigAvg.setScale(4, 4).doubleValue();
        this.setAvgPrice(StringUtils.toStr((double)avg, (int)4));
        ((AlgoParam)((Object)this.algoParam.get())).update((Object)info);
    }

    private void update(AlgoBaseOrder algo) {
        this.setId(algo.getId());
        this.setBaseId(algo.getBaseId());
        this.getType().setRaw(algo.getType().getRaw());
        this.setSubAcct(algo.getSubAcct());
        this.setSubSecAcct(algo.getSubSecAcct());
        this.setStatus(algo.getStatus());
        this.setCode(algo.getCode());
        this.setMarket(algo.getMarket());
        this.setName(algo.getName());
        this.getSide().setRaw(algo.getSide().getRaw());
        this.setCount(algo.getCount());
        this.setDealCount(algo.getDealCount());
        this.setDealAmount(algo.getDealAmount());
        this.setDealPer(algo.getDealPer());
        this.setAvgPrice(algo.getAvgPrice());
        this.setErrorCode(algo.getErrorCode());
        this.setErrorMsg(algo.getErrorMsg());
        this.setExe(algo.getExe());
        this.setPortfolioId(algo.getPortfolioId());
        this.setPortfolioName(algo.getPortfolioName());
        this.setOrderDate(algo.getOrderDate());
        this.setOrderEndTime(algo.getOrderEndTime());
        this.setOrderErrInfo(algo.getOrderErrInfo());
        this.setInstructionId(algo.getInstructionId());
        this.setMiseSingleSecuirty(algo.isMiseSingleSecuirty());
        this.setInvestorId(algo.getInvestorId());
        this.setInvestorSecId(algo.getInvestorSecId());
    }

    private void update(PStrategy.BaseOrderInfo info) {
        this.setId(info.getSysOrderId());
        this.setBaseId(info.getSysOrderId());
        this.getType().setRaw(String.valueOf(info.getAlgoTypeValue()));
        this.getStatus().setRaw(String.valueOf(info.getBaseOrderStatusValue()));
        this.setCode(info.getInstrument().getSecurityId());
        this.setMarket(info.getInstrument().getMarket());
        this.setName(info.getInstrument().getSymbol());
        this.getSide().setRaw(String.valueOf(info.getSideValue()));
        this.setCount(info.getOrderQty());
        this.setErrorCode(info.getErrorCode());
        this.setErrorMsg(info.getErrorInfo());
        this.setOrderErrInfo(info.getErrorInfo());
        this.setOrderDate(info.getOrderDate());
        this.setOrderStartTime(info.getOrderStartTime());
        this.setOrderEndTime(info.getOrderEndTime());
        ((AlgoParam)((Object)this.algoParam.get())).update((Object)info);
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final String getId() {
        return (String)this.idProperty().get();
    }

    public final void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public final StringProperty codeProperty() {
        return this.code;
    }

    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final IntegerProperty countProperty() {
        return this.count;
    }

    public final int getCount() {
        return this.countProperty().get();
    }

    public final void setCount(int count) {
        this.countProperty().set(count);
    }

    public final IntegerProperty dealCountProperty() {
        return this.dealCount;
    }

    public final int getDealCount() {
        return this.dealCountProperty().get();
    }

    public final void setDealCount(int dealCount) {
        this.dealCountProperty().set(dealCount);
    }

    public final DoubleProperty dealPerProperty() {
        return this.dealPer;
    }

    public final double getDealPer() {
        return this.dealPerProperty().get();
    }

    public final void setDealPer(double dealPer) {
        this.dealPerProperty().set(dealPer);
    }

    public final StringProperty errorMsgProperty() {
        return this.errorMsg;
    }

    public final String getErrorMsg() {
        return (String)this.errorMsgProperty().get();
    }

    public final void setErrorMsg(String errorMsg) {
        this.errorMsgProperty().set((Object)errorMsg);
    }

    public final StringProperty subAcctProperty() {
        return this.subAcct;
    }

    public final String getSubAcct() {
        return (String)this.subAcctProperty().get();
    }

    public final void setSubAcct(String subAcct) {
        this.subAcctProperty().set((Object)subAcct);
    }

    public final StringProperty subSecAcctProperty() {
        return this.subSecAcct;
    }

    public final String getSubSecAcct() {
        return (String)this.subSecAcctProperty().get();
    }

    public final void setSubSecAcct(String subSecAcct) {
        this.subSecAcctProperty().set((Object)subSecAcct);
    }

    public final IntegerProperty errorCodeProperty() {
        return this.errorCode;
    }

    public final int getErrorCode() {
        return this.errorCodeProperty().get();
    }

    public final void setErrorCode(int errorCode) {
        this.errorCodeProperty().set(errorCode);
    }

    public final ObjectProperty<Algorithm> algorithmProperty() {
        return this.algorithm;
    }

    public final Algorithm getAlgorithm() {
        return (Algorithm)((Object)this.algorithmProperty().get());
    }

    public final void setAlgorithm(Algorithm algorithm) {
        this.algorithmProperty().set((Object)algorithm);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final ObjectProperty<AlgoParam> algoParamProperty() {
        return this.algoParam;
    }

    public final AlgoParam getAlgoParam() {
        return (AlgoParam)((Object)this.algoParamProperty().get());
    }

    public final void setAlgoParam(AlgoParam algoParam) {
        this.algoParamProperty().set((Object)algoParam);
    }

    public boolean isParam() {
        return this.param;
    }

    public void setParam(boolean param) {
        this.param = param;
    }

    public final StringProperty baseIdProperty() {
        return this.baseId;
    }

    public final String getBaseId() {
        return (String)this.baseIdProperty().get();
    }

    public final void setBaseId(String baseId) {
        this.baseIdProperty().set((Object)baseId);
    }

    public final StringProperty orderDateProperty() {
        return this.orderDate;
    }

    public final String getOrderDate() {
        return (String)this.orderDateProperty().get();
    }

    public final void setOrderDate(String orderDate) {
        this.orderDateProperty().set((Object)orderDate);
    }

    public final ObjectProperty<MxNode> typeProperty() {
        return this.type;
    }

    public final MxNode getType() {
        return (MxNode)this.typeProperty().get();
    }

    public final void setType(MxNode type) {
        this.typeProperty().set((Object)type);
    }

    public final DoubleProperty exeProperty() {
        return this.exe;
    }

    public final double getExe() {
        return this.exeProperty().get();
    }

    public final void setExe(double exe) {
        this.exeProperty().set(exe);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.baseId.get() == null ? 0 : ((String)this.baseId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AlgoBaseOrder other = (AlgoBaseOrder)((Object)obj);
        return !(this.baseId.get() == null ? other.baseId.get() != null : !((String)this.baseId.get()).equals(other.baseId.get()));
    }

    public String toString() {
        return "AlgoBaseOrder [baseId=" + this.baseId + "]";
    }

    public final StringProperty avgPriceProperty() {
        return this.avgPrice;
    }

    public final String getAvgPrice() {
        return (String)this.avgPriceProperty().get();
    }

    public final void setAvgPrice(String avgPrice) {
        this.avgPriceProperty().set((Object)avgPrice);
    }

    public final StringProperty orderStartTimeProperty() {
        return this.orderStartTime;
    }

    public final String getOrderStartTime() {
        return (String)this.orderStartTimeProperty().get();
    }

    public final void setOrderStartTime(String orderStartTime) {
        this.orderStartTimeProperty().set((Object)orderStartTime);
    }

    public final StringProperty orderEndTimeProperty() {
        return this.orderEndTime;
    }

    public final String getOrderEndTime() {
        return (String)this.orderEndTimeProperty().get();
    }

    public final void setOrderEndTime(String orderEndTime) {
        this.orderEndTimeProperty().set((Object)orderEndTime);
    }

    public final StringProperty orderErrInfoProperty() {
        return this.orderErrInfo;
    }

    public final String getOrderErrInfo() {
        return (String)this.orderErrInfoProperty().get();
    }

    public final void setOrderErrInfo(String orderErrInfo) {
        this.orderErrInfoProperty().set((Object)orderErrInfo);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty instructionIdProperty() {
        return this.instructionId;
    }

    public final String getInstructionId() {
        return (String)this.instructionIdProperty().get();
    }

    public final void setInstructionId(String instructionId) {
        this.instructionIdProperty().set((Object)instructionId);
    }

    public boolean isMiseSingleSecuirty() {
        return this.miseSingleSecuirty;
    }

    public void setMiseSingleSecuirty(boolean miseSingleSecuirty) {
        this.miseSingleSecuirty = miseSingleSecuirty;
    }

    public final DoubleProperty dealAmountProperty() {
        return this.dealAmount;
    }

    public final double getDealAmount() {
        return this.dealAmountProperty().get();
    }

    public final void setDealAmount(double dealAmount) {
        this.dealAmountProperty().set(dealAmount);
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }

    public String getInvestorSecId() {
        return this.investorSecId;
    }

    public void setInvestorSecId(String investorSecId) {
        this.investorSecId = investorSecId;
    }

    public String getSubFundId() {
        return this.subFundId;
    }

    public void setSubFundId(String subFundId) {
        this.subFundId = subFundId;
    }

    public String getSubSecId() {
        return this.subSecId;
    }

    public void setSubSecId(String subSecId) {
        this.subSecId = subSecId;
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public final StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public final String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public final void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }
}

