/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.strategy;

import cms.tmx.entity.strategy.BondStrategy;
import cms.tmx.http.api.strategy.dto.ContextSettings;
import cms.tmx.http.api.strategy.dto.ExecMode;
import cms.tmx.http.api.strategy.dto.LegParams;
import cms.tmx.http.api.strategy.dto.SdfArbitrageContextSetting;
import cms.tmx.javafx.MxNode;
import com.google.gson.Gson;

public class StdBondForward
extends BondStrategy {
    ExecMode execMode;
    private double cleanBid;
    private double cleanOfr;
    private int qtyBid;
    private int qtyOfr;
    private int qtyOfrMax;
    private int qtyBidMax;
    private int qtyOfrDeal;
    private int qtyBidDeal;
    private double slip;
    private String pricingJobId = "";

    public void update(ContextSettings job) {
        LegParams leg;
        this.setStatus(new MxNode().load("status_strategy", String.valueOf(job.getAlgoStatus().ordinal())));
        this.setContextId(job.getAlgoId());
        Object details = job.getDetails();
        Gson gson = new Gson();
        SdfArbitrageContextSetting ctx = (SdfArbitrageContextSetting)gson.fromJson(gson.toJson(details), SdfArbitrageContextSetting.class);
        if (ctx.getExecMode() != null) {
            this.setExecMode(ctx.getExecMode());
        }
        this.setPricingJobId(ctx.getPricingJobId());
        this.setSlip(ctx.getBidSlip());
        this.setQtyBidMax(ctx.getBidMaxAllowFilledQty());
        this.setQtyOfrMax(ctx.getOfferMaxAllowFilledQty());
        this.setInstSecId(ctx.getInstrument().getSecurityId());
        this.setCleanBid(ctx.getBidPrice());
        this.setCleanOfr(ctx.getOfferPrice());
        this.setIrr(ctx.getBidIrr());
        this.setQtyBid(ctx.getBidQty());
        this.setQtyOfr(ctx.getOfferQty());
        this.setSpread(ctx.getBidSpread());
        if (ctx.getLeg().size() >= 1) {
            leg = (LegParams)ctx.getLeg().get(0);
            if (leg.getInstrument() != null) {
                this.setActiveSecId(leg.getInstrument().getSecurityId());
            }
            this.setActiveBidYield(Double.valueOf(String.format("%.4f", leg.getBidYtm() * 100.0)));
            this.setActiveOfferYield(Double.valueOf(String.format("%.4f", leg.getOfferYtm() * 100.0)));
            this.setActiveBidSource(StdBondForward.getSourceName(leg.getBidSource(), true));
            this.setActiveOfferSource(StdBondForward.getSourceName(leg.getOfferSource(), false));
        }
        if (ctx.getLeg().size() >= 2) {
            leg = (LegParams)ctx.getLeg().get(1);
            if (leg.getInstrument() != null) {
                this.setInactiveSecId(leg.getInstrument().getSecurityId());
            }
            this.setInactiveBidYield(Double.valueOf(String.format("%.4f", leg.getBidYtm() * 100.0)));
            this.setInactiveOfferYield(Double.valueOf(String.format("%.4f", leg.getOfferYtm() * 100.0)));
            this.setInactiveBidSource(StdBondForward.getSourceName(leg.getBidSource(), true));
            this.setInactiveOfferSource(StdBondForward.getSourceName(leg.getOfferSource(), false));
        }
    }

    public static String getSourceName(String source, boolean isBid) {
        if (source == null) {
            return "";
        }
        String bs = "OFR_";
        if (isBid) {
            bs = "BID_";
        }
        switch (source) {
            case "BEST": {
                return String.valueOf(bs) + "\u6700\u4f18";
            }
            case "ICAP": {
                return String.valueOf(bs) + "\u56fd\u9645";
            }
            case "TP": {
                return String.valueOf(bs) + "\u56fd\u5229";
            }
            case "TJXT": {
                return String.valueOf(bs) + "\u4fe1\u5510";
            }
            case "CBBJ": {
                return String.valueOf(bs) + "\u4e2d\u8bda";
            }
            case "PATR": {
                return String.valueOf(bs) + "\u5e73\u5b89";
            }
        }
        return "";
    }

    public int getQtyOfrDeal() {
        return this.qtyOfrDeal;
    }

    public void setQtyOfrDeal(int qtyOfrDeal) {
        this.qtyOfrDeal = qtyOfrDeal;
    }

    public int getQtyBidDeal() {
        return this.qtyBidDeal;
    }

    public void setQtyBidDeal(int qtyBidDeal) {
        this.qtyBidDeal = qtyBidDeal;
    }

    public double getSlip() {
        return this.slip;
    }

    public void setSlip(double slip) {
        this.slip = slip;
    }

    public ExecMode getExecMode() {
        return this.execMode;
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public double getCleanBid() {
        return this.cleanBid;
    }

    public void setCleanBid(double cleanBid) {
        this.cleanBid = cleanBid;
    }

    public double getCleanOfr() {
        return this.cleanOfr;
    }

    public void setCleanOfr(double cleanOfr) {
        this.cleanOfr = cleanOfr;
    }

    public int getQtyBid() {
        return this.qtyBid;
    }

    public void setQtyBid(int qtyBid) {
        this.qtyBid = qtyBid;
    }

    public int getQtyOfr() {
        return this.qtyOfr;
    }

    public void setQtyOfr(int qtyOfr) {
        this.qtyOfr = qtyOfr;
    }

    public int getQtyBidMax() {
        return this.qtyBidMax;
    }

    public void setQtyBidMax(int qtyBidMax) {
        this.qtyBidMax = qtyBidMax;
    }

    public int getQtyOfrMax() {
        return this.qtyOfrMax;
    }

    public void setQtyOfrMax(int qtyOfrMax) {
        this.qtyOfrMax = qtyOfrMax;
    }

    public String getPricingJobId() {
        return this.pricingJobId;
    }

    public void setPricingJobId(String pricingJobId) {
        this.pricingJobId = pricingJobId;
    }
}

